/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.render;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.util.Calendar;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.chart.computation.BoundingBox;
import org.eclipse.birt.chart.computation.DataPointHints;
import org.eclipse.birt.chart.computation.DataSetIterator;
import org.eclipse.birt.chart.computation.EllipsisHelper;
import org.eclipse.birt.chart.computation.Engine3D;
import org.eclipse.birt.chart.computation.GObjectFactory;
import org.eclipse.birt.chart.computation.IChartComputation;
import org.eclipse.birt.chart.computation.IGObjectFactory;
import org.eclipse.birt.chart.computation.LabelLimiter;
import org.eclipse.birt.chart.computation.LegendEntryRenderingHints;
import org.eclipse.birt.chart.computation.LegendItemHints;
import org.eclipse.birt.chart.computation.LegendItemRenderingHints;
import org.eclipse.birt.chart.computation.LegendLayoutHints;
import org.eclipse.birt.chart.computation.Methods;
import org.eclipse.birt.chart.computation.PlotComputation;
import org.eclipse.birt.chart.computation.withaxes.OneAxis;
import org.eclipse.birt.chart.computation.withaxes.PlotWithAxes;
import org.eclipse.birt.chart.computation.withoutaxes.Coordinates;
import org.eclipse.birt.chart.computation.withoutaxes.PlotWithoutAxes;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.device.IPrimitiveRenderer;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.event.BlockGenerationEvent;
import org.eclipse.birt.chart.event.EventObjectCache;
import org.eclipse.birt.chart.event.InteractionEvent;
import org.eclipse.birt.chart.event.LineRenderEvent;
import org.eclipse.birt.chart.event.Oval3DRenderEvent;
import org.eclipse.birt.chart.event.OvalRenderEvent;
import org.eclipse.birt.chart.event.Polygon3DRenderEvent;
import org.eclipse.birt.chart.event.PolygonRenderEvent;
import org.eclipse.birt.chart.event.PrimitiveRenderEvent;
import org.eclipse.birt.chart.event.RectangleRenderEvent;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.event.StructureType;
import org.eclipse.birt.chart.event.TextRenderEvent;
import org.eclipse.birt.chart.event.WrappedInstruction;
import org.eclipse.birt.chart.event.WrappedStructureSource;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.DialChart;
import org.eclipse.birt.chart.model.attribute.ActionType;
import org.eclipse.birt.chart.model.attribute.ActionValue;
import org.eclipse.birt.chart.model.attribute.Anchor;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Direction;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.HorizontalAlignment;
import org.eclipse.birt.chart.model.attribute.Insets;
import org.eclipse.birt.chart.model.attribute.LegendItemType;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.Location3D;
import org.eclipse.birt.chart.model.attribute.Marker;
import org.eclipse.birt.chart.model.attribute.MultiURLValues;
import org.eclipse.birt.chart.model.attribute.MultipleFill;
import org.eclipse.birt.chart.model.attribute.Orientation;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.Size;
import org.eclipse.birt.chart.model.attribute.Text;
import org.eclipse.birt.chart.model.attribute.TextAlignment;
import org.eclipse.birt.chart.model.attribute.TooltipValue;
import org.eclipse.birt.chart.model.attribute.TriggerCondition;
import org.eclipse.birt.chart.model.attribute.URLValue;
import org.eclipse.birt.chart.model.attribute.VerticalAlignment;
import org.eclipse.birt.chart.model.attribute.impl.SizeImpl;
import org.eclipse.birt.chart.model.attribute.impl.TextAlignmentImpl;
import org.eclipse.birt.chart.model.attribute.impl.URLValueImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.LabelImpl;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.Action;
import org.eclipse.birt.chart.model.data.MultipleActions;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.Trigger;
import org.eclipse.birt.chart.model.data.impl.MultipleActionsImpl;
import org.eclipse.birt.chart.model.layout.Block;
import org.eclipse.birt.chart.model.layout.ClientArea;
import org.eclipse.birt.chart.model.layout.LabelBlock;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.layout.TitleBlock;
import org.eclipse.birt.chart.render.AxesRenderer;
import org.eclipse.birt.chart.render.DeferredCache;
import org.eclipse.birt.chart.render.DeferredCacheManager;
import org.eclipse.birt.chart.render.EmptyWithAxes;
import org.eclipse.birt.chart.render.EmptyWithoutAxes;
import org.eclipse.birt.chart.render.IActionRenderer;
import org.eclipse.birt.chart.render.IAxesDecorator;
import org.eclipse.birt.chart.render.ISeriesRenderer;
import org.eclipse.birt.chart.render.ISeriesRenderingHints;
import org.eclipse.birt.chart.render.MarkerRenderer;
import org.eclipse.birt.chart.script.AbstractScriptHandler;
import org.eclipse.birt.chart.script.ScriptHandler;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.chart.util.FillUtil;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.emf.common.util.EList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseRenderer
implements ISeriesRenderer {
    protected static final String STACKED_SERIES_LOCATION_KEY = "stacked_series_location_key";
    protected static final String FIXED_STACKED_SERIES_LOCATION_KEY = "fixed_stacked_series_location_key";
    protected static final String FIXED_STACKED_SERIES_INDEX_KEY = "fixed_stacked_series_index_key";
    protected static final String STACKED_SERIES_SIZE_KEY = "stacked_series_size_key";
    protected static final IGObjectFactory goFactory = GObjectFactory.instance();
    protected ISeriesRenderingHints srh;
    protected IDisplayServer xs;
    protected IDeviceRenderer ir;
    protected DeferredCache dc;
    protected Chart cm;
    protected PlotComputation oComputations;
    protected Series se;
    protected SeriesDefinition sd;
    protected IChartComputation cComp;
    protected BaseRenderer[] brna;
    protected transient int iSeriesIndex = -1;
    protected transient int iSeriesCount = 1;
    protected static final ColorDefinition SHADOW = goFactory.createColorDefinition(64, 64, 64, 127);
    protected static final ColorDefinition DARK_GLASS = goFactory.createColorDefinition(64, 64, 64, 127);
    protected static final ColorDefinition LIGHT_GLASS = goFactory.createColorDefinition(196, 196, 196, 127);
    protected static final double OVERRIDE_TRANSPARENCY = 50.0;
    protected transient RunTimeContext rtc = null;
    protected DeferredCacheManager fDeferredCacheManager;
    private static final ILogger logger = Logger.getLogger("org.eclipse.birt.chart.engine/render");
    static Comparator<SeriesDefinition> zOrderComparatorImpl = new Comparator<SeriesDefinition>(){

        @Override
        public int compare(SeriesDefinition o1, SeriesDefinition o2) {
            if (o1 != null && o2 != null) {
                return o1.getZOrder() - o2.getZOrder();
            }
            return 0;
        }
    };
    static Comparator<BaseRenderer> zOrderComparator = new Comparator<BaseRenderer>(){

        @Override
        public int compare(BaseRenderer o1, BaseRenderer o2) {
            if (o1 != null && o2 != null) {
                return zOrderComparatorImpl.compare(o1.getSeriesDefinition(), o2.getSeriesDefinition());
            }
            return 0;
        }
    };

    public void set(Chart _cm, PlotComputation _oComputation, Series _se, SeriesDefinition _sd) {
        this.cm = _cm;
        this.setComputation(_oComputation);
        this.se = _se;
        this.sd = _sd;
    }

    private void setComputation(PlotComputation _oComputation) {
        this.oComputations = _oComputation;
        this.cComp = _oComputation.getChartComputation();
    }

    public final void set(DeferredCache _dc) {
        this.dc = _dc;
    }

    public final void set(IDeviceRenderer _ir) {
        this.ir = _ir;
    }

    public final void set(IDisplayServer _xs) {
        this.xs = _xs;
    }

    public final void set(ISeriesRenderingHints _srh) {
        this.srh = _srh;
    }

    public final void set(BaseRenderer[] _brna) {
        this.brna = _brna;
    }

    public final void set(RunTimeContext _rtc) {
        this.rtc = _rtc;
    }

    public final ISeriesRenderingHints getSeriesRenderingHints() {
        return this.srh;
    }

    public final IDisplayServer getXServer() {
        return this.xs;
    }

    public final double getDeviceScale() {
        return (double)this.xs.getDpiResolution() / 72.0;
    }

    public final SeriesDefinition getSeriesDefinition() {
        return this.sd;
    }

    public final int getSeriesIndex() {
        return this.iSeriesIndex;
    }

    public final int getSeriesCount() {
        return this.iSeriesCount;
    }

    public final DeferredCache getDeferredCache() {
        return this.dc;
    }

    public final BaseRenderer getRenderer(int iIndex) {
        return this.brna[iIndex];
    }

    public final RunTimeContext getRunTimeContext() {
        return this.rtc;
    }

    public void render(Map<Series, LegendItemRenderingHints> htRenderers, Bounds bo) throws ChartException {
        boolean bFirstInSequence = this.iSeriesIndex == 0;
        boolean bLastInSequence = this.iSeriesIndex == this.iSeriesCount - 1;
        boolean bStarted = bFirstInSequence;
        Block bl = this.cm.getBlock();
        Enumeration<Block> e = bl.children(true);
        BlockGenerationEvent bge = new BlockGenerationEvent(this);
        IDeviceRenderer idr = this.getDevice();
        AbstractScriptHandler sh = this.getRunTimeContext().getScriptHandler();
        if (bFirstInSequence) {
            ScriptHandler.callFunction(sh, "beforeDrawBlock", bl, this.getRunTimeContext().getScriptContext());
            this.getRunTimeContext().notifyStructureChange("beforeDrawBlock", bl);
            bge.updateBlock(bl);
            this.renderChartBlock(idr, bl, StructureSource.createChartBlock(bl));
            ScriptHandler.callFunction(sh, "afterDrawBlock", bl, this.getRunTimeContext().getScriptContext());
            this.getRunTimeContext().notifyStructureChange("afterDrawBlock", bl);
        }
        while (e.hasMoreElements()) {
            bl = e.nextElement();
            bge.updateBlock(bl);
            if (bl instanceof Plot) {
                ScriptHandler.callFunction(sh, "beforeDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                this.getRunTimeContext().notifyStructureChange("beforeDrawBlock", bl);
                this.renderPlot(this.ir, (Plot)bl);
                ScriptHandler.callFunction(sh, "afterDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                this.getRunTimeContext().notifyStructureChange("afterDrawBlock", bl);
                if (bFirstInSequence && !bLastInSequence) break;
                if (bStarted) continue;
                bStarted = true;
                continue;
            }
            if (bl instanceof TitleBlock && bStarted) {
                ScriptHandler.callFunction(sh, "beforeDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                this.getRunTimeContext().notifyStructureChange("beforeDrawBlock", bl);
                this.renderTitle(this.ir, (TitleBlock)bl);
                ScriptHandler.callFunction(sh, "afterDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                this.getRunTimeContext().notifyStructureChange("afterDrawBlock", bl);
                continue;
            }
            if (bl instanceof LabelBlock && bStarted) {
                ScriptHandler.callFunction(sh, "beforeDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                this.getRunTimeContext().notifyStructureChange("beforeDrawBlock", bl);
                this.renderLabel(this.ir, bl, StructureSource.createUnknown(bl));
                ScriptHandler.callFunction(sh, "afterDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                this.getRunTimeContext().notifyStructureChange("afterDrawBlock", bl);
                continue;
            }
            if (bl instanceof Legend && bStarted && bLastInSequence) {
                ScriptHandler.callFunction(sh, "beforeDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                this.getRunTimeContext().notifyStructureChange("beforeDrawBlock", bl);
                this.renderLegend(idr, (Legend)bl, htRenderers);
                ScriptHandler.callFunction(sh, "afterDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                this.getRunTimeContext().notifyStructureChange("afterDrawBlock", bl);
                continue;
            }
            if (!bStarted) continue;
            ScriptHandler.callFunction(sh, "beforeDrawBlock", bl, this.getRunTimeContext().getScriptContext());
            this.getRunTimeContext().notifyStructureChange("beforeDrawBlock", bl);
            this.renderBlock(this.ir, bl, StructureSource.createUnknown(bl));
            ScriptHandler.callFunction(sh, "afterDrawBlock", bl, this.getRunTimeContext().getScriptContext());
            this.getRunTimeContext().notifyStructureChange("afterDrawBlock", bl);
        }
        if (bLastInSequence) {
            try {
                this.fDeferredCacheManager.flushAll();
            }
            catch (ChartException ex) {
                throw new ChartException("org.eclipse.birt.chart.engine", 11, (Throwable)((Object)ex));
            }
        }
    }

    private double getItemWidth(Map<LegendItemHints, Double> columnCache, Bounds bo, LegendItemHints lih, boolean bVertical) {
        double itemWidth = lih.getWidth();
        if (bVertical) {
            Double cachedWidth = columnCache.get(lih);
            itemWidth = cachedWidth != null ? cachedWidth.doubleValue() : bo.getWidth();
        }
        return itemWidth;
    }

    private void renderAllLegendItems(IPrimitiveRenderer ipr, Legend lg, LegendLayoutHints lilh, Map<Series, LegendItemRenderingHints> htRenderers, Bounds bo, double dBaseX, double dBaseY) throws ChartException {
        boolean bPaletteByCategory;
        ClientArea ca = lg.getClientArea();
        double dScale = this.getDeviceScale();
        LineAttributes lia = goFactory.copyOf(ca.getOutline());
        lia.setVisible(true);
        LineAttributes liSep = lg.getSeparator() == null ? lia : lg.getSeparator();
        Label la = goFactory.createLabel();
        la.setCaption(goFactory.copyOf(lg.getText()));
        la.getCaption().setValue("X");
        double dItemHeight = this.cComp.computeFontHeight(this.xs, la) + la.getInsets().getTop() + la.getInsets().getBottom();
        Insets insCA = goFactory.scaleInsets(ca.getInsets(), dScale);
        LegendItemHints[] liha = lilh.getLegendItemHints();
        Orientation orientation = lg.getOrientation();
        boolean bVertical = orientation.getValue() == 1;
        Map<LegendItemHints, Double> columnCache = bVertical ? this.searchMaxColumnWidth(liha, dItemHeight, insCA) : null;
        Direction direction = lg.getDirection();
        boolean bl = bPaletteByCategory = this.cm.getLegend().getItemType().getValue() == 1;
        if (lilh.getLegendItemHints() == null) {
            throw new ChartException("org.eclipse.birt.chart.engine", 11, "exception.null.legend.item.hints", Messages.getResourceBundle(this.rtc.getULocale()));
        }
        if (orientation.getValue() != 1 && orientation.getValue() != 0) {
            throw new ChartException("org.eclipse.birt.chart.engine", 11, "exception.illegal.legend.orientation", new Object[]{orientation.getName()}, Messages.getResourceBundle(this.rtc.getULocale()));
        }
        if (direction.getValue() != 1 && direction.getValue() != 0) {
            throw new ChartException("org.eclipse.birt.chart.engine", 11, "exception.illegal.legend.direction", new Object[]{direction.getName()}, Messages.getResourceBundle(this.rtc.getULocale()));
        }
        int k = 0;
        while (k < liha.length) {
            LegendItemHints lih = liha[k];
            double itemWidth = this.getItemWidth(columnCache, bo, lih, bVertical);
            if (lih.getType() == LegendItemHints.Type.LG_GROUPNAME) {
                la.getCaption().setValue(EllipsisHelper.ellipsisString(lih.getItemText(), lih.getValidItemLen()));
                this.renderLegendGroupName(ipr, lg, la, dBaseX + lih.getLeft(), dBaseY + lih.getTop(), itemWidth, lih.getItemHeight(), 4.0);
            } else if (lih.getType() == LegendItemHints.Type.LG_ENTRY || lih.getType() == LegendItemHints.Type.LG_MINSLICE) {
                la.getCaption().setValue(lih.getItemText());
                Series se = lih.getSeries();
                LegendItemRenderingHints lirh = htRenderers.get(se);
                EList<Fill> elPaletteEntries = lih.getSeriesDefinition().getSeriesPalette().getEntries();
                Label valueLa = null;
                if (!bPaletteByCategory && lg.isShowValue()) {
                    valueLa = goFactory.copyOf(se.getLabel());
                    valueLa.getCaption().setValue(EllipsisHelper.ellipsisString(lih.getValueText(), lih.getValidValueLen()));
                    valueLa.setVisible(true);
                }
                Fill fPaletteEntry = FillUtil.getPaletteFill(elPaletteEntries, lih.getIndex());
                if (!bVertical) {
                    itemWidth = BaseRenderer.getFullLegendItemWidth(itemWidth, dItemHeight, insCA);
                }
                this.renderLegendItem(ipr, lg, la, valueLa, lih, dBaseX + lih.getLeft(), dBaseY + lih.getTop() + insCA.getTop(), dItemHeight, itemWidth, insCA.getLeft(), 4.0, fPaletteEntry, lirh, dScale);
            } else if (lih.getType() == LegendItemHints.Type.LG_SEPERATOR) {
                double sepratorLength;
                Orientation sepratorOrientation;
                if (direction.getValue() == 1) {
                    sepratorOrientation = Orientation.HORIZONTAL_LITERAL;
                    sepratorLength = orientation.getValue() == 1 ? itemWidth : bo.getWidth();
                } else {
                    sepratorOrientation = Orientation.VERTICAL_LITERAL;
                    sepratorLength = orientation.getValue() == 1 ? bo.getHeight() : lih.getItemHeight();
                }
                BaseRenderer.renderSeparator(ipr, lg, liSep, dBaseX + lih.getLeft(), dBaseY + lih.getTop(), sepratorLength, sepratorOrientation);
            }
            ++k;
        }
    }

    public IAxesDecorator getAxesDecorator(OneAxis ax) {
        return null;
    }

    protected Location getPanningOffset() throws ChartException {
        return null;
    }

    public boolean isTransposed() {
        return false;
    }

    protected Engine3D get3DEngine() {
        return null;
    }

    protected final void renderMarker(Object oParent, IPrimitiveRenderer ipr, Marker m, Location lo, LineAttributes lia, Fill fPaletteEntry, DataPointHints dph, Integer markerSize, boolean bDeferred, boolean bConsiderTranspostion) throws ChartException {
        if (dph != null && dph.getIndex() >= 0 && (BaseRenderer.isNaN(dph.getOrthogonalValue()) || dph.isOutside())) {
            return;
        }
        if (m != null) {
            Fill markerFill = m.getFill();
            m = goFactory.copyMarkerNoFill(m);
            if (dph != null && dph.getOrthogonalValue() instanceof Double) {
                fPaletteEntry = FillUtil.convertFill(fPaletteEntry, (Double)dph.getOrthogonalValue(), null);
            }
            if (m.getType().getValue() != 4 && fPaletteEntry != null) {
                m.setFill(fPaletteEntry);
            } else {
                m.setFill(goFactory.copyOf(markerFill));
            }
        }
        AbstractScriptHandler sh = this.getRunTimeContext().getScriptHandler();
        ScriptHandler.callFunction(sh, "beforeDrawMarker", m, dph, this.getRunTimeContext().getScriptContext());
        this.getRunTimeContext().notifyStructureChange("beforeDrawMarker", m);
        Series se = this.getSeries();
        StructureSource oSource = oParent instanceof Legend ? StructureSource.createLegend((Legend)oParent) : WrappedStructureSource.createSeriesDataPoint(se, dph);
        boolean bTransposed = bConsiderTranspostion && this.isTransposed();
        PrimitiveRenderEvent preCopy = null;
        if (m == null || !m.isVisible()) {
            OvalRenderEvent ore;
            int iSize = 5;
            if (m != null) {
                iSize = m.getSize();
            }
            if (lo instanceof Location3D) {
                ore = ((EventObjectCache)((Object)ipr)).getEventObject(oSource, Oval3DRenderEvent.class);
                Location3D lo3d = (Location3D)lo;
                ((Oval3DRenderEvent)ore).setLocation3D(new Location3D[]{goFactory.createLocation3D(lo3d.getX() - (double)iSize, lo3d.getY() + (double)iSize, lo3d.getZ()), goFactory.createLocation3D(lo3d.getX() - (double)iSize, lo3d.getY() - (double)iSize, lo3d.getZ()), goFactory.createLocation3D(lo3d.getX() + (double)iSize, lo3d.getY() - (double)iSize, lo3d.getZ()), goFactory.createLocation3D(lo3d.getX() + (double)iSize, lo3d.getY() + (double)iSize, lo3d.getZ())});
                preCopy = ((Oval3DRenderEvent)ore).copy();
            } else {
                ore = ((EventObjectCache)((Object)ipr)).getEventObject(oSource, OvalRenderEvent.class);
                ore.setBounds(goFactory.createBounds(lo.getX() - (double)iSize, lo.getY() - (double)iSize, iSize * 2, iSize * 2));
                preCopy = ore.copy();
            }
        } else if (m.isVisible()) {
            MarkerRenderer mr = new MarkerRenderer(this.getDevice(), oSource, lo, lia, m.getFill(), m, markerSize, this.getDeferredCache(), bDeferred, bTransposed);
            mr.draw(ipr);
            preCopy = mr.getRenderArea();
        }
        if (this.isInteractivityEnabled() && dph != null && !(oParent instanceof Legend)) {
            EList<Trigger> elTriggers;
            Location panningOffset = this.getPanningOffset();
            Engine3D engine3d = this.get3DEngine();
            if ((!(lo instanceof Location3D) || panningOffset != null && engine3d != null && engine3d.processEvent(preCopy, panningOffset.getX(), panningOffset.getY()) != null) && !(elTriggers = se.getTriggers()).isEmpty()) {
                StructureSource iSource = WrappedStructureSource.createSeriesDataPoint(se, dph);
                InteractionEvent iev = ((EventObjectCache)((Object)ipr)).getEventObject(iSource, InteractionEvent.class);
                iev.setCursor(se.getCursor());
                int t = 0;
                while (t < elTriggers.size()) {
                    Trigger tg = goFactory.copyOf((Trigger)elTriggers.get(t));
                    this.processTrigger(tg, iSource);
                    iev.addTrigger(tg);
                    ++t;
                }
                iev.setHotSpot(preCopy);
                iev.setZOrder((short)m.getSize());
                ipr.enableInteraction(iev);
            }
        }
        ScriptHandler.callFunction(sh, "afterDrawMarker", m, dph, this.getRunTimeContext().getScriptContext());
        this.getRunTimeContext().notifyStructureChange("afterDrawMarker", m);
    }

    public void renderLegend(IPrimitiveRenderer ipr, Legend lg, Map<Series, LegendItemRenderingHints> htRenderers) throws ChartException {
        Axis axPrimaryBase;
        boolean bPaletteByCategory;
        double dY;
        double dX;
        if (!lg.isVisible()) {
            return;
        }
        this.renderBlock(ipr, lg, StructureSource.createLegend(lg));
        IDisplayServer xs = this.getDevice().getDisplayServer();
        double dScale = this.getDeviceScale();
        Bounds bo = goFactory.scaleBounds(lg.getBounds(), dScale);
        Size sz = null;
        if (lg.getPosition() != Position.INSIDE_LITERAL) {
            try {
                sz = lg.getPreferredSize(xs, this.cm, this.rtc);
            }
            catch (Exception ex) {
                throw new ChartException("org.eclipse.birt.chart.engine", 11, ex);
            }
            sz.scale(dScale);
            dX = bo.getLeft() + (bo.getWidth() - sz.getWidth()) / 2.0;
            dY = 0.0;
            if (lg.isSetAnchor()) {
                int iAnchor = lg.getAnchor().getValue();
                if (this.isRightToLeft()) {
                    if (iAnchor == 2) {
                        iAnchor = 6;
                    } else if (iAnchor == 1) {
                        iAnchor = 7;
                    } else if (iAnchor == 3) {
                        iAnchor = 5;
                    } else if (iAnchor == 6) {
                        iAnchor = 2;
                    } else if (iAnchor == 7) {
                        iAnchor = 1;
                    } else if (iAnchor == 5) {
                        iAnchor = 3;
                    }
                }
                switch (iAnchor) {
                    case 0: 
                    case 1: 
                    case 7: {
                        dY = bo.getTop();
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        dY = bo.getTop() + bo.getHeight() - sz.getHeight();
                        break;
                    }
                    default: {
                        dY = bo.getTop() + (bo.getHeight() - sz.getHeight()) / 2.0;
                    }
                }
                switch (iAnchor) {
                    case 5: 
                    case 6: 
                    case 7: {
                        dX = bo.getLeft();
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        dX = bo.getLeft() + bo.getWidth() - sz.getWidth();
                        break;
                    }
                    default: {
                        dX = bo.getLeft() + (bo.getWidth() - sz.getWidth()) / 2.0;
                        break;
                    }
                }
            } else {
                dX = bo.getLeft() + (bo.getWidth() - sz.getWidth()) / 2.0;
                dY = bo.getTop() + (bo.getHeight() - sz.getHeight()) / 2.0;
            }
        } else {
            dX = bo.getLeft();
            dY = bo.getTop();
            sz = SizeImpl.create(bo.getWidth(), bo.getHeight());
        }
        LegendLayoutHints lilh = this.rtc.getLegendLayoutHints();
        if (lilh == null) {
            throw new ChartException("org.eclipse.birt.chart.engine", 11, "exception.null.legend.layout.hints", Messages.getResourceBundle(this.rtc.getULocale()));
        }
        Label lgTitle = lg.getTitle();
        double lgTitleWidth = 0.0;
        double lgTitleHeight = 0.0;
        double yOffset = 0.0;
        double xOffset = 0.0;
        double wOffset = 0.0;
        double hOffset = 0.0;
        boolean bRenderLegendTitle = lgTitle != null && lgTitle.isVisible() && !lilh.getLaTitle().getCaption().getValue().equals("");
        int iTitlePos = 0;
        if (bRenderLegendTitle) {
            lgTitle = lilh.getLaTitle();
            Size titleSize = lilh.getTitleSize();
            lgTitleWidth = titleSize.getWidth();
            lgTitleHeight = titleSize.getHeight();
            iTitlePos = lg.getTitlePosition().getValue();
            if (this.isRightToLeft()) {
                if (iTitlePos == 2) {
                    iTitlePos = 3;
                } else if (iTitlePos == 3) {
                    iTitlePos = 2;
                }
            }
            switch (iTitlePos) {
                case 0: {
                    yOffset = lgTitleHeight;
                    hOffset = -yOffset;
                    break;
                }
                case 1: {
                    hOffset = -lgTitleHeight;
                    break;
                }
                case 2: {
                    xOffset = lgTitleWidth;
                    wOffset = -xOffset;
                    break;
                }
                case 3: {
                    wOffset = -lgTitleWidth;
                }
            }
        }
        ClientArea ca = lg.getClientArea();
        Insets lgIns = goFactory.scaleInsets(lg.getInsets(), dScale);
        LineAttributes lia = ca.getOutline();
        bo = goFactory.createBounds(dX, dY, sz.getWidth(), sz.getHeight());
        bo = goFactory.adjusteBounds(bo, lgIns);
        dX = bo.getLeft();
        dY = bo.getTop();
        bo.delta(xOffset, yOffset, wOffset, hOffset);
        dX = bo.getLeft();
        dY = bo.getTop();
        double dBaseX = dX;
        double dBaseY = dY;
        RectangleRenderEvent rre = ((EventObjectCache)((Object)this.ir)).getEventObject(StructureSource.createLegend(lg), RectangleRenderEvent.class);
        if (ca.getShadowColor() != null) {
            rre.setBounds(goFactory.translateBounds(bo, 3.0, 3.0));
            rre.setBackground(ca.getShadowColor());
            ipr.fillRectangle(rre);
        }
        rre.setBounds(bo);
        rre.setOutline(lia);
        rre.setBackground(ca.getBackground());
        ipr.fillRectangle(rre);
        ipr.drawRectangle(rre);
        lia = goFactory.copyOf(lia);
        lia.setVisible(true);
        boolean bl = bPaletteByCategory = this.cm.getLegend().getItemType().getValue() == 1;
        if (bPaletteByCategory && (this.cm instanceof ChartWithAxes ? (axPrimaryBase = ((ChartWithAxes)this.cm).getBaseAxes()[0]).getSeriesDefinitions().isEmpty() : this.cm instanceof ChartWithoutAxes && ((ChartWithoutAxes)this.cm).getSeriesDefinitions().isEmpty())) {
            return;
        }
        this.handelLegendBehavior(lg);
        this.renderAllLegendItems(ipr, lg, lilh, htRenderers, bo, dBaseX, dBaseY);
        if (bRenderLegendTitle) {
            double lX = bo.getLeft();
            double lY = bo.getTop();
            switch (iTitlePos) {
                case 0: {
                    lX = bo.getLeft() + (bo.getWidth() - lgTitleWidth) / 2.0;
                    lY = bo.getTop() - lgTitleHeight;
                    break;
                }
                case 1: {
                    lX = bo.getLeft() + (bo.getWidth() - lgTitleWidth) / 2.0;
                    lY = bo.getTop() + bo.getHeight();
                    break;
                }
                case 2: {
                    lX = bo.getLeft() - lgTitleWidth;
                    lY = bo.getTop() + (bo.getHeight() - lgTitleHeight) / 2.0;
                    break;
                }
                case 3: {
                    lX = bo.getLeft() + bo.getWidth();
                    lY = bo.getTop() + (bo.getHeight() - lgTitleHeight) / 2.0;
                }
            }
            TextRenderEvent tre = ((EventObjectCache)((Object)this.ir)).getEventObject(WrappedStructureSource.createLegendTitle(lg, lgTitle), TextRenderEvent.class);
            tre.setBlockBounds(goFactory.createBounds(lX, lY, lgTitleWidth, lgTitleHeight));
            TextAlignment ta = TextAlignmentImpl.create();
            ta.setHorizontalAlignment(HorizontalAlignment.CENTER_LITERAL);
            ta.setVerticalAlignment(VerticalAlignment.CENTER_LITERAL);
            tre.setBlockAlignment(ta);
            tre.setLabel(lgTitle);
            tre.setAction(3);
            if (this.rtc.isRightToLeftText()) {
                tre.setRtlCaption();
            }
            ipr.drawText(tre);
        }
    }

    private static double getFullLegendItemWidth(double dItemTextWidth, double dItemHeight, Insets insCA) {
        return dItemTextWidth + 1.5 * dItemHeight + 2.0 * insCA.getLeft();
    }

    protected static final void renderSeparator(IPrimitiveRenderer ipr, Legend lg, LineAttributes lia, double dX, double dY, double dLength, Orientation o) throws ChartException {
        if (o.getValue() == 0) {
            LineRenderEvent lre = ((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createLegend(lg), LineRenderEvent.class);
            lre.setLineAttributes(lia);
            lre.setStart(goFactory.createLocation(dX, dY));
            lre.setEnd(goFactory.createLocation(dX + dLength, dY));
            ipr.drawLine(lre);
        } else if (o.getValue() == 1) {
            LineRenderEvent lre = ((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createLegend(lg), LineRenderEvent.class);
            lre.setLineAttributes(lia);
            lre.setStart(goFactory.createLocation(dX, dY));
            lre.setEnd(goFactory.createLocation(dX, dY + dLength));
            ipr.drawLine(lre);
        }
    }

    protected Map<LegendItemHints, Double> searchMaxColumnWidth(LegendItemHints[] liha, double dItemHeight, Insets insCA) {
        HashMap<LegendItemHints, Double> rt = new HashMap<LegendItemHints, Double>();
        int start = -1;
        double x = 0.0;
        double maxWidth = 0.0;
        int i = 0;
        while (i < liha.length) {
            double dWidth = liha[i].getWidth();
            if (liha[i].getType() == LegendItemHints.Type.LG_ENTRY || liha[i].getType() == LegendItemHints.Type.LG_MINSLICE) {
                dWidth = BaseRenderer.getFullLegendItemWidth(dWidth, dItemHeight, insCA);
            }
            if (start < 0) {
                start = i;
                x = liha[i].getLeft();
                maxWidth = dWidth;
            } else if (liha[i].getLeft() != x) {
                int j = start;
                while (j < i) {
                    rt.put(liha[j], new Double(maxWidth));
                    ++j;
                }
                start = i;
                x = liha[i].getLeft();
                maxWidth = dWidth;
            } else {
                maxWidth = Math.max(maxWidth, dWidth);
            }
            ++i;
        }
        int j = Math.max(start, 0);
        while (j < liha.length) {
            rt.put(liha[j], new Double(maxWidth));
            ++j;
        }
        return rt;
    }

    private boolean checkActionType(Action action, ActionType actionType) {
        if (action instanceof MultipleActions) {
            for (Action ac : ((MultipleActions)action).getActions()) {
                if (ac.getType() != actionType) continue;
                return true;
            }
            return false;
        }
        return action != null && action.getType() == actionType;
    }

    private void handelLegendBehavior(Legend lg) {
        if (this.isInteractivityEnabled() && this.cm.getInteractivity() != null) {
            ActionType actionType = null;
            switch (this.cm.getInteractivity().getLegendBehavior().getValue()) {
                case 2: {
                    actionType = ActionType.HIGHLIGHT_LITERAL;
                    break;
                }
                case 1: {
                    actionType = ActionType.TOGGLE_VISIBILITY_LITERAL;
                }
            }
            if (actionType == null) {
                return;
            }
            Trigger tgOnClick = null;
            boolean customed = false;
            for (Trigger trigger : lg.getTriggers()) {
                if (trigger.getCondition() != TriggerCondition.ONCLICK_LITERAL) continue;
                tgOnClick = trigger;
                customed = this.checkActionType(trigger.getAction(), actionType);
                break;
            }
            if (!customed) {
                Action action = goFactory.createAction(actionType, goFactory.createSeriesValue(String.valueOf(this.se.getSeriesIdentifier())));
                if (tgOnClick == null) {
                    tgOnClick = goFactory.createTrigger(TriggerCondition.ONCLICK_LITERAL, action);
                    lg.getTriggers().add((Object)tgOnClick);
                } else {
                    Action oldAction = tgOnClick.getAction();
                    if (oldAction instanceof MultipleActions) {
                        ((MultipleActions)oldAction).getActions().add((Object)action);
                    } else {
                        MultipleActions ma = MultipleActionsImpl.create();
                        ma.getActions().add((Object)action);
                        ma.getActions().add((Object)oldAction);
                        tgOnClick.setAction(ma);
                    }
                }
            }
        }
    }

    protected final void renderLegendItem(IPrimitiveRenderer ipr, Legend lg, Label la, Label valueLa, LegendItemHints lih, double dX, double dY, double dItemHeight, double dColumnWidth, double dLeftInset, double dHorizontalSpacing, Fill fPaletteEntry, LegendItemRenderingHints lirh, double dScale) throws ChartException {
        double dFullHeight = lih.getItemHeight();
        double dExtraHeight = lih.getValueHeight();
        Series se = lih.getSeries();
        int dataIndex = lih.getIndex();
        if (la != null && la.getCaption() != null && valueLa != null && valueLa.getCaption() != null) {
            valueLa.getCaption().setFont(goFactory.copyOf(la.getCaption().getFont()));
            valueLa.getCaption().setColor(goFactory.copyOf(la.getCaption().getColor()));
        }
        this.updateTranslucency(fPaletteEntry, lih.getSeries());
        LegendEntryRenderingHints lerh = new LegendEntryRenderingHints(la, valueLa, dataIndex, fPaletteEntry);
        AbstractScriptHandler sh = this.getRunTimeContext().getScriptHandler();
        ScriptHandler.callFunction(sh, "beforeDrawLegendEntry", la, this.getRunTimeContext().getScriptContext());
        this.getRunTimeContext().notifyStructureChange("beforeDrawLegendEntry", la);
        Bounds bo = lirh.getLegendGraphicBounds();
        if (this.isRightToLeft()) {
            bo.setLeft((dX + dColumnWidth - dLeftInset - 1.0 - 3.0 * dItemHeight / 2.0) / dScale);
        } else {
            bo.setLeft((dX + dLeftInset + 1.0) / dScale);
        }
        bo.setTop((dY + 1.0 + (dFullHeight - dItemHeight) / 2.0) / dScale);
        bo.setWidth(3.0 * dItemHeight / 2.0 / dScale);
        bo.setHeight((dItemHeight - 2.0) / dScale);
        ScriptHandler.callFunction(sh, "beforeDrawLegendItem", lerh, bo, this.getRunTimeContext().getScriptContext());
        this.getRunTimeContext().notifyStructureChange("beforeDrawLegendItem", lerh);
        if (la != null) {
            la.getCaption().setValue(EllipsisHelper.ellipsisString(la.getCaption().getValue(), lih.getValidItemLen()));
        }
        this.cComp.applyWrapping(this.xs, la, lg.getWrappingSize());
        bo.setLeft(bo.getLeft() * dScale);
        bo.setTop(bo.getTop() * dScale);
        bo.setWidth(bo.getWidth() * dScale);
        bo.setHeight(bo.getHeight() * dScale);
        BaseRenderer br = lirh.getRenderer();
        br.renderLegendGraphic(ipr, lg, fPaletteEntry, bo);
        TextRenderEvent tre = ((EventObjectCache)((Object)this.ir)).getEventObject(StructureSource.createLegend(lg), TextRenderEvent.class);
        double dDeltaHeight = 0.0;
        if (la != null) {
            double dLaAngle = la.getCaption().getFont().getRotation();
            if (this.isRightToLeft()) {
                dLaAngle = -dLaAngle;
            }
            if (dLaAngle > 0.0 && dLaAngle < 90.0) {
                dDeltaHeight = (bo.getHeight() + dFullHeight - dItemHeight) / 2.0;
            } else if (dLaAngle < 0.0 && dLaAngle > -90.0) {
                dDeltaHeight = (bo.getHeight() - dFullHeight + dItemHeight) / 2.0;
            } else if (dLaAngle == 0.0 || dLaAngle == 90.0 || dLaAngle == -90.0) {
                dDeltaHeight = bo.getHeight() / 2.0;
            }
        }
        if (this.isRightToLeft()) {
            tre.setLocation(goFactory.createLocation(dX + dColumnWidth - dLeftInset - 3.0 * dItemHeight / 2.0 - dHorizontalSpacing, bo.getTop() + dDeltaHeight));
            tre.setTextPosition(1);
        } else {
            tre.setLocation(goFactory.createLocation(dX + dLeftInset + 3.0 * dItemHeight / 2.0 + dHorizontalSpacing, bo.getTop() + dDeltaHeight));
            tre.setTextPosition(2);
        }
        if (la != null && la.isVisible()) {
            tre.setLabel(la);
            tre.setAction(2);
            if (this.rtc.isRightToLeftText()) {
                tre.setRtlCaption();
            }
            ipr.drawText(tre);
        }
        if (valueLa != null) {
            double dValueWidth = dColumnWidth - 2.0 * dLeftInset;
            Label tmpLa = goFactory.copyOf(valueLa);
            TextAlignment ta = TextAlignmentImpl.create();
            ta.setHorizontalAlignment(HorizontalAlignment.CENTER_LITERAL);
            ta.setVerticalAlignment(VerticalAlignment.CENTER_LITERAL);
            tre.setBlockAlignment(ta);
            tre.setBlockBounds(goFactory.createBounds(dX + dLeftInset + 1.0, dY + dFullHeight + 1.0, dValueWidth - 2.0, dExtraHeight - 1.0));
            tre.setLabel(tmpLa);
            tre.setAction(3);
            if (this.rtc.isRightToLeftText()) {
                tre.setRtlCaption();
            }
            ipr.drawText(tre);
        }
        if (la != null) {
            la.getCaption().setValue(lih.getItemText());
        }
        if (this.isInteractivityEnabled()) {
            EList<Trigger> elTriggers = lg.getTriggers();
            Location[] loaHotspot = new Location[]{goFactory.createLocation(dX + 1.0, dY + 1.0), goFactory.createLocation(dX + dColumnWidth - 1.0, dY + 1.0), goFactory.createLocation(dX + dColumnWidth - 1.0, dY + dFullHeight + dExtraHeight - 1.0), goFactory.createLocation(dX + 1.0, dY + dFullHeight + dExtraHeight - 1.0)};
            if (!elTriggers.isEmpty()) {
                StructureSource source;
                if (this.cm.getLegend().getItemType() == LegendItemType.CATEGORIES_LITERAL && la != null) {
                    DataPointHints dph = new DataPointHints((Object)la.getCaption().getValue(), null, null, null, null, null, null, null, null, dataIndex, null, 0.0, null);
                    source = WrappedStructureSource.createSeriesDataPoint(se, dph);
                } else {
                    source = StructureSource.createSeries(se);
                }
                source = new WrappedStructureSource(source, lih, StructureType.LEGEND_ENTRY);
                InteractionEvent iev = ((EventObjectCache)((Object)ipr)).getEventObject(source, InteractionEvent.class);
                iev.setCursor(lg.getCursor());
                int t = 0;
                while (t < elTriggers.size()) {
                    Trigger tg = goFactory.copyOf((Trigger)elTriggers.get(t));
                    this.processTrigger(tg, WrappedStructureSource.createLegendEntry(lg, lih));
                    iev.addTrigger(tg);
                    ++t;
                }
                PolygonRenderEvent pre = ((EventObjectCache)((Object)ipr)).getEventObject(source, PolygonRenderEvent.class);
                pre.setPoints(loaHotspot);
                iev.setHotSpot(pre);
                ipr.enableInteraction(iev);
            }
        }
        ScriptHandler.callFunction(sh, "afterDrawLegendItem", lerh, bo, this.getRunTimeContext().getScriptContext());
        this.getRunTimeContext().notifyStructureChange("afterDrawLegendItem", lerh);
        ScriptHandler.callFunction(sh, "afterDrawLegendEntry", la, this.getRunTimeContext().getScriptContext());
        this.getRunTimeContext().notifyStructureChange("afterDrawLegendEntry", la);
    }

    protected final void renderLegendGroupName(IPrimitiveRenderer ipr, Legend lg, Label la, double dX, double dY, double dWidth, double dHeight, double dLeftInset) throws ChartException {
        if (la.isVisible()) {
            TextRenderEvent tre = ((EventObjectCache)((Object)this.ir)).getEventObject(StructureSource.createLegend(lg), TextRenderEvent.class);
            Label tmpLa = goFactory.copyOf(la);
            TextAlignment ta = TextAlignmentImpl.create();
            ta.setHorizontalAlignment(HorizontalAlignment.CENTER_LITERAL);
            ta.setVerticalAlignment(VerticalAlignment.CENTER_LITERAL);
            tre.setBlockAlignment(ta);
            tre.setBlockBounds(goFactory.createBounds(dX + dLeftInset + 1.0, dY + 1.0, dWidth - 2.0, dHeight - 1.0));
            tre.setLabel(tmpLa);
            tre.setAction(3);
            if (this.rtc.isRightToLeftText()) {
                tre.setRtlCaption();
            }
            ipr.drawText(tre);
        }
    }

    public void renderPlot(IPrimitiveRenderer ipr, Plot p) throws ChartException {
        boolean bLastInSequence;
        if (!p.isVisible()) {
            return;
        }
        boolean bFirstInSequence = this.iSeriesIndex == 0;
        boolean bl = bLastInSequence = this.iSeriesIndex == this.iSeriesCount - 1;
        if (bFirstInSequence) {
            this.renderBackground(ipr, p);
        }
        if (this.getSeries() != null) {
            ScriptHandler.callFunction(this.getRunTimeContext().getScriptHandler(), "beforeDrawSeries", this.getSeries(), this, this.getRunTimeContext().getScriptContext());
            this.getRunTimeContext().notifyStructureChange("beforeDrawSeries", this.getSeries());
            this.renderSeries(ipr, p, this.srh);
            ScriptHandler.callFunction(this.getRunTimeContext().getScriptHandler(), "afterDrawSeries", this.getSeries(), this, this.getRunTimeContext().getScriptContext());
            this.getRunTimeContext().notifyStructureChange("afterDrawSeries", this.getSeries());
        }
    }

    protected void renderBackground(IPrimitiveRenderer ipr, Plot p) throws ChartException {
        double dScale = this.getDeviceScale();
        RectangleRenderEvent rre = ((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createPlot(p), RectangleRenderEvent.class);
        rre.updateFrom(p, dScale);
        ipr.fillRectangle(rre);
        ipr.drawRectangle(rre);
        PlotComputation oComputations = this.getComputations();
        if (oComputations instanceof PlotWithoutAxes) {
            PlotWithoutAxes pwoa = (PlotWithoutAxes)oComputations;
            ClientArea ca = p.getClientArea();
            Bounds bo = pwoa.getPlotBounds();
            if (ca.getShadowColor() != null) {
                rre.setBounds(goFactory.translateBounds(bo, 3.0, 3.0));
                rre.setBackground(ca.getShadowColor());
                ipr.fillRectangle(rre);
            }
            rre.setBounds(bo);
            rre.setBackground(ca.getBackground());
            ipr.fillRectangle(rre);
            if (ca.getOutline().isVisible()) {
                Size sz = pwoa.getCellSize();
                LineRenderEvent lre = ((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createPlot(p), LineRenderEvent.class);
                lre.setLineAttributes(ca.getOutline());
                int colCount = pwoa.getColumnCount();
                int rowCount = pwoa.getRowCount();
                ChartWithoutAxes cwoa = pwoa.getModel();
                if (cwoa instanceof DialChart && ((DialChart)cwoa).isDialSuperimposition()) {
                    colCount = 1;
                    rowCount = 1;
                }
                int i = 0;
                while (i < colCount + 1) {
                    lre.setStart(goFactory.createLocation(bo.getLeft() + (double)i * sz.getWidth(), bo.getTop()));
                    lre.setEnd(goFactory.createLocation(bo.getLeft() + (double)i * sz.getWidth(), bo.getTop() + bo.getHeight()));
                    ipr.drawLine(lre);
                    ++i;
                }
                int j = 0;
                while (j < rowCount + 1) {
                    lre.setStart(goFactory.createLocation(bo.getLeft(), bo.getTop() + (double)j * sz.getHeight()));
                    lre.setEnd(goFactory.createLocation(bo.getLeft() + bo.getWidth(), bo.getTop() + (double)j * sz.getHeight()));
                    ipr.drawLine(lre);
                    ++j;
                }
            }
        }
    }

    protected void renderBlock(IPrimitiveRenderer ipr, Block b, Object oSource) throws ChartException {
        double dScale = this.getDeviceScale();
        RectangleRenderEvent rre = ((EventObjectCache)((Object)ipr)).getEventObject(oSource, RectangleRenderEvent.class);
        rre.updateFrom(b, dScale);
        ipr.fillRectangle(rre);
        ipr.drawRectangle(rre);
    }

    protected void renderChartBlock(IPrimitiveRenderer ipr, Block b, Object oSource) throws ChartException {
        double dScale = this.getDeviceScale();
        RectangleRenderEvent rre = ((EventObjectCache)((Object)ipr)).getEventObject(oSource, RectangleRenderEvent.class);
        rre.updateFrom(b, dScale);
        try {
            ipr.fillRectangle(rre);
        }
        catch (Exception e) {
            logger.log(e);
        }
        ipr.drawRectangle(rre);
        if (this.isInteractivityEnabled()) {
            EList<Trigger> elTriggers = b.getTriggers();
            Location[] loaHotspot = new Location[4];
            Bounds bo = goFactory.scaleBounds(b.getBounds(), dScale);
            double dLeft = bo.getLeft();
            double dTop = bo.getTop();
            double dWidth = bo.getWidth();
            double dHeight = bo.getHeight();
            loaHotspot[0] = goFactory.createLocation(dLeft, dTop);
            loaHotspot[1] = goFactory.createLocation(dLeft + dWidth, dTop);
            loaHotspot[2] = goFactory.createLocation(dLeft + dWidth, dTop + dHeight);
            loaHotspot[3] = goFactory.createLocation(dLeft, dTop + dHeight);
            if (!elTriggers.isEmpty()) {
                InteractionEvent iev = ((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createChartBlock(b), InteractionEvent.class);
                iev.setCursor(b.getCursor());
                int t = 0;
                while (t < elTriggers.size()) {
                    Trigger tg = goFactory.copyOf((Trigger)elTriggers.get(t));
                    this.processTrigger(tg, StructureSource.createChartBlock(b));
                    iev.addTrigger(tg);
                    ++t;
                }
                PolygonRenderEvent pre = ((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createChartBlock(b), PolygonRenderEvent.class);
                pre.setPoints(loaHotspot);
                iev.setHotSpot(pre);
                ipr.enableInteraction(iev);
            }
        }
    }

    public void renderLabel(IPrimitiveRenderer ipr, Block b, Object oSource) throws ChartException {
        if (!b.isVisible()) {
            return;
        }
        LabelBlock lb = (LabelBlock)b;
        Label la = lb.getLabel();
        String sPreviousValue = la.getCaption().getValue();
        la.getCaption().setValue(this.rtc.externalizedMessage(sPreviousValue));
        Map<Label, LabelLimiter> mapLimiter = this.rtc.getState(RunTimeContext.StateKey.LABEL_LIMITER_LOOKUP_KEY);
        LabelLimiter lbLimiter = mapLimiter.get(lb.getLabel());
        if (lbLimiter != null) {
            lbLimiter.computeWrapping(this.xs, lb.getLabel());
            lbLimiter = lbLimiter.limitLabelSize(this.cComp, this.xs, lb.getLabel());
            if (!lbLimiter.isSuccessed()) {
                return;
            }
        }
        this.renderBlock(ipr, b, oSource);
        double dScale = this.getDeviceScale();
        TextRenderEvent tre = ((EventObjectCache)((Object)ipr)).getEventObject(oSource, TextRenderEvent.class);
        tre.updateFrom(lb, dScale, this.rtc);
        if (lb.getLabel().isVisible()) {
            if (this.rtc.isRightToLeftText()) {
                tre.setRtlCaption();
            }
            ipr.drawText(tre);
        }
        lb.getLabel().getCaption().setValue(sPreviousValue);
    }

    public void renderTitle(IPrimitiveRenderer ipr, TitleBlock b) throws ChartException {
        Label la = b.getLabel();
        TextAlignment restoreValue = la.getCaption().getFont().getAlignment();
        la.getCaption().getFont().setAlignment(this.switchTextAlignment(restoreValue));
        this.renderLabel(ipr, b, StructureSource.createTitle(b));
        b.getLabel().getCaption().getFont().setAlignment(restoreValue);
        if (this.isInteractivityEnabled()) {
            EList<Trigger> elTriggers = b.getTriggers();
            Location[] loaHotspot = new Location[4];
            double dScale = this.getDeviceScale();
            Bounds bo = goFactory.scaleBounds(b.getBounds(), dScale);
            double dLeft = bo.getLeft();
            double dTop = bo.getTop();
            double dWidth = bo.getWidth();
            double dHeight = bo.getHeight();
            loaHotspot[0] = goFactory.createLocation(dLeft, dTop);
            loaHotspot[1] = goFactory.createLocation(dLeft + dWidth, dTop);
            loaHotspot[2] = goFactory.createLocation(dLeft + dWidth, dTop + dHeight);
            loaHotspot[3] = goFactory.createLocation(dLeft, dTop + dHeight);
            if (!elTriggers.isEmpty()) {
                InteractionEvent iev = ((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createTitle(b), InteractionEvent.class);
                iev.setCursor(b.getCursor());
                int t = 0;
                while (t < elTriggers.size()) {
                    Trigger tg = goFactory.copyOf((Trigger)elTriggers.get(t));
                    this.processTrigger(tg, StructureSource.createTitle(b));
                    iev.addTrigger(tg);
                    ++t;
                }
                PolygonRenderEvent pre = ((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createTitle(b), PolygonRenderEvent.class);
                pre.setPoints(loaHotspot);
                iev.setHotSpot(pre);
                ipr.enableInteraction(iev);
            }
        }
    }

    private static final BaseRenderer[] createEmptyInstance(Chart cm, RunTimeContext rtc, PlotComputation oComputations) {
        BaseRenderer[] brna = new BaseRenderer[1];
        EmptyWithAxes ar = new EmptyWithAxes();
        ar.iSeriesIndex = 0;
        ar.set(cm, oComputations, null, null, null);
        ar.set(rtc);
        brna[0] = ar;
        return brna;
    }

    public static final BaseRenderer[] instances(Chart cm, RunTimeContext rtc, PlotComputation oComputations) throws ChartException {
        BaseRenderer[] brna;
        block14: {
            boolean bPaletteByCategory;
            PluginSettings ps;
            block13: {
                ps = PluginSettings.instance();
                brna = null;
                boolean bl = bPaletteByCategory = cm.getLegend().getItemType().getValue() == 1;
                if (!(cm instanceof ChartWithAxes)) break block13;
                ChartWithAxes cwa = (ChartWithAxes)cm;
                Axis[] axa = cwa.getPrimaryBaseAxes();
                Axis axPrimaryBase = axa[0];
                AxesRenderer ar = null;
                ArrayList<AxesRenderer> al = new ArrayList<AxesRenderer>();
                SeriesDefinition sd = null;
                EList<SeriesDefinition> elBase = axPrimaryBase.getSeriesDefinitions();
                if (elBase.isEmpty()) {
                    return BaseRenderer.createEmptyInstance(cm, rtc, oComputations);
                }
                SeriesDefinition sdBase = (SeriesDefinition)elBase.get(0);
                List<Series> alRunTimeSeries = sdBase.getRunTimeSeries();
                if (alRunTimeSeries.isEmpty()) {
                    return BaseRenderer.createEmptyInstance(cm, rtc, oComputations);
                }
                Series se = alRunTimeSeries.get(0);
                ar = se.getClass() == SeriesImpl.class ? new EmptyWithAxes() : (AxesRenderer)ps.getRenderer(se.getClass());
                ar.set(cm, oComputations, se, axPrimaryBase, sdBase);
                ar.set(rtc);
                al.add(ar);
                Axis[] axaOrthogonal = cwa.getOrthogonalAxes(axPrimaryBase, true);
                int i = 0;
                while (i < axaOrthogonal.length) {
                    EList<SeriesDefinition> elOrthogonal = axaOrthogonal[i].getSeriesDefinitions();
                    int j = 0;
                    while (j < elOrthogonal.size()) {
                        sd = (SeriesDefinition)elOrthogonal.get(j);
                        alRunTimeSeries = sd.getRunTimeSeries();
                        int k = 0;
                        while (k < alRunTimeSeries.size()) {
                            se = alRunTimeSeries.get(k);
                            ar = se.getClass() == SeriesImpl.class ? new EmptyWithAxes() : (AxesRenderer)ps.getRenderer(se.getClass());
                            ar.set(cm, oComputations, se, axaOrthogonal[i], bPaletteByCategory ? sdBase : sd);
                            al.add(ar);
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
                if (cm.getDimension() == ChartDimension.TWO_DIMENSIONAL_LITERAL) {
                    Collections.sort(al, zOrderComparator);
                }
                brna = new BaseRenderer[al.size()];
                i = 0;
                while (i < brna.length) {
                    ar = (AxesRenderer)al.get(i);
                    ar.iSeriesIndex = i;
                    ar.iSeriesCount = brna.length;
                    brna[i] = ar;
                    ++i;
                }
                break block14;
            }
            if (!(cm instanceof ChartWithoutAxes)) break block14;
            ChartWithoutAxes cwoa = (ChartWithoutAxes)cm;
            EList<SeriesDefinition> elBase = cwoa.getSeriesDefinitions();
            Series[] sea = cwoa.getRunTimeSeries();
            int iSeriesCount = sea.length;
            brna = new BaseRenderer[iSeriesCount];
            int iSI = 0;
            int i = 0;
            while (i < elBase.size()) {
                SeriesDefinition sdBase = (SeriesDefinition)elBase.get(i);
                List<Series> alRuntimeSeries = sdBase.getRunTimeSeries();
                if (alRuntimeSeries.isEmpty() || ChartUtil.isDataEmpty(rtc)) {
                    brna = new BaseRenderer[]{new EmptyWithoutAxes()};
                    brna[0].set(cm, oComputations, (Series)sdBase.getSeries().get(0), sdBase);
                    brna[0].set(rtc);
                    brna[0].iSeriesIndex = 0;
                    brna[0].iSeriesCount = 1;
                    return brna;
                }
                if (alRuntimeSeries.size() != 1) {
                    throw new ChartException("org.eclipse.birt.chart.engine", 10, "exception.illegal.base.runtime.series.count", new Object[]{alRuntimeSeries.size()}, Messages.getResourceBundle(rtc.getULocale()));
                }
                Series se = alRuntimeSeries.get(0);
                brna[iSI] = se.getClass() == SeriesImpl.class ? new EmptyWithoutAxes() : ps.getRenderer(se.getClass());
                brna[iSI].set(cm, oComputations, se, sdBase);
                brna[iSI].set(rtc);
                brna[iSI].iSeriesIndex = iSI++;
                EList<SeriesDefinition> elOrthogonal = ((SeriesDefinition)elBase.get(i)).getSeriesDefinitions();
                int j = 0;
                while (j < elOrthogonal.size()) {
                    SeriesDefinition sd = (SeriesDefinition)elOrthogonal.get(j);
                    alRuntimeSeries = sd.getRunTimeSeries();
                    int k = 0;
                    while (k < alRuntimeSeries.size()) {
                        se = alRuntimeSeries.get(k);
                        brna[iSI] = se.getClass() == SeriesImpl.class ? new EmptyWithoutAxes() : ps.getRenderer(se.getClass());
                        brna[iSI].set(cm, oComputations, se, bPaletteByCategory ? sdBase : sd);
                        brna[iSI].iSeriesIndex = iSI++;
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            int k = 0;
            while (k < iSI) {
                brna[k].iSeriesCount = iSI;
                ++k;
            }
        }
        return brna;
    }

    public final Series getSeries() {
        return this.se;
    }

    public final Chart getModel() {
        return this.cm;
    }

    public final PlotComputation getComputations() {
        return this.oComputations;
    }

    public final IDeviceRenderer getDevice() {
        return this.ir;
    }

    protected final void renderPlane(IPrimitiveRenderer ipr, Object oSource, Location[] loaFront, Fill f, LineAttributes lia, ChartDimension cd, double dSeriesThickness, boolean bDeferred) throws ChartException {
        this.renderPlane(ipr, oSource, loaFront, f, lia, cd, dSeriesThickness, bDeferred, 0, null);
    }

    protected final void renderPlane(IPrimitiveRenderer ipr, Object oSource, Location[] loaFront, Fill f, LineAttributes lia, ChartDimension cd, double dSeriesThickness, boolean bDeferred, int zorder_hint, Bounds compareBounds) throws ChartException {
        if (cd.getValue() == 0) {
            PolygonRenderEvent pre = ((EventObjectCache)((Object)ipr)).getEventObject(oSource, PolygonRenderEvent.class);
            pre.setPoints(loaFront);
            pre.setBackground(f);
            pre.setOutline(lia);
            if (bDeferred) {
                this.dc.addPlane(pre, 3);
            } else {
                ipr.fillPolygon(pre);
                ipr.drawPolygon(pre);
            }
            return;
        }
        boolean bSolidColor = f instanceof ColorDefinition;
        Fill fDarker = null;
        Fill fBrighter = null;
        if (cd.getValue() == 1 || cd.getValue() == 2) {
            fDarker = f;
            if (fDarker instanceof ColorDefinition) {
                fDarker = goFactory.darker((ColorDefinition)fDarker);
            }
            fBrighter = f;
            if (this.getModel().getDimension() != ChartDimension.THREE_DIMENSIONAL_LITERAL) {
                if (fBrighter instanceof ColorDefinition) {
                    fBrighter = goFactory.brighter((ColorDefinition)fBrighter);
                }
            } else {
                fBrighter = FillUtil.changeBrightness(f, 0.89);
                fDarker = FillUtil.changeBrightness(f, 0.65);
                f = FillUtil.changeBrightness(f, 0.91);
            }
        }
        int nSides = loaFront.length;
        Location[][] loaa = new Location[nSides + 1][];
        double dSmallestY = 0.0;
        int i = 0;
        while (i < nSides) {
            int j = i + 1;
            if (j >= loaFront.length) {
                j = 0;
            }
            Location[] loa = new Location[]{goFactory.createLocation(loaFront[i].getX(), loaFront[i].getY()), goFactory.createLocation(loaFront[j].getX(), loaFront[j].getY()), goFactory.createLocation(loaFront[j].getX() + dSeriesThickness, loaFront[j].getY() - dSeriesThickness), goFactory.createLocation(loaFront[i].getX() + dSeriesThickness, loaFront[i].getY() - dSeriesThickness)};
            loaa[i] = loa;
            ++i;
        }
        loaa[nSides] = loaFront;
        int i2 = 0;
        while (i2 < nSides - 1) {
            Location[] loaI = loaa[i2];
            int j = i2 + 1;
            while (j < nSides) {
                Location[] loaJ = loaa[j];
                double dI = BaseRenderer.getY(loaI, 4);
                double dJ = BaseRenderer.getY(loaJ, 4);
                if (ChartUtil.mathGT(dJ, dI)) {
                    loaa[i2] = loaJ;
                    loaa[j] = loaI;
                    loaI = loaJ;
                } else if (ChartUtil.mathEqual(dJ, dI) && ChartUtil.mathGT(dI = BaseRenderer.getX(loaI, 4), dJ = BaseRenderer.getX(loaJ, 4))) {
                    loaa[i2] = loaJ;
                    loaa[j] = loaI;
                    loaI = loaJ;
                }
                ++j;
            }
            ++i2;
        }
        int iSmallestYIndex = 0;
        int i3 = 0;
        while (i3 < nSides) {
            double dY = BaseRenderer.getY(loaa[i3], 4);
            if (i3 == 0) {
                dSmallestY = dY;
            } else if (ChartUtil.mathGT(dSmallestY, dY)) {
                dSmallestY = dY;
                iSmallestYIndex = i3;
            }
            ++i3;
        }
        ArrayList<PrimitiveRenderEvent> alModel = new ArrayList<PrimitiveRenderEvent>(nSides + 1);
        int i4 = 0;
        while (i4 <= nSides) {
            PolygonRenderEvent pre = ((EventObjectCache)((Object)ipr)).getEventObject(oSource, PolygonRenderEvent.class);
            pre.setOutline(lia);
            pre.setPoints(loaa[i4]);
            if (i4 < nSides) {
                pre.setDepth(-dSeriesThickness);
            } else {
                pre.setDepth(0.0);
            }
            Fill fP = i4 == nSides ? f : (i4 == iSmallestYIndex ? fBrighter : fDarker);
            pre.setBackground(fP);
            if (bDeferred) {
                alModel.add(pre.copy());
            } else {
                ipr.fillPolygon(pre);
            }
            if (i4 != nSides) {
                if (i4 == iSmallestYIndex) {
                    if (!bSolidColor) {
                        pre.setBackground(LIGHT_GLASS);
                    }
                    if (bDeferred) {
                        alModel.add(pre.copy());
                    } else {
                        ipr.fillPolygon(pre);
                    }
                } else {
                    if (!bSolidColor) {
                        pre.setBackground(DARK_GLASS);
                    }
                    if (bDeferred) {
                        alModel.add(pre.copy());
                    } else {
                        ipr.fillPolygon(pre);
                    }
                }
            }
            if (!bDeferred) {
                ipr.drawPolygon(pre);
            }
            ++i4;
        }
        if (!alModel.isEmpty()) {
            WrappedInstruction wi = new WrappedInstruction(this.getDeferredCache(), alModel, 2, (long)zorder_hint);
            wi.setCompareBounds(compareBounds);
            this.dc.addModel(wi);
        }
    }

    protected final void render3DPlane(IPrimitiveRenderer ipr, Object oSource, List<Location3D[]> loaFace, Fill f, LineAttributes lia) throws ChartException {
        Polygon3DRenderEvent pre = ((EventObjectCache)((Object)ipr)).getEventObject(oSource, Polygon3DRenderEvent.class);
        pre.setDoubleSided(false);
        int nSides = loaFace.size();
        int i = 0;
        while (i < nSides) {
            pre.setOutline(lia);
            pre.setPoints3D(loaFace.get(i));
            pre.setBackground(f);
            this.dc.addPlane(pre, 3);
            ++i;
        }
    }

    public static final double getY(Location[] loa, int iProperty) {
        int iCount = loa.length;
        double dY = 0.0;
        if (iProperty == 2) {
            dY = loa[0].getY();
            int i = 1;
            while (i < iCount) {
                dY = Math.min(dY, loa[i].getY());
                ++i;
            }
        } else if (iProperty == 1) {
            dY = loa[0].getY();
            int i = 1;
            while (i < iCount) {
                dY = Math.max(dY, loa[i].getY());
                ++i;
            }
        } else if (iProperty == 4) {
            int i = 0;
            while (i < iCount) {
                dY += loa[i].getY();
                ++i;
            }
            dY /= (double)iCount;
        }
        return dY;
    }

    public static final double getX(Location[] loa, int iProperty) {
        int iCount = loa.length;
        double dX = 0.0;
        if (iProperty == 2) {
            dX = loa[0].getX();
            int i = 1;
            while (i < iCount) {
                dX = Math.min(dX, loa[i].getX());
                ++i;
            }
        } else if (iProperty == 1) {
            dX = loa[0].getX();
            int i = 1;
            while (i < iCount) {
                dX = Math.max(dX, loa[i].getX());
                ++i;
            }
        } else if (iProperty == 4) {
            int i = 0;
            while (i < iCount) {
                dX += loa[i].getX();
                ++i;
            }
            dX /= (double)iCount;
        }
        return dX;
    }

    public void processTrigger(Trigger tg, StructureSource source) {
        IActionRenderer iar = this.getRunTimeContext().getActionRenderer();
        if (iar != null) {
            iar.processAction(tg.getAction(), source);
        }
        if (StructureType.LEGEND_ENTRY.equals(source.getType())) {
            if (tg.getAction().getType() == ActionType.URL_REDIRECT_LITERAL) {
                LegendItemHints lerh = (LegendItemHints)source.getSource();
                this.assembleURLs(tg, lerh);
            }
        } else if (StructureType.SERIES_DATA_POINT.equals(source.getType())) {
            DataPointHints dph = (DataPointHints)source.getSource();
            if (tg.getAction().getType() == ActionType.SHOW_TOOLTIP_LITERAL) {
                String toolText = ((TooltipValue)tg.getAction().getValue()).getText();
                if (toolText == null) {
                    ((TooltipValue)tg.getAction().getValue()).setText(dph.getDisplayValue());
                }
            } else if (tg.getAction().getType() == ActionType.URL_REDIRECT_LITERAL) {
                this.assembleURLs(tg, dph);
            }
        }
    }

    private <T> void assembleURLs(Trigger tg, T valueHints) {
        if (tg.getAction() instanceof MultipleActions) {
            MultipleActions mas = (MultipleActions)tg.getAction();
            int size = mas.getActions().size();
            if (size == 0) {
                return;
            }
            if (size == 1 && ((Action)mas.getActions().get(0)).getValue() instanceof URLValue) {
                this.buildURI(valueHints, (URLValue)((Action)mas.getActions().get(0)).getValue());
            } else {
                for (Action subAction : mas.getActions()) {
                    String expr;
                    String displayName;
                    ActionValue av = subAction.getValue();
                    if ((av.getLabel() == null || av.getLabel().getCaption().getValue() == null || "".equals(av.getLabel().getCaption().getValue())) && (displayName = Messages.getString(expr = "ActionType." + subAction.getType().getName() + ".DisplayName")) != null) {
                        Label l = LabelImpl.create();
                        l.getCaption().setValue(displayName);
                        av.setLabel(l);
                    }
                    if (!(subAction.getValue() instanceof URLValue)) continue;
                    this.buildMultiURL(valueHints, (URLValue)subAction.getValue());
                }
            }
        } else if (tg.getAction().getValue() instanceof MultiURLValues) {
            MultiURLValues muv = (MultiURLValues)tg.getAction().getValue();
            if (muv.getURLValues().size() == 0) {
                return;
            }
            if (muv.getURLValues().size() == 1) {
                this.buildURI(valueHints, (URLValue)muv.getURLValues().get(0));
            } else {
                for (URLValue uv : muv.getURLValues()) {
                    this.buildMultiURL(valueHints, uv);
                }
            }
        } else if (tg.getAction().getValue() instanceof URLValue) {
            URLValue uv = (URLValue)tg.getAction().getValue();
            this.buildURI(valueHints, uv);
        }
    }

    private <T> void buildURI(T valueHints, URLValue uv) {
        String sBaseURL = uv.getBaseUrl();
        if (sBaseURL == null) {
            sBaseURL = "";
        }
        StringBuffer sb = new StringBuffer(sBaseURL);
        int c = 63;
        if (sBaseURL.indexOf(c) != -1) {
            c = 38;
        }
        DataPointHints dph = null;
        if (valueHints instanceof DataPointHints) {
            String urlValue;
            dph = (DataPointHints)valueHints;
            if (uv.getBaseParameterName() != null && uv.getBaseParameterName().length() > 0) {
                sb.append((char)c);
                c = 38;
                sb.append(URLValueImpl.encode(uv.getBaseParameterName()));
                sb.append('=');
                urlValue = dph.getBaseDisplayValue();
                if (dph.getBaseValue() instanceof Calendar) {
                    urlValue = this.formatDateString(dph.getBaseValue());
                }
                sb.append(URLValueImpl.encode(urlValue));
            }
            if (uv.getValueParameterName() != null && uv.getValueParameterName().length() > 0) {
                sb.append((char)c);
                c = 38;
                sb.append(URLValueImpl.encode(uv.getValueParameterName()));
                sb.append('=');
                urlValue = dph.getOrthogonalDisplayValue();
                if (dph.getOrthogonalValue() instanceof Calendar) {
                    urlValue = this.formatDateString(dph.getOrthogonalValue());
                }
                sb.append(URLValueImpl.encode(urlValue));
            }
        }
        if (uv.getSeriesParameterName() != null && uv.getSeriesParameterName().length() > 0) {
            sb.append((char)c);
            c = 38;
            sb.append(URLValueImpl.encode(uv.getSeriesParameterName()));
            sb.append('=');
            if (valueHints instanceof DataPointHints) {
                sb.append(URLValueImpl.encode(dph.getSeriesDisplayValue()));
            } else {
                sb.append(URLValueImpl.encode(((LegendItemHints)valueHints).getItemText()));
            }
        }
        uv.setBaseUrl(sb.toString());
    }

    private <T> void buildMultiURL(T valueHints, URLValue uv) {
        String sBaseURL = uv.getBaseUrl();
        if (sBaseURL == null) {
            sBaseURL = "";
        }
        StringBuffer sb = new StringBuffer("");
        sb.append(sBaseURL);
        int c = 63;
        if (sBaseURL.indexOf(c) != -1) {
            c = 38;
        }
        boolean hasCategory = false;
        boolean hasValueData = false;
        boolean hasSeriesName = false;
        if (valueHints instanceof DataPointHints) {
            if (uv.getBaseParameterName() != null && uv.getBaseParameterName().length() > 0) {
                sb.append((char)c);
                c = 38;
                sb.append(URLValueImpl.encode(uv.getBaseParameterName()));
                sb.append('=');
                sb.append("\"+");
                sb.append("categoryData");
                hasCategory = true;
            }
            if (uv.getValueParameterName() != null && uv.getValueParameterName().length() > 0) {
                if (hasCategory) {
                    sb.append("+\"");
                }
                sb.append((char)c);
                c = 38;
                sb.append(URLValueImpl.encode(uv.getValueParameterName()));
                sb.append('=');
                sb.append("\"+");
                sb.append("valueData");
                hasValueData = true;
            }
        }
        if (uv.getSeriesParameterName() != null && uv.getSeriesParameterName().length() > 0) {
            if (hasCategory || hasValueData) {
                sb.append("+\"");
            }
            sb.append((char)c);
            c = 38;
            sb.append(URLValueImpl.encode(uv.getSeriesParameterName()));
            sb.append('=');
            sb.append("\"+");
            sb.append("valueSeriesName");
            hasSeriesName = true;
        }
        if (hasCategory || hasValueData || hasSeriesName) {
            sb.insert(0, "\"");
        }
        uv.setBaseUrl(sb.toString());
    }

    private String formatDateString(Object value) {
        return DateFormat.getDateInstance((int)1).format(value);
    }

    protected final Bounds getCellBounds() {
        return this.getCellBounds(this.iSeriesIndex);
    }

    protected final Bounds getCellBounds(int seriesIndex) {
        PlotComputation obj = this.getComputations();
        Bounds bo = null;
        if (obj instanceof PlotWithoutAxes) {
            PlotWithoutAxes pwoa = (PlotWithoutAxes)obj;
            Coordinates co = pwoa.getCellCoordinates(seriesIndex - 1);
            Size sz = pwoa.getCellSize();
            bo = goFactory.copyOf(pwoa.getPlotBounds());
            bo.setLeft(bo.getLeft() + (double)co.getColumn() * sz.getWidth());
            bo.setTop(bo.getTop() + (double)co.getRow() * sz.getHeight());
            bo.setWidth(sz.getWidth());
            bo.setHeight(sz.getHeight());
            bo = goFactory.adjusteBounds(bo, pwoa.getPlotInsets());
        } else if (obj instanceof PlotWithAxes) {
            PlotWithAxes pwa = (PlotWithAxes)obj;
            bo = goFactory.copyOf(pwa.getPlotBounds());
            bo = goFactory.adjusteBounds(bo, pwa.getPlotInsets());
        }
        return bo;
    }

    protected final Bounds getPlotBounds() {
        PlotComputation oComputation = this.getComputations();
        Bounds bo = goFactory.adjusteBounds(oComputation.getPlotBounds(), oComputation.getPlotInsets());
        return bo;
    }

    public final void renderLabel(Object oSource, int iTextRenderType, Label laDataPoint, Position lp, Location lo, Bounds bo) throws ChartException {
        this.limitDataPointLabelLocation(this.getModel(), this.xs, laDataPoint, this.getDeviceScale(), lo, lp);
        this.renderLabel(oSource, iTextRenderType, laDataPoint, lp, lo, bo, this.dc);
    }

    private void limitDataPointLabelLocation(Chart cm, IDisplayServer xs, Label laDataPoint, double dScale, Location lo, Position lp) throws ChartException {
        double dXmax;
        double dXmin;
        double dYmax;
        double dYmin;
        if (lo == null || cm instanceof ChartWithoutAxes) {
            return;
        }
        ChartWithAxes cwa = (ChartWithAxes)cm;
        Plot p = cwa.getPlot();
        BoundingBox bb = this.cComp.computeBox(xs, 4, laDataPoint, 0.0, 0.0);
        Bounds boCa = goFactory.scaleBounds(p.getBounds(), dScale);
        double rotation = laDataPoint.getCaption().getFont().getRotation();
        int state = 0;
        switch (lp.getValue()) {
            case 0: {
                if (rotation > 0.0 && rotation < 90.0) {
                    state = 8;
                    break;
                }
                if (rotation < 0.0 && rotation > -90.0) {
                    state = 2;
                    break;
                }
                state = 1;
                break;
            }
            case 3: {
                if (rotation > 0.0 && rotation < 90.0) {
                    state = 8;
                    break;
                }
                if (rotation < 0.0 && rotation > -90.0) {
                    state = 6;
                    break;
                }
                state = 7;
                break;
            }
            case 1: {
                if (rotation > 0.0 && rotation < 90.0) {
                    state = 4;
                    break;
                }
                if (rotation < 0.0 && rotation > -90.0) {
                    state = 6;
                    break;
                }
                state = 5;
                break;
            }
            case 2: {
                state = rotation > 0.0 && rotation < 90.0 ? 4 : (rotation < 0.0 && rotation > -90.0 ? 2 : 3);
            }
        }
        switch (state) {
            case 1: {
                dYmin = boCa.getTop() + bb.getHeight();
                dYmax = boCa.getTop() + boCa.getHeight();
                dXmin = boCa.getLeft() + bb.getWidth() / 2.0;
                dXmax = boCa.getLeft() + boCa.getWidth() - bb.getWidth() / 2.0;
                break;
            }
            case 2: {
                dYmin = boCa.getTop() + bb.getHeight();
                dYmax = boCa.getTop() + boCa.getHeight();
                dXmin = boCa.getLeft() + bb.getWidth();
                dXmax = boCa.getLeft() + boCa.getWidth();
                break;
            }
            case 3: {
                dYmin = boCa.getTop() + bb.getHeight() / 2.0;
                dYmax = boCa.getTop() + boCa.getHeight() - bb.getHeight() / 2.0;
                dXmin = boCa.getLeft() + bb.getWidth();
                dXmax = boCa.getLeft() + boCa.getWidth();
                break;
            }
            case 4: {
                dYmin = boCa.getTop();
                dYmax = boCa.getTop() + boCa.getHeight() - bb.getHeight();
                dXmin = boCa.getLeft() + bb.getWidth();
                dXmax = boCa.getLeft() + boCa.getWidth();
                break;
            }
            case 5: {
                dYmin = boCa.getTop();
                dYmax = boCa.getTop() + boCa.getHeight() - bb.getHeight();
                dXmin = boCa.getLeft() + bb.getWidth() / 2.0;
                dXmax = boCa.getLeft() + boCa.getWidth() - bb.getWidth() / 2.0;
                break;
            }
            case 6: {
                dYmin = boCa.getTop();
                dYmax = boCa.getTop() + boCa.getHeight() - bb.getHeight();
                dXmin = boCa.getLeft();
                dXmax = boCa.getLeft() + boCa.getWidth() - bb.getWidth();
                break;
            }
            case 7: {
                dYmin = boCa.getTop() + bb.getHeight() / 2.0;
                dYmax = boCa.getTop() + boCa.getHeight() - bb.getHeight() / 2.0;
                dXmin = boCa.getLeft();
                dXmax = boCa.getLeft() + boCa.getWidth() - bb.getWidth();
                break;
            }
            case 8: {
                dYmin = boCa.getTop() + bb.getHeight();
                dYmax = boCa.getTop() + boCa.getHeight();
                dXmin = boCa.getLeft();
                dXmax = boCa.getLeft() + boCa.getWidth() - bb.getWidth();
                break;
            }
            default: {
                dYmin = lo.getY();
                dYmax = lo.getY();
                dXmin = lo.getX();
                dXmax = lo.getX();
            }
        }
        if (lo.getY() < dYmin) {
            lo.setY(dYmin);
        }
        if (lo.getY() > dYmax) {
            lo.setY(dYmax);
        }
        if (lo.getX() < dXmin) {
            lo.setX(dXmin);
        }
        if (lo.getX() > dXmax) {
            lo.setX(dXmax);
        }
    }

    public final void renderLabel(Object oSource, int iTextRenderType, Label laDataPoint, Position lp, Location lo, Bounds bo, DeferredCache _dc) throws ChartException {
        IDeviceRenderer idr = this.getDevice();
        TextRenderEvent tre = ((EventObjectCache)((Object)idr)).getEventObject(oSource, TextRenderEvent.class);
        if (iTextRenderType != 3) {
            tre.setTextPosition(Methods.getLabelPosition(lp));
            tre.setLocation(lo);
        } else {
            tre.setBlockBounds(bo);
            tre.setBlockAlignment(null);
        }
        tre.setLabel(laDataPoint);
        tre.setAction(iTextRenderType);
        if (_dc == null) {
            this.dc.addLabel(tre);
        } else {
            _dc.addLabel(tre);
        }
    }

    protected void validateNullDatapoint(DataPointHints[] dphs) throws ChartException {
        if (dphs == null) {
            throw new ChartException("org.eclipse.birt.chart.engine", 30, "exception.base.orthogonal.null.datapoint", Messages.getResourceBundle(this.rtc.getULocale()));
        }
    }

    protected void validateDataSetCount(ISeriesRenderingHints isrh) throws ChartException {
        if ((isrh.getDataSetStructure() & 2) == 2) {
            throw new ChartException("org.eclipse.birt.chart.engine", 30, "exception.base.orthogonal.inconsistent.count", new Object[]{isrh.getBaseDataSet().size(), isrh.getOrthogonalDataSet().size()}, Messages.getResourceBundle(this.rtc.getULocale()));
        }
    }

    protected List<double[]> filterNull(List<double[]> ll) {
        ArrayList<double[]> al = new ArrayList<double[]>();
        int i = 0;
        while (i < ll.size()) {
            double[] obj = ll.get(i);
            if (obj != null && !Double.isNaN(obj[0]) && !Double.isNaN(obj[1])) {
                al.add(obj);
            }
            ++i;
        }
        return al;
    }

    protected Location[] filterNull(Location[] ll) {
        ArrayList<Location> al = new ArrayList<Location>();
        int i = 0;
        while (i < ll.length) {
            if (!Double.isNaN(ll[i].getX()) && !Double.isNaN(ll[i].getY())) {
                al.add(ll[i]);
            }
            ++i;
        }
        if (ll instanceof Location3D[]) {
            return al.toArray(new Location3D[al.size()]);
        }
        return al.toArray(new Location[al.size()]);
    }

    protected static Location[] filterNull(Location[] ll, DataPointHints[] dpha) throws ChartException {
        if (ll == null || dpha == null || ll.length != dpha.length) {
            throw new ChartException("org.eclipse.birt.chart.engine", 30, new IllegalArgumentException());
        }
        int iLen = dpha.length;
        ArrayList<Location> al = new ArrayList<Location>(iLen);
        int i = 0;
        while (i < iLen) {
            if (dpha[i].getBaseValue() != null && dpha[i].getOrthogonalValue() != null) {
                al.add(ll[i]);
            }
            ++i;
        }
        if (ll instanceof Location3D[]) {
            return al.toArray(new Location3D[al.size()]);
        }
        return al.toArray(new Location[al.size()]);
    }

    protected static boolean isNaN(Object value) {
        return value == null || value instanceof Number && Double.isNaN(((Number)value).doubleValue());
    }

    public boolean isRightToLeft() {
        if (this.rtc == null) {
            return false;
        }
        return this.rtc.isRightToLeft();
    }

    protected boolean isPaletteByCategory() {
        return this.cm.getLegend().getItemType().getValue() == 1;
    }

    public Anchor switchAnchor(Anchor anchor) {
        if (anchor != null && this.isRightToLeft()) {
            switch (anchor.getValue()) {
                case 2: {
                    anchor = Anchor.WEST_LITERAL;
                    break;
                }
                case 1: {
                    anchor = Anchor.NORTH_WEST_LITERAL;
                    break;
                }
                case 3: {
                    anchor = Anchor.SOUTH_WEST_LITERAL;
                    break;
                }
                case 6: {
                    anchor = Anchor.EAST_LITERAL;
                    break;
                }
                case 7: {
                    anchor = Anchor.NORTH_EAST_LITERAL;
                    break;
                }
                case 5: {
                    anchor = Anchor.SOUTH_EAST_LITERAL;
                }
            }
        }
        return anchor;
    }

    public Position switchPosition(Position po) {
        if (po != null && this.isRightToLeft()) {
            if (po == Position.RIGHT_LITERAL) {
                po = Position.LEFT_LITERAL;
            } else if (po == Position.LEFT_LITERAL) {
                po = Position.RIGHT_LITERAL;
            }
        }
        return po;
    }

    public TextAlignment switchTextAlignment(TextAlignment ta) {
        if (ta != null && this.isRightToLeft()) {
            if (ta.getHorizontalAlignment() == HorizontalAlignment.LEFT_LITERAL) {
                ta.setHorizontalAlignment(HorizontalAlignment.RIGHT_LITERAL);
            } else if (ta.getHorizontalAlignment() == HorizontalAlignment.RIGHT_LITERAL) {
                ta.setHorizontalAlignment(HorizontalAlignment.LEFT_LITERAL);
            }
        }
        return ta;
    }

    public boolean isInteractivityEnabled() {
        return this.cm.getInteractivity() == null || this.cm.getInteractivity().isEnable();
    }

    public Collection<Integer> getFilteredMinSliceEntry(DataSetIterator dsi) {
        return null;
    }

    public void updateTranslucency(Fill fill, Series se) {
        if (se != null && se.isTranslucent()) {
            if (fill instanceof ColorDefinition) {
                ((ColorDefinition)fill).setTransparency(127);
            } else if (fill instanceof MultipleFill) {
                int i = 0;
                while (i < ((MultipleFill)fill).getFills().size()) {
                    this.updateTranslucency((Fill)((MultipleFill)fill).getFills().get(i), se);
                    ++i;
                }
            }
        }
    }

    public void setDeferredCacheManager(DeferredCacheManager dcm) {
        this.fDeferredCacheManager = dcm;
    }

    public DeferredCacheManager getDeferredCacheManager() {
        return this.fDeferredCacheManager;
    }

    protected final InteractionEvent createEvent(StructureSource iSource, List<Trigger> elTriggers, IPrimitiveRenderer ipr) {
        InteractionEvent iev = new InteractionEvent(iSource);
        int t = 0;
        while (t < elTriggers.size()) {
            Trigger tg = goFactory.copyOf(elTriggers.get(t));
            this.processTrigger(tg, iSource);
            iev.addTrigger(tg);
            ++t;
        }
        return iev;
    }

    protected final void renderInteractivity(IPrimitiveRenderer ipr, DataPointHints dph, PrimitiveRenderEvent pre) throws ChartException {
        EList<Trigger> elTriggers;
        if (this.isInteractivityEnabled() && dph != null && !(elTriggers = this.getSeries().getTriggers()).isEmpty()) {
            StructureSource iSource = WrappedStructureSource.createSeriesDataPoint(this.getSeries(), dph);
            InteractionEvent iev = this.createEvent(iSource, (List<Trigger>)elTriggers, ipr);
            iev.setCursor(this.getSeries().getCursor());
            iev.setHotSpot(pre);
            ipr.enableInteraction(iev);
        }
    }

    protected boolean isFirstVisibleSeries() {
        if (this.iSeriesIndex == 0) {
            return false;
        }
        int i = 1;
        while (i < this.iSeriesCount) {
            BaseRenderer renderer = this.getRenderer(i);
            if (renderer.getSeries().isVisible()) {
                return i == this.iSeriesIndex;
            }
            ++i;
        }
        return false;
    }

    protected boolean isLastSeries() {
        if (this.iSeriesIndex == 0) {
            return false;
        }
        return this.iSeriesIndex == this.iSeriesCount - 1;
    }

    protected Label getExternalizedCopy(Label la) {
        Label laCopy = goFactory.copyOf(this.getModel().getEmptyMessage());
        Text caption = laCopy.getCaption();
        caption.setValue(this.getRunTimeContext().externalizedMessage(caption.getValue()));
        return laCopy;
    }

    protected void renderEmptyPlot(IPrimitiveRenderer ipr, Plot p, Bounds bo) throws ChartException {
        StructureSource oSource = StructureSource.createPlot(p);
        if (this.getModel().getEmptyMessage().isVisible()) {
            Label la = this.getExternalizedCopy(this.getModel().getEmptyMessage());
            this.rendLabelInBounds(ipr, la, oSource, bo);
        }
    }

    protected void rendLabelInBounds(IPrimitiveRenderer ipr, Label la, Object oSource, Bounds bo) throws ChartException {
        EventObjectCache eoc = (EventObjectCache)((Object)ipr);
        TextRenderEvent tre = eoc.getEventObject(oSource, TextRenderEvent.class);
        tre.setBlockBounds(bo);
        tre.setLabel(la);
        if (this.rtc.isRightToLeftText()) {
            tre.setRtlCaption();
        }
        LabelLimiter lbLimiter = new LabelLimiter(bo.getWidth(), bo.getHeight(), 0.0);
        lbLimiter.computeWrapping(this.xs, la);
        lbLimiter.limitLabelSize(this.cComp, this.xs, la);
        tre.setBlockAlignment(la.getCaption().getFont().getAlignment());
        tre.setAction(3);
        ipr.drawText(tre);
    }
}

