/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.validators;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.LibraryException;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.validators.AbstractElementValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncludedLibraryValidator
extends AbstractElementValidator {
    private static IncludedLibraryValidator instance = new IncludedLibraryValidator();

    public static IncludedLibraryValidator getInstance() {
        return instance;
    }

    @Override
    public List<SemanticException> validate(Module module, DesignElement element) {
        ArrayList<SemanticException> errors = new ArrayList<SemanticException>();
        List<Library> libs = module.getAllLibraries();
        int i = 0;
        while (i < libs.size()) {
            Library lib = libs.get(i);
            if (!lib.isValid()) {
                errors.add(new LibraryException(module, new String[]{lib.getNamespace()}, "Error.LibraryException.LIBRARY_NOT_FOUND"));
            }
            ++i;
        }
        return errors;
    }
}

