/*
 * Decompiled with CFR 0.152.
 */
package org.webbitserver.netty;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.webbitserver.HttpConnection;
import org.webbitserver.netty.NettyHttpRequest;

public abstract class AbstractHttpConnection
implements HttpConnection {
    private final Executor executor;
    private final NettyHttpRequest nettyHttpRequest;
    private final ChannelHandlerContext ctx;

    public AbstractHttpConnection(ChannelHandlerContext ctx, NettyHttpRequest nettyHttpRequest, Executor executor) {
        this.ctx = ctx;
        this.nettyHttpRequest = nettyHttpRequest;
        this.executor = executor;
    }

    protected void writeMessage(Object message) {
        this.ctx.getChannel().write(message);
    }

    protected void closeChannel() {
        this.ctx.getChannel().write((Object)ChannelBuffers.EMPTY_BUFFER).addListener(ChannelFutureListener.CLOSE);
    }

    protected void putData(String key, Object value) {
        this.data().put(key, value);
    }

    @Override
    public NettyHttpRequest httpRequest() {
        return this.nettyHttpRequest;
    }

    @Override
    public Map<String, Object> data() {
        return this.nettyHttpRequest.data();
    }

    @Override
    public Object data(String key) {
        return this.data().get(key);
    }

    @Override
    public Set<String> dataKeys() {
        return this.data().keySet();
    }

    @Override
    public Executor handlerExecutor() {
        return this.executor;
    }

    @Override
    public void execute(Runnable command) {
        this.handlerExecutor().execute(command);
    }
}

