/*
 * Decompiled with CFR 0.152.
 */
package org.webbitserver.handler.logging;

import org.webbitserver.WebSocketConnection;
import org.webbitserver.WebSocketHandler;
import org.webbitserver.handler.logging.LogSink;

class LoggingWebSocketHandler
implements WebSocketHandler {
    private final LogSink logSink;
    private final WebSocketConnection loggingConnection;
    private final WebSocketHandler handler;

    LoggingWebSocketHandler(LogSink logSink, WebSocketConnection loggingConnection, WebSocketHandler handler) {
        this.logSink = logSink;
        this.loggingConnection = loggingConnection;
        this.handler = handler;
    }

    @Override
    public void onOpen(WebSocketConnection connection) throws Throwable {
        this.logSink.webSocketConnectionOpen(connection);
        this.handler.onOpen(this.loggingConnection);
    }

    @Override
    public void onClose(WebSocketConnection connection) throws Throwable {
        this.logSink.webSocketConnectionClose(connection);
        this.logSink.httpEnd(connection.httpRequest());
        this.handler.onClose(this.loggingConnection);
    }

    @Override
    public void onMessage(WebSocketConnection connection, String message) throws Throwable {
        this.logSink.webSocketInboundData(connection, message);
        this.handler.onMessage(this.loggingConnection, message);
    }

    @Override
    public void onMessage(WebSocketConnection connection, byte[] message) throws Throwable {
        this.logSink.webSocketInboundData(connection, message);
        this.handler.onMessage(this.loggingConnection, message);
    }

    @Override
    public void onPing(WebSocketConnection connection, byte[] message) throws Throwable {
        this.logSink.webSocketInboundPing(connection, message);
        this.handler.onPing(this.loggingConnection, message);
    }

    @Override
    public void onPong(WebSocketConnection connection, byte[] message) throws Throwable {
        this.logSink.webSocketInboundPong(connection, message);
        this.handler.onPong(this.loggingConnection, message);
    }
}

