/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.dataset;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.report.data.adapter.impl.DataSetMetaDataHelper;
import org.eclipse.birt.report.designer.data.ui.dataset.AppContextPopulator;
import org.eclipse.birt.report.designer.data.ui.dataset.AppContextResourceReleaser;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetEditor;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetPreviewer;
import org.eclipse.birt.report.designer.data.ui.dataset.ResultSetTableAction;
import org.eclipse.birt.report.designer.data.ui.dataset.ResultSetTableActionFactory;
import org.eclipse.birt.report.designer.data.ui.util.DTPUtil;
import org.eclipse.birt.report.designer.data.ui.util.DataSetProvider;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.properties.AbstractPropertyPage;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.birt.report.model.api.elements.structures.DataSetParameter;
import org.eclipse.datatools.connectivity.oda.util.ResourceIdentifiers;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public class OutputParameterPreviewPage
extends AbstractPropertyPage
implements Listener {
    private Table outputParameterTable = null;
    private boolean modelChanged = true;

    public Control createPageControl(Composite parent) {
        this.outputParameterTable = new Table(parent, 65538);
        this.outputParameterTable.setHeaderVisible(true);
        this.outputParameterTable.setLinesVisible(true);
        ((DataSetHandle)this.getContainer().getModel()).addListener((Listener)this);
        this.outputParameterTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (e.button != 1) {
                    MenuManager menuManager = new MenuManager();
                    ResultSetTableAction copyAction = ResultSetTableActionFactory.createResultSetTableAction(OutputParameterPreviewPage.this.outputParameterTable, 1);
                    ResultSetTableAction selectAllAction = ResultSetTableActionFactory.createResultSetTableAction(OutputParameterPreviewPage.this.outputParameterTable, 2);
                    menuManager.add((IAction)copyAction);
                    menuManager.add((IAction)selectAllAction);
                    menuManager.update();
                    copyAction.update();
                    selectAllAction.update();
                    Menu contextMenu = menuManager.createContextMenu((Control)OutputParameterPreviewPage.this.outputParameterTable);
                    contextMenu.setEnabled(true);
                    contextMenu.setVisible(true);
                }
            }
        });
        return this.outputParameterTable;
    }

    public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
        if (focus.equals(this.getContainer().getModel())) {
            this.modelChanged = true;
        }
    }

    public void pageActivated() {
        this.getContainer().setMessage(Messages.getString((String)"dataset.editor.outputparameters"), 0);
        if (this.modelChanged || ((DataSetEditor)this.getContainer()).modelChanged()) {
            this.modelChanged = false;
            this.runUpdateResults();
        }
    }

    private void runUpdateResults() {
        if (this.outputParameterTable != null && !this.outputParameterTable.isDisposed()) {
            this.clearResultSetTable();
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (OutputParameterPreviewPage.this.outputParameterTable != null && !OutputParameterPreviewPage.this.outputParameterTable.isDisposed()) {
                        OutputParameterPreviewPage.this.updateResults();
                    }
                }
            });
        }
    }

    private void clearResultSetTable() {
        TableColumn[] columns = this.outputParameterTable.getColumns();
        int n = 0;
        while (n < columns.length) {
            columns[n].dispose();
            ++n;
        }
        this.outputParameterTable.removeAll();
    }

    private void updateResults() {
        int outputParamsSize = this.outputParametersSize();
        if (outputParamsSize == 0) {
            return;
        }
        ModuleHandle handle = null;
        DataSetHandle dsHandle = ((DataSetEditor)this.getContainer()).getHandle();
        handle = dsHandle.getModuleHandle();
        DataSetPreviewer previewer = new DataSetPreviewer(dsHandle, 1, DataSetPreviewer.PreviewType.OUTPUTPARAM);
        HashMap<String, ResourceIdentifiers> appContext = new HashMap<String, ResourceIdentifiers>();
        HashMap dataSetBindingMap = new HashMap();
        HashMap dataSourceBindingMap = new HashMap();
        TableLayout layout = new TableLayout();
        TableColumn column = null;
        TableItem tableItem = null;
        try {
            try {
                ResourceIdentifiers identifiers = new ResourceIdentifiers();
                String resouceIDs = "org.eclipse.datatools.connectivity.oda.util_consumerResourceIds";
                identifiers.setApplResourceBaseURI(DTPUtil.getInstance().getBIRTResourcePath());
                identifiers.setDesignResourceBaseURI(DTPUtil.getInstance().getReportDesignPath());
                appContext.put(resouceIDs, identifiers);
                this.clearProperyBindingMap(dataSetBindingMap, dataSourceBindingMap);
                AppContextPopulator.populateApplicationContext(dsHandle, appContext);
                previewer.open(appContext, this.getEngineConfig(handle));
                IResultIterator iter = previewer.preview();
                iter.next();
                IResultMetaData meta = iter.getResultMetaData();
                String[] record = new String[meta.getColumnCount()];
                int n = 0;
                while (n < record.length) {
                    column = new TableColumn(this.outputParameterTable, 16384);
                    column.setText(meta.getColumnName(n + 1));
                    column.setResizable(true);
                    layout.addColumnData((ColumnLayoutData)new ColumnPixelData(120, true));
                    record[n] = iter.getString(meta.getColumnName(n + 1));
                    ++n;
                }
                this.outputParameterTable.setLayout((Layout)layout);
                this.outputParameterTable.layout(true);
                tableItem = new TableItem(this.outputParameterTable, 0);
                tableItem.setText(record);
                iter.close();
            }
            catch (BirtException e) {
                ExceptionHandler.handle((Throwable)e);
                try {
                    AppContextResourceReleaser.release(appContext);
                    previewer.close();
                }
                catch (BirtException e2) {
                    e2.printStackTrace();
                }
                this.resetPropertyBinding(dataSetBindingMap, dataSourceBindingMap);
            }
        }
        finally {
            try {
                AppContextResourceReleaser.release(appContext);
                previewer.close();
            }
            catch (BirtException e) {
                e.printStackTrace();
            }
            this.resetPropertyBinding(dataSetBindingMap, dataSourceBindingMap);
        }
    }

    private EngineConfig getEngineConfig(ModuleHandle handle) {
        EngineConfig ec = new EngineConfig();
        ClassLoader parent = Thread.currentThread().getContextClassLoader();
        if (parent == null) {
            parent = ((Object)((Object)this)).getClass().getClassLoader();
        }
        ClassLoader customClassLoader = DataSetProvider.getCustomScriptClassLoader((ClassLoader)parent, (ModuleHandle)handle);
        ec.getAppContext().put("PARENT_CLASSLOADER", customClassLoader);
        return ec;
    }

    private void resetPropertyBinding(final Map dataSetBindingMap, final Map dataSourceBindingMap) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                try {
                    DataSetHandle dsHandle = ((DataSetEditor)OutputParameterPreviewPage.this.getContainer()).getHandle();
                    DataSetMetaDataHelper.resetPropertyBinding((DataSetHandle)dsHandle, (Map)dataSetBindingMap, (Map)dataSourceBindingMap);
                }
                catch (SemanticException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            }
        });
    }

    private void clearProperyBindingMap(final Map dataSetBindingMap, final Map dataSourceBindingMap) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                DataSetHandle dsHandle = ((DataSetEditor)OutputParameterPreviewPage.this.getContainer()).getHandle();
                try {
                    DataSetMetaDataHelper.clearPropertyBindingMap((DataSetHandle)dsHandle, (Map)dataSetBindingMap, (Map)dataSourceBindingMap);
                }
                catch (SemanticException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            }
        });
    }

    private int outputParametersSize() {
        PropertyHandle propertyHandle = ((DataSetEditor)this.getContainer()).getHandle().getPropertyHandle("parameters");
        ArrayList paramList = propertyHandle.getListValue();
        if (paramList == null || paramList.size() == 0) {
            return 0;
        }
        int size = 0;
        int paramSize = paramList.size();
        int i = 0;
        while (i < paramSize) {
            DataSetParameter parameter = (DataSetParameter)paramList.get(i);
            if (parameter.isOutput()) {
                ++size;
            }
            ++i;
        }
        return size;
    }

    public boolean performOk() {
        ((DataSetHandle)this.getContainer().getModel()).removeListener((Listener)this);
        return super.performOk();
    }

    public boolean performCancel() {
        ((DataSetHandle)this.getContainer().getModel()).removeListener((Listener)this);
        return super.performCancel();
    }

    public String getToolTip() {
        return Messages.getString((String)"dataset.outputparameters.preview.tooltip");
    }
}

