/*
 * Decompiled with CFR 0.152.
 */
package org.graysky.eclipse.logwatcher.wizards;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class HighlightOptionsPage
extends WizardPage {
    private Text m_filterText;
    private Composite m_actionOptions;
    private Color m_color = null;
    private Color m_startingColor = null;
    private Combo m_actionsCombo;

    public HighlightOptionsPage(String pageName) {
        super(pageName);
    }

    public HighlightOptionsPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        this.m_startingColor = this.getShell().getDisplay().getSystemColor(3);
        this.m_color = new Color((Device)this.getShell().getDisplay(), this.m_startingColor.getRGB());
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.horizontalSpacing = 10;
        layout.verticalSpacing = 20;
        composite.setLayout((Layout)layout);
        new Label(composite, 0).setText("Highlight color:");
        final Canvas c = new Canvas(composite, 0);
        GridData gridData = new GridData(256);
        gridData.heightHint = 20;
        gridData.widthHint = 20;
        c.setLayoutData((Object)gridData);
        c.setBackground(this.m_startingColor);
        Button colorButton = new Button(composite, 8);
        colorButton.setText("Select...");
        colorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ColorDialog dialog = new ColorDialog(HighlightOptionsPage.this.getShell());
                dialog.open();
                if (dialog.getRGB() != null) {
                    if (HighlightOptionsPage.this.m_color != null) {
                        HighlightOptionsPage.this.m_color.dispose();
                    }
                    HighlightOptionsPage.this.m_color = new Color((Device)HighlightOptionsPage.this.getShell().getDisplay(), dialog.getRGB());
                    c.setBackground(HighlightOptionsPage.this.m_color);
                }
            }
        });
        this.setPageComplete(true);
    }

    public String getTitle() {
        return "Set the highlight color.";
    }

    public IWizardPage getNextPage() {
        return null;
    }

    public void dispose() {
        super.dispose();
    }

    public Color getColor() {
        return this.m_color;
    }
}

