/*
 * Decompiled with CFR 0.152.
 */
package org.graysky.eclipse.logwatcher.filters;

import java.io.Reader;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.oro.text.regex.MalformedPatternException;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.graysky.eclipse.logwatcher.LogwatcherPlugin;
import org.graysky.eclipse.logwatcher.filters.AddTaskAction;
import org.graysky.eclipse.logwatcher.filters.Filter;
import org.graysky.eclipse.logwatcher.filters.FilterAction;
import org.graysky.eclipse.logwatcher.filters.HighlightAction;
import org.graysky.eclipse.logwatcher.filters.IgnoreAction;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class FilterLoader {
    public Vector loadFilters(Reader r) throws Exception {
        Document doc = this.getDocument(r);
        Vector filters = this.loadFilters(doc);
        return filters;
    }

    public Vector loadFilters(Document doc) {
        Vector<Filter> filters = new Vector<Filter>();
        NodeList filterNodes = doc.getElementsByTagName("filter");
        int i = 0;
        while (i < filterNodes.getLength()) {
            Node node = filterNodes.item(i);
            filters.add(this.loadFilter(node));
            ++i;
        }
        return filters;
    }

    public Filter loadFilter(Node filterNode) {
        Filter f = new Filter();
        NodeList children = filterNode.getChildNodes();
        String pattern = "";
        boolean caseSensitive = false;
        int i = 0;
        while (i < children.getLength()) {
            Node node = children.item(i);
            String name = node.getNodeName();
            if (name.equals("pattern")) {
                pattern = node.getFirstChild().getNodeValue();
            } else if (name.equals("caseSensitive")) {
                caseSensitive = new Boolean(node.getFirstChild().getNodeValue());
            } else if (name.equals("description")) {
                f.setDescription(node.getFirstChild().getNodeValue());
            } else if (name.equals("contains")) {
                f.setContains(new Boolean(node.getFirstChild().getNodeValue()));
            } else if (name.equals("action")) {
                f.addAction(this.loadAction(node));
            }
            ++i;
        }
        try {
            f.setPattern(pattern, caseSensitive);
        }
        catch (MalformedPatternException malformedPatternException) {}
        return f;
    }

    protected FilterAction loadAction(Node node) {
        NamedNodeMap attrs = node.getAttributes();
        Node type = attrs.getNamedItem("type");
        if (type.getNodeValue().equals("highlight")) {
            NodeList children = node.getChildNodes();
            int red = 0;
            int green = 0;
            int blue = 0;
            int i = 0;
            while (i < children.getLength()) {
                Node colorNode = children.item(i);
                String name = colorNode.getNodeName();
                if (name.equals("red")) {
                    red = Integer.parseInt(colorNode.getFirstChild().getNodeValue());
                } else if (name.equals("green")) {
                    green = Integer.parseInt(colorNode.getFirstChild().getNodeValue());
                } else if (name.equals("blue")) {
                    blue = Integer.parseInt(colorNode.getFirstChild().getNodeValue());
                }
                ++i;
            }
            Display d = LogwatcherPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay();
            Color c = new Color((Device)d, red, green, blue);
            return new HighlightAction(c);
        }
        if (type.getNodeValue().equals("ignore")) {
            return new IgnoreAction();
        }
        if (type.getNodeValue().equals("task")) {
            NodeList children = node.getChildNodes();
            String desc = "";
            int priority = 0;
            int i = 0;
            while (i < children.getLength()) {
                Node n = children.item(i);
                String name = n.getNodeName();
                if (name.equals("taskDescription")) {
                    desc = n.getFirstChild().getNodeValue();
                } else if (name.equals("priority")) {
                    priority = Integer.parseInt(n.getFirstChild().getNodeValue());
                }
                ++i;
            }
            return new AddTaskAction(desc, priority, (IResource)LogwatcherPlugin.getWorkspace().getRoot());
        }
        LogwatcherPlugin.getDefault().logError("Invalid action type: " + type, null);
        return null;
    }

    protected Document getDocument(Reader r) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder parser = factory.newDocumentBuilder();
        Document document = parser.parse(new InputSource(r));
        return document;
    }
}

