/*
 * Decompiled with CFR 0.152.
 */
package org.graysky.eclipse.logwatcher.filters;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.custom.LineStyleEvent;
import org.graysky.eclipse.logwatcher.filters.FilterAction;
import org.graysky.eclipse.util.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AddTaskAction
implements FilterAction {
    private String m_taskDescription = "";
    private int m_priority = -1;
    private IResource m_resource = null;
    public static final int LOW = 0;
    public static final int NORMAL = 1;
    public static final int HIGH = 2;

    public AddTaskAction() {
    }

    public AddTaskAction(String desc, int pri, IResource res) {
        this.m_taskDescription = desc;
        this.m_priority = pri;
        this.m_resource = res;
    }

    public void dispose() {
    }

    public void doViewerAction(LineStyleEvent event) {
    }

    public String getDescription() {
        return "Add a Todo Task";
    }

    public int getPriority() {
        return this.m_priority;
    }

    public void setPriority(int priority) {
        this.m_priority = priority;
    }

    public String getTaskDescription() {
        return this.m_taskDescription;
    }

    public void setTaskDescription(String taskDescription) {
        this.m_taskDescription = taskDescription;
    }

    public String doWatcherAction(String line, boolean firstMatch) {
        if (firstMatch) {
            try {
                IMarker marker = this.m_resource.createMarker("org.eclipse.core.resources.taskmarker");
                marker.setAttribute("priority", this.m_priority);
                marker.setAttribute("message", (Object)this.m_taskDescription);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return line;
    }

    public void toXML(Document doc, Node node) {
        Element action = doc.createElement("action");
        action.setAttribute("type", "task");
        action.appendChild(XmlUtils.createElementWithText(doc, "taskDescription", this.getTaskDescription()));
        action.appendChild(XmlUtils.createElementWithText(doc, "priority", Integer.toString(this.getPriority())));
        node.appendChild(action);
    }
}

