/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.yaml.dom;

import hiro.yoshioka.util.StringUtil;
import hiro.yoshioka.yaml.dom.AbsYamlElement;
import hiro.yoshioka.yaml.dom.IYamlElement;
import hiro.yoshioka.yaml.dom.IYamlMapElement;
import java.util.Map;
import org.eclipse.core.resources.IFile;

public class YamlElement
extends AbsYamlElement
implements IYamlMapElement {
    String key;
    Object value;
    IFile iFile;

    public YamlElement() {
        this.key = "ROOT";
    }

    public YamlElement(String key, Object value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public boolean isMapValue() {
        if (this.value == null) {
            return false;
        }
        return this.value instanceof Map;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public IYamlElement getParent() {
        return this.parent;
    }

    @Override
    public String toString(int depth) {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < depth) {
            buf.append("  ");
            ++i;
        }
        if (this.hasChild()) {
            if (StringUtil.isEmpty((Object)this.title)) {
                buf.append(String.format("%s%n", this.key));
            } else {
                buf.append(String.format("%s [title:%s]%n", this.key, this.title));
            }
            for (IYamlElement child : this.childList) {
                buf.append(child.toString(depth + 1));
            }
        } else if (this.value == null) {
            buf.append(String.format("%s:[NULL]%n", this.key));
        } else if (StringUtil.isEmpty((Object)this.title)) {
            buf.append(String.format("%s:[%s][%s] %n", this.key, this.value, this.value.getClass().getSimpleName()));
        } else {
            buf.append(String.format("%s: [title:%s][%s][%s] %n", this.key, this.title, this.value, this.value.getClass().getSimpleName()));
        }
        return buf.toString();
    }

    @Override
    public void setIFile(IFile f) {
        this.iFile = f;
    }

    @Override
    public IFile getIFile() {
        IYamlElement p;
        if (this.iFile == null && (p = this.getParent()) != null) {
            return p.getIFile();
        }
        return null;
    }
}

