/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.scsu;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Debug {
    private static final Log LOG = LogFactory.getLog(Debug.class);

    public static void out(char[] chars) {
        Debug.out(chars, 0);
    }

    public static void out(char[] chars, int iStart) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        StringBuilder msg = new StringBuilder();
        for (int i = iStart; i < chars.length; ++i) {
            if (chars[i] >= '\u0000' && chars[i] <= '\u001a') {
                msg.append("^" + (char)(chars[i] + 64));
                continue;
            }
            if (chars[i] <= '\u00ff') {
                msg.append(chars[i]);
                continue;
            }
            msg.append("\\u" + Integer.toString(chars[i], 16));
        }
        LOG.debug((Object)msg.toString());
    }

    public static void out(byte[] bytes) {
        Debug.out(bytes, 0);
    }

    public static void out(byte[] bytes, int iStart) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        StringBuilder msg = new StringBuilder();
        for (int i = iStart; i < bytes.length; ++i) {
            msg.append(bytes[i] + ",");
        }
        LOG.debug((Object)msg.toString());
    }

    public static void out(String str) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        LOG.debug((Object)str);
    }

    public static void out(String msg, int iData) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        LOG.debug((Object)(msg + iData));
    }

    public static void out(String msg, char ch) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        LOG.debug((Object)(msg + "[U+" + Integer.toString(ch, 16) + "]" + ch));
    }

    public static void out(String msg, byte bData) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        LOG.debug((Object)(msg + bData));
    }

    public static void out(String msg, String str) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        LOG.debug((Object)(msg + str));
    }

    public static void out(String msg, char[] data) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        LOG.debug((Object)msg);
        Debug.out(data);
    }

    public static void out(String msg, byte[] data) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        LOG.debug((Object)msg);
        Debug.out(data);
    }

    public static void out(String msg, char[] data, int iStart) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        LOG.debug((Object)(msg + "(" + iStart + "): "));
        Debug.out(data, iStart);
    }

    public static void out(String msg, byte[] data, int iStart) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        LOG.debug((Object)(msg + "(" + iStart + "): "));
        Debug.out(data, iStart);
    }
}

