/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.DataType;
import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.IndexBuilder;
import com.healthmarketscience.jackcess.JetFormat;
import com.healthmarketscience.jackcess.PageChannel;
import com.healthmarketscience.jackcess.Table;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TableCreator {
    private final Database _database;
    private final String _name;
    private final List<Column> _columns;
    private final List<IndexBuilder> _indexes;
    private final Map<IndexBuilder, IndexState> _indexStates = new HashMap<IndexBuilder, IndexState>();
    private int _tdefPageNumber = -1;
    private int _umapPageNumber = -1;
    private int _indexCount;
    private int _logicalIndexCount;

    public TableCreator(Database database, String name, List<Column> columns, List<IndexBuilder> indexes) {
        this._database = database;
        this._name = name;
        this._columns = columns;
        this._indexes = indexes != null ? indexes : Collections.emptyList();
    }

    public JetFormat getFormat() {
        return this._database.getFormat();
    }

    public PageChannel getPageChannel() {
        return this._database.getPageChannel();
    }

    public Charset getCharset() {
        return this._database.getCharset();
    }

    public int getTdefPageNumber() {
        return this._tdefPageNumber;
    }

    public int getUmapPageNumber() {
        return this._umapPageNumber;
    }

    public List<Column> getColumns() {
        return this._columns;
    }

    public List<IndexBuilder> getIndexes() {
        return this._indexes;
    }

    public boolean hasIndexes() {
        return !this._indexes.isEmpty();
    }

    public int getIndexCount() {
        return this._indexCount;
    }

    public int getLogicalIndexCount() {
        return this._logicalIndexCount;
    }

    public IndexState getIndexState(IndexBuilder idx) {
        return this._indexStates.get(idx);
    }

    public int reservePageNumber() throws IOException {
        return this.getPageChannel().allocateNewPage();
    }

    public void createTable() throws IOException {
        this.validate();
        if (this.hasIndexes()) {
            for (IndexBuilder idx : this._indexes) {
                IndexState idxState = new IndexState();
                idxState.setIndexNumber(this._logicalIndexCount++);
                idxState.setIndexDataNumber(this._indexCount++);
                this._indexStates.put(idx, idxState);
            }
        }
        this._tdefPageNumber = this.reservePageNumber();
        this._umapPageNumber = this.reservePageNumber();
        Table.writeTableDefinition(this);
        this._database.addNewTable(this._name, this._tdefPageNumber, Database.TYPE_TABLE, null, null);
    }

    private void validate() {
        Database.validateIdentifierName(this._name, this.getFormat().MAX_TABLE_NAME_LENGTH, "table");
        if (this._columns == null || this._columns.isEmpty()) {
            throw new IllegalArgumentException("Cannot create table with no columns");
        }
        if (this._columns.size() > this.getFormat().MAX_COLUMNS_PER_TABLE) {
            throw new IllegalArgumentException("Cannot create table with more than " + this.getFormat().MAX_COLUMNS_PER_TABLE + " columns");
        }
        Column.SortOrder dbSortOrder = null;
        try {
            dbSortOrder = this._database.getDefaultSortOrder();
        }
        catch (IOException e) {
            // empty catch block
        }
        HashSet<String> colNames = new HashSet<String>();
        for (Column column : this._columns) {
            if (column.getType() == DataType.COMPLEX_TYPE) {
                throw new UnsupportedOperationException("Complex column creation is not yet implemented");
            }
            column.validate(this.getFormat());
            if (!colNames.add(column.getName().toUpperCase())) {
                throw new IllegalArgumentException("duplicate column name: " + column.getName());
            }
            if (!column.getType().isTextual() || column.getTextSortOrder() != null) continue;
            column.setTextSortOrder(dbSortOrder);
        }
        List<Column> autoCols = Table.getAutoNumberColumns(this._columns);
        if (autoCols.size() > 1) {
            EnumSet<DataType> autoTypes = EnumSet.noneOf(DataType.class);
            for (Column c : autoCols) {
                if (c.getType().isMultipleAutoNumberAllowed() || autoTypes.add(c.getType())) continue;
                throw new IllegalArgumentException("Can have at most one AutoNumber column of type " + (Object)((Object)c.getType()) + " per table");
            }
        }
        if (this.hasIndexes()) {
            HashSet<String> idxNames = new HashSet<String>();
            boolean foundPk = false;
            for (IndexBuilder index : this._indexes) {
                index.validate(colNames);
                if (!idxNames.add(index.getName().toUpperCase())) {
                    throw new IllegalArgumentException("duplicate index name: " + index.getName());
                }
                if (!index.isPrimaryKey()) continue;
                if (foundPk) {
                    throw new IllegalArgumentException("found second primary key index: " + index.getName());
                }
                foundPk = true;
            }
        }
    }

    static final class IndexState {
        private int _indexNumber;
        private int _indexDataNumber;
        private byte _umapRowNumber;
        private int _umapPageNumber;
        private int _rootPageNumber;

        IndexState() {
        }

        public int getIndexNumber() {
            return this._indexNumber;
        }

        public void setIndexNumber(int newIndexNumber) {
            this._indexNumber = newIndexNumber;
        }

        public int getIndexDataNumber() {
            return this._indexDataNumber;
        }

        public void setIndexDataNumber(int newIndexDataNumber) {
            this._indexDataNumber = newIndexDataNumber;
        }

        public byte getUmapRowNumber() {
            return this._umapRowNumber;
        }

        public void setUmapRowNumber(byte newUmapRowNumber) {
            this._umapRowNumber = newUmapRowNumber;
        }

        public int getUmapPageNumber() {
            return this._umapPageNumber;
        }

        public void setUmapPageNumber(int newUmapPageNumber) {
            this._umapPageNumber = newUmapPageNumber;
        }

        public int getRootPageNumber() {
            return this._rootPageNumber;
        }

        public void setRootPageNumber(int newRootPageNumber) {
            this._rootPageNumber = newRootPageNumber;
        }
    }
}

