/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.views;

import org.eclipse.ant.internal.ui.AntUtil;
import org.eclipse.ant.internal.ui.model.AntProjectNode;
import org.eclipse.ant.internal.ui.model.AntProjectNodeProxy;
import org.eclipse.ant.internal.ui.views.AntView;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;

public class AntViewDropAdapter
extends DropTargetAdapter {
    private AntView view;

    public AntViewDropAdapter(AntView view) {
        this.view = view;
    }

    public void drop(DropTargetEvent event) {
        Object data = event.data;
        if (data instanceof String[]) {
            final String[] strings = (String[])data;
            BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                public void run() {
                    int i = 0;
                    while (i < strings.length) {
                        AntViewDropAdapter.this.processString(strings[i]);
                        ++i;
                    }
                }
            });
        }
    }

    private void processString(String buildFileName) {
        IFile buildFile = AntUtil.getFileForLocation(buildFileName, null);
        if (!AntUtil.isKnownAntFile((IResource)buildFile)) {
            return;
        }
        String name = buildFile.getFullPath().toString();
        AntProjectNode[] existingProjects = this.view.getProjects();
        int j = 0;
        while (j < existingProjects.length) {
            AntProjectNodeProxy existingProject = (AntProjectNodeProxy)existingProjects[j];
            if (existingProject.getBuildFileName().equals(name)) {
                return;
            }
            ++j;
        }
        AntProjectNodeProxy project = new AntProjectNodeProxy(name);
        this.view.addProject(project);
    }

    public void dragEnter(DropTargetEvent event) {
        event.detail = 1;
        super.dragEnter(event);
    }

    public void dragOperationChanged(DropTargetEvent event) {
        event.detail = 1;
        super.dragOperationChanged(event);
    }
}

