/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.views.attributes;

import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.BaseAttributePage;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.views.attributes.TabPageGenerator;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.CategoryProviderFactory;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ICategoryProvider;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ICategoryProviderFactory;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class CategoryPageGenerator
extends TabPageGenerator {
    public static final String ATTRIBUTESTITLE = Messages.getString((String)"PageGenerator.TabItem.Attributes");
    public static final String BINDINGTITLE = Messages.getString((String)"PageGenerator.TabItem.Binding");
    public static final String SORTINGTITLE = Messages.getString((String)"PageGenerator.TabItem.Sorting");
    public static final String FILTERTITLE = Messages.getString((String)"PageGenerator.TabItem.Filters");
    public static final String HIGHLIGHTSTITLE = Messages.getString((String)"PageGenerator.TabItem.Highlights");
    public static final String GROUPSSTITLE = Messages.getString((String)"PageGenerator.TabItem.Groups");
    public static final String MAPTITLE = Messages.getString((String)"PageGenerator.TabItem.map");
    protected BaseAttributePage basicPage;
    private ICategoryProviderFactory factory = null;
    private ICategoryProvider customProvider;

    public CategoryPageGenerator() {
        if (this.factory == null) {
            this.factory = (ICategoryProviderFactory)Platform.getAdapterManager().getAdapter((Object)this, ICategoryProviderFactory.class);
            if (this.factory == null) {
                this.factory = CategoryProviderFactory.getInstance();
            }
        }
    }

    protected ICategoryProviderFactory getCategoryProviderFactory() {
        return this.factory;
    }

    public void refresh() {
        this.createTabItems(this.input);
        this.basicPage.setInput(this.input);
        this.addSelectionListener(this);
        this.basicPage.refresh();
    }

    public void createTabItems(List input) {
        if (this.basicPage == null || this.basicPage.getControl().isDisposed()) {
            super.createTabItems(input);
            this.tabFolder.setLayout((Layout)new FillLayout());
            this.basicPage = new BaseAttributePage();
            this.basicPage.buildUI((Composite)this.tabFolder);
            CTabItem tabItem = new CTabItem(this.tabFolder, 0);
            tabItem.setText(ATTRIBUTESTITLE);
            tabItem.setControl(this.basicPage.getControl());
            if (this.customProvider != null) {
                this.basicPage.setCategoryProvider(this.customProvider);
            } else {
                this.basicPage.setCategoryProvider(this.factory.getCategoryProvider(input));
            }
        }
    }

    public void createControl(Composite parent, Object input) {
        super.createControl(parent, input);
    }

    public void setCategoryProvider(ICategoryProvider provider) {
        this.customProvider = provider;
    }
}

