/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.widget;

import com.ibm.icu.util.ULocale;
import org.eclipse.birt.report.designer.internal.ui.dialogs.FormatAdapter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.FormatLayoutPeer;
import org.eclipse.birt.report.designer.internal.ui.dialogs.IFormatChangeListener;
import org.eclipse.birt.report.designer.internal.ui.dialogs.IFormatPage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.FormatDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.PropertyDescriptor;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class FormatDescriptor
extends PropertyDescriptor
implements IFormatPage {
    protected FormatLayoutPeer layoutPeer;
    private FormatDescriptorProvider provider;

    public void addFormatChangeListener(IFormatChangeListener listener) {
        this.layoutPeer.addFormatChangeListener(listener);
    }

    public void setDescriptorProvider(IDescriptorProvider provider) {
        super.setDescriptorProvider(provider);
        if (provider instanceof FormatDescriptorProvider) {
            this.provider = (FormatDescriptorProvider)provider;
        }
    }

    public void load() {
        this.layoutPeer.setEnabled(true);
        String[] result = (String[])this.provider.load();
        if (result == null || result.length == 0) {
            this.layoutPeer.setEnabled(false);
        } else if (result.length == 1) {
            this.setInput(result[0]);
        } else if (result.length == 2) {
            this.layoutPeer.setInput(result[0], result[1]);
        } else if (result.length == 3) {
            this.setInput(result[0], result[1], FormatAdapter.getLocaleByDisplayName((String)result[2]));
        }
    }

    public void save(Object obj) throws SemanticException {
        this.provider.save(obj);
    }

    public String getCategory() {
        return this.layoutPeer.getCategory();
    }

    public String getFormatString() {
        return this.layoutPeer.getFormatString();
    }

    public ULocale getLocale() {
        return this.layoutPeer.getLocale();
    }

    public String getPattern() {
        return this.layoutPeer.getPattern();
    }

    public boolean isDirty() {
        return this.layoutPeer.isDirty();
    }

    public boolean isFormatModified() {
        return this.layoutPeer.isFormatModified();
    }

    public void setInput(String category, String pattern, ULocale formatLocale) {
        this.layoutPeer.setInput(category, pattern, formatLocale);
    }

    public void setInput(Object object) {
        super.setInput(object);
        this.getDescriptorProvider().setInput(object);
    }

    public void setInput(String formatString) {
        this.layoutPeer.setInput(formatString);
    }

    public void setPreviewText(String text) {
        this.layoutPeer.setPreviewText(text);
    }

    public Control createControl(Composite parent) {
        return this.layoutPeer.createLayout(parent);
    }

    public Control getControl() {
        return this.layoutPeer.getControl();
    }
}

