/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.adapter.oda.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.birt.report.model.api.elements.structures.OdaDataSetParameter;
import org.eclipse.birt.report.model.api.util.StringUtil;

public class IdentifierUtility {
    private static final char RENAME_SEPARATOR = '_';
    private static final String UNNAME_PREFIX = "UNNAMED";
    private static final String PARAM_PREFIX = "param_";

    public static String getUniqueColumnName(Set orgColumnNameSet, Set newColumnNameSet, String columnNativeName, int index) {
        String newColumnName = null;
        if (columnNativeName == null || columnNativeName.trim().length() == 0 || newColumnNameSet.contains(columnNativeName)) {
            StringBuffer columnName = new StringBuffer();
            if (columnNativeName == null || columnNativeName.trim().length() == 0) {
                columnName.append(UNNAME_PREFIX);
            } else {
                columnName.append(columnNativeName);
            }
            columnName.append('_');
            columnName.append(index + 1);
            int i = 1;
            while (orgColumnNameSet.contains(newColumnName) || newColumnNameSet.contains(newColumnName)) {
                columnName.append(String.valueOf(String.valueOf('_')) + i);
                ++i;
            }
            newColumnName = columnName.toString();
        } else {
            newColumnName = columnNativeName;
        }
        return newColumnName;
    }

    public static final void updateParams2UniqueName(List parameters) {
        List existedNames = IdentifierUtility.collectParameterNames(parameters);
        ArrayList<String> newNames = new ArrayList<String>();
        int i = 0;
        while (i < parameters.size()) {
            OdaDataSetParameter param = (OdaDataSetParameter)parameters.get(i);
            String name = param.getName();
            if (StringUtil.isBlank((String)name) || newNames.contains(name)) {
                String prefix = StringUtil.isBlank((String)name) ? PARAM_PREFIX : String.valueOf(name) + '_';
                int n = 1;
                while (existedNames.contains(name = String.valueOf(prefix) + n) || newNames.contains(name)) {
                    ++n;
                }
                param.setName(name);
            }
            newNames.add(name);
            ++i;
        }
    }

    private static List collectParameterNames(List parameters) {
        ArrayList<String> names = new ArrayList<String>();
        int i = 0;
        while (i < parameters.size()) {
            OdaDataSetParameter param = (OdaDataSetParameter)parameters.get(i);
            String name = param.getName();
            if (!StringUtil.isBlank((String)name) && !names.contains(name)) {
                names.add(name);
            }
            ++i;
        }
        return names;
    }
}

