/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.adapter.oda.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.adapter.oda.IAmbiguousAttribute;
import org.eclipse.birt.report.model.adapter.oda.impl.AdapterUtil;
import org.eclipse.birt.report.model.adapter.oda.impl.AmbiguousAttribute;
import org.eclipse.birt.report.model.adapter.oda.impl.CompareUtil;
import org.eclipse.birt.report.model.adapter.oda.impl.ReportParamChecker;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.OdaDataSetParameterHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.elements.structures.OdaDataSetParameter;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.datatools.connectivity.oda.design.DataElementAttributes;
import org.eclipse.datatools.connectivity.oda.design.ElementNullability;
import org.eclipse.datatools.connectivity.oda.design.InputElementAttributes;
import org.eclipse.datatools.connectivity.oda.design.ParameterDefinition;
import org.eclipse.datatools.connectivity.oda.design.ParameterMode;
import org.eclipse.datatools.connectivity.oda.design.StaticValues;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DataSetParameterChecker {
    List<IAmbiguousAttribute> ambiguousList;
    ParameterDefinition paramDefn = null;
    OdaDataSetParameterHandle paramHandle;

    DataSetParameterChecker(ParameterDefinition paramDefn, OdaDataSetParameterHandle paramHandle) {
        if (paramDefn == null || paramHandle == null) {
            throw new IllegalArgumentException("The parameter definition and oda data set parameter handle can not be null!");
        }
        this.paramDefn = paramDefn;
        this.paramHandle = paramHandle;
        this.ambiguousList = new ArrayList<IAmbiguousAttribute>();
    }

    List<IAmbiguousAttribute> process() {
        DataElementAttributes dataAttrs = this.paramDefn.getAttributes();
        this.processDataElementAttributes(dataAttrs);
        ParameterMode inOutMode = this.paramDefn.getInOutMode();
        this.processInOutMode(inOutMode);
        InputElementAttributes inputElementAttrs = this.paramDefn.getEditableInputElementAttributes();
        this.processInputElementAttributes(inputElementAttrs);
        this.processLinkedReportParameter();
        return this.ambiguousList;
    }

    private void processDataElementAttributes(DataElementAttributes dataAttrs) {
        if (dataAttrs == null) {
            return;
        }
        String newValue = dataAttrs.getName();
        String oldValue = this.paramHandle.getNativeName();
        this.handleValue(newValue, oldValue, "nativeName");
        ElementNullability nullability = dataAttrs.getNullability();
        this.processElementNullability(nullability);
    }

    private void processElementNullability(ElementNullability nullability) {
        if (nullability == null) {
            return;
        }
        Boolean newValue = AdapterUtil.getROMNullability(nullability);
        Boolean oldValue = this.paramHandle.allowNull();
        this.handleValue(newValue, oldValue, "allowNull");
    }

    public void processInOutMode(ParameterMode mode) {
        if (mode == null) {
            return;
        }
        Boolean newIsInput = null;
        Boolean newIsOutput = null;
        switch (mode.getValue()) {
            case 2: {
                newIsInput = Boolean.TRUE;
                newIsOutput = Boolean.TRUE;
                break;
            }
            case 0: {
                newIsInput = Boolean.TRUE;
                newIsOutput = Boolean.FALSE;
                break;
            }
            case 1: {
                newIsInput = Boolean.FALSE;
                newIsOutput = Boolean.TRUE;
            }
        }
        boolean oldIsInput = this.paramHandle.isInput();
        boolean oldIsOutput = this.paramHandle.isOutput();
        this.handleValue(newIsInput, oldIsInput, "isInput");
        this.handleValue(newIsOutput, oldIsOutput, "isOutput");
    }

    public void processInputElementAttributes(InputElementAttributes attrs) {
        boolean withLinkedParameter;
        boolean bl = withLinkedParameter = !StringUtil.isBlank((String)this.paramHandle.getParamName());
        if (!withLinkedParameter) {
            Expression oldDefaultExpr;
            Expression newDefaultValue;
            StaticValues defaultValue = attrs.getDefaultValues();
            Object newValue = null;
            if (defaultValue != null && !defaultValue.isEmpty()) {
                newValue = defaultValue.getValues().get(0);
            }
            if (!CompareUtil.isEquals(newDefaultValue = AdapterUtil.createExpression(newValue), oldDefaultExpr = (Expression)this.getLocalValue("defaultValue"))) {
                this.ambiguousList.add(new AmbiguousAttribute("defaultValue", oldDefaultExpr, newDefaultValue, false));
            }
        }
        boolean newIsOptional = attrs.isOptional();
        Boolean oldIsOptional = this.paramHandle.isOptional();
        this.handleValue(newIsOptional, oldIsOptional, "isOptional");
    }

    public void processLinkedReportParameter() {
        String reportParamName = this.paramHandle.getParamName();
        if (StringUtil.isBlank((String)reportParamName)) {
            return;
        }
        ScalarParameterHandle reportParam = (ScalarParameterHandle)this.paramHandle.getModule().getModuleHandle().findParameter(reportParamName);
        if (reportParam == null) {
            return;
        }
        ReportParamChecker tmpVisitor = new ReportParamChecker(this.paramDefn, reportParam);
        List<IAmbiguousAttribute> tmpList = tmpVisitor.process();
        this.ambiguousList.addAll(tmpList);
    }

    private Object getLocalValue(String memberName) {
        OdaDataSetParameter param = (OdaDataSetParameter)this.paramHandle.getStructure();
        Object localValue = param.getLocalProperty(this.paramHandle.getModule(), memberName);
        return localValue;
    }

    private void handleValue(String newValue, String oldValue, String propName) {
        if (!CompareUtil.isEquals(newValue, oldValue)) {
            if (newValue == null && this.getLocalValue(propName) == null) {
                return;
            }
            this.ambiguousList.add(new AmbiguousAttribute(propName, oldValue, newValue, false));
        }
    }

    private void handleValue(Boolean newValue, Boolean oldValue, String propName) {
        if (!CompareUtil.isEquals(newValue, oldValue)) {
            if (newValue == null && this.getLocalValue(propName) == null) {
                return;
            }
            this.ambiguousList.add(new AmbiguousAttribute(propName, oldValue, newValue, false));
        }
    }
}

