/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.arnx.jsonic.Formatter;
import net.arnx.jsonic.JSON;
import net.arnx.jsonic.StringFormatter;
import net.arnx.jsonic.io.OutputSource;
import net.arnx.jsonic.util.ClassUtil;

final class DynaBeanFormatter
implements Formatter {
    public static final DynaBeanFormatter INSTANCE = new DynaBeanFormatter();

    DynaBeanFormatter() {
    }

    public boolean format(JSON json, JSON.Context context, Object src, Object o, OutputSource out) throws Exception {
        int count;
        block18: {
            out.append('{');
            count = 0;
            try {
                Class<?> dynaBeanClass = ClassUtil.findClass("org.apache.commons.beanutils.DynaBean");
                Object dynaClass = dynaBeanClass.getMethod("getDynaClass", new Class[0]).invoke(o, new Object[0]);
                Object[] dynaProperties = (Object[])dynaClass.getClass().getMethod("getDynaProperties", new Class[0]).invoke(dynaClass, new Object[0]);
                if (dynaProperties == null || dynaProperties.length <= 0) break block18;
                Method getName = dynaProperties[0].getClass().getMethod("getName", new Class[0]);
                Method get = dynaBeanClass.getMethod("get", String.class);
                for (Object dp : dynaProperties) {
                    Object name = null;
                    try {
                        name = getName.invoke(dp, new Object[0]);
                    }
                    catch (InvocationTargetException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (name == null) continue;
                    Object value = null;
                    Exception cause = null;
                    try {
                        value = get.invoke(o, name);
                    }
                    catch (Exception e) {
                        cause = e;
                    }
                    if (value == src || cause == null && context.isSuppressNull() && value == null) continue;
                    if (count != 0) {
                        out.append(',');
                    }
                    if (context.isPrettyPrint()) {
                        out.append('\n');
                        for (int j = 0; j < context.getLevel() + 1; ++j) {
                            out.append('\t');
                        }
                    }
                    StringFormatter.serialize(context, name.toString(), out);
                    out.append(':');
                    if (context.isPrettyPrint()) {
                        out.append(' ');
                    }
                    context.enter(name);
                    if (cause != null) {
                        throw cause;
                    }
                    value = json.preformatInternal(context, value);
                    json.formatInternal(context, value, out);
                    context.exit();
                    ++count;
                }
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof Error) {
                    throw (Error)e.getCause();
                }
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw (Exception)e.getCause();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (context.isPrettyPrint() && count > 0) {
            out.append('\n');
            for (int j = 0; j < context.getLevel(); ++j) {
                out.append('\t');
            }
        }
        out.append('}');
        return true;
    }
}

