/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import java.io.Flushable;
import net.arnx.jsonic.Formatter;
import net.arnx.jsonic.JSON;
import net.arnx.jsonic.StringFormatter;
import net.arnx.jsonic.io.OutputSource;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class DOMElementFormatter
implements Formatter {
    public static final DOMElementFormatter INSTANCE = new DOMElementFormatter();

    DOMElementFormatter() {
    }

    public boolean format(JSON json, JSON.Context context, Object src, Object o, OutputSource out) throws Exception {
        int i;
        int j;
        Element elem = (Element)o;
        out.append('[');
        StringFormatter.serialize(context, elem.getTagName(), out);
        out.append(',');
        if (context.isPrettyPrint()) {
            out.append('\n');
            for (j = 0; j < context.getLevel() + 1; ++j) {
                out.append('\t');
            }
        }
        out.append('{');
        if (elem.hasAttributes()) {
            NamedNodeMap names = elem.getAttributes();
            for (i = 0; i < names.getLength(); ++i) {
                Node node;
                if (i != 0) {
                    out.append(',');
                }
                if (context.isPrettyPrint() && names.getLength() > 1) {
                    out.append('\n');
                    for (int j2 = 0; j2 < context.getLevel() + 2; ++j2) {
                        out.append('\t');
                    }
                }
                if (!((node = names.item(i)) instanceof Attr)) continue;
                StringFormatter.serialize(context, node.getNodeName(), out);
                out.append(':');
                if (context.isPrettyPrint()) {
                    out.append(' ');
                }
                StringFormatter.serialize(context, node.getNodeValue(), out);
            }
            if (context.isPrettyPrint() && names.getLength() > 1) {
                out.append('\n');
                for (int j3 = 0; j3 < context.getLevel() + 1; ++j3) {
                    out.append('\t');
                }
            }
        }
        out.append('}');
        if (elem.hasChildNodes()) {
            NodeList nodes = elem.getChildNodes();
            for (i = 0; i < nodes.getLength(); ++i) {
                Object value = nodes.item(i);
                if (!(value instanceof Element) && (!(value instanceof CharacterData) || value instanceof Comment)) continue;
                out.append(',');
                if (context.isPrettyPrint()) {
                    out.append('\n');
                    for (int j4 = 0; j4 < context.getLevel() + 1; ++j4) {
                        out.append('\t');
                    }
                }
                context.enter(i + 2);
                value = json.preformatInternal(context, value);
                json.formatInternal(context, value, out);
                context.exit();
                if (!(out instanceof Flushable)) continue;
                ((Flushable)((Object)out)).flush();
            }
        }
        if (context.isPrettyPrint()) {
            out.append('\n');
            for (j = 0; j < context.getLevel(); ++j) {
                out.append('\t');
            }
        }
        out.append(']');
        return true;
    }
}

