/*
    w32loader
    copyright (c) 1998-2005 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "winmm.h"
#include "advapi32.h"
#include "kernel32.h"
#include "tchar.h"
#include <time.h>


#ifdef W32LDR_HEADER
#define DRV_LOAD            0x0001
#define DRV_ENABLE          0x0002
#define DRV_OPEN            0x0003
#define DRV_CLOSE           0x0004
#define DRV_DISABLE         0x0005
#define DRV_FREE            0x0006
#define DRV_CONFIGURE       0x0007
#define DRV_QUERYCONFIGURE  0x0008
#define DRV_INSTALL         0x0009
#define DRV_REMOVE          0x000a
#define DRV_EXITSESSION     0x000b
#define DRV_EXITAPPLICATION 0x000c
#define DRV_POWER           0x000f
#define DRV_RESERVED        0x0800
#define DRV_USER            0x4000
#define DRV_CANCEL          0x0000
#define DRV_OK              0x0001
#define DRV_RESTART         0x0002
#define DRVCNF_CANCEL       0x0000
#define DRVCNF_OK           0x0001
#define DRVCNF_RESTART      0x0002
#define DRVEA_NORMALEXIT    0x0001
#define DRVEA_ABNORMALEXIT  0x0002
#define DRV_SUCCESS         0x0001
#define DRV_FAILURE         0x0000
typedef struct _HDRVR *HDRVR;
#endif /* W32LDR_HEADER */


struct _HDRVR
{
  W32LdrModule *module;
  LONG lOpenID;
  DWORD dwDriverId;
  LONG CALLBACK (*DriverProc)(DWORD, HDRVR, UINT, LONG, LONG);
};


/* CloseDriver ordinal = 3, argument = 12 */
LRESULT WINAPI CloseDriver (HDRVR hdrvr, LONG lParam1, LONG lParam2)
{
  if (hdrvr)
    {
      hdrvr->DriverProc (hdrvr->dwDriverId, hdrvr, DRV_CLOSE, 0, 0);
      hdrvr->DriverProc (hdrvr->lOpenID, hdrvr, DRV_CLOSE, 0, 0);
      hdrvr->DriverProc (0, hdrvr, DRV_DISABLE, 0, 0);
      hdrvr->DriverProc (0, hdrvr, DRV_FREE, 0, 0);
      w32ldr_free_module (hdrvr->module);
      g_free (hdrvr);
    }
  return TRUE;
}


/* DefDriverProc ordinal = 4, argument = 20 */
LONG WINAPI DefDriverProc (DWORD dwDriverId, HDRVR hDrvr, UINT msg, LONG lParam1, LONG lParam2)
{
  switch (msg)
    {
      case DRV_LOAD:
      case DRV_FREE:
      case DRV_ENABLE:
      case DRV_DISABLE:
        return 1;
      case DRV_OPEN:
      case DRV_CLOSE:
      case DRV_QUERYCONFIGURE:
      case DRV_CONFIGURE:
        return 0;
      case DRV_INSTALL:
      case DRV_REMOVE:
        return DRV_SUCCESS;
    }
  return 0;
}


/* DriverCallback ordinal = 5, argument = 28 temporary */
DWORD WINAPI DriverCallback (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* DrvGetModuleHandle ordinal = 6, argument = 4 temporary */
DWORD WINAPI DrvGetModuleHandle (DWORD dwArgv0)
{
  return 0;
}


/* GetDriverModuleHandle ordinal = 7, argument = 4 */
HMODULE WINAPI GetDriverModuleHandle (HDRVR hdrvr)
{
  return hdrvr ? ((W32LdrModule *)hdrvr->module) + 1 : NULL;
}


/* MigrateAllDrivers ordinal = 8, argument = 0 temporary */
DWORD WINAPI MigrateAllDrivers (VOID)
{
  return 0;
}


/* MigrateMidiUser ordinal = 9, argument = 0 temporary */
DWORD WINAPI MigrateMidiUser (VOID)
{
  return 0;
}


/* MigrateSoundEvents ordinal = 10, argument = 0 temporary */
DWORD WINAPI MigrateSoundEvents (VOID)
{
  return 0;
}


/* NotifyCallbackData ordinal = 11, argument = 20 temporary */
DWORD WINAPI NotifyCallbackData (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* OpenDriver ordinal = 12, argument = 12 */
HDRVR WINAPI OpenDriver (LPCWSTR lpDriverName, LPCWSTR lpSectionName, LONG lParam)
{
  gchar *file, *utf8str;
  HDRVR hdrvr;
  HKEY hKey;

  hdrvr = g_malloc (sizeof (struct _HDRVR));
  utf8str = g_utf16_to_utf8 (lpDriverName, -1, NULL, NULL, NULL);
  file = g_filename_from_utf8 (utf8str, -1, NULL, NULL, NULL);
  g_free (utf8str);
  hdrvr->module = w32ldr_load_module (file, TRUE);
  g_free (file);
  if (!hdrvr->module && RegOpenKeyEx (HKEY_LOCAL_MACHINE,
        _T("Software\\Microsoft\\Windows NT\\CurrentVersion\\Drivers32"), 0,
                                    KEY_QUERY_VALUE, &hKey) == ERROR_SUCCESS)
    {
      DWORD dwType, dwValue = MAX_PATH;
#ifdef UNICODE
      WCHAR szValue[MAX_PATH];

      if (RegQueryValueEx (hKey, lpDriverName, NULL,
            &dwType, szValue, &dwValue) == ERROR_SUCCESS && dwType == REG_SZ)
        {
          file = w32ldr_filename_from_wc (szValue);
#else
      CHAR szName[MAX_PATH], szValue[MAX_PATH];

      WideCharToMultiByte (CP_ACP, 0, lpDriverName, -1,
                                                szName, MAX_PATH, NULL, NULL);
      if (RegQueryValueEx (hKey, szName, NULL, &dwType,
            (LPBYTE)szValue, &dwValue) == ERROR_SUCCESS && dwType == REG_SZ)
        {
          file = w32ldr_filename_from_mb (szValue);
#endif
          hdrvr->module = w32ldr_load_module (file, TRUE);
          g_free (file);
        }
      RegCloseKey (hKey);
    }
  hdrvr->DriverProc = w32ldr_get_func (hdrvr->module, "DriverProc");
  if (hdrvr->DriverProc)
    {
      gunichar2 param = '\0';

      hdrvr->DriverProc (0, hdrvr, DRV_LOAD, 0, 0);
      hdrvr->DriverProc (0, hdrvr, DRV_ENABLE, 0, 0);
      hdrvr->lOpenID = hdrvr->DriverProc (0, hdrvr, DRV_OPEN,
                                                GPOINTER_TO_INT (&param), 0);
      hdrvr->dwDriverId = hdrvr->DriverProc (0, hdrvr, DRV_OPEN, 0, lParam);
    }
  else
    {
      w32ldr_free_module (hdrvr->module);
      g_free (hdrvr);
      hdrvr = NULL;
    }
  return hdrvr;
}


/* PlaySound ordinal = 13, argument = 12 temporary */
/* DWORD WINAPI PlaySound (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2) */


/* PlaySoundA ordinal = 14, argument = 12 temporary */
DWORD WINAPI PlaySoundA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* PlaySoundW ordinal = 15, argument = 12 temporary */
DWORD WINAPI PlaySoundW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SendDriverMessage ordinal = 16, argument = 16 */
LRESULT WINAPI SendDriverMessage (HDRVR hdrvr, UINT msg, LONG lParam1, LONG lParam2)
{
  return hdrvr
    ? hdrvr->DriverProc (hdrvr->dwDriverId, hdrvr, msg, lParam1, lParam2) : 0;
}


/* WOW32DriverCallback ordinal = 17, argument = 28 temporary */
DWORD WINAPI WOW32DriverCallback (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* WOW32ResolveMultiMediaHandle ordinal = 18, argument = 24 temporary */
DWORD WINAPI WOW32ResolveMultiMediaHandle (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* WOWAppExit ordinal = 19, argument = 4 temporary */
DWORD WINAPI WOWAppExit (DWORD dwArgv0)
{
  return 0;
}


/* WinmmLogoff ordinal = 20, argument = 0 temporary */
DWORD WINAPI WinmmLogoff (VOID)
{
  return 0;
}


/* WinmmLogon ordinal = 21, argument = 4 temporary */
DWORD WINAPI WinmmLogon (DWORD dwArgv0)
{
  return 0;
}


/* aux32Message ordinal = 22, argument = 20 temporary */
DWORD WINAPI aux32Message (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* auxGetDevCapsA ordinal = 23, argument = 12 temporary */
DWORD WINAPI auxGetDevCapsA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* auxGetDevCapsW ordinal = 24, argument = 12 temporary */
DWORD WINAPI auxGetDevCapsW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* auxGetNumDevs ordinal = 25, argument = 0 temporary */
DWORD WINAPI auxGetNumDevs (VOID)
{
  return 0;
}


/* auxGetVolume ordinal = 26, argument = 8 temporary */
DWORD WINAPI auxGetVolume (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* auxOutMessage ordinal = 27, argument = 16 temporary */
DWORD WINAPI auxOutMessage (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* auxSetVolume ordinal = 28, argument = 8 temporary */
DWORD WINAPI auxSetVolume (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* joy32Message ordinal = 29, argument = 20 temporary */
DWORD WINAPI joy32Message (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* joyConfigChanged ordinal = 30, argument = 4 temporary */
DWORD WINAPI joyConfigChanged (DWORD dwArgv0)
{
  return 0;
}


/* joyGetDevCapsA ordinal = 31, argument = 12 temporary */
DWORD WINAPI joyGetDevCapsA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* joyGetDevCapsW ordinal = 32, argument = 12 temporary */
DWORD WINAPI joyGetDevCapsW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* joyGetNumDevs ordinal = 33, argument = 0 temporary */
DWORD WINAPI joyGetNumDevs (VOID)
{
  return 0;
}


/* joyGetPos ordinal = 34, argument = 8 temporary */
DWORD WINAPI joyGetPos (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* joyGetPosEx ordinal = 35, argument = 8 temporary */
DWORD WINAPI joyGetPosEx (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* joyGetThreshold ordinal = 36, argument = 8 temporary */
DWORD WINAPI joyGetThreshold (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* joyReleaseCapture ordinal = 37, argument = 4 temporary */
DWORD WINAPI joyReleaseCapture (DWORD dwArgv0)
{
  return 0;
}


/* joySetCapture ordinal = 38, argument = 16 temporary */
DWORD WINAPI joySetCapture (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* joySetThreshold ordinal = 39, argument = 8 temporary */
DWORD WINAPI joySetThreshold (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* mci32Message ordinal = 40, argument = 20 temporary */
DWORD WINAPI mci32Message (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* mciDriverNotify ordinal = 41, argument = 12 temporary */
DWORD WINAPI mciDriverNotify (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* mciDriverYield ordinal = 42, argument = 4 temporary */
DWORD WINAPI mciDriverYield (DWORD dwArgv0)
{
  return 0;
}


/* mciExecute ordinal = 43, argument = 4 temporary */
DWORD WINAPI mciExecute (DWORD dwArgv0)
{
  return 0;
}


/* mciFreeCommandResource ordinal = 44, argument = 4 temporary */
DWORD WINAPI mciFreeCommandResource (DWORD dwArgv0)
{
  return 0;
}


/* mciGetCreatorTask ordinal = 45, argument = 4 temporary */
DWORD WINAPI mciGetCreatorTask (DWORD dwArgv0)
{
  return 0;
}


/* mciGetDeviceIDA ordinal = 46, argument = 4 temporary */
DWORD WINAPI mciGetDeviceIDA (DWORD dwArgv0)
{
  return 0;
}


/* mciGetDeviceIDFromElementIDA ordinal = 47, argument = 8 temporary */
DWORD WINAPI mciGetDeviceIDFromElementIDA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* mciGetDeviceIDFromElementIDW ordinal = 48, argument = 8 temporary */
DWORD WINAPI mciGetDeviceIDFromElementIDW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* mciGetDeviceIDW ordinal = 49, argument = 4 temporary */
DWORD WINAPI mciGetDeviceIDW (DWORD dwArgv0)
{
  return 0;
}


/* mciGetDriverData ordinal = 50, argument = 4 temporary */
DWORD WINAPI mciGetDriverData (DWORD dwArgv0)
{
  return 0;
}


/* mciGetErrorStringA ordinal = 51, argument = 12 temporary */
DWORD WINAPI mciGetErrorStringA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* mciGetErrorStringW ordinal = 52, argument = 12 temporary */
DWORD WINAPI mciGetErrorStringW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* mciGetYieldProc ordinal = 53, argument = 8 temporary */
DWORD WINAPI mciGetYieldProc (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* mciLoadCommandResource ordinal = 54, argument = 12 temporary */
DWORD WINAPI mciLoadCommandResource (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* mciSendCommandA ordinal = 55, argument = 16 temporary */
DWORD WINAPI mciSendCommandA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* mciSendCommandW ordinal = 56, argument = 16 temporary */
DWORD WINAPI mciSendCommandW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* mciSendStringA ordinal = 57, argument = 16 temporary */
DWORD WINAPI mciSendStringA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* mciSendStringW ordinal = 58, argument = 16 temporary */
DWORD WINAPI mciSendStringW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* mciSetDriverData ordinal = 59, argument = 8 temporary */
DWORD WINAPI mciSetDriverData (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* mciSetYieldProc ordinal = 60, argument = 12 temporary */
DWORD WINAPI mciSetYieldProc (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* mid32Message ordinal = 61, argument = 20 temporary */
DWORD WINAPI mid32Message (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* midiConnect ordinal = 62, argument = 12 temporary */
DWORD WINAPI midiConnect (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* midiDisconnect ordinal = 63, argument = 12 temporary */
DWORD WINAPI midiDisconnect (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* midiInAddBuffer ordinal = 64, argument = 12 temporary */
DWORD WINAPI midiInAddBuffer (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* midiInClose ordinal = 65, argument = 4 temporary */
DWORD WINAPI midiInClose (DWORD dwArgv0)
{
  return 0;
}


/* midiInGetDevCapsA ordinal = 66, argument = 12 temporary */
DWORD WINAPI midiInGetDevCapsA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* midiInGetDevCapsW ordinal = 67, argument = 12 temporary */
DWORD WINAPI midiInGetDevCapsW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* midiInGetErrorTextA ordinal = 68, argument = 12 temporary */
DWORD WINAPI midiInGetErrorTextA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* midiInGetErrorTextW ordinal = 69, argument = 12 temporary */
DWORD WINAPI midiInGetErrorTextW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* midiInGetID ordinal = 70, argument = 8 temporary */
DWORD WINAPI midiInGetID (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* midiInGetNumDevs ordinal = 71, argument = 0 temporary */
DWORD WINAPI midiInGetNumDevs (VOID)
{
  return 0;
}


/* midiInMessage ordinal = 72, argument = 16 temporary */
DWORD WINAPI midiInMessage (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* midiInOpen ordinal = 73, argument = 20 temporary */
DWORD WINAPI midiInOpen (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* midiInPrepareHeader ordinal = 74, argument = 12 temporary */
DWORD WINAPI midiInPrepareHeader (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* midiInReset ordinal = 75, argument = 4 temporary */
DWORD WINAPI midiInReset (DWORD dwArgv0)
{
  return 0;
}


/* midiInStart ordinal = 76, argument = 4 temporary */
DWORD WINAPI midiInStart (DWORD dwArgv0)
{
  return 0;
}


/* midiInStop ordinal = 77, argument = 4 temporary */
DWORD WINAPI midiInStop (DWORD dwArgv0)
{
  return 0;
}


/* midiInUnprepareHeader ordinal = 78, argument = 12 temporary */
DWORD WINAPI midiInUnprepareHeader (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* midiOutCacheDrumPatches ordinal = 79, argument = 16 temporary */
DWORD WINAPI midiOutCacheDrumPatches (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* midiOutCachePatches ordinal = 80, argument = 16 temporary */
DWORD WINAPI midiOutCachePatches (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* midiOutClose ordinal = 81, argument = 4 temporary */
DWORD WINAPI midiOutClose (DWORD dwArgv0)
{
  return 0;
}


/* midiOutGetDevCapsA ordinal = 82, argument = 12 temporary */
DWORD WINAPI midiOutGetDevCapsA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* midiOutGetDevCapsW ordinal = 83, argument = 12 temporary */
DWORD WINAPI midiOutGetDevCapsW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* midiOutGetErrorTextA ordinal = 84, argument = 12 temporary */
DWORD WINAPI midiOutGetErrorTextA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* midiOutGetErrorTextW ordinal = 85, argument = 12 temporary */
DWORD WINAPI midiOutGetErrorTextW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* midiOutGetID ordinal = 86, argument = 8 temporary */
DWORD WINAPI midiOutGetID (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* midiOutGetNumDevs ordinal = 87, argument = 0 temporary */
DWORD WINAPI midiOutGetNumDevs (VOID)
{
  return 0;
}


/* midiOutGetVolume ordinal = 88, argument = 8 temporary */
DWORD WINAPI midiOutGetVolume (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* midiOutLongMsg ordinal = 89, argument = 12 temporary */
DWORD WINAPI midiOutLongMsg (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* midiOutMessage ordinal = 90, argument = 16 temporary */
DWORD WINAPI midiOutMessage (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* midiOutOpen ordinal = 91, argument = 20 temporary */
DWORD WINAPI midiOutOpen (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* midiOutPrepareHeader ordinal = 92, argument = 12 temporary */
DWORD WINAPI midiOutPrepareHeader (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* midiOutReset ordinal = 93, argument = 4 temporary */
DWORD WINAPI midiOutReset (DWORD dwArgv0)
{
  return 0;
}


/* midiOutSetVolume ordinal = 94, argument = 8 temporary */
DWORD WINAPI midiOutSetVolume (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* midiOutShortMsg ordinal = 95, argument = 8 temporary */
DWORD WINAPI midiOutShortMsg (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* midiOutUnprepareHeader ordinal = 96, argument = 12 temporary */
DWORD WINAPI midiOutUnprepareHeader (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* midiStreamClose ordinal = 97, argument = 4 temporary */
DWORD WINAPI midiStreamClose (DWORD dwArgv0)
{
  return 0;
}


/* midiStreamOpen ordinal = 98, argument = 24 temporary */
DWORD WINAPI midiStreamOpen (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* midiStreamOut ordinal = 99, argument = 12 temporary */
DWORD WINAPI midiStreamOut (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* midiStreamPause ordinal = 100, argument = 4 temporary */
DWORD WINAPI midiStreamPause (DWORD dwArgv0)
{
  return 0;
}


/* midiStreamPosition ordinal = 101, argument = 12 temporary */
DWORD WINAPI midiStreamPosition (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* midiStreamProperty ordinal = 102, argument = 12 temporary */
DWORD WINAPI midiStreamProperty (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* midiStreamRestart ordinal = 103, argument = 4 temporary */
DWORD WINAPI midiStreamRestart (DWORD dwArgv0)
{
  return 0;
}


/* midiStreamStop ordinal = 104, argument = 4 temporary */
DWORD WINAPI midiStreamStop (DWORD dwArgv0)
{
  return 0;
}


/* mixerClose ordinal = 105, argument = 4 temporary */
DWORD WINAPI mixerClose (DWORD dwArgv0)
{
  return 0;
}


/* mixerGetControlDetailsA ordinal = 106, argument = 12 temporary */
DWORD WINAPI mixerGetControlDetailsA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* mixerGetControlDetailsW ordinal = 107, argument = 12 temporary */
DWORD WINAPI mixerGetControlDetailsW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* mixerGetDevCapsA ordinal = 108, argument = 12 temporary */
DWORD WINAPI mixerGetDevCapsA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* mixerGetDevCapsW ordinal = 109, argument = 12 temporary */
DWORD WINAPI mixerGetDevCapsW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* mixerGetID ordinal = 110, argument = 12 temporary */
DWORD WINAPI mixerGetID (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* mixerGetLineControlsA ordinal = 111, argument = 12 temporary */
DWORD WINAPI mixerGetLineControlsA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* mixerGetLineControlsW ordinal = 112, argument = 12 temporary */
DWORD WINAPI mixerGetLineControlsW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* mixerGetLineInfoA ordinal = 113, argument = 12 temporary */
DWORD WINAPI mixerGetLineInfoA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* mixerGetLineInfoW ordinal = 114, argument = 12 temporary */
DWORD WINAPI mixerGetLineInfoW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* mixerGetNumDevs ordinal = 115, argument = 0 temporary */
DWORD WINAPI mixerGetNumDevs (VOID)
{
  return 0;
}


/* mixerMessage ordinal = 116, argument = 16 temporary */
DWORD WINAPI mixerMessage (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* mixerOpen ordinal = 117, argument = 20 temporary */
DWORD WINAPI mixerOpen (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* mixerSetControlDetails ordinal = 118, argument = 12 temporary */
DWORD WINAPI mixerSetControlDetails (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* mmDrvInstall ordinal = 119, argument = 16 temporary */
DWORD WINAPI mmDrvInstall (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* mmGetCurrentTask ordinal = 120, argument = 0 temporary */
DWORD WINAPI mmGetCurrentTask (VOID)
{
  return 0;
}


/* mmTaskBlock ordinal = 121, argument = 4 temporary */
DWORD WINAPI mmTaskBlock (DWORD dwArgv0)
{
  return 0;
}


/* mmTaskCreate ordinal = 122, argument = 12 temporary */
DWORD WINAPI mmTaskCreate (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* mmTaskSignal ordinal = 123, argument = 4 temporary */
DWORD WINAPI mmTaskSignal (DWORD dwArgv0)
{
  return 0;
}


/* mmTaskYield ordinal = 124, argument = 0 temporary */
DWORD WINAPI mmTaskYield (VOID)
{
  return 0;
}


/* mmioAdvance ordinal = 125, argument = 12 temporary */
DWORD WINAPI mmioAdvance (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* mmioAscend ordinal = 126, argument = 12 temporary */
DWORD WINAPI mmioAscend (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* mmioClose ordinal = 127, argument = 8 temporary */
DWORD WINAPI mmioClose (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* mmioCreateChunk ordinal = 128, argument = 12 temporary */
DWORD WINAPI mmioCreateChunk (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* mmioDescend ordinal = 129, argument = 16 temporary */
DWORD WINAPI mmioDescend (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* mmioFlush ordinal = 130, argument = 8 temporary */
DWORD WINAPI mmioFlush (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* mmioGetInfo ordinal = 131, argument = 12 temporary */
DWORD WINAPI mmioGetInfo (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* mmioInstallIOProcA ordinal = 132, argument = 12 temporary */
DWORD WINAPI mmioInstallIOProcA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* mmioInstallIOProcW ordinal = 133, argument = 12 temporary */
DWORD WINAPI mmioInstallIOProcW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* mmioOpenA ordinal = 134, argument = 12 temporary */
DWORD WINAPI mmioOpenA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* mmioOpenW ordinal = 135, argument = 12 temporary */
DWORD WINAPI mmioOpenW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* mmioRead ordinal = 136, argument = 12 temporary */
DWORD WINAPI mmioRead (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* mmioRenameA ordinal = 137, argument = 16 temporary */
DWORD WINAPI mmioRenameA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* mmioRenameW ordinal = 138, argument = 16 temporary */
DWORD WINAPI mmioRenameW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* mmioSeek ordinal = 139, argument = 12 temporary */
DWORD WINAPI mmioSeek (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* mmioSendMessage ordinal = 140, argument = 16 temporary */
DWORD WINAPI mmioSendMessage (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* mmioSetBuffer ordinal = 141, argument = 16 temporary */
DWORD WINAPI mmioSetBuffer (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* mmioSetInfo ordinal = 142, argument = 12 temporary */
DWORD WINAPI mmioSetInfo (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* mmioStringToFOURCCA ordinal = 143, argument = 8 temporary */
DWORD WINAPI mmioStringToFOURCCA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* mmioStringToFOURCCW ordinal = 144, argument = 8 temporary */
DWORD WINAPI mmioStringToFOURCCW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* mmioWrite ordinal = 145, argument = 12 temporary */
DWORD WINAPI mmioWrite (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* mmsystemGetVersion ordinal = 146, argument = 0 temporary */
DWORD WINAPI mmsystemGetVersion (VOID)
{
  return 0;
}


/* mod32Message ordinal = 147, argument = 20 temporary */
DWORD WINAPI mod32Message (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* mxd32Message ordinal = 148, argument = 20 temporary */
DWORD WINAPI mxd32Message (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* sndPlaySoundA ordinal = 149, argument = 8 temporary */
DWORD WINAPI sndPlaySoundA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* sndPlaySoundW ordinal = 150, argument = 8 temporary */
DWORD WINAPI sndPlaySoundW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* tid32Message ordinal = 151, argument = 20 temporary */
DWORD WINAPI tid32Message (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* timeBeginPeriod ordinal = 152, argument = 4 temporary */
DWORD WINAPI timeBeginPeriod (DWORD dwArgv0)
{
  return 0;
}


/* timeEndPeriod ordinal = 153, argument = 4 temporary */
DWORD WINAPI timeEndPeriod (DWORD dwArgv0)
{
  return 0;
}


/* timeGetDevCaps ordinal = 154, argument = 8 temporary */
DWORD WINAPI timeGetDevCaps (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* timeGetSystemTime ordinal = 155, argument = 8 temporary */
DWORD WINAPI timeGetSystemTime (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* timeGetTime ordinal = 156, argument = 0 */
DWORD WINAPI timeGetTime (VOID)
{
  return time (NULL) * 1000;
}


/* timeKillEvent ordinal = 157, argument = 4 temporary */
DWORD WINAPI timeKillEvent (DWORD dwArgv0)
{
  return 0;
}


/* timeSetEvent ordinal = 158, argument = 20 temporary */
DWORD WINAPI timeSetEvent (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* waveInAddBuffer ordinal = 159, argument = 12 temporary */
DWORD WINAPI waveInAddBuffer (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* waveInClose ordinal = 160, argument = 4 temporary */
DWORD WINAPI waveInClose (DWORD dwArgv0)
{
  return 0;
}


/* waveInGetDevCapsA ordinal = 161, argument = 12 temporary */
DWORD WINAPI waveInGetDevCapsA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* waveInGetDevCapsW ordinal = 162, argument = 12 temporary */
DWORD WINAPI waveInGetDevCapsW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* waveInGetErrorTextA ordinal = 163, argument = 12 temporary */
DWORD WINAPI waveInGetErrorTextA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* waveInGetErrorTextW ordinal = 164, argument = 12 temporary */
DWORD WINAPI waveInGetErrorTextW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* waveInGetID ordinal = 165, argument = 8 temporary */
DWORD WINAPI waveInGetID (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* waveInGetNumDevs ordinal = 166, argument = 0 temporary */
DWORD WINAPI waveInGetNumDevs (VOID)
{
  return 0;
}


/* waveInGetPosition ordinal = 167, argument = 12 temporary */
DWORD WINAPI waveInGetPosition (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* waveInMessage ordinal = 168, argument = 16 temporary */
DWORD WINAPI waveInMessage (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* waveInOpen ordinal = 169, argument = 24 temporary */
DWORD WINAPI waveInOpen (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* waveInPrepareHeader ordinal = 170, argument = 12 temporary */
DWORD WINAPI waveInPrepareHeader (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* waveInReset ordinal = 171, argument = 4 temporary */
DWORD WINAPI waveInReset (DWORD dwArgv0)
{
  return 0;
}


/* waveInStart ordinal = 172, argument = 4 temporary */
DWORD WINAPI waveInStart (DWORD dwArgv0)
{
  return 0;
}


/* waveInStop ordinal = 173, argument = 4 temporary */
DWORD WINAPI waveInStop (DWORD dwArgv0)
{
  return 0;
}


/* waveInUnprepareHeader ordinal = 174, argument = 12 temporary */
DWORD WINAPI waveInUnprepareHeader (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* waveOutBreakLoop ordinal = 175, argument = 4 temporary */
DWORD WINAPI waveOutBreakLoop (DWORD dwArgv0)
{
  return 0;
}


/* waveOutClose ordinal = 176, argument = 4 temporary */
DWORD WINAPI waveOutClose (DWORD dwArgv0)
{
  return 0;
}


/* waveOutGetDevCapsA ordinal = 177, argument = 12 temporary */
DWORD WINAPI waveOutGetDevCapsA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* waveOutGetDevCapsW ordinal = 178, argument = 12 temporary */
DWORD WINAPI waveOutGetDevCapsW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* waveOutGetErrorTextA ordinal = 179, argument = 12 temporary */
DWORD WINAPI waveOutGetErrorTextA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* waveOutGetErrorTextW ordinal = 180, argument = 12 temporary */
DWORD WINAPI waveOutGetErrorTextW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* waveOutGetID ordinal = 181, argument = 8 temporary */
DWORD WINAPI waveOutGetID (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* waveOutGetNumDevs ordinal = 182, argument = 0 temporary */
DWORD WINAPI waveOutGetNumDevs (VOID)
{
  return 0;
}


/* waveOutGetPitch ordinal = 183, argument = 8 temporary */
DWORD WINAPI waveOutGetPitch (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* waveOutGetPlaybackRate ordinal = 184, argument = 8 temporary */
DWORD WINAPI waveOutGetPlaybackRate (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* waveOutGetPosition ordinal = 185, argument = 12 temporary */
DWORD WINAPI waveOutGetPosition (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* waveOutGetVolume ordinal = 186, argument = 8 temporary */
DWORD WINAPI waveOutGetVolume (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* waveOutMessage ordinal = 187, argument = 16 temporary */
DWORD WINAPI waveOutMessage (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* waveOutOpen ordinal = 188, argument = 24 temporary */
DWORD WINAPI waveOutOpen (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* waveOutPause ordinal = 189, argument = 4 temporary */
DWORD WINAPI waveOutPause (DWORD dwArgv0)
{
  return 0;
}


/* waveOutPrepareHeader ordinal = 190, argument = 12 temporary */
DWORD WINAPI waveOutPrepareHeader (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* waveOutReset ordinal = 191, argument = 4 temporary */
DWORD WINAPI waveOutReset (DWORD dwArgv0)
{
  return 0;
}


/* waveOutRestart ordinal = 192, argument = 4 temporary */
DWORD WINAPI waveOutRestart (DWORD dwArgv0)
{
  return 0;
}


/* waveOutSetPitch ordinal = 193, argument = 8 temporary */
DWORD WINAPI waveOutSetPitch (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* waveOutSetPlaybackRate ordinal = 194, argument = 8 temporary */
DWORD WINAPI waveOutSetPlaybackRate (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* waveOutSetVolume ordinal = 195, argument = 8 temporary */
DWORD WINAPI waveOutSetVolume (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* waveOutUnprepareHeader ordinal = 196, argument = 12 temporary */
DWORD WINAPI waveOutUnprepareHeader (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* waveOutWrite ordinal = 197, argument = 12 temporary */
DWORD WINAPI waveOutWrite (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* wid32Message ordinal = 198, argument = 20 temporary */
DWORD WINAPI wid32Message (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* winmmDbgOut ordinal = 199, argument = 0 temporary */
DWORD WINAPI winmmDbgOut (VOID)
{
  return 0;
}


/* winmmSetDebugLevel ordinal = 200, argument = 4 temporary */
DWORD WINAPI winmmSetDebugLevel (DWORD dwArgv0)
{
  return 0;
}


/* wod32Message ordinal = 201, argument = 20 temporary */
DWORD WINAPI wod32Message (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


W32LdrExport winmm_exports[] = {
{3, "CloseDriver", CloseDriver},
{4, "DefDriverProc", DefDriverProc},
{5, "DriverCallback", DriverCallback},
{6, "DrvGetModuleHandle", DrvGetModuleHandle},
{7, "GetDriverModuleHandle", GetDriverModuleHandle},
{8, "MigrateAllDrivers", MigrateAllDrivers},
{9, "MigrateMidiUser", MigrateMidiUser},
{10, "MigrateSoundEvents", MigrateSoundEvents},
{11, "NotifyCallbackData", NotifyCallbackData},
{12, "OpenDriver", OpenDriver},
{13, "PlaySound", PlaySoundA},
{14, "PlaySoundA", PlaySoundA},
{15, "PlaySoundW", PlaySoundW},
{16, "SendDriverMessage", SendDriverMessage},
{17, "WOW32DriverCallback", WOW32DriverCallback},
{18, "WOW32ResolveMultiMediaHandle", WOW32ResolveMultiMediaHandle},
{19, "WOWAppExit", WOWAppExit},
{20, "WinmmLogoff", WinmmLogoff},
{21, "WinmmLogon", WinmmLogon},
{22, "aux32Message", aux32Message},
{23, "auxGetDevCapsA", auxGetDevCapsA},
{24, "auxGetDevCapsW", auxGetDevCapsW},
{25, "auxGetNumDevs", auxGetNumDevs},
{26, "auxGetVolume", auxGetVolume},
{27, "auxOutMessage", auxOutMessage},
{28, "auxSetVolume", auxSetVolume},
{29, "joy32Message", joy32Message},
{30, "joyConfigChanged", joyConfigChanged},
{31, "joyGetDevCapsA", joyGetDevCapsA},
{32, "joyGetDevCapsW", joyGetDevCapsW},
{33, "joyGetNumDevs", joyGetNumDevs},
{34, "joyGetPos", joyGetPos},
{35, "joyGetPosEx", joyGetPosEx},
{36, "joyGetThreshold", joyGetThreshold},
{37, "joyReleaseCapture", joyReleaseCapture},
{38, "joySetCapture", joySetCapture},
{39, "joySetThreshold", joySetThreshold},
{40, "mci32Message", mci32Message},
{41, "mciDriverNotify", mciDriverNotify},
{42, "mciDriverYield", mciDriverYield},
{43, "mciExecute", mciExecute},
{44, "mciFreeCommandResource", mciFreeCommandResource},
{45, "mciGetCreatorTask", mciGetCreatorTask},
{46, "mciGetDeviceIDA", mciGetDeviceIDA},
{47, "mciGetDeviceIDFromElementIDA", mciGetDeviceIDFromElementIDA},
{48, "mciGetDeviceIDFromElementIDW", mciGetDeviceIDFromElementIDW},
{49, "mciGetDeviceIDW", mciGetDeviceIDW},
{50, "mciGetDriverData", mciGetDriverData},
{51, "mciGetErrorStringA", mciGetErrorStringA},
{52, "mciGetErrorStringW", mciGetErrorStringW},
{53, "mciGetYieldProc", mciGetYieldProc},
{54, "mciLoadCommandResource", mciLoadCommandResource},
{55, "mciSendCommandA", mciSendCommandA},
{56, "mciSendCommandW", mciSendCommandW},
{57, "mciSendStringA", mciSendStringA},
{58, "mciSendStringW", mciSendStringW},
{59, "mciSetDriverData", mciSetDriverData},
{60, "mciSetYieldProc", mciSetYieldProc},
{61, "mid32Message", mid32Message},
{62, "midiConnect", midiConnect},
{63, "midiDisconnect", midiDisconnect},
{64, "midiInAddBuffer", midiInAddBuffer},
{65, "midiInClose", midiInClose},
{66, "midiInGetDevCapsA", midiInGetDevCapsA},
{67, "midiInGetDevCapsW", midiInGetDevCapsW},
{68, "midiInGetErrorTextA", midiInGetErrorTextA},
{69, "midiInGetErrorTextW", midiInGetErrorTextW},
{70, "midiInGetID", midiInGetID},
{71, "midiInGetNumDevs", midiInGetNumDevs},
{72, "midiInMessage", midiInMessage},
{73, "midiInOpen", midiInOpen},
{74, "midiInPrepareHeader", midiInPrepareHeader},
{75, "midiInReset", midiInReset},
{76, "midiInStart", midiInStart},
{77, "midiInStop", midiInStop},
{78, "midiInUnprepareHeader", midiInUnprepareHeader},
{79, "midiOutCacheDrumPatches", midiOutCacheDrumPatches},
{80, "midiOutCachePatches", midiOutCachePatches},
{81, "midiOutClose", midiOutClose},
{82, "midiOutGetDevCapsA", midiOutGetDevCapsA},
{83, "midiOutGetDevCapsW", midiOutGetDevCapsW},
{84, "midiOutGetErrorTextA", midiOutGetErrorTextA},
{85, "midiOutGetErrorTextW", midiOutGetErrorTextW},
{86, "midiOutGetID", midiOutGetID},
{87, "midiOutGetNumDevs", midiOutGetNumDevs},
{88, "midiOutGetVolume", midiOutGetVolume},
{89, "midiOutLongMsg", midiOutLongMsg},
{90, "midiOutMessage", midiOutMessage},
{91, "midiOutOpen", midiOutOpen},
{92, "midiOutPrepareHeader", midiOutPrepareHeader},
{93, "midiOutReset", midiOutReset},
{94, "midiOutSetVolume", midiOutSetVolume},
{95, "midiOutShortMsg", midiOutShortMsg},
{96, "midiOutUnprepareHeader", midiOutUnprepareHeader},
{97, "midiStreamClose", midiStreamClose},
{98, "midiStreamOpen", midiStreamOpen},
{99, "midiStreamOut", midiStreamOut},
{100, "midiStreamPause", midiStreamPause},
{101, "midiStreamPosition", midiStreamPosition},
{102, "midiStreamProperty", midiStreamProperty},
{103, "midiStreamRestart", midiStreamRestart},
{104, "midiStreamStop", midiStreamStop},
{105, "mixerClose", mixerClose},
{106, "mixerGetControlDetailsA", mixerGetControlDetailsA},
{107, "mixerGetControlDetailsW", mixerGetControlDetailsW},
{108, "mixerGetDevCapsA", mixerGetDevCapsA},
{109, "mixerGetDevCapsW", mixerGetDevCapsW},
{110, "mixerGetID", mixerGetID},
{111, "mixerGetLineControlsA", mixerGetLineControlsA},
{112, "mixerGetLineControlsW", mixerGetLineControlsW},
{113, "mixerGetLineInfoA", mixerGetLineInfoA},
{114, "mixerGetLineInfoW", mixerGetLineInfoW},
{115, "mixerGetNumDevs", mixerGetNumDevs},
{116, "mixerMessage", mixerMessage},
{117, "mixerOpen", mixerOpen},
{118, "mixerSetControlDetails", mixerSetControlDetails},
{119, "mmDrvInstall", mmDrvInstall},
{120, "mmGetCurrentTask", mmGetCurrentTask},
{121, "mmTaskBlock", mmTaskBlock},
{122, "mmTaskCreate", mmTaskCreate},
{123, "mmTaskSignal", mmTaskSignal},
{124, "mmTaskYield", mmTaskYield},
{125, "mmioAdvance", mmioAdvance},
{126, "mmioAscend", mmioAscend},
{127, "mmioClose", mmioClose},
{128, "mmioCreateChunk", mmioCreateChunk},
{129, "mmioDescend", mmioDescend},
{130, "mmioFlush", mmioFlush},
{131, "mmioGetInfo", mmioGetInfo},
{132, "mmioInstallIOProcA", mmioInstallIOProcA},
{133, "mmioInstallIOProcW", mmioInstallIOProcW},
{134, "mmioOpenA", mmioOpenA},
{135, "mmioOpenW", mmioOpenW},
{136, "mmioRead", mmioRead},
{137, "mmioRenameA", mmioRenameA},
{138, "mmioRenameW", mmioRenameW},
{139, "mmioSeek", mmioSeek},
{140, "mmioSendMessage", mmioSendMessage},
{141, "mmioSetBuffer", mmioSetBuffer},
{142, "mmioSetInfo", mmioSetInfo},
{143, "mmioStringToFOURCCA", mmioStringToFOURCCA},
{144, "mmioStringToFOURCCW", mmioStringToFOURCCW},
{145, "mmioWrite", mmioWrite},
{146, "mmsystemGetVersion", mmsystemGetVersion},
{147, "mod32Message", mod32Message},
{148, "mxd32Message", mxd32Message},
{149, "sndPlaySoundA", sndPlaySoundA},
{150, "sndPlaySoundW", sndPlaySoundW},
{151, "tid32Message", tid32Message},
{152, "timeBeginPeriod", timeBeginPeriod},
{153, "timeEndPeriod", timeEndPeriod},
{154, "timeGetDevCaps", timeGetDevCaps},
{155, "timeGetSystemTime", timeGetSystemTime},
{156, "timeGetTime", timeGetTime},
{157, "timeKillEvent", timeKillEvent},
{158, "timeSetEvent", timeSetEvent},
{159, "waveInAddBuffer", waveInAddBuffer},
{160, "waveInClose", waveInClose},
{161, "waveInGetDevCapsA", waveInGetDevCapsA},
{162, "waveInGetDevCapsW", waveInGetDevCapsW},
{163, "waveInGetErrorTextA", waveInGetErrorTextA},
{164, "waveInGetErrorTextW", waveInGetErrorTextW},
{165, "waveInGetID", waveInGetID},
{166, "waveInGetNumDevs", waveInGetNumDevs},
{167, "waveInGetPosition", waveInGetPosition},
{168, "waveInMessage", waveInMessage},
{169, "waveInOpen", waveInOpen},
{170, "waveInPrepareHeader", waveInPrepareHeader},
{171, "waveInReset", waveInReset},
{172, "waveInStart", waveInStart},
{173, "waveInStop", waveInStop},
{174, "waveInUnprepareHeader", waveInUnprepareHeader},
{175, "waveOutBreakLoop", waveOutBreakLoop},
{176, "waveOutClose", waveOutClose},
{177, "waveOutGetDevCapsA", waveOutGetDevCapsA},
{178, "waveOutGetDevCapsW", waveOutGetDevCapsW},
{179, "waveOutGetErrorTextA", waveOutGetErrorTextA},
{180, "waveOutGetErrorTextW", waveOutGetErrorTextW},
{181, "waveOutGetID", waveOutGetID},
{182, "waveOutGetNumDevs", waveOutGetNumDevs},
{183, "waveOutGetPitch", waveOutGetPitch},
{184, "waveOutGetPlaybackRate", waveOutGetPlaybackRate},
{185, "waveOutGetPosition", waveOutGetPosition},
{186, "waveOutGetVolume", waveOutGetVolume},
{187, "waveOutMessage", waveOutMessage},
{188, "waveOutOpen", waveOutOpen},
{189, "waveOutPause", waveOutPause},
{190, "waveOutPrepareHeader", waveOutPrepareHeader},
{191, "waveOutReset", waveOutReset},
{192, "waveOutRestart", waveOutRestart},
{193, "waveOutSetPitch", waveOutSetPitch},
{194, "waveOutSetPlaybackRate", waveOutSetPlaybackRate},
{195, "waveOutSetVolume", waveOutSetVolume},
{196, "waveOutUnprepareHeader", waveOutUnprepareHeader},
{197, "waveOutWrite", waveOutWrite},
{198, "wid32Message", wid32Message},
{199, "winmmDbgOut", winmmDbgOut},
{200, "winmmSetDebugLevel", winmmSetDebugLevel},
{201, "wod32Message", wod32Message},
{0, NULL, NULL}};
