/*
    w32loader
    copyright (c) 1998-2006 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef __WINDEF_H__
#define __WINDEF_H__


#include "common.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define __stdcall __attribute__((__stdcall__))
#define __cdecl __attribute__((__cdecl__))
#define CALLBACK __stdcall
#define PASCAL __stdcall
#define WINAPI __stdcall
#define CDECL __cdecl
#define WINAPIV __cdecl


/* en:Macros to split words and longs. */
#define LOBYTE(w)               ((BYTE)(WORD)(w))
#define HIBYTE(w)               ((BYTE)((WORD)(w) >> 8))
#define LOWORD(l)               ((WORD)(DWORD)(l))
#define HIWORD(l)               ((WORD)((DWORD)(l) >> 16))
#define SLOWORD(l)              ((SHORT)(LONG)(l))
#define SHIWORD(l)              ((SHORT)((LONG)(l) >> 16))
#define MAKEWORD(low,high)      ((WORD)(((BYTE)(low))                       \
                                                | ((WORD)((BYTE)(high))) << 8))
#define MAKELONG(low,high)      ((LONG)(((WORD)(low))                       \
                                            | (((DWORD)((WORD)(high))) << 16)))
#define MAKELPARAM(low,high)    ((LPARAM)MAKELONG(low,high))
#define MAKEWPARAM(low,high)    ((WPARAM)MAKELONG(low,high))
#define MAKELRESULT(low,high)   ((LRESULT)MAKELONG(low,high))


/* ja:基本 */
#define CONST const
typedef gint32      BOOL,   *PBOOL,   *LPBOOL;
typedef void        VOID,   *PVOID,   *LPVOID;
typedef const void  CVOID,  *PCVOID,  *LPCVOID;
typedef gchar       CHAR,   *PCHAR,   *LPCHAR,   *CHAR_PTR;
typedef guchar      UCHAR,  *PUCHAR,  *LPUCHAR,  *UCHAR_PTR;
typedef gunichar2   WCHAR,  *PWCHAR,  *LPWCHAR,  *WCHAR_PTR;
typedef gunichar2   WUCHAR, *PWUCHAR, *LPWUCHAR, *WUCHAR_PTR;
typedef gint16      SHORT,  *PSHORT,  *LPSHORT,  *SHORT_PTR;
typedef guint16     USHORT, *PUSHORT, *LPUSHORT, *USHORT_PTR;
typedef gint32      INT,    *PINT,    *LPINT,    *INT_PTR;
typedef guint32     UINT,   *PUINT,   *LPUINT,   *UINT_PTR;
typedef gint32      LONG,   *PLONG,   *LPLONG,   *LONG_PTR;
typedef guint32     ULONG,  *PULONG,  *LPULONG,  *ULONG_PTR;
typedef guint32     SIZE_T;
/* en:WORD */
typedef guint8      BYTE,   *PBYTE,   *LPBYTE;
typedef guint16     WORD,   *PWORD,   *LPWORD;
typedef guint32     DWORD,  *PDWORD,  *LPDWORD;
/* ja:文字列 */
typedef CHAR                *PSTR,    *LPSTR;
typedef CONST CHAR          *PCSTR,   *LPCSTR;
typedef WCHAR               *PWSTR,   *LPWSTR;
typedef CONST WCHAR         *PCWSTR,  *LPCWSTR;
/* ja:コールバック */
typedef LONG LRESULT;
typedef LONG LPARAM;
typedef LONG WPARAM;
/* ja:ハンドル */
typedef struct _W32LdrHandle *HANDLE;
typedef struct _W32LdrModule *HINSTANCE, *HMODULE;
typedef GtkWidget *HWND;
typedef LPVOID HDC;
/* ja:構造体 */
#include "pshpack1.h"
typedef struct _SECURITY_ATTRIBUTES
{
  DWORD nLength;
  LPVOID lpSecurityDescriptor;
  BOOL bInheritHandle;
} SECURITY_ATTRIBUTES, *PSECURITY_ATTRIBUTES, *LPSECURITY_ATTRIBUTES;
#include "poppack.h"


/* ja:リソース */
#define RT_CURSOR       1
#define RT_BITMAP       2
#define RT_ICON         3
#define RT_MENU         4
#define RT_DIALOG       5
#define RT_STRING       6
#define RT_FONTDIR      7
#define RT_FONT         8
#define RT_ACCELERATOR  9
#define RT_RCDATA       10
#define RT_MESSAGETABLE 11
#define RT_GROUP_CURSOR 12
#define RT_GROUP_ICON   14
#define RT_VERSION      16
#define RT_DLGINCLUDE   17
#define RT_PLUGPLAY     19
#define RT_VXD          20
#define RT_ANICURSOR    21
#define RT_ANIICON      22
#define RT_HTML         23
typedef LPVOID HRSRC;
#define IS_INTRESOURCE(x)   ((GPOINTER_TO_UINT(x)>>16)==0)
#define MAKEINTRESOURCEA(i) (LPSTR)(GUINT_TO_POINTER((DWORD)(WORD)(i)))
#define MAKEINTRESOURCEW(i) (LPWSTR)(GUINT_TO_POINTER((DWORD)(WORD)(i)))
#ifdef UNICODE
# define MAKEINTRESOURCE MAKEINTRESOURCEW
#else /* not UNICODE */
# define MAKEINTRESOURCE MAKEINTRESOURCEA
#endif /* not UNICODE */


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __WINDEF_H__ */
