/*
    w32loader
    copyright (c) 1998-2005 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef __KERNEL32_H__
#define __KERNEL32_H__


#include "w32ldr.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/* ja:一般 */
#define MAX_PATH 260
#define INVALID_HANDLE_VALUE (GINT_TO_POINTER(-1))
#define WAIT_FAILED 0xffffffff
#define DONT_RESOLVE_DLL_REFERENCES   0x00000001
#define LOAD_LIBRARY_AS_DATAFILE      0x00000002
#define LOAD_WITH_ALTERED_SEARCH_PATH 0x00000008
typedef LPVOID LPCRITICAL_SECTION;
typedef LRESULT CALLBACK (*FARPROC)(VOID);
/* ja:メモリ */
#define LMEM_INVALID_HANDLE 0x8000
#define GMEM_INVALID_HANDLE 0x8000
typedef HANDLE HGLOBAL, HLOCAL;
#include "pshpack1.h"
typedef struct _MEMORY_BASIC_INFORMATION
{
  LPVOID BaseAddress;
  LPVOID AllocationBase;
  DWORD AllocationProtect;
  SIZE_T RegionSize;
  DWORD State;
  DWORD Protect;
  DWORD Type;
} MEMORY_BASIC_INFORMATION, *PMEMORY_BASIC_INFORMATION, *LPMEMORY_BASIC_INFORMATION;
typedef struct tagMEMORYSTATUS
{
  DWORD dwLength;
  DWORD dwMemoryLoad;
  SIZE_T dwTotalPhys;
  SIZE_T dwAvailPhys;
  SIZE_T dwTotalPageFile;
  SIZE_T dwAvailPageFile;
  SIZE_T dwTotalVirtual;
  SIZE_T dwAvailVirtual;
} MEMORYSTATUS, *PMEMORYSTATUS, *LPMEMORYSTATUS;
#include "poppack.h"
/* ja:ファイル */
#define STD_INPUT_HANDLE         (-10)
#define STD_OUTPUT_HANDLE        (-11)
#define STD_ERROR_HANDLE         (-12)
#define INVALID_SET_FILE_POINTER (-1)
#define FILE_TYPE_UNKNOWN        0x0000
#define FILE_TYPE_DISK           0x0001
#define FILE_TYPE_CHAR           0x0002
#define FILE_TYPE_PIPE           0x0003
#define FILE_TYPE_REMOTE         0x8000
#define FILE_BEGIN               0
#define FILE_CURRENT             1
#define FILE_END                 2
#include "pshpack1.h"
typedef struct _OVERLAPPED
{
  ULONG_PTR Internal;
  ULONG_PTR InternalHigh;
  DWORD Offset;
  DWORD OffsetHigh;
  HANDLE hEvent;
} OVERLAPPED, *POVERLAPPED, *LPOVERLAPPED;
#include "poppack.h"
/* ja:ファイル(Win16互換) */
#include "misc/fileio.h"
#define HFILE_ERROR (GINT_TO_POINTER(-1))
typedef FileIO *HFILE;
/* ja:言語/ロケール/コードページ */
#define MAX_DEFAULTCHAR 2
#define MAX_LEADBYTES   12
#define CP_ACP        0
#define CP_OEMCP      1
#define CP_MACCP      2
#define CP_THREAD_ACP 3
#define CP_SYMBOL     42
#define CP_UTF7       65000
#define CP_UTF8       65001
#define LCMAP_LOWERCASE 0x00000100
#define LCMAP_UPPERCASE 0x00000200
#define LCMAP_SORTKEY   0x00000400
#define LCMAP_BYTEREV   0x00000800
#define MAKELCID(l,s)        (MAKELONG(l,s))
#define MAKELANGID(p,s)      ((((WORD)(s))<<10)|(WORD)(p))
#define PRIMARYLANGID(l)     ((WORD)(l)&0x3ff)
#define SUBLANGID(l)         ((WORD)(l)>>10)
#define LANGIDFROMLCID(lcid) ((WORD)(lcid))
#define SORTIDFROMLCID(lcid) ((WORD)((((DWORD)(lcid))>>16)&0x0f))
#define LANG_MAIN_NEUTRAL                0x00
#define LANG_MAIN_AFRIKAANS              0x36
#define LANG_MAIN_ALBANIAN               0x1c
#define LANG_MAIN_ARABIC                 0x01
#define LANG_MAIN_ARMENIAN               0x2b
#define LANG_MAIN_ASSAMESE               0x4d
#define LANG_MAIN_AZERI                  0x2c
#define LANG_MAIN_BASQUE                 0x2d
#define LANG_MAIN_BENGALI                0x45
#define LANG_MAIN_BULGARIAN              0x02
#define LANG_MAIN_BYELORUSSIAN           0x23
#define LANG_MAIN_CATALAN                0x03
#define LANG_MAIN_CHINESE                0x04
#define LANG_MAIN_SERBO_CROATIAN         0x1a
#define LANG_MAIN_CROATIAN               LANG_MAIN_SERBO_CROATIAN
#define LANG_MAIN_SERBIAN                LANG_MAIN_SERBO_CROATIAN
#define LANG_MAIN_CZECH                  0x05
#define LANG_MAIN_DANISH                 0x06
#define LANG_MAIN_DUTCH                  0x13
#define LANG_MAIN_ENGLISH                0x09
#define LANG_MAIN_ESTONIAN               0x25
#define LANG_MAIN_FAEROESE               0x38
#define LANG_MAIN_FARSI                  0x29
#define LANG_MAIN_FINNISH                0x0b
#define LANG_MAIN_FRENCH                 0x0c
#define LANG_MAIN_GAELIC                 0x3c
#define LANG_MAIN_GEORGIAN               0x37
#define LANG_MAIN_GERMAN                 0x07
#define LANG_MAIN_GREEK                  0x08
#define LANG_MAIN_GUJARATI               0x47
#define LANG_MAIN_HEBREW                 0x0D
#define LANG_MAIN_HINDI                  0x39
#define LANG_MAIN_HUNGARIAN              0x0e
#define LANG_MAIN_ICELANDIC              0x0f
#define LANG_MAIN_INDONESIAN             0x21
#define LANG_MAIN_ITALIAN                0x10
#define LANG_MAIN_JAPANESE               0x11
#define LANG_MAIN_KANNADA                0x4b
#define LANG_MAIN_KAZAKH                 0x3f
#define LANG_MAIN_KONKANI                0x57
#define LANG_MAIN_KOREAN                 0x12
#define LANG_MAIN_LATVIAN                0x26
#define LANG_MAIN_LITHUANIAN             0x27
#define LANG_MAIN_MACEDONIAN             0x2f
#define LANG_MAIN_MALAY                  0x3e
#define LANG_MAIN_MALAYALAM              0x4c
#define LANG_MAIN_MALTESE                0x3a
#define LANG_MAIN_MAORI                  0x28
#define LANG_MAIN_MARATHI                0x4e
#define LANG_MAIN_NORWEGIAN              0x14
#define LANG_MAIN_ORIYA                  0x48
#define LANG_MAIN_POLISH                 0x15
#define LANG_MAIN_PORTUGUESE             0x16
#define LANG_MAIN_PUNJABI                0x46
#define LANG_MAIN_RHAETO_ROMANCE         0x17
#define LANG_MAIN_ROMANIAN               0x18
#define LANG_MAIN_RUSSIAN                0x19
#define LANG_MAIN_SAAMI                  0x3b
#define LANG_MAIN_SANSKRIT               0x4f
#define LANG_MAIN_SLOVAK                 0x1b
#define LANG_MAIN_SLOVENIAN              0x24
#define LANG_MAIN_SORBIAN                0x2e
#define LANG_MAIN_SPANISH                0x0a
#define LANG_MAIN_SUTU                   0x30
#define LANG_MAIN_SWAHILI                0x41
#define LANG_MAIN_SWEDISH                0x1d
#define LANG_MAIN_TAMIL                  0x49
#define LANG_MAIN_TATAR                  0x44
#define LANG_MAIN_TELUGU                 0x4a
#define LANG_MAIN_THAI                   0x1e
#define LANG_MAIN_TSONGA                 0x31
#define LANG_MAIN_TSWANA                 0x32
#define LANG_MAIN_TURKISH                0x1f
#define LANG_MAIN_UKRAINIAN              0x22
#define LANG_MAIN_URDU                   0x20
#define LANG_MAIN_UZBEK                  0x43
#define LANG_MAIN_VENDA                  0x33
#define LANG_MAIN_VIETNAMESE             0x2a
#define LANG_MAIN_XHOSA                  0x34
#define LANG_MAIN_ZULU                   0x35
#define LANG_MAIN_ESPERANTO              0x8f
#define LANG_MAIN_WALON                  0x90
#define LANG_MAIN_CORNISH                0x91
#define LANG_MAIN_WELSH                  0x92
#define LANG_MAIN_BRETON                 0x93
#define LANG_SUB_NEUTRAL                 0x00
#define LANG_SUB_DEFAULT                 0x01
#define LANG_SUB_SYS_DEFAULT             0x02
#define LANG_SUB_ARABIC                  0x01
#define LANG_SUB_ARABIC_SAUDI_ARABIA     0x01
#define LANG_SUB_ARABIC_IRAQ             0x02
#define LANG_SUB_ARABIC_EGYPT            0x03
#define LANG_SUB_ARABIC_LIBYA            0x04
#define LANG_SUB_ARABIC_ALGERIA          0x05
#define LANG_SUB_ARABIC_MOROCCO          0x06
#define LANG_SUB_ARABIC_TUNISIA          0x07
#define LANG_SUB_ARABIC_OMAN             0x08
#define LANG_SUB_ARABIC_YEMEN            0x09
#define LANG_SUB_ARABIC_SYRIA            0x0a
#define LANG_SUB_ARABIC_JORDAN           0x0b
#define LANG_SUB_ARABIC_LEBANON          0x0c
#define LANG_SUB_ARABIC_KUWAIT           0x0d
#define LANG_SUB_ARABIC_UAE              0x0e
#define LANG_SUB_ARABIC_BAHRAIN          0x0f
#define LANG_SUB_ARABIC_QATAR            0x10
#define LANG_SUB_CHINESE_TRADITIONAL     0x01
#define LANG_SUB_CHINESE_SIMPLIFIED      0x02
#define LANG_SUB_CHINESE_HONGKONG        0x03
#define LANG_SUB_CHINESE_SINGAPORE       0x04
#define LANG_SUB_CHINESE_MACAU           0x05
#define LANG_SUB_DUTCH                   0x01
#define LANG_SUB_DUTCH_BELGIAN           0x02
#define LANG_SUB_DUTCH_SURINAM           0x03
#define LANG_SUB_ENGLISH_US              0x01
#define LANG_SUB_ENGLISH_UK              0x02
#define LANG_SUB_ENGLISH_AUS             0x03
#define LANG_SUB_ENGLISH_CAN             0x04
#define LANG_SUB_ENGLISH_NZ              0x05
#define LANG_SUB_ENGLISH_EIRE            0x06
#define LANG_SUB_ENGLISH_SAFRICA         0x07
#define LANG_SUB_ENGLISH_JAMAICA         0x08
#define LANG_SUB_ENGLISH_CARRIBEAN       0x09
#define LANG_SUB_ENGLISH_BELIZE          0x0a
#define LANG_SUB_ENGLISH_TRINIDAD        0x0b
#define LANG_SUB_ENGLISH_ZIMBABWE        0x0c
#define LANG_SUB_ENGLISH_PHILIPPINES     0x0d
#define LANG_SUB_FRENCH                  0x01
#define LANG_SUB_FRENCH_BELGIAN          0x02
#define LANG_SUB_FRENCH_CANADIAN         0x03
#define LANG_SUB_FRENCH_SWISS            0x04
#define LANG_SUB_FRENCH_LUXEMBOURG       0x05
#define LANG_SUB_FRENCH_MONACO           0x06
#define LANG_SUB_GERMAN                  0x01
#define LANG_SUB_GERMAN_SWISS            0x02
#define LANG_SUB_GERMAN_AUSTRIAN         0x03
#define LANG_SUB_GERMAN_LUXEMBOURG       0x04
#define LANG_SUB_GERMAN_LIECHTENSTEIN    0x05
#define LANG_SUB_ITALIAN                 0x01
#define LANG_SUB_ITALIAN_SWISS           0x02
#define LANG_SUB_KOREAN                  0x01
#define LANG_SUB_KOREAN_JOHAB            0x02
#define LANG_SUB_NORWEGIAN_BOKMAL        0x01
#define LANG_SUB_NORWEGIAN_NYNORSK       0x02
#define LANG_SUB_PORTUGUESE              0x02
#define LANG_SUB_PORTUGUESE_BRAZILIAN    0x01
#define LANG_SUB_SPANISH                 0x01
#define LANG_SUB_SPANISH_MEXICAN         0x02
#define LANG_SUB_SPANISH_MODERN          0x03
#define LANG_SUB_SPANISH_GUATEMALA       0x04
#define LANG_SUB_SPANISH_COSTARICA       0x05
#define LANG_SUB_SPANISH_PANAMA          0x06
#define LANG_SUB_SPANISH_DOMINICAN       0x07
#define LANG_SUB_SPANISH_VENEZUELA       0x08
#define LANG_SUB_SPANISH_COLOMBIA        0x09
#define LANG_SUB_SPANISH_PERU            0x0a
#define LANG_SUB_SPANISH_ARGENTINA       0x0b
#define LANG_SUB_SPANISH_ECUADOR         0x0c
#define LANG_SUB_SPANISH_CHILE           0x0d
#define LANG_SUB_SPANISH_URUGUAY         0x0e
#define LANG_SUB_SPANISH_PARAGUAY        0x0f
#define LANG_SUB_SPANISH_BOLIVIA         0x10
#define LANG_SUB_SPANISH_EL_SALVADOR     0x11
#define LANG_SUB_SPANISH_HONDURAS        0x12
#define LANG_SUB_SPANISH_NICARAGUA       0x13
#define LANG_SUB_SPANISH_PUERTO_RICO     0x14
#define LANG_SUB_ROMANIAN                0x01
#define LANG_SUB_ROMANIAN_MOLDAVIA       0x02
#define LANG_SUB_RUSSIAN                 0x01
#define LANG_SUB_RUSSIAN_MOLDAVIA        0x02
#define LANG_SUB_CROATIAN                0x01
#define LANG_SUB_SERBIAN                 0x02
#define LANG_SUB_SERBIAN_LATIN           0x03
#define LANG_SUB_SWEDISH                 0x01
#define LANG_SUB_SWEDISH_FINLAND         0x02
#define LANG_SUB_LITHUANIAN              0x01
#define LANG_SUB_LITHUANIAN_CLASSIC      0x02
#define LANG_SUB_AZERI                   0x01
#define LANG_SUB_AZERI_CYRILLIC          0x02
#define LANG_SUB_GAELIC                  0x01
#define LANG_SUB_GAELIC_SCOTTISH         0x02
#define LANG_SUB_GAELIC_MANX             0x03
#define LANG_SUB_MALAY                   0x01
#define LANG_SUB_MALAY_BRUNEI_DARUSSALAM 0x02
#define LANG_SUB_UZBEK                   0x01
#define LANG_SUB_UZBEK_CYRILLIC          0x02
#define LANG_SUB_URDU_PAKISTAN           0x01
typedef WORD LANGID;
typedef DWORD CALID;
typedef DWORD CALTYPE;
typedef DWORD LCID;
typedef DWORD LCTYPE;
typedef BOOL CALLBACK (*CALINFO_ENUMPROCA)(LPSTR);
typedef BOOL CALLBACK (*CALINFO_ENUMPROCW)(LPWSTR);
typedef DWORD CALLBACK (*LPTHREAD_START_ROUTINE)(LPVOID);
#ifdef UNICODE
# define CALINFO_ENUMPROC CALINFO_ENUMPROCW
#else /* not UNICODE */
# define CALINFO_ENUMPROC CALINFO_ENUMPROCA
#endif /* not UNICODE */
#include "pshpack1.h"
typedef struct
{
  UINT MaxCharSize;
  BYTE DefaultChar[MAX_DEFAULTCHAR];
  BYTE LeadByte[MAX_LEADBYTES];
} CPINFO, *LPCPINFO;
typedef struct
{
  UINT MaxCharSize;
  BYTE DefaultChar[MAX_DEFAULTCHAR];
  BYTE LeadByte[MAX_LEADBYTES];
  WCHAR UnicodeDefaultChar;
  UINT CodePage;
  CHAR CodePageName[MAX_PATH];
} CPINFOEXA, *LPCPINFOEXA;
typedef struct
{
  UINT MaxCharSize;
  BYTE DefaultChar[MAX_DEFAULTCHAR];
  BYTE LeadByte[MAX_LEADBYTES];
  WCHAR UnicodeDefaultChar;
  UINT CodePage;
  WCHAR CodePageName[MAX_PATH];
} CPINFOEXW, *LPCPINFOEXW;
#ifdef UNICODE
# define CPINFOEX CPINFOEXW
# define LPCPINFOEX LPCPINFOEXW
#else /* not UNICODE */
# define CPINFOEX CPINFOEXA
# define LPCPINFOEX LPCPINFOEXA
#endif /* not UNICODE */
#include "poppack.h"
/* ja:環境 */
#define VER_PLATFORM_WIN32s        0
#define VER_PLATFORM_WIN32_WINDOWS 1
#define VER_PLATFORM_WIN32_NT      2
#ifdef G_HAVE_GINT64
typedef gint64 LARGE_INTEGER, *PLARGE_INTEGER, *LPLARGE_INTEGER;
#else /* not G_HAVE_GINT64 */
typedef gint32 LARGE_INTEGER, *PLARGE_INTEGER, *LPLARGE_INTEGER;
#endif /* not G_HAVE_GINT64 */
#include "pshpack1.h"
typedef struct
{
  DWORD dwOSVersionInfoSize;
  DWORD dwMajorVersion;
  DWORD dwMinorVersion;
  DWORD dwBuildNumber;
  DWORD dwPlatformId;
  CHAR szCSDVersion[128];
} OSVERSIONINFOA, *POSVERSIONINFOA, *LPOSVERSIONINFOA;
typedef struct
{
  DWORD dwOSVersionInfoSize;
  DWORD dwMajorVersion;
  DWORD dwMinorVersion;
  DWORD dwBuildNumber;
  DWORD dwPlatformId;
  WCHAR szCSDVersion[128];
} OSVERSIONINFOW, *POSVERSIONINFOW, *LPOSVERSIONINFOW;
#ifdef UNICODE
# define OSVERSIONINFO OSVERSIONINFOW
# define POSVERSIONINFO POSVERSIONINFOW
# define LPOSVERSIONINFO LPOSVERSIONINFOW
#else /* not UNICODE */
# define OSVERSIONINFO OSVERSIONINFOA
# define POSVERSIONINFO POSVERSIONINFOA
# define LPOSVERSIONINFO LPOSVERSIONINFOA
#endif /* not UNICODE */
typedef struct _STARTUPINFOA
{
  DWORD cb;
  LPSTR lpReserved;
  LPSTR lpDesktop;
  LPSTR lpTitle;
  DWORD dwX;
  DWORD dwY;
  DWORD dwXSize;
  DWORD dwYSize;
  DWORD dwXCountChars;
  DWORD dwYCountChars;
  DWORD dwFillAttribute;
  DWORD dwFlags;
  WORD wShowWindow;
  WORD cbReserved2;
  BYTE *lpReserved2;
  HANDLE hStdInput;
  HANDLE hStdOutput;
  HANDLE hStdError;
} STARTUPINFOA, *LPSTARTUPINFOA;
typedef struct _STARTUPINFOW
{
  DWORD cb;
  LPWSTR lpReserved;
  LPWSTR lpDesktop;
  LPWSTR lpTitle;
  DWORD dwX;
  DWORD dwY;
  DWORD dwXSize;
  DWORD dwYSize;
  DWORD dwXCountChars;
  DWORD dwYCountChars;
  DWORD dwFillAttribute;
  DWORD dwFlags;
  WORD wShowWindow;
  WORD cbReserved2;
  BYTE *lpReserved2;
  HANDLE hStdInput;
  HANDLE hStdOutput;
  HANDLE hStdError;
} STARTUPINFOW, *LPSTARTUPINFOW;
#ifdef UNICODE
# define STARTUPINFO STARTUPINFOW
# define LPSTARTUPINFO LPSTARTUPINFOW
#else /* not UNICODE */
# define STARTUPINFO STARTUPINFOA
# define LPSTARTUPINFO LPSTARTUPINFOA
#endif /* not UNICODE */
typedef struct _SYSTEM_INFO
{
  union {
  DWORD dwOemId;
    struct {
      WORD wProcessorArchitecture;
      WORD wReserved;
    } DUMMYSTRUCTNAME;
  } DUMMYUNIONNAME;
  DWORD dwPageSize;
  LPVOID lpMinimumApplicationAddress;
  LPVOID lpMaximumApplicationAddress;
  DWORD dwActiveProcessorMask;
  DWORD dwNumberOfProcessors;
  DWORD dwProcessorType;
  DWORD dwAllocationGranularity;
  WORD wProcessorLevel;
  WORD wProcessorRevision;
} SYSTEM_INFO, *LPSYSTEM_INFO;
typedef struct _SYSTEMTIME
{
  WORD wYear;
  WORD wMonth;
  WORD wDayOfWeek;
  WORD wDay;
  WORD wHour;
  WORD wMinute;
  WORD wSecond;
  WORD wMilliseconds;
} SYSTEMTIME, *PSYSTEMTIME, *LPSYSTEMTIME;
#include "poppack.h"
/* ja:コンソール */
#include "pshpack1.h"
typedef struct tagCOORD
{
  SHORT X;
  SHORT Y;
} COORD, *PCOORD, *LPCOORD;
#include "poppack.h"


extern W32LdrExport kernel32_exports[];


BOOL WINAPI AllocConsole (VOID);
BOOL WINAPI CloseHandle (HANDLE hObject);
BOOL WINAPI CopyFileA (LPCSTR lpExistingFileName, LPCWSTR lpNewFileName, BOOL bFailIfExists);
BOOL WINAPI CopyFileW (LPCWSTR lpExistingFileName, LPCWSTR lpNewFileName, BOOL bFailIfExists);
BOOL WINAPI CreateDirectoryA (LPCSTR lpPathName, LPSECURITY_ATTRIBUTES lpSecurityAttributes);
BOOL WINAPI CreateDirectoryW (LPCWSTR lpPathName, LPSECURITY_ATTRIBUTES lpSecurityAttributes);
HANDLE WINAPI CreateEventA (LPSECURITY_ATTRIBUTES lpEventAttributes, BOOL bManualReset, BOOL bInitialState, LPCSTR lpName);
HANDLE WINAPI CreateEventW (LPSECURITY_ATTRIBUTES lpEventAttributes, BOOL bManualReset, BOOL bInitialState, LPCWSTR lpName);
HANDLE WINAPI CreateFileA (LPCSTR lpFileName, DWORD dwDesiredAccess, DWORD dwShareMode, LPSECURITY_ATTRIBUTES lpSecurityAttributes, DWORD dwCreationDisposition, DWORD dwFlagsAndAttributes, HANDLE hTemplateFile);
HANDLE WINAPI CreateFileMappingA (HANDLE hFile, LPSECURITY_ATTRIBUTES lpAttributes, DWORD flProtect, DWORD dwMaximumSizeHigh, DWORD dwMaximumSizeLow, LPCSTR lpName);
HANDLE WINAPI CreateFileMappingW (HANDLE hFile, LPSECURITY_ATTRIBUTES lpAttributes, DWORD flProtect, DWORD dwMaximumSizeHigh, DWORD dwMaximumSizeLow, LPCWSTR lpName);
HANDLE WINAPI CreateFileW (LPCWSTR lpFileName, DWORD dwDesiredAccess, DWORD dwShareMode, LPSECURITY_ATTRIBUTES lpSecurityAttributes, DWORD dwCreationDisposition, DWORD dwFlagsAndAttributes, HANDLE hTemplateFile);
HANDLE WINAPI CreateSemaphoreA (LPSECURITY_ATTRIBUTES lpSemaphoreAttributes, LONG lInitialCount, LONG lMaximumCount, LPCSTR lpName);
HANDLE WINAPI CreateSemaphoreW (LPSECURITY_ATTRIBUTES lpSemaphoreAttributes, LONG lInitialCount, LONG lMaximumCount, LPCWSTR lpName);
HANDLE WINAPI CreateThread (LPSECURITY_ATTRIBUTES lpThreadAttributes, DWORD dwStackSize, LPTHREAD_START_ROUTINE lpStartAddress, LPVOID lpParameter, DWORD dwCreationFlags, LPDWORD lpThreadId);
VOID WINAPI DeleteCriticalSection (LPCRITICAL_SECTION lpCriticalSection);
BOOL WINAPI DeleteFileA (LPCSTR lpFileName);
BOOL WINAPI DeleteFileW (LPCWSTR lpFileName);
BOOL WINAPI DisableThreadLibraryCalls (HMODULE hLibModule);
VOID WINAPI EnterCriticalSection (LPCRITICAL_SECTION lpCriticalSection);
BOOL WINAPI EnumCalendarInfoA (CALINFO_ENUMPROCA lpCalInfoEnumProc, LCID Locale, CALID Calendar, CALTYPE CalType);
BOOL WINAPI EnumCalendarInfoW (CALINFO_ENUMPROCW lpCalInfoEnumProc, LCID Locale, CALID Calendar, CALTYPE CalType);
VOID WINAPI ExitProcess (UINT uExitCode);
HRSRC WINAPI FindResourceA (HMODULE hModule, LPCSTR lpName, LPCSTR lpType);
HRSRC WINAPI FindResourceExA (HMODULE hModule, LPCSTR lpType, LPCSTR lpName, WORD wLanguage);
HRSRC WINAPI FindResourceExW (HMODULE hModule, LPCWSTR lpType, LPCWSTR lpName, WORD wLanguage);
HRSRC WINAPI FindResourceW (HMODULE hModule, LPCWSTR lpName, LPCWSTR lpType);
BOOL WINAPI FlushFileBuffers (HANDLE hFile);
BOOL WINAPI FreeEnvironmentStringsA (LPSTR lpszEnvironmentBlock);
BOOL WINAPI FreeEnvironmentStringsW (LPWSTR lpszEnvironmentBlock);
BOOL WINAPI FreeLibrary (HMODULE hModule);
BOOL WINAPI FreeResource (HGLOBAL hResData);
UINT WINAPI GetACP (VOID);
BOOL WINAPI GetCPInfo (UINT CodePage, LPCPINFO lpCPInfo);
BOOL WINAPI GetCPInfoExA (UINT CodePage, DWORD dwFlags, LPCPINFOEXA lpCPInfoEx);
BOOL WINAPI GetCPInfoExW (UINT CodePage, DWORD dwFlags, LPCPINFOEXW lpCPInfoEx);
LPSTR WINAPI GetCommandLineA (VOID);
LPWSTR WINAPI GetCommandLineW (VOID);
HANDLE WINAPI GetCurrentProcess (VOID);
HANDLE WINAPI GetCurrentThread (VOID);
DWORD WINAPI GetCurrentThreadId (VOID);
LPVOID WINAPI GetEnvironmentStringsA (VOID);
LPVOID WINAPI GetEnvironmentStringsW (VOID);
DWORD WINAPI GetEnvironmentVariableA (LPCSTR lpName, LPSTR lpBuffer, DWORD nSize);
DWORD WINAPI GetEnvironmentVariableW (LPCWSTR lpName, LPWSTR lpBuffer, DWORD nSize);
DWORD WINAPI GetFileSize (HANDLE hFile, LPDWORD lpFileSizeHigh);
DWORD WINAPI GetFileType (HANDLE hFile);
DWORD WINAPI GetLastError (VOID);
VOID WINAPI GetLocalTime (LPSYSTEMTIME lpSystemTime);
INT WINAPI GetLocaleInfoA (LCID Locale, LCTYPE LCType, LPSTR lpLCData, INT cchData);
INT WINAPI GetLocaleInfoW (LCID Locale, LCTYPE LCType, LPWSTR lpLCData, INT cchData);
DWORD WINAPI GetModuleFileNameA (HMODULE hModule, LPSTR lpFilename, DWORD nSize);
DWORD WINAPI GetModuleFileNameW (HMODULE hModule, LPWSTR lpFilename, DWORD nSize);
HMODULE WINAPI GetModuleHandleA (LPCSTR lpModuleName);
HMODULE WINAPI GetModuleHandleW (LPCWSTR lpModuleName);
UINT WINAPI GetOEMCP (VOID);
UINT WINAPI GetPrivateProfileIntA (LPCSTR lpAppName, LPCSTR lpKeyName, INT nDefault, LPCSTR lpFileName);
UINT WINAPI GetPrivateProfileIntW (LPCWSTR lpAppName, LPCWSTR lpKeyName, INT nDefault, LPCWSTR lpFileName);
DWORD WINAPI GetPrivateProfileSectionA (LPCSTR lpAppName, LPSTR lpReturnedString, DWORD nSize, LPCSTR lpFileName);
DWORD WINAPI GetPrivateProfileSectionNamesA (LPSTR lpszReturnBuffer, DWORD nSize, LPCSTR lpFileName);
DWORD WINAPI GetPrivateProfileSectionW (LPCWSTR lpAppName, LPWSTR lpReturnedString, DWORD nSize, LPCWSTR lpFileName);
DWORD WINAPI GetPrivateProfileStringA (LPCSTR lpAppName, LPCSTR lpKeyName, LPCSTR lpDefault, LPSTR lpReturnedString, DWORD nSize, LPCSTR lpFileName);
DWORD WINAPI GetPrivateProfileStringW (LPCWSTR lpAppName, LPCWSTR lpKeyName, LPCWSTR lpDefault, LPWSTR lpReturnedString, DWORD nSize, LPCWSTR lpFileName);
BOOL WINAPI GetPrivateProfileStructA (LPCSTR lpszSection, LPCSTR lpszKey, LPVOID lpStruct, UINT uSizeStruct, LPCSTR szFile);
BOOL WINAPI GetPrivateProfileStructW (LPCWSTR lpszSection, LPCWSTR lpszKey, LPVOID lpStruct, UINT uSizeStruct, LPCWSTR szFile);
FARPROC WINAPI GetProcAddress (HMODULE hModule, LPCSTR lpProcName);
HANDLE WINAPI GetProcessHeap (VOID);
DWORD WINAPI GetProcessHeaps (DWORD NumberOfHeaps, HANDLE *ProcessHeaps);
UINT WINAPI GetProfileIntA (LPCSTR lpAppName, LPCSTR lpKeyName, INT nDefault);
UINT WINAPI GetProfileIntW (LPCWSTR lpAppName, LPCWSTR lpKeyName, INT nDefault);
DWORD WINAPI GetProfileSectionA (LPCSTR lpAppName, LPSTR lpReturnedString, DWORD nSize);
DWORD WINAPI GetProfileSectionW (LPCWSTR lpAppName, LPWSTR lpReturnedString, DWORD nSize);
DWORD WINAPI GetProfileStringA (LPCSTR lpAppName, LPCSTR lpKeyName, LPCSTR lpDefault, LPSTR lpReturnedString, DWORD nSize);
DWORD WINAPI GetProfileStringW (LPCWSTR lpAppName, LPCWSTR lpKeyName, LPCWSTR lpDefault, LPWSTR lpReturnedString, DWORD nSize);
DWORD WINAPI GetShortPathNameA (LPCSTR lpszLongPath, LPSTR lpszShortPath, DWORD cchBuffer);
DWORD WINAPI GetShortPathNameW (LPCWSTR lpszLongPath, LPWSTR lpszShortPath, DWORD cchBuffer);
HANDLE WINAPI GetStdHandle (DWORD nStdHandle);
BOOL WINAPI GetStringTypeA (LCID Locale, DWORD dwInfoType, LPCSTR lpSrcStr, INT cchSrc, LPWORD lpCharType);
BOOL WINAPI GetStringTypeW (DWORD dwInfoType, LPCWSTR lpSrcStr, INT cchSrc, LPWORD lpCharType);
DWORD WINAPI GetSystemDefaultLCID (VOID);
LANGID WINAPI GetSystemDefaultLangID (VOID);
LANGID WINAPI GetSystemDefaultUILanguage (VOID);
UINT WINAPI GetSystemDirectoryA (LPSTR lpBuffer, UINT uSize);
UINT WINAPI GetSystemDirectoryW (LPWSTR lpBuffer, UINT uSize);
LCID WINAPI GetThreadLocale (VOID);
DWORD WINAPI GetUserDefaultLCID (VOID);
LANGID WINAPI GetUserDefaultLangID (VOID);
LANGID WINAPI GetUserDefaultUILanguage (VOID);
DWORD WINAPI GetVersion (VOID);
BOOL WINAPI GetVersionExA (LPOSVERSIONINFOA lpVersionInfo);
BOOL WINAPI GetVersionExW (LPOSVERSIONINFOW lpVersionInfo);
HGLOBAL WINAPI GlobalAlloc (UINT uFlags, UINT uBytes);
UINT WINAPI GlobalFlags (HGLOBAL hMem);
HGLOBAL WINAPI GlobalFree (HGLOBAL hMem);
HGLOBAL WINAPI GlobalHandle (LPCVOID pMem);
LPVOID WINAPI GlobalLock (HGLOBAL hMem);
HGLOBAL WINAPI GlobalReAlloc (HGLOBAL hMem, UINT uBytes, UINT uFlags);
UINT WINAPI GlobalSize (HGLOBAL hMem);
UINT WINAPI GlobalUnlock (HGLOBAL hMem);
LPVOID WINAPI HeapAlloc (HANDLE hHeap, DWORD dwFlags, DWORD dwBytes);
HANDLE WINAPI HeapCreate (DWORD flOptions, DWORD dwInitialSize, DWORD dwMaximumSize);
BOOL WINAPI HeapDestroy (HANDLE hHeap);
BOOL WINAPI HeapFree (HANDLE hHeap, DWORD dwFlags, LPVOID lpMem);
LPVOID WINAPI HeapReAlloc (HANDLE hHeap, DWORD dwFlags, LPVOID lpMem, DWORD dwBytes);
DWORD WINAPI HeapSize (HANDLE hHeap, DWORD dwFlags, LPCVOID lpMem);
VOID WINAPI InitializeCriticalSection (LPCRITICAL_SECTION lpCriticalSection);
PVOID WINAPI InterlockedCompareExchange (PVOID *Destination, PVOID Exchange, PVOID Comperand);
LONG WINAPI InterlockedDecrement (LPLONG lpAddend);
LONG WINAPI InterlockedExchange (LPLONG Target, LONG Value);
LONG WINAPI InterlockedExchangeAdd (PLONG lpAddend, LONG Increment);
LONG WINAPI InterlockedIncrement (LPLONG lpAddend);
BOOL WINAPI IsBadCodePtr (FARPROC lpfn);
BOOL WINAPI IsBadReadPtr (LPVOID lp, UINT ucb);
BOOL WINAPI IsBadWritePtr (LPVOID lp, UINT ucb);
BOOL WINAPI IsDBCSLeadByte (BYTE bTestChar);
BOOL IsDBCSLeadByteEx (UINT CodePage, BYTE bTestChar);
INT WINAPI LCMapStringA (LCID Locale, DWORD dwMapFlags, LPCSTR lpSrcStr, INT cchSrc, LPSTR lpDestStr, INT cchDest);
INT WINAPI LCMapStringW (LCID Locale, DWORD dwMapFlags, LPCWSTR lpSrcStr, INT cchSrc, LPWSTR lpDestStr, INT cchDest);
VOID WINAPI LeaveCriticalSection (LPCRITICAL_SECTION lpCriticalSection);
HINSTANCE WINAPI LoadLibraryA (LPCSTR lpFileName);
HINSTANCE WINAPI LoadLibraryExA (LPCSTR lpLibFileName, HANDLE hFile, DWORD dwFlags);
HINSTANCE WINAPI LoadLibraryExW (LPCWSTR lpLibFileName, HANDLE hFile, DWORD dwFlags);
HINSTANCE WINAPI LoadLibraryW (LPCWSTR lpFileName);
HGLOBAL WINAPI LoadResource (HMODULE hModule, HRSRC hResInfo);
HLOCAL WINAPI LocalAlloc (UINT uFlags, UINT uBytes);
UINT WINAPI LocalFlags (HLOCAL hMem);
HLOCAL WINAPI LocalFree (HLOCAL hMem);
HLOCAL WINAPI LocalHandle (LPCVOID pMem);
LPVOID WINAPI LocalLock (HLOCAL hMem);
HLOCAL WINAPI LocalReAlloc (HLOCAL hMem, UINT uBytes, UINT uFlags);
UINT WINAPI LocalSize (HLOCAL hMem);
UINT WINAPI LocalUnlock (HLOCAL hMem);
LPVOID WINAPI LockResource (HGLOBAL hResData);
LPVOID WINAPI MapViewOfFile (HANDLE hFileMappingObject, DWORD dwDesiredAccess, DWORD dwFileOffsetHigh, DWORD dwFileOffsetLow, SIZE_T dwNumberOfBytesToMap);
LPVOID WINAPI MapViewOfFileEx (HANDLE hFileMappingObject, DWORD dwDesiredAccess, DWORD dwFileOffsetHigh, DWORD dwFileOffsetLow, SIZE_T dwNumberOfBytesToMap, LPVOID lpBaseAddress);
BOOL WINAPI MoveFileA (LPCSTR lpExistingFileName, LPCSTR lpNewFileName);
BOOL WINAPI MoveFileExA (LPCSTR lpExistingFileName, LPCSTR lpNewFileName, DWORD dwFlags);
BOOL WINAPI MoveFileExW (LPCWSTR lpExistingFileName, LPCWSTR lpNewFileName, DWORD dwFlags);
BOOL WINAPI MoveFileW (LPCWSTR lpExistingFileName, LPCWSTR lpNewFileName);
INT WINAPI MulDiv (INT nNumber, INT nNumerator, INT nDenominator);
INT WINAPI MultiByteToWideChar (UINT CodePage, DWORD dwFlags, LPCSTR lpMultiByteStr, INT cchMultiByte, LPWSTR lpWideCharStr, INT cchWideChar);
HANDLE WINAPI OpenFileMappingA (DWORD dwDesiredAccess, BOOL bInheritHandle, LPCSTR lpName);
HANDLE WINAPI OpenFileMappingW (DWORD dwDesiredAccess, BOOL bInheritHandle, LPCWSTR lpName);
VOID WINAPI OutputDebugStringA (LPCSTR lpOutputString);
VOID WINAPI OutputDebugStringW (LPCWSTR lpOutputString);
BOOL WINAPI QueryPerformanceCounter (LARGE_INTEGER *lpPerformanceCount);
BOOL WINAPI QueryPerformanceFrequency (LARGE_INTEGER *lpFrequency);
BOOL WINAPI ReadFile (HANDLE hFile, LPVOID lpBuffer, DWORD nNumberOfBytesToRead, LPDWORD lpNumberOfBytesRead, LPOVERLAPPED lpOverlapped);
BOOL WINAPI ReleaseSemaphore (HANDLE hSemaphore, LONG lReleaseCount, LPLONG lpPreviousCount);
BOOL WINAPI RemoveDirectoryA (LPCSTR lpPathName);
BOOL WINAPI RemoveDirectoryW (LPCWSTR lpPathName);
BOOL WINAPI ResetEvent (HANDLE hEvent);
BOOL WINAPI SetConsoleScreenBufferSize (HANDLE hConsoleOutput, COORD dwSize);
BOOL WINAPI SetEndOfFile (HANDLE hFile);
DWORD WINAPI SetFilePointer (HANDLE hFile, LONG lDistanceToMove, PLONG lpDistanceToMoveHigh, DWORD dwMoveMethod);
UINT WINAPI SetHandleCount (UINT uNumber);
VOID WINAPI SetLastError (DWORD dwErrCode);
BOOL WINAPI SetStdHandle (DWORD nStdHandle, HANDLE hHandle);
DWORD WINAPI SizeofResource (HMODULE hModule, HRSRC hResInfo);
VOID WINAPI Sleep (DWORD dwMilliseconds);
BOOL WINAPI TerminateProcess (HANDLE hProcess, UINT uExitCode);
DWORD WINAPI TlsAlloc (VOID);
BOOL WINAPI TlsFree (DWORD dwTlsIndex);
LPVOID WINAPI TlsGetValue (DWORD dwTlsIndex);
BOOL WINAPI TlsSetValue (DWORD dwTlsIndex, LPVOID lpTlsValue);
BOOL WINAPI TryEnterCriticalSection (LPCRITICAL_SECTION lpCriticalSection);
BOOL WINAPI UnmapViewOfFile (LPCVOID lpBaseAddress);
DWORD WINAPI VerLanguageNameA (DWORD wLang, LPSTR szLang, DWORD nSize);
DWORD WINAPI VerLanguageNameW (DWORD wLang, LPWSTR szLang, DWORD nSize);
LPVOID WINAPI VirtualAlloc (LPVOID lpAddress, DWORD dwSize, DWORD flAllocationType, DWORD flProtect);
BOOL WINAPI VirtualFree (LPVOID lpAddress, DWORD dwSize, DWORD dwFreeType);
BOOL WINAPI VirtualLock (LPVOID lpAddress, DWORD dwSize);
BOOL WINAPI VirtualProtect (LPVOID lpAddress, DWORD dwSize, DWORD flNewProtect, PDWORD lpflOldProtect);
DWORD WINAPI VirtualQuery (LPCVOID lpAddress, PMEMORY_BASIC_INFORMATION lpBuffer, DWORD dwLength);
BOOL WINAPI VirtualUnlock (LPVOID lpAddress, DWORD dwSize);
DWORD WINAPI WaitForSingleObject (HANDLE hHandle, DWORD dwMilliseconds);
INT WINAPI WideCharToMultiByte (UINT CodePage, DWORD dwFlags, LPCWSTR lpWideCharStr, INT cchWideChar, LPSTR lpMultiByteStr, INT cchMultiByte, LPCSTR lpDefaultChar, LPBOOL lpUsedDefaultChar);
BOOL WINAPI WriteConsoleA (HANDLE hConsoleOutput, CONST VOID *lpBuffer, DWORD nNumberOfCharsToWrite, LPDWORD lpNumberOfCharsWritten, LPVOID lpReserved);
BOOL WINAPI WriteConsoleW (HANDLE hConsoleOutput, CONST VOID *lpBuffer, DWORD nNumberOfCharsToWrite, LPDWORD lpNumberOfCharsWritten, LPVOID lpReserved);
BOOL WINAPI WriteFile (HANDLE hFile, LPCVOID lpBuffer, DWORD nNumberOfBytesToWrite, LPDWORD lpNumberOfBytesWritten, LPOVERLAPPED lpOverlapped);
BOOL WINAPI WritePrivateProfileSectionA (LPCSTR lpAppName, LPCSTR lpString, LPCSTR lpFileName);
BOOL WINAPI WritePrivateProfileSectionW (LPCWSTR lpAppName, LPCWSTR lpString, LPCWSTR lpFileName);
BOOL WINAPI WritePrivateProfileStringA (LPCSTR lpAppName, LPCSTR lpKeyName, LPCSTR lpString, LPCSTR lpFileName);
BOOL WINAPI WritePrivateProfileStringW (LPCWSTR lpAppName, LPCWSTR lpKeyName, LPCWSTR lpString, LPCWSTR lpFileName);
BOOL WINAPI WritePrivateProfileStructA (LPCSTR lpszSection, LPCSTR lpszKey, LPVOID lpStruct, UINT uSizeStruct, LPCSTR szFile);
BOOL WINAPI WritePrivateProfileStructW (LPCWSTR lpszSection, LPCWSTR lpszKey, LPVOID lpStruct, UINT uSizeStruct, LPCWSTR szFile);
BOOL WINAPI WriteProfileSectionA (LPCSTR lpAppName, LPCSTR lpString);
BOOL WINAPI WriteProfileSectionW (LPCWSTR lpAppName, LPCWSTR lpString);
BOOL WINAPI WriteProfileStringA (LPCSTR lpAppName, LPCSTR lpKeyName, LPCSTR lpString);
BOOL WINAPI WriteProfileStringW (LPCWSTR lpAppName, LPCWSTR lpKeyName, LPCWSTR lpString);
HFILE WINAPI _lclose (HFILE hFile);
HFILE WINAPI _lcreat (LPCSTR lpPathName, INT iAttribute);
LONG WINAPI _llseek (HFILE hFile, LONG lOffset, INT iOrigin);
UINT WINAPI _lread (HFILE hFile, LPVOID lpBuffer, UINT uBytes);
UINT WINAPI _lwrite (HFILE hFile, LPVOID lpBuffer, UINT uBytes);
LPSTR WINAPI lstrcatA (LPSTR lpString1, LPCSTR lpString2);
LPWSTR WINAPI lstrcatW (LPWSTR lpString1, LPCWSTR lpString2);
INT WINAPI lstrcmpA (LPCSTR lpString1, LPCSTR lpString2);
INT WINAPI lstrcmpW (LPCWSTR lpString1, LPCWSTR lpString2);
INT WINAPI lstrcmpiA (LPCSTR lpString1, LPCSTR lpString2);
INT WINAPI lstrcmpiW (LPCWSTR lpString1, LPCWSTR lpString2);
LPSTR WINAPI lstrcpyA (LPSTR lpString1, LPCSTR lpString2);
LPWSTR WINAPI lstrcpyW (LPWSTR lpString1, LPCWSTR lpString2);
LPSTR WINAPI lstrcpynA (LPSTR lpString1, LPCSTR lpString2, INT iMaxLength);
LPWSTR WINAPI lstrcpynW (LPWSTR lpString1, LPCWSTR lpString2, INT iMaxLength);
INT WINAPI lstrlenA (LPCSTR lpString);
INT WINAPI lstrlenW (LPCWSTR lpString);


#ifdef UNICODE
# define CopyFile CopyFileW
# define CreateDirectory CreateDirectoryW
# define CreateEvent CreateEventW
# define CreateFile CreateFileW
# define CreateFileMapping CreateFileMappingW
# define CreateSemaphore CreateSemaphoreW
# define DeleteFile DeleteFileW
# define EnumCalendarInfo EnumCalendarInfoW
# define FindResource FindResourceW
# define FindResourceEx FindResourceExW
# define FreeEnvironmentStrings FreeEnvironmentStringsW
# define GetCPInfoEx GetCPInfoExW
# define GetCommandLine GetCommandLineW
# define GetEnvironmentStrings GetEnvironmentStringsW
# define GetEnvironmentVariable GetEnvironmentVariableW
# define GetModuleFileName GetModuleFileNameW
# define GetModuleHandle GetModuleHandleW
# define GetPrivateProfileInt GetPrivateProfileIntW
# define GetPrivateProfileSection GetPrivateProfileSectionW
# define GetPrivateProfileString GetPrivateProfileStringW
# define GetPrivateProfileStruct GetPrivateProfileStructW
# define GetProfileInt GetProfileIntW
# define GetProfileSection GetProfileSectionW
# define GetProfileString GetProfileStringW
# define GetShortPathName GetShortPathNameW
# define GetStringType GetStringTypeW
# define GetSystemDirectory GetSystemDirectoryW
# define GetVersionEx GetVersionExW
# define LCMapString LCMapStringW
# define LoadLibrary LoadLibraryW
# define LoadLibraryEx LoadLibraryExW
# define MoveFile MoveFileW
# define MoveFileEx MoveFileExW
# define OpenFileMapping OpenFileMappingW
# define OutputDebugString OutputDebugStringW
# define RemoveDirectory RemoveDirectoryW
# define VerLanguageName VerLanguageNameW
# define WriteConsole WriteConsoleW
# define WritePrivateProfileSection WritePrivateProfileSectionW
# define WritePrivateProfileString WritePrivateProfileStringW
# define WritePrivateProfileStruct WritePrivateProfileStructW
# define WriteProfileSection WriteProfileSectionW
# define WriteProfileString WriteProfileStringW
# define lstrcat lstrcatW
# define lstrcmp lstrcmpW
# define lstrcmpi lstrcmpiW
# define lstrcpy lstrcpyW
# define lstrcpyn lstrcpynW
# define lstrlen lstrlenW
#else /* not UNICODE*/
# define CopyFile CopyFileA
# define CreateDirectory CreateDirectoryA
# define CreateEvent CreateEventA
# define CreateFile CreateFileA
# define CreateFileMapping CreateFileMappingA
# define CreateSemaphore CreateSemaphoreA
# define DeleteFile DeleteFileA
# define EnumCalendarInfo EnumCalendarInfoA
# define FindResource FindResourceA
# define FindResourceEx FindResourceExA
# define FreeEnvironmentStrings FreeEnvironmentStringsA
# define GetCPInfoEx GetCPInfoExA
# define GetCommandLine GetCommandLineA
# define GetEnvironmentStrings GetEnvironmentStringsA
# define GetEnvironmentVariable GetEnvironmentVariableA
# define GetModuleFileName GetModuleFileNameA
# define GetModuleHandle GetModuleHandleA
# define GetPrivateProfileInt GetPrivateProfileIntA
# define GetPrivateProfileSection GetPrivateProfileSectionA
# define GetPrivateProfileString GetPrivateProfileStringA
# define GetPrivateProfileStruct GetPrivateProfileStructA
# define GetProfileInt GetProfileIntA
# define GetProfileSection GetProfileSectionA
# define GetProfileString GetProfileStringA
# define GetShortPathName GetShortPathNameA
# define GetStringType GetStringTypeA
# define GetSystemDirectory GetSystemDirectoryA
# define GetVersionEx GetVersionExA
# define LCMapString LCMapStringA
# define LoadLibrary LoadLibraryA
# define LoadLibraryEx LoadLibraryExA
# define MoveFile MoveFileA
# define MoveFileEx MoveFileExA
# define OpenFileMapping OpenFileMappingA
# define OutputDebugString OutputDebugStringA
# define RemoveDirectory RemoveDirectoryA
# define VerLanguageName VerLanguageNameA
# define WriteConsole WriteConsoleA
# define WritePrivateProfileSection WritePrivateProfileSectionA
# define WritePrivateProfileString WritePrivateProfileStringA
# define WritePrivateProfileStruct WritePrivateProfileStructA
# define WriteProfileSection WriteProfileSectionA
# define WriteProfileString WriteProfileStringA
# define lstrcat lstrcatA
# define lstrcmp lstrcmpA
# define lstrcmpi lstrcmpiA
# define lstrcpy lstrcpyA
# define lstrcpyn lstrcpynA
# define lstrlen lstrlenA
#endif /* not UNICODE */


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __KERNEL32_H__ */
