/*
    Video maid
    copyright (c) 1998-2006 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef __SIGMAIN_H__
#define __SIGMAIN_H__


#include "vmaid.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/******************************************************************************
*                                                                             *
* ja:シグナル/イベント関数群(テキスト)                                        *
*                                                                             *
******************************************************************************/
void
signal_style_set (GtkWidget *widget,
                  GtkStyle  *style,
                  gpointer   user_data);


/******************************************************************************
*                                                                             *
* ja:シグナル/イベント関数群(メニュー)                                        *
*                                                                             *
******************************************************************************/
void
signal_activate_menu_history (GtkWidget   *widget,
                              const gchar *file);


/******************************************************************************
*                                                                             *
* ja:シグナル/イベント関数群(MDI)                                             *
*                                                                             *
******************************************************************************/
void
signal_close_window (GtkWidget   *widget,
                     guint        page_num,
                     VmaidWindow *vmaid);


void
signal_switch_window (GtkWidget   *widget,
                      guint        page_num,
                      VmaidWindow *vmaid);


void
signal_destroy_mdi (GtkWidget *widget,
                    gpointer   user_data);


/******************************************************************************
*                                                                             *
* ja:シグナル/イベント関数群(リスト)                                          *
*                                                                             *
******************************************************************************/
void
signal_changed (GtkTreeSelection *select,
                gpointer          user_data);


gboolean
signal_button_press_tview (GtkWidget        *widget,
                           GdkEventButton   *event,
                           GtkTreeSelection *select);


/******************************************************************************
*                                                                             *
* ja:シグナル/イベント関数群(セレクション)                                    *
*                                                                             *
******************************************************************************/
void
signal_drag_data_received (GtkWidget        *widget,
                           GdkDragContext   *context,
                           gint              x,
                           gint              y,
                           GtkSelectionData *selection_data,
                           guint             info,
                           guint             time);


void
signal_selection_paste (GObject   *object,
                        AviEdit  **avi_edit,
                        gpointer   user_data);


void
signal_selection_recv (GObject   *object,
                       gchar    **argv,
                       gpointer   user_data);


/******************************************************************************
*                                                                             *
* ja:シグナル/イベント関数群(メイン)                                          *
*                                                                             *
******************************************************************************/
gboolean
signal_delete (GtkWidget *widget,
               GdkEvent  *event,
               gpointer   user_data);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __SIGMAIN_H__ */
