/*
 * Copyright (c) 2008, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

package javafx.scene.text;

/**
 * The {@code TextAlignment} enum represents the horizontal text alignment. 
 * @since JavaFX 2.0
 */
public enum TextAlignment {

    /**
     * Represents text alignment to the left (left-justified, ragged right).
     */
    LEFT,
    
    /**
     * Represents centered text alignment (ragged left and right).
     */
    CENTER,
    
    /**
     * Represents text alignment to the right (right-justified, ragged left).
     */
    RIGHT,
    
    /**
     * Represents justified text alignment.
     */
    JUSTIFY
}
