/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk;

import java.io.File;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.JPanel;
import org.netbeans.lib.profiler.heap.GCRoot;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.HeapSummary;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.heap.JavaFrameGCRoot;
import org.netbeans.lib.profiler.heap.PrimitiveArrayInstance;
import org.netbeans.lib.profiler.heap.ThreadObjectGCRoot;
import org.netbeans.modules.profiler.api.GoToSource;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.heapwalk.AbstractController;
import org.netbeans.modules.profiler.heapwalk.Bundle;
import org.netbeans.modules.profiler.heapwalk.HeapFragmentWalker;
import org.netbeans.modules.profiler.heapwalk.SummaryController;
import org.netbeans.modules.profiler.heapwalk.ui.OverviewControllerUI;
import org.openide.util.Lookup;
import sun.misc.VM;

public class OverviewController
extends AbstractController {
    public static final String SHOW_SYSPROPS_URL = "file:/sysprops";
    public static final String SHOW_THREADS_URL = "file:/threads";
    private static final String OPEN_THREADS_URL = "file:/stackframe/";
    private static final String CLASS_URL_PREFIX = "file://class/";
    private static final String INSTANCE_URL_PREFIX = "file://instance/";
    private static final String THREAD_URL_PREFIX = "file://thread/";
    private static final String LINE_PREFIX = "&nbsp;&nbsp;&nbsp;&nbsp;";
    private HeapFragmentWalker heapFragmentWalker;
    private SummaryController summaryController;
    private boolean systemPropertiesComputed = false;
    private Properties systemProperties;
    private String stackTrace;
    private JavaClass java_lang_Class;
    private ThreadObjectGCRoot oome;

    public OverviewController(SummaryController summaryController) {
        this.summaryController = summaryController;
        this.heapFragmentWalker = summaryController.getHeapFragmentWalker();
    }

    public SummaryController getSummaryController() {
        return this.summaryController;
    }

    @Override
    protected AbstractButton createControllerPresenter() {
        return ((OverviewControllerUI)((Object)this.getPanel())).getPresenter();
    }

    @Override
    protected JPanel createControllerUI() {
        return new OverviewControllerUI(this);
    }

    void showInThreads(Instance instance) {
        ((OverviewControllerUI)((Object)this.getPanel())).showInThreads(instance);
    }

    public String computeSummary() {
        String string;
        Object object;
        Object object2;
        Object object3;
        File file = this.heapFragmentWalker.getHeapDumpFile();
        Heap heap = this.heapFragmentWalker.getHeapFragment();
        HeapSummary heapSummary = heap.getSummary();
        long l = this.computeFinalizers(heap);
        int n = 0;
        JavaClass javaClass = heap.getJavaClassByName("java.lang.ClassLoader");
        NumberFormat numberFormat = (NumberFormat)NumberFormat.getInstance().clone();
        numberFormat.setMaximumFractionDigits(1);
        this.oome = this.getOOMEThread(heap);
        if (javaClass != null) {
            n = javaClass.getInstancesCount();
            object3 = javaClass.getSubClasses();
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (JavaClass)object2.next();
                n += object.getInstancesCount();
            }
        }
        object3 = LINE_PREFIX + Bundle.OverviewController_FileItemString(file != null && file.exists() ? file.getAbsolutePath() : Bundle.OverviewController_NotAvailableMsg());
        object2 = LINE_PREFIX + Bundle.OverviewController_FileSizeItemString(file != null && file.exists() ? numberFormat.format((double)file.length() / 1048576.0) + " MB" : Bundle.OverviewController_NotAvailableMsg());
        object = LINE_PREFIX + Bundle.OverviewController_DateTakenItemString(new Date(heapSummary.getTime()).toString());
        String string2 = LINE_PREFIX + Bundle.OverviewController_TotalBytesItemString(numberFormat.format(heapSummary.getTotalLiveBytes()));
        String string3 = LINE_PREFIX + Bundle.OverviewController_TotalClassesItemString(numberFormat.format(heap.getAllClasses().size()));
        String string4 = LINE_PREFIX + Bundle.OverviewController_TotalInstancesItemString(numberFormat.format(heapSummary.getTotalLiveInstances()));
        String string5 = LINE_PREFIX + Bundle.OverviewController_ClassloadersItemString(numberFormat.format(n));
        String string6 = LINE_PREFIX + Bundle.OverviewController_GcRootsItemString(numberFormat.format(heap.getGCRoots().size()));
        String string7 = LINE_PREFIX + Bundle.OverviewController_FinalizersItemString(numberFormat.format(l));
        String string8 = "";
        if (this.oome != null) {
            string = this.oome.getInstance();
            String string9 = OverviewController.htmlize(this.getThreadName((Instance)string));
            String string10 = "<a href='file://thread/" + string.getJavaClass().getName() + "/" + string.getInstanceId() + "'>" + string9 + "</a>";
            string8 = "<br><br>&nbsp;&nbsp;&nbsp;&nbsp;" + Bundle.OverviewController_OOMELabelString() + "<br>" + LINE_PREFIX + Bundle.OverviewController_OOMEItemString(string10);
        }
        string = Icons.getResource((String)"ProfilerIcons.HeapDump");
        return "<b><img border='0' align='bottom' src='nbresloc:/" + string + "'>&nbsp;&nbsp;" + Bundle.OverviewController_SummaryString() + "</b><br><hr>" + (String)object + "<br>" + (String)object3 + "<br>" + (String)object2 + "<br><br>" + string2 + "<br>" + string3 + "<br>" + string4 + "<br>" + string5 + "<br>" + string6 + "<br>" + string7 + string8;
    }

    public String computeEnvironment() {
        String string = Icons.getResource((String)"HeapWalkerIcons.SystemInfo");
        String string2 = "<b><img border='0' align='bottom' src='nbresloc:/" + string + "'>&nbsp;&nbsp;" + Bundle.OverviewController_EnvironmentString() + "</b><br><hr>";
        Properties properties = this.getSystemProperties();
        if (properties == null) {
            return string2 + LINE_PREFIX + Bundle.OverviewController_NotAvailableMsg();
        }
        String string3 = properties.getProperty("sun.os.patch.level", "");
        String string4 = LINE_PREFIX + Bundle.OverviewController_OsItemString(properties.getProperty("os.name", Bundle.OverviewController_NotAvailableMsg()), properties.getProperty("os.version", ""), "unknown".equals(string3) ? "" : string3);
        String string5 = LINE_PREFIX + Bundle.OverviewController_ArchitectureItemString(properties.getProperty("os.arch", Bundle.OverviewController_NotAvailableMsg()), properties.getProperty("sun.arch.data.model", "?") + "bit");
        String string6 = LINE_PREFIX + Bundle.OverviewController_JavaHomeItemString(properties.getProperty("java.home", Bundle.OverviewController_NotAvailableMsg()));
        String string7 = LINE_PREFIX + Bundle.OverviewController_JavaVersionItemString(properties.getProperty("java.version", Bundle.OverviewController_NotAvailableMsg()));
        String string8 = LINE_PREFIX + Bundle.OverviewController_JvmItemString(properties.getProperty("java.vm.name", Bundle.OverviewController_NotAvailableMsg()), properties.getProperty("java.vm.version", ""), properties.getProperty("java.vm.info", ""));
        String string9 = LINE_PREFIX + Bundle.OverviewController_JavaVendorItemString(properties.getProperty("java.vendor", Bundle.OverviewController_NotAvailableMsg()));
        return string2 + string4 + "<br>" + string5 + "<br>" + string6 + "<br>" + string7 + "<br>" + string8 + "<br>" + string9;
    }

    public String computeSystemProperties(boolean bl) {
        String string = Icons.getResource((String)"HeapWalkerIcons.Properties");
        String string2 = "<b><img border='0' align='bottom' src='nbresloc:/" + string + "'>&nbsp;&nbsp;" + Bundle.OverviewController_SystemPropertiesString() + "</b><br><hr>";
        Properties properties = this.getSystemProperties();
        if (properties == null) {
            return string2 + LINE_PREFIX + Bundle.OverviewController_NotAvailableMsg();
        }
        return string2 + (bl ? this.formatSystemProperties(properties) : "&nbsp;&nbsp;&nbsp;&nbsp;<a href='file:/sysprops'>" + Bundle.OverviewController_ShowSysPropsLinkString() + "</a>");
    }

    public String computeThreads(boolean bl) {
        String string = Icons.getResource((String)"ProfilerIcons.WindowThreads");
        return "<b><img border='0' align='bottom' src='nbresloc:/" + string + "'>&nbsp;&nbsp;" + Bundle.OverviewController_ThreadsString() + "</b><br><hr>" + (bl ? this.getStackTrace() : "&nbsp;&nbsp;&nbsp;&nbsp;<a href='file:/threads'>" + Bundle.OverviewController_ShowThreadsLinkString() + "</a><br>&nbsp;");
    }

    public void showURL(String string) {
        if (string.startsWith(OPEN_THREADS_URL)) {
            string = string.substring(OPEN_THREADS_URL.length());
            String[] stringArray = string.split("\\|");
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            int n = Integer.parseInt(stringArray[2]);
            GoToSource.openSource((Lookup.Provider)this.heapFragmentWalker.getHeapDumpProject(), (String)string2, (String)string3, (int)n);
        } else if (string.startsWith(INSTANCE_URL_PREFIX)) {
            string = string.substring(INSTANCE_URL_PREFIX.length());
            String[] stringArray = string.split("/");
            long l = Long.parseLong(stringArray[2]);
            Instance instance = this.heapFragmentWalker.getHeapFragment().getInstanceByID(l);
            if (instance != null) {
                this.heapFragmentWalker.getClassesController().showInstance(instance);
            } else {
                ProfilerDialogs.displayError((String)Bundle.AnalysisController_CannotResolveInstanceMsg(stringArray[1], stringArray[0]));
            }
        } else if (string.startsWith(CLASS_URL_PREFIX)) {
            string = string.substring(CLASS_URL_PREFIX.length());
            String[] stringArray = string.split("/");
            long l = Long.parseLong(stringArray[1]);
            JavaClass javaClass = this.heapFragmentWalker.getHeapFragment().getJavaClassByID(l);
            if (javaClass != null) {
                this.heapFragmentWalker.getClassesController().showClass(javaClass);
            } else {
                ProfilerDialogs.displayError((String)Bundle.AnalysisController_CannotResolveClassMsg(stringArray[0]));
            }
        } else if (string.startsWith(THREAD_URL_PREFIX)) {
            string = string.substring(THREAD_URL_PREFIX.length());
            String[] stringArray = string.split("/");
            long l = Long.parseLong(stringArray[1]);
            this.showInThreads(this.heapFragmentWalker.getHeapFragment().getInstanceByID(l));
        }
    }

    private long computeFinalizers(Heap heap) {
        Long l;
        Instance instance;
        JavaClass javaClass = heap.getJavaClassByName("java.lang.ref.Finalizer");
        if (javaClass != null && (instance = (Instance)javaClass.getValueOfStaticField("queue")) != null && (l = (Long)instance.getValueOfField("queueLength")) != null) {
            return l;
        }
        return -1L;
    }

    private ThreadObjectGCRoot getOOMEThread(Heap heap) {
        Collection collection = heap.getGCRoots();
        for (GCRoot gCRoot : collection) {
            ThreadObjectGCRoot threadObjectGCRoot;
            StackTraceElement[] stackTraceElementArray;
            if (!gCRoot.getKind().equals("thread object") || (stackTraceElementArray = (threadObjectGCRoot = (ThreadObjectGCRoot)gCRoot).getStackTrace()) == null || stackTraceElementArray.length < 1) continue;
            StackTraceElement stackTraceElement = stackTraceElementArray[0];
            if (!OutOfMemoryError.class.getName().equals(stackTraceElement.getClassName()) || !"<init>".equals(stackTraceElement.getMethodName())) continue;
            return threadObjectGCRoot;
        }
        return null;
    }

    private Properties getSystemProperties() {
        if (!this.systemPropertiesComputed) {
            this.systemProperties = this.heapFragmentWalker.getHeapFragment().getSystemProperties();
            this.systemPropertiesComputed = true;
        }
        return this.systemProperties;
    }

    private String formatSystemProperties(Properties properties) {
        StringBuilder stringBuilder = new StringBuilder(200);
        ArrayList arrayList = new ArrayList();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        Collections.sort(arrayList);
        for (String string : arrayList) {
            String string2 = properties.getProperty(string);
            if ("line.separator".equals(string) && string2 != null) {
                string2 = string2.replace("\n", "\\n");
                string2 = string2.replace("\r", "\\r");
            }
            stringBuilder.append("<nobr>&nbsp;&nbsp;&nbsp;&nbsp;<b>");
            stringBuilder.append(string);
            stringBuilder.append("</b>=");
            stringBuilder.append(string2);
            stringBuilder.append("</nobr><br>");
        }
        return stringBuilder.toString();
    }

    private synchronized String getStackTrace() {
        if (this.stackTrace == null) {
            boolean bl = this.heapFragmentWalker.getHeapDumpProject() != null && GoToSource.isAvailable();
            StringBuilder stringBuilder = new StringBuilder();
            Heap heap = this.heapFragmentWalker.getHeapFragment();
            Collection collection = heap.getGCRoots();
            Map<ThreadObjectGCRoot, Map<Integer, List<JavaFrameGCRoot>>> map = this.computeJavaFrameMap(collection);
            stringBuilder.append("<pre>");
            for (GCRoot gCRoot : collection) {
                if (!gCRoot.getKind().equals("thread object")) continue;
                ThreadObjectGCRoot threadObjectGCRoot = (ThreadObjectGCRoot)gCRoot;
                Instance instance = threadObjectGCRoot.getInstance();
                if (instance != null) {
                    String string = this.getThreadName(instance);
                    Boolean bl2 = (Boolean)instance.getValueOfField("daemon");
                    Integer n = (Integer)instance.getValueOfField("priority");
                    Long l = (Long)instance.getValueOfField("tid");
                    Integer n2 = (Integer)instance.getValueOfField("threadStatus");
                    StackTraceElement[] stackTraceElementArray = threadObjectGCRoot.getStackTrace();
                    Map<Integer, List<JavaFrameGCRoot>> map2 = map.get(threadObjectGCRoot);
                    String string2 = "";
                    if (threadObjectGCRoot.equals(this.oome)) {
                        string2 = "style=\"color: #FF0000\"";
                    }
                    stringBuilder.append("&nbsp;&nbsp;<a name=").append(instance.getInstanceId()).append("></a><b ").append(string2).append(">");
                    stringBuilder.append("\"").append(OverviewController.htmlize(string)).append("\"").append(bl2 != false ? " daemon" : "").append(" prio=").append(n);
                    if (l != null) {
                        stringBuilder.append(" tid=").append(l);
                    }
                    if (n2 != null) {
                        Thread.State state = VM.toThreadState((int)n2);
                        stringBuilder.append(" ").append((Object)state);
                    }
                    stringBuilder.append("</b><br>");
                    if (stackTraceElementArray != null) {
                        for (int i = 0; i < stackTraceElementArray.length; ++i) {
                            String string3;
                            String string4;
                            Object object;
                            Object object2;
                            StackTraceElement stackTraceElement = stackTraceElementArray[i];
                            String string5 = OverviewController.htmlize(stackTraceElement.toString());
                            if (bl) {
                                object2 = stackTraceElement.getClassName();
                                object = stackTraceElement.getMethodName();
                                int n3 = stackTraceElement.getLineNumber();
                                string4 = OPEN_THREADS_URL + (String)object2 + "|" + (String)object + "|" + n3;
                                string3 = "<a href=\"" + string4 + "\">" + string5 + "</a>";
                            } else {
                                string3 = string5;
                            }
                            stringBuilder.append("\tat ").append(string3).append("<br>");
                            if (map2 == null || (object2 = map2.get(i)) == null) continue;
                            object = object2.iterator();
                            while (object.hasNext()) {
                                JavaFrameGCRoot javaFrameGCRoot = (JavaFrameGCRoot)object.next();
                                string4 = javaFrameGCRoot.getInstance();
                                if (string4 != null) {
                                    stringBuilder.append("\t   Local Variable: ").append(this.printInstance((Instance)string4)).append("<br>");
                                    continue;
                                }
                                stringBuilder.append("\t   Unknown Local Variable<br>");
                            }
                        }
                    }
                } else {
                    stringBuilder.append("&nbsp;&nbsp;Unknown thread<br>");
                }
                stringBuilder.append("<br>");
            }
            stringBuilder.append("</pre>");
            this.stackTrace = stringBuilder.toString();
        }
        return this.stackTrace;
    }

    private String getThreadName(Instance instance) {
        Object object;
        Object object2;
        Object object3;
        int n;
        PrimitiveArrayInstance primitiveArrayInstance;
        Object object4 = instance.getValueOfField("name");
        int n2 = 0;
        if (object4 == null) {
            return "*null*";
        }
        if (object4 instanceof PrimitiveArrayInstance) {
            primitiveArrayInstance = (PrimitiveArrayInstance)object4;
            n = primitiveArrayInstance.getLength();
        } else {
            object3 = (Instance)object4;
            assert (object3.getJavaClass().getName().equals(String.class.getName()));
            primitiveArrayInstance = (PrimitiveArrayInstance)object3.getValueOfField("value");
            if (primitiveArrayInstance != null) {
                object2 = (Integer)object3.getValueOfField("offset");
                object = (Integer)object3.getValueOfField("count");
                if (object2 != null) {
                    n2 = (Integer)object2;
                }
                n = object != null ? ((Integer)object).intValue() : primitiveArrayInstance.getLength();
            } else {
                return "*null*";
            }
        }
        object3 = primitiveArrayInstance.getValues();
        object2 = object3.subList(n2, n2 + n);
        object = new char[object2.size()];
        int n3 = 0;
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            object[n3++] = string.charAt(0);
        }
        return new String((char[])object);
    }

    private Map<ThreadObjectGCRoot, Map<Integer, List<JavaFrameGCRoot>>> computeJavaFrameMap(Collection<GCRoot> collection) {
        HashMap<ThreadObjectGCRoot, Map<Integer, List<JavaFrameGCRoot>>> hashMap = new HashMap<ThreadObjectGCRoot, Map<Integer, List<JavaFrameGCRoot>>>();
        for (GCRoot gCRoot : collection) {
            ArrayList<JavaFrameGCRoot> arrayList;
            if (!"Java frame".equals(gCRoot.getKind())) continue;
            JavaFrameGCRoot javaFrameGCRoot = (JavaFrameGCRoot)gCRoot;
            ThreadObjectGCRoot threadObjectGCRoot = javaFrameGCRoot.getThreadGCRoot();
            Integer n = javaFrameGCRoot.getFrameNumber();
            HashMap<Integer, ArrayList<JavaFrameGCRoot>> hashMap2 = (HashMap<Integer, ArrayList<JavaFrameGCRoot>>)hashMap.get(threadObjectGCRoot);
            if (hashMap2 == null) {
                hashMap2 = new HashMap<Integer, ArrayList<JavaFrameGCRoot>>();
                hashMap.put(threadObjectGCRoot, hashMap2);
            }
            if ((arrayList = (ArrayList<JavaFrameGCRoot>)hashMap2.get(n)) == null) {
                arrayList = new ArrayList<JavaFrameGCRoot>(2);
                hashMap2.put(n, arrayList);
            }
            arrayList.add(javaFrameGCRoot);
        }
        return hashMap;
    }

    private String printInstance(Instance instance) {
        JavaClass javaClass;
        JavaClass javaClass2 = instance.getJavaClass();
        if (javaClass2 == null) {
            return "unknown instance #" + instance.getInstanceId();
        }
        if (javaClass2.equals(this.getJavaClass()) && (javaClass = this.heapFragmentWalker.getHeapFragment().getJavaClassByID(instance.getInstanceId())) != null) {
            String string = javaClass.getName();
            return "<a href='file://class/" + string + "/" + javaClass.getJavaClassId() + "'>class " + string + "</a>";
        }
        String string = javaClass2.getName();
        return "<a href='file://instance/" + string + "/" + instance.getInstanceNumber() + "/" + instance.getInstanceId() + "' name='" + instance.getInstanceId() + "'>" + string + '#' + instance.getInstanceNumber() + "</a>";
    }

    private JavaClass getJavaClass() {
        if (this.java_lang_Class == null) {
            this.java_lang_Class = this.heapFragmentWalker.getHeapFragment().getJavaClassByName(Class.class.getName());
        }
        return this.java_lang_Class;
    }

    private static String htmlize(String string) {
        return string.replace(">", "&gt;").replace("<", "&lt;");
    }
}

