/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net.proxy;

import com.sun.deploy.config.Config;
import com.sun.deploy.net.proxy.AbstractAutoProxyHandler;
import com.sun.deploy.net.proxy.BrowserProxyInfo;
import com.sun.deploy.net.proxy.PACFunctions;
import com.sun.deploy.net.proxy.PACFunctionsImpl;
import com.sun.deploy.net.proxy.ProxyConfigException;
import com.sun.deploy.net.proxy.ProxyInfo;
import com.sun.deploy.net.proxy.ProxyUnavailableException;
import com.sun.deploy.trace.Trace;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.StringTokenizer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;

public class SunAutoProxyHandler
extends AbstractAutoProxyHandler {
    private ScriptEngineManager manager = null;
    private ScriptEngine engine = null;
    private PACFunctions functionsImpl = null;
    private static final String pacFuncsImpl = "    function dnsResolve(host){\n                                     return obj.dnsResolve(host);\n                           }\n                                                          function isResolvable(host){\n                                   return obj.isResolvable(host);\n                         }\n                                                          function localHostOrDomainIs(host, domain){\n                    return obj.localHostOrDomainIs(host, domain);\n          }\n                                                          function isPlainHostName(host){\n                                return obj.isPlainHostName(host);\n                      }\n                                                          function myIpAddress(){\n                                        return obj.myIpAddress();\n                              }\n                                                          function shExpMatch(str, shexp){\n                               return obj.shExpMatch(str, shexp);\n                     }\n                                                          function dnsDomainIs(host, domain){\n                            return obj.dnsDomainIs(host, domain);\n                  }\n                                                          function dnsDomainLevels(host){\n                                return obj.dnsDomainLevels(host);\n                      }";

    public SunAutoProxyHandler() {
        this.functionsImpl = new PACFunctionsImpl();
    }

    public SunAutoProxyHandler(PACFunctions pACFunctions) {
        this.functionsImpl = pACFunctions;
    }

    public final void init(BrowserProxyInfo browserProxyInfo) throws ProxyConfigException {
        super.init(browserProxyInfo);
        this.initEngine(Config.getNoPermissionACC());
    }

    private void initEngine(AccessControlContext accessControlContext) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                SunAutoProxyHandler.this.initEngine();
                return null;
            }
        }, accessControlContext);
    }

    private void initEngine() {
        this.manager = new ScriptEngineManager(null);
        this.engine = this.manager.getEngineByName("js");
    }

    public ProxyInfo[] getProxyInfo(URL uRL) throws ProxyUnavailableException {
        ProxyInfo[] proxyInfoArray = null;
        proxyInfoArray = this.jsGetProxyInfo(uRL, Config.getNoPermissionACC());
        if (proxyInfoArray == null) {
            proxyInfoArray = this.fallbackGetProxyInfo(uRL);
        }
        return proxyInfoArray;
    }

    private ProxyInfo[] jsGetProxyInfo(final URL uRL, AccessControlContext accessControlContext) {
        return (ProxyInfo[])AccessController.doPrivileged(new PrivilegedAction(){

            public ProxyInfo[] run() {
                return SunAutoProxyHandler.this.jsGetProxyInfo(uRL);
            }
        }, accessControlContext);
    }

    private ProxyInfo[] jsGetProxyInfo(URL uRL) {
        ProxyInfo[] proxyInfoArray = null;
        if (Config.isJavaVersionAtLeast18() && System.getSecurityManager() == null) {
            return null;
        }
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager(null);
        ScriptEngine scriptEngine = scriptEngineManager.getEngineByName("js");
        if (scriptEngine != null) {
            try {
                if (Config.isJavaVersionAtLeast18()) {
                    this.bindPACFunctions_18(scriptEngine);
                } else {
                    this.bindPACFunctions(scriptEngine);
                }
                scriptEngine.eval(this.autoProxyScript.toString());
                if (scriptEngine instanceof Invocable) {
                    Invocable invocable = (Invocable)((Object)scriptEngine);
                    Object object = invocable.invokeFunction("FindProxyForURL", uRL.toString(), uRL.getHost());
                    proxyInfoArray = this.extractAutoProxySetting((String)object);
                } else {
                    Trace.netPrintln("JavaScript engine cannot invoke methods");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return proxyInfoArray;
    }

    private void bindPACFunctions_18(ScriptEngine scriptEngine) {
        scriptEngine.put("dnsDomainIs", new BiFunction<String, String, Boolean>(){

            @Override
            public Boolean apply(String string, String string2) {
                return SunAutoProxyHandler.this.functionsImpl.dnsDomainIs(string, string2);
            }
        });
        scriptEngine.put("shExpMatch", new BiFunction<String, String, Boolean>(){

            @Override
            public Boolean apply(String string, String string2) {
                return SunAutoProxyHandler.this.functionsImpl.shExpMatch(string, string2);
            }
        });
        scriptEngine.put("myIpAddress", new Supplier<String>(){

            @Override
            public String get() {
                return SunAutoProxyHandler.this.functionsImpl.myIpAddress();
            }
        });
        scriptEngine.put("dnsResolve", new Function<String, String>(){

            @Override
            public String apply(String string) {
                return SunAutoProxyHandler.this.functionsImpl.dnsResolve(string);
            }
        });
        scriptEngine.put("isPlainHostName", new Function<String, Boolean>(){

            @Override
            public Boolean apply(String string) {
                return SunAutoProxyHandler.this.functionsImpl.isPlainHostName(string);
            }
        });
        scriptEngine.put("localHostOrDomainIs", new BiFunction<String, String, Boolean>(){

            @Override
            public Boolean apply(String string, String string2) {
                return SunAutoProxyHandler.this.functionsImpl.localHostOrDomainIs(string, string2);
            }
        });
        scriptEngine.put("isResolvable", new Function<String, Boolean>(){

            @Override
            public Boolean apply(String string) {
                return SunAutoProxyHandler.this.functionsImpl.isResolvable(string);
            }
        });
        scriptEngine.put("dnsDomainLevels", new Function<String, Integer>(){

            @Override
            public Integer apply(String string) {
                return SunAutoProxyHandler.this.functionsImpl.dnsDomainLevels(string);
            }
        });
    }

    private void bindPACFunctions(ScriptEngine scriptEngine) {
        scriptEngine.put("obj", this.functionsImpl);
    }

    protected String getBrowserSpecificAutoProxy() {
        if (Config.isJavaVersionAtLeast18()) {
            return "";
        }
        return pacFuncsImpl;
    }

    ProxyInfo[] fallbackGetProxyInfo(URL uRL) {
        try {
            String string = null;
            if (this.jsPacScript != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(this.jsPacScript, ";", false);
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    int n = string2.indexOf("DIRECT");
                    int n2 = string2.indexOf("PROXY");
                    int n3 = string2.indexOf("SOCKS");
                    int n4 = this.positiveMin(n, this.positiveMin(n2, n3));
                    int n5 = string2.lastIndexOf("\"");
                    if (n4 == -1) continue;
                    string = n5 <= n4 ? string2.substring(n4) : string2.substring(n4, n5);
                    break;
                }
            }
            return this.extractAutoProxySetting(string);
        }
        catch (Throwable throwable) {
            Trace.msgNetPrintln("net.proxy.auto.result.error");
            return new ProxyInfo[]{new ProxyInfo(null)};
        }
    }

    private int positiveMin(int n, int n2) {
        if (n < 0) {
            return n2;
        }
        if (n2 < 0) {
            return n;
        }
        if (n > n2) {
            return n2;
        }
        return n;
    }
}

