/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.misc;

import com.jrockit.mc.ui.misc.ExceptionDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ErrorDialog {
    private ErrorDialog() {
    }

    public static void showError(Shell shell, String title, String message) {
        MessageDialog.openError((Shell)shell, (String)title, (String)message);
    }

    public static void showException(Shell shell, String title, Throwable t) {
        ExceptionDialog.openExceptionDialog(shell, title, t.getMessage(), t);
    }

    public static void showException(Shell shell, String title, String message, Throwable t) {
        ExceptionDialog.openExceptionDialog(shell, title, message, t);
    }

    public static void showExceptionDialogAsync(final Display display, final String title, final String message, final Throwable t) {
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                ErrorDialog.showException(display.getActiveShell(), title, message, t);
            }
        });
    }

    public static void showExceptionDialogAsync(Display display, String title, Throwable t) {
        ErrorDialog.showExceptionDialogAsync(display, title, t.getMessage(), t);
    }

    public static void showExceptionDialogAsync(String title, Throwable t) {
        ErrorDialog.showExceptionDialogAsync(Display.getDefault(), title, t.getMessage(), t);
    }

    public static void showExceptionDialogAsync(String title, String message, Throwable t) {
        ErrorDialog.showExceptionDialogAsync(Display.getDefault(), title, message, t);
    }

    public static void showErrorDialogAsync(final Display display, final String title, final String message) {
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                ErrorDialog.showError(display.getActiveShell(), title, message);
            }
        });
    }

    public static void showWarningDialogAsync(final Display display, final String title, final String message) {
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openWarning((Shell)display.getActiveShell(), (String)title, (String)message);
            }
        });
    }
}

