/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.misc;

import com.jrockit.mc.ui.misc.Messages;
import java.text.NumberFormat;
import java.text.ParsePosition;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class DoubleFieldEditor
extends StringFieldEditor {
    private static final int DEFAULT_TEXT_LIMIT = 10;
    private final NumberFormat format;
    private double minValidValue = 0.0;
    private double maxValidValue = Double.POSITIVE_INFINITY;
    private String generatedErrorMsg;

    public DoubleFieldEditor(String name, String labelText, Composite parent) {
        this(name, labelText, parent, 10);
    }

    public DoubleFieldEditor(String name, String labelText, Composite parent, int textLimit) {
        this.format = NumberFormat.getNumberInstance();
        this.format.setGroupingUsed(false);
        this.init(name, labelText);
        this.setTextLimit(textLimit);
        this.setEmptyStringAllowed(false);
        this.createControl(parent);
    }

    public void setValidRange(double min, double max) {
        this.minValidValue = min;
        this.maxValidValue = max;
        this.generatedErrorMsg = null;
    }

    protected boolean checkState() {
        Text text = this.getTextControl();
        if (text != null) {
            String numberString = text.getText();
            double number = this.parse(numberString);
            if (number >= this.minValidValue && number <= this.maxValidValue && !Double.isNaN(number)) {
                this.clearErrorMessage();
                return true;
            }
            this.showErrorMessage();
            return false;
        }
        return false;
    }

    public void showErrorMessage() {
        this.showErrorMessage(this.getErrorMessage());
    }

    public String getErrorMessage() {
        String valueName;
        boolean hasMin;
        String msg = super.getErrorMessage();
        if (msg != null) {
            return msg;
        }
        if (this.generatedErrorMsg != null) {
            return this.generatedErrorMsg;
        }
        boolean hasMax = this.maxValidValue != Double.POSITIVE_INFINITY;
        boolean bl = hasMin = this.minValidValue != Double.NEGATIVE_INFINITY;
        if (this.minValidValue == 0.0) {
            valueName = Messages.DoubleFieldEditor_ERROR_MESSAGE_PART_POSITIVE_DECIMAL_VALUE;
            hasMin = false;
        } else if (this.maxValidValue == 0.0) {
            valueName = Messages.DoubleFieldEditor_ERROR_MESSAGE_PART_NEGATIVE_DECIMAL_VALUE;
            hasMax = false;
        } else {
            valueName = Messages.DoubleFieldEditor_ERROR_MESSAGE_PART_DECIMAL_VALUE;
        }
        Object[] msgArgs = new Object[]{valueName, hasMin ? this.format.format(this.minValidValue) : "", hasMax ? this.format.format(this.maxValidValue) : ""};
        msg = hasMax && hasMin ? NLS.bind((String)Messages.NumberFieldEditor_ERROR_MESSAGE_INTERVAL, (Object[])msgArgs) : (hasMax && !hasMin ? NLS.bind((String)Messages.NumberFieldEditor_ERROR_MESSAGE_NO_GREATER, (Object[])msgArgs) : (!hasMax && hasMin ? NLS.bind((String)Messages.NumberFieldEditor_ERROR_MESSAGE_NO_SMALLER, (Object[])msgArgs) : NLS.bind((String)Messages.NumberFieldEditor_ERROR_MESSAGE_MUST_BE, (Object[])msgArgs)));
        this.generatedErrorMsg = msg;
        return this.generatedErrorMsg;
    }

    private double parse(String text) {
        ParsePosition pos;
        String trimmed = text.trim();
        Number number = this.format.parse(trimmed, pos = new ParsePosition(0));
        if (number == null || pos.getIndex() != trimmed.length()) {
            return Double.NaN;
        }
        return number.doubleValue();
    }

    protected void doLoad() {
        Text text = this.getTextControl();
        if (text != null) {
            double value = this.getPreferenceStore().getDouble(this.getPreferenceName());
            text.setText(this.format.format(value));
        }
    }

    protected void doLoadDefault() {
        Text text = this.getTextControl();
        if (text != null) {
            double value = this.getPreferenceStore().getDefaultDouble(this.getPreferenceName());
            text.setText(this.format.format(value));
        }
        this.valueChanged();
    }

    protected void doStore() {
        Text text = this.getTextControl();
        if (text != null) {
            double value = this.parse(text.getText());
            this.getPreferenceStore().setValue(this.getPreferenceName(), value);
        }
    }

    public double getDoubleValue() {
        return this.parse(this.getStringValue());
    }
}

