/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui;

import com.jrockit.mc.common.io.IOToolkit;
import com.jrockit.mc.core.MCVersion;
import com.jrockit.mc.core.l10n.Toolkit;
import com.jrockit.mc.ui.Messages;
import com.jrockit.mc.ui.OverlayIcon;
import com.jrockit.mc.ui.UIPlugin;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.IProgressService;
import org.osgi.framework.BundleContext;

public abstract class MCAbstractUIPlugin
extends AbstractUIPlugin {
    public static final String ICON_DIRECTORY = "icons/";
    public static final String ICON_OVERLAY_PREFIX = "overlay{";
    public static final String ICON_OVERLAY_SEPARATOR = ",";
    public static final String ICON_OVERLAY_POSTFIX = "}";
    private static final int HIGH_CONTRAST_CUTOFF = 100;
    protected final Logger m_logger;
    protected final String m_pluginName;
    protected FormColors m_formColors;
    protected String[] m_dialogUIvariants;
    private volatile Vector<String> m_preloadImages = new Vector();

    public MCAbstractUIPlugin(String pluginName) {
        this.m_logger = Logger.getLogger(pluginName);
        this.m_pluginName = pluginName;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void registerFromImageConstantClass(ImageRegistry registry, Class<?> classWithConstants) {
        Field[] fieldArray = classWithConstants.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            try {
                String iconName = (String)field.get(null);
                this.registerImage(registry, iconName, iconName);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("Could not access field icon constant class");
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Could not access field icon constant class");
            }
            ++n2;
        }
    }

    public String getPluginName() {
        return this.m_pluginName;
    }

    public Logger getLogger() {
        return this.m_logger;
    }

    public FormColors getFormColors(Display display) {
        if (this.m_formColors == null) {
            this.m_formColors = new FormColors(display);
            this.m_formColors.markShared();
            RGB BLACK = new RGB(0, 0, 0);
            if (this.colorDistance(BLACK, this.m_formColors.getBackground().getRGB()) > 100) {
                this.m_formColors.createColor("org.eclipse.ui.forms.TITLE", BLACK);
            }
        }
        return this.m_formColors;
    }

    private int colorDistance(RGB title, RGB background) {
        int r = Math.abs(title.red - background.red);
        int g = Math.abs(title.green - background.green);
        int b = Math.abs(title.blue - background.blue);
        return r + g + b;
    }

    public Image getImage(String key) {
        return this.getImageRegistry().get(key);
    }

    public void schedulePreloading() {
        Runnable t = new Runnable(){

            @Override
            public void run() {
                try {
                    ImageRegistry registry = MCAbstractUIPlugin.this.getImageRegistry();
                    for (String key : MCAbstractUIPlugin.this.m_preloadImages) {
                        UIPlugin.getDefault().getLogger().log(Level.INFO, "Preloading image" + key);
                        registry.get(key);
                    }
                }
                catch (Exception t) {
                    UIPlugin.getDefault().getLogger().log(Level.SEVERE, "Could not preload images", t);
                }
            }
        };
        Display display = Display.getDefault();
        if (display != null && !display.isDisposed()) {
            display.asyncExec(t);
        }
    }

    public void stop(BundleContext context) throws Exception {
        try {
            if (this.m_formColors != null) {
                this.m_formColors.dispose();
                this.m_formColors = null;
            }
        }
        finally {
            super.stop(context);
        }
    }

    protected void registerOverlayImage(ImageRegistry registry, String baseKey, String overlayKey) {
        this.getOverlayImage(baseKey, overlayKey);
        this.m_preloadImages.add(this.getOverlayKey(baseKey, overlayKey));
    }

    public synchronized Image getOverlayImage(String baseKey, String overlayKey) {
        Image ret = this.getImageRegistry().get(this.getOverlayKey(baseKey, overlayKey));
        if (ret != null) {
            return ret;
        }
        Image baseImage = this.getImageRegistry().get(baseKey);
        if (baseImage == null) {
            return null;
        }
        Image overlayImage = this.getImageRegistry().get(overlayKey);
        if (overlayImage == null) {
            return null;
        }
        OverlayIcon overlayIcon = new OverlayIcon(baseImage, overlayImage);
        ret = overlayIcon.createImage();
        if (ret == null) {
            return null;
        }
        this.getImageRegistry().put(this.getOverlayKey(baseKey, overlayKey), ret);
        return ret;
    }

    private String getOverlayKey(String base, String overlay) {
        return ICON_OVERLAY_PREFIX + base + ICON_OVERLAY_SEPARATOR + overlay + ICON_OVERLAY_POSTFIX;
    }

    protected String getImageDescriptorPath(String imageName) {
        return ICON_DIRECTORY + imageName;
    }

    public ImageDescriptor getImageDescriptor(String path) {
        URL url = this.getBundle().getEntry(path);
        if (url == null) {
            return null;
        }
        return this.getImageDescriptor(url);
    }

    public ImageDescriptor getImageDescriptor(URL url) {
        return ImageDescriptor.createFromURL((URL)url);
    }

    public ImageDescriptor getMCImageDescriptor(String imageName) {
        ImageDescriptor descriptor = this.getImageDescriptor(this.getImageDescriptorPath(imageName));
        if (descriptor == null) {
            UIPlugin.getDefault().getLogger().log(Level.SEVERE, "Icon not found " + imageName);
        }
        return descriptor;
    }

    public ImageDescriptor getMCImageDescriptor(URL imageUrl) {
        ImageDescriptor descriptor = this.getImageDescriptor(imageUrl);
        if (descriptor == null) {
            UIPlugin.getDefault().getLogger().log(Level.SEVERE, "Icon not found " + imageUrl);
        }
        return descriptor;
    }

    protected void registerImage(ImageRegistry registry, String key, String imageName) {
        try {
            this.m_preloadImages.add(key);
            if (registry.get(key) != null) {
                this.getLogger().log(Level.INFO, "Warning! ImageDescriptor already in image registry. Current descriptor will be replaced with " + imageName);
            }
            registry.put(key, this.getMCImageDescriptor(imageName));
        }
        catch (Exception e) {
            this.getLogger().log(Level.CONFIG, "Could not load icon with file name " + imageName, e);
        }
    }

    protected void registerImage(ImageRegistry registry, String key, URL imageUrl) {
        try {
            this.m_preloadImages.add(key);
            if (registry.get(key) != null) {
                this.getLogger().log(Level.INFO, "Warning! ImageDescriptor already in image registry. Current descriptor will be replaced with " + imageUrl);
            }
            registry.put(key, this.getMCImageDescriptor(imageUrl));
        }
        catch (Exception e) {
            this.getLogger().log(Level.CONFIG, "Could not load icon with URL " + imageUrl, e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IDialogSettings getMCDialogSettings() {
        IDialogSettings iDialogSettings;
        InputStream inStream;
        BufferedReader bufferedReader;
        block9: {
            IDialogSettings versionedSettings;
            String rootSectionString;
            block10: {
                IDialogSettings workBenchSettings = this.getDialogSettings();
                String versionedSettingsString = "mc.ui.settings.version." + MCVersion.getFullVersion();
                rootSectionString = "root";
                versionedSettings = workBenchSettings.getSection(versionedSettingsString);
                if (versionedSettings == null) {
                    versionedSettings = workBenchSettings.addNewSection(versionedSettingsString);
                    bufferedReader = null;
                    inStream = null;
                    try {
                        String[] variants;
                        ClassLoader loader = ((Object)((Object)this)).getClass().getClassLoader();
                        String[] stringArray = variants = this.getDialogUIVariants();
                        int n = variants.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String variant = stringArray[n2];
                            inStream = loader.getResourceAsStream(variant);
                            if (inStream != null) {
                                bufferedReader = new BufferedReader(new InputStreamReader(inStream, "8859_1"));
                                IDialogSettings dummySection = versionedSettings.addNewSection(rootSectionString);
                                dummySection.load((Reader)bufferedReader);
                                iDialogSettings = dummySection;
                                break block9;
                            }
                            ++n2;
                        }
                    }
                    catch (Throwable throwable) {
                        IOToolkit.closeSilently(bufferedReader);
                        IOToolkit.closeSilently(inStream);
                        throw throwable;
                    }
                    {
                        catch (Exception e) {
                            this.getLogger().log(Level.SEVERE, "Error while locating ui settings for plugin " + this.getPluginName(), e);
                            IOToolkit.closeSilently(bufferedReader);
                            IOToolkit.closeSilently(inStream);
                            break block10;
                            break;
                        }
                    }
                    IOToolkit.closeSilently(bufferedReader);
                    IOToolkit.closeSilently(inStream);
                }
            }
            if (versionedSettings.getSection(rootSectionString) == null) {
                this.getLogger().log(Level.INFO, "Can't find ui settings for plugin " + this.getPluginName() + ". If this is the first time starting JMC against a new workspace, this is probably perfectly normal.");
                versionedSettings.addNewSection(rootSectionString);
            }
            return versionedSettings.getSection(rootSectionString);
        }
        IOToolkit.closeSilently((Closeable)bufferedReader);
        IOToolkit.closeSilently((Closeable)inStream);
        return iDialogSettings;
    }

    public void runProgressTask(boolean async, final boolean fork, final boolean canceable, final IRunnableWithProgress runnable) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
                    progressService.run(fork, canceable, runnable);
                }
                catch (InvocationTargetException e) {
                    if (e.getCause() != null) {
                        MessageDialog.openError(null, (String)Messages.MCAbstractUIPlugin_ERROR_HAS_OCCURRED_TEXT, (String)e.getCause().getMessage());
                        MCAbstractUIPlugin.this.getLogger().log(Level.INFO, Messages.MCAbstractUIPlugin_ERROR_RUNNING_TASK_TEXT, e.getCause());
                    }
                }
                catch (InterruptedException e) {
                    MCAbstractUIPlugin.this.getLogger().log(Level.INFO, Messages.MCAbstractUIPlugin_PROGRESS_TASK_INTERRUPTED_TEXT, e);
                }
            }
        };
        Display display = Display.getDefault();
        if (async) {
            display.asyncExec(r);
        } else {
            r.run();
        }
    }

    protected String[] getDialogUIVariants() {
        if (this.m_dialogUIvariants == null) {
            this.m_dialogUIvariants = Toolkit.buildVariants((String)(String.valueOf(this.getPluginName()) + ".defaultSettings"), (String)".xml");
        }
        return this.m_dialogUIvariants;
    }
}

