/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.objects;

import java.util.Collections;
import jdk.nashorn.internal.objects.ArrayBufferView;
import jdk.nashorn.internal.objects.Global;
import jdk.nashorn.internal.objects.NativeArrayBuffer;
import jdk.nashorn.internal.runtime.JSType;
import jdk.nashorn.internal.runtime.PropertyMap;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.arrays.ArrayData;

public final class NativeUint8ClampedArray
extends ArrayBufferView {
    public static final int BYTES_PER_ELEMENT = 1;
    private static PropertyMap $nasgenmap$;
    private static final ArrayBufferView.Factory FACTORY;

    public static NativeUint8ClampedArray constructor(boolean newObj, Object self, Object ... args) {
        return (NativeUint8ClampedArray)NativeUint8ClampedArray.constructorImpl(args, FACTORY);
    }

    NativeUint8ClampedArray(NativeArrayBuffer buffer, int byteOffset, int length) {
        super(buffer, byteOffset, length);
    }

    @Override
    public String getClassName() {
        return "Uint8ClampedArray";
    }

    @Override
    protected ArrayBufferView.Factory factory() {
        return FACTORY;
    }

    protected static Object set(Object self, Object array, Object offset) {
        return ArrayBufferView.setImpl(self, array, offset);
    }

    protected static NativeUint8ClampedArray subarray(Object self, Object begin, Object end) {
        return (NativeUint8ClampedArray)ArrayBufferView.subarrayImpl(self, begin, end);
    }

    @Override
    protected ScriptObject getPrototype(Global global) {
        return global.getUint8ClampedArrayPrototype();
    }

    static {
        FACTORY = new ArrayBufferView.Factory(1){

            @Override
            public ArrayBufferView construct(NativeArrayBuffer buffer, int byteOffset, int length) {
                return new NativeUint8ClampedArray(buffer, byteOffset, length);
            }

            @Override
            public ArrayData createArrayData(NativeArrayBuffer buffer, int byteOffset, int length) {
                return new Uint8ClampedArrayData(buffer, byteOffset, length);
            }
        };
        NativeUint8ClampedArray.$clinit$();
    }

    public static void $clinit$() {
        $nasgenmap$ = PropertyMap.newMap(Collections.EMPTY_LIST);
    }

    private static final class Uint8ClampedArrayData
    extends ArrayBufferView.ArrayDataImpl {
        private Uint8ClampedArrayData(NativeArrayBuffer buffer, int byteOffset, int elementLength) {
            super(buffer, byteOffset, elementLength);
        }

        @Override
        protected int byteIndex(int index) {
            return index * 1 + this.byteOffset;
        }

        @Override
        protected int getIntImpl(int index) {
            return this.buffer.getByteArray()[this.byteIndex(index)] & 0xFF;
        }

        @Override
        protected void setImpl(int index, int value) {
            int clamped = (value & 0xFFFFFF00) == 0 ? (int)value : (value < 0 ? 0 : -1);
            this.buffer.getByteArray()[this.byteIndex((int)index)] = clamped;
        }

        @Override
        protected void setImpl(int index, long value) {
            if (JSType.isRepresentableAsInt(value)) {
                this.setImpl(index, (int)value);
            } else {
                this.buffer.getByteArray()[this.byteIndex((int)index)] = value > 0L ? -1 : 0;
            }
        }

        @Override
        protected void setImpl(int key, double value) {
            this.setImpl(key, (int)Math.rint(value));
        }

        @Override
        protected void setImpl(int key, Object value) {
            this.setImpl(key, JSType.toNumber(value));
        }
    }
}

