/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import java.util.Collections;
import java.util.List;
import jdk.nashorn.internal.codegen.Label;
import jdk.nashorn.internal.ir.BreakableNode;
import jdk.nashorn.internal.ir.LexicalContextStatement;
import jdk.nashorn.internal.ir.annotations.Immutable;

@Immutable
abstract class BreakableStatement
extends LexicalContextStatement
implements BreakableNode {
    protected final Label breakLabel;

    protected BreakableStatement(int lineNumber, long token, int finish, Label breakLabel) {
        super(lineNumber, token, finish);
        this.breakLabel = breakLabel;
    }

    protected BreakableStatement(BreakableStatement breakableNode) {
        super(breakableNode);
        this.breakLabel = new Label(breakableNode.getBreakLabel());
    }

    @Override
    public boolean isBreakableWithoutLabel() {
        return true;
    }

    @Override
    public Label getBreakLabel() {
        return this.breakLabel;
    }

    @Override
    public List<Label> getLabels() {
        return Collections.singletonList(this.breakLabel);
    }
}

