/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.wizards;

import com.jrockit.mc.core.MCFile;
import com.jrockit.mc.flightrecorder.controlpanel.ui.ControlPanel;
import com.jrockit.mc.flightrecorder.controlpanel.ui.RecordingProvider;
import com.jrockit.mc.flightrecorder.controlpanel.ui.jobs.DumpRecordingJob;
import com.jrockit.mc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.DumpRecordingWizardModel;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.RecordingWizardModel;
import com.jrockit.mc.flightrecorder.ui.FlightRecorderUI;
import com.jrockit.mc.ui.misc.DateTimeChooser;
import com.jrockit.mc.ui.wizards.IPerformFinishable;
import java.util.Date;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Text;

public class DumpRecordingWizardPage
extends WizardPage
implements IPerformFinishable {
    private static long[] FIXED_INTERVALS = new long[]{10000L, 20000L, 30000L, 40000L, 50000L, 60000L, 90000L, 120000L, 150000L, 180000L, 210000L, 240000L, 270000L, 300000L, 360000L, 420000L, 480000L, 540000L, 600000L, 900000L, 1200000L, 1500000L, 1800000L, 2400000L, 3000000L, 3600000L, 5400000L, 0x6DDD00L, 9000000L, 10800000L, 12600000L, 14400000L, 16200000L, 18000000L, 21600000L, 25200000L, 28800000L, 32400000L, 36000000L, 39600000L, 43200000L, 50400000L, 57600000L, 72000000L, 86400000L};
    private Text m_filenameText;
    private Button m_wholeRadioButton;
    private long[] m_lastPartIntervals;
    private Button m_lastPartRadioButton;
    private Scale m_lastPartScale;
    private Text m_lastPartText;
    private Button m_intervalRadioButton;
    private Label m_startTimeLabel;
    private DateTimeChooser m_startTimeChooser;
    private Label m_endTimeLabel;
    private DateTimeChooser m_endTimeChooser;
    private final DumpRecordingWizardModel wizardModel;
    private Button m_lastPartDefaultCheckbox;

    public DumpRecordingWizardPage(DumpRecordingWizardModel dumpRecordingWizardModel) {
        super("dumpRecording", Messages.DUMP_RECORDING_WIZARD_PAGE_TITLE, ControlPanel.getDefault().getMCImageDescriptor("startjfrwiz.gif"));
        this.wizardModel = dumpRecordingWizardModel;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        int indent = this.convertWidthInCharsToPixels(4);
        this.setDescription(Messages.DUMP_RECORDING_WIZARD_PAGE_DESCRIPTION);
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        container.setLayout((Layout)layout);
        this.createFileNameInput(container, indent);
        this.createWholeRecordingOption(container, indent);
        this.createLastPartRecordingOption(container, indent);
        this.createIntervalRecordingOption(container, indent);
        this.createDivider(container);
        this.createLastPartDefaultCheckbox(container);
        this.selectInitialOption();
        this.setControl((Control)container);
    }

    private void selectInitialOption() {
        if (this.wizardModel.isRecordingToDisk()) {
            this.m_lastPartRadioButton.setSelection(true);
            this.setLastPartControlsEnabled(true);
            this.setIntervalControlsEnabled(false);
        } else {
            this.m_wholeRadioButton.setSelection(true);
            this.m_lastPartRadioButton.setEnabled(false);
            this.setLastPartControlsEnabled(false);
            this.m_intervalRadioButton.setEnabled(false);
            this.setIntervalControlsEnabled(false);
        }
    }

    private void createFileNameInput(Composite parent, int indent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.LABEL_FILENAME_TEXT);
        label.setLayoutData((Object)this.createGridData(false, indent));
        this.m_filenameText = new Text(parent, 2056);
        this.m_filenameText.setLayoutData((Object)this.createGridData(true));
        Button browseButton = this.createFilenameBrowseButton(parent);
        browseButton.setLayoutData((Object)this.createGridData(false));
        this.updateFilename();
    }

    private Button createFilenameBrowseButton(Composite parent) {
        final Button button = new Button(parent, 0);
        button.setText(Messages.BUTTON_BROWSE_TEXT);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MCFile path = RecordingWizardModel.openRecordingFileBrowser(DumpRecordingWizardPage.this.wizardModel.getPath());
                if (path != null) {
                    DumpRecordingWizardPage.this.wizardModel.setPath(path);
                    DumpRecordingWizardPage.this.updateFilename();
                }
                button.setFocus();
            }
        });
        return button;
    }

    private void updateFilename() {
        this.m_filenameText.setText(this.wizardModel.getPath() == null ? "" : this.wizardModel.getPath().getPath().toOSString());
        this.setMessage(null, 0);
        if (this.wizardModel.getPath().exists()) {
            this.setMessage(Messages.WARNING_FILE_WILL_BE_OVERWRITTEN_MSG, 2);
        }
    }

    private void createWholeRecordingOption(Composite parent, int indent) {
        this.m_wholeRadioButton = new Button(parent, 16);
        this.m_wholeRadioButton.setText(Messages.BUTTON_WHOLE_RECORDING_TEXT);
        this.m_wholeRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DumpRecordingWizardPage.this.setLastPartControlsEnabled(false);
                DumpRecordingWizardPage.this.setDefaultControlsEnabled(true);
                DumpRecordingWizardPage.this.setIntervalControlsEnabled(false);
            }
        });
        this.m_wholeRadioButton.setLayoutData((Object)this.createGridData(false, 2, 0));
        this.createPadding(parent, 1);
    }

    private void createLastPartRecordingOption(Composite parent, int indent) {
        this.createLastPartRecordingRadioButton(parent);
        this.createLastPartRecordingScale(parent, indent);
    }

    private void createLastPartRecordingRadioButton(Composite parent) {
        this.m_lastPartRadioButton = new Button(parent, 16);
        this.m_lastPartRadioButton.setText(Messages.BUTTON_LAST_PART_OF_RECORDING_TEXT);
        this.m_lastPartRadioButton.setLayoutData((Object)this.createGridData(false, 2, 0));
        this.m_lastPartRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DumpRecordingWizardPage.this.setLastPartControlsEnabled(true);
                DumpRecordingWizardPage.this.setDefaultControlsEnabled(true);
                DumpRecordingWizardPage.this.setIntervalControlsEnabled(false);
            }
        });
        this.createPadding(parent, 1);
    }

    private void createLastPartRecordingScale(Composite parent, int indent) {
        this.m_lastPartScale = new Scale(parent, 0);
        this.initLastPartScale();
        this.m_lastPartScale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DumpRecordingWizardPage.this.updateLastPartLength();
            }
        });
        this.m_lastPartScale.setLayoutData((Object)this.createGridData(true, 2, indent));
        this.m_lastPartText = new Text(parent, 133128);
        this.m_lastPartText.setLayoutData((Object)this.createGridData(false));
        this.updateLastPartLength();
    }

    private void initLastPartScale() {
        long dayLength;
        long duration = this.wizardModel.recordingEndTime().getTime() - this.wizardModel.getRecordingStartTime().getTime();
        if (duration > (dayLength = FIXED_INTERVALS[FIXED_INTERVALS.length - 1])) {
            this.createMoreIntervals(duration);
        } else {
            this.createLessIntervals(duration);
        }
        this.m_lastPartScale.setMinimum(0);
        this.m_lastPartScale.setMaximum(this.m_lastPartIntervals.length - 1);
        this.m_lastPartScale.setSelection(Math.min(9, this.m_lastPartIntervals.length - 1));
        this.m_lastPartScale.setPageIncrement(Math.max(1, this.m_lastPartIntervals.length / 8));
    }

    private void createMoreIntervals(long duration) {
        long dayLength = FIXED_INTERVALS[FIXED_INTERVALS.length - 1];
        int days = (int)(duration / dayLength);
        days = Math.min(days, 100 - FIXED_INTERVALS.length);
        this.m_lastPartIntervals = new long[FIXED_INTERVALS.length + days];
        System.arraycopy(FIXED_INTERVALS, 0, this.m_lastPartIntervals, 0, FIXED_INTERVALS.length);
        int i = 0;
        while (i < days) {
            this.m_lastPartIntervals[DumpRecordingWizardPage.FIXED_INTERVALS.length + i] = (long)(i + 2) * dayLength;
            ++i;
        }
    }

    private void createLessIntervals(long duration) {
        int lastInterval = FIXED_INTERVALS.length - 1;
        int i = 0;
        while (i < FIXED_INTERVALS.length) {
            if (FIXED_INTERVALS[i] >= duration) {
                lastInterval = i;
                break;
            }
            ++i;
        }
        if (lastInterval == 0) {
            this.m_lastPartIntervals = new long[]{FIXED_INTERVALS[0] / 2L, FIXED_INTERVALS[0]};
            return;
        }
        this.m_lastPartIntervals = new long[lastInterval + 1];
        System.arraycopy(FIXED_INTERVALS, 0, this.m_lastPartIntervals, 0, this.m_lastPartIntervals.length);
    }

    private void createDivider(Composite container) {
        Label divider = new Label(container, 258);
        divider.setLayoutData((Object)this.createGridData(true, 3, 0));
    }

    private void createLastPartDefaultCheckbox(Composite parent) {
        this.m_lastPartDefaultCheckbox = new Button(parent, 32);
        this.m_lastPartDefaultCheckbox.setText(Messages.DUMP_RECORDING_SAVE_LAST_PART_TO_DUMP);
        this.m_lastPartDefaultCheckbox.setLayoutData((Object)this.createGridData(true, 2, 0));
    }

    private void updateLastPartLength() {
        long ms = this.m_lastPartIntervals[this.m_lastPartScale.getSelection()];
        long s = ms / 1000L;
        long m = s / 60L;
        long h = m / 60L;
        long d = h / 24L;
        StringBuilder textMsg = new StringBuilder();
        this.addTimePartToMessage(d, 0L, Messages.VALUE_DATE_DAYS_SUFFIX, textMsg);
        this.addTimePartToMessage(h, d * 24L, Messages.VALUE_DATE_HOURS_SUFFIX, textMsg);
        this.addTimePartToMessage(m, h * 60L, Messages.VALUE_DATE_MINUTES_SUFFIX, textMsg);
        this.addTimePartToMessage(s, m * 60L, Messages.VALUE_DATE_SECONDS_SUFFIX, textMsg);
        String msg = textMsg.toString();
        msg = msg.substring(0, msg.length() - 1);
        this.m_lastPartText.setText(msg);
        this.m_lastPartScale.setToolTipText(msg);
    }

    private void addTimePartToMessage(long timePartCount, long accountedFor, String timePart, StringBuilder textMsg) {
        long whole = timePartCount - accountedFor;
        if (whole > 0L) {
            textMsg.append(whole);
            textMsg.append(timePart);
        }
    }

    private void setLastPartControlsEnabled(boolean enabled) {
        this.m_lastPartScale.setEnabled(enabled);
        this.m_lastPartText.setEnabled(enabled);
    }

    private void setDefaultControlsEnabled(boolean enabled) {
        this.m_lastPartDefaultCheckbox.setEnabled(enabled);
    }

    private void createIntervalRecordingOption(Composite parent, int indent) {
        this.createIntervalRecordingRadioButton(parent);
        this.createStartTimeChooser(parent, indent);
        this.createEndTimeChooser(parent, indent);
        this.m_startTimeChooser.setLessThan(this.m_endTimeChooser);
        this.m_endTimeChooser.setGreaterThan(this.m_startTimeChooser);
    }

    private void createIntervalRecordingRadioButton(Composite parent) {
        this.m_intervalRadioButton = new Button(parent, 16);
        this.m_intervalRadioButton.setText(Messages.BUTTON_INTERVAL_OF_RECORDING_TEXT);
        this.m_intervalRadioButton.setLayoutData((Object)this.createGridData(false, 2, 0));
        this.m_intervalRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DumpRecordingWizardPage.this.setIntervalControlsEnabled(true);
                DumpRecordingWizardPage.this.setLastPartControlsEnabled(false);
                DumpRecordingWizardPage.this.setDefaultControlsEnabled(false);
            }
        });
        this.createPadding(parent, 1);
    }

    private void createStartTimeChooser(Composite parent, int indent) {
        this.m_startTimeLabel = this.createLabel(parent, Messages.LABEL_START_TIME_TEXT);
        this.m_startTimeLabel.setLayoutData((Object)this.createGridData(false, indent));
        this.m_startTimeChooser = new DateTimeChooser(parent, 0);
        this.m_startTimeChooser.setMinimumTime(this.wizardModel.getRecordingStartTime());
        this.m_startTimeChooser.setTime(this.wizardModel.getRecordingStartTime());
        this.m_startTimeChooser.setLayoutData((Object)this.createGridData(true));
        this.createPadding(parent, 1);
    }

    private void createEndTimeChooser(Composite parent, int indent) {
        this.m_endTimeLabel = this.createLabel(parent, Messages.LABEL_END_TIME_TEXT);
        this.m_endTimeLabel.setLayoutData((Object)this.createGridData(false, indent));
        this.m_endTimeChooser = new DateTimeChooser(parent, 0);
        Date endTime = this.wizardModel.recordingEndTime();
        this.m_endTimeChooser.setMaximumTime(endTime);
        this.m_endTimeChooser.setTime(endTime);
        this.m_endTimeChooser.setLayoutData((Object)this.createGridData(true));
        this.createPadding(parent, 1);
    }

    private void setIntervalControlsEnabled(boolean enabled) {
        this.m_startTimeLabel.setEnabled(enabled);
        this.m_startTimeChooser.setEnabled(enabled);
        this.m_endTimeLabel.setEnabled(enabled);
        this.m_endTimeChooser.setEnabled(enabled);
    }

    private Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        return label;
    }

    private void createPadding(Composite parent, int horizontalSpan) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)this.createGridData(false, horizontalSpan, 0));
    }

    private GridData createGridData(boolean grabExcessHorizontalSpace) {
        return this.createGridData(grabExcessHorizontalSpace, 1, 0);
    }

    private GridData createGridData(boolean grabExcessHorizontalSpace, int indent) {
        return this.createGridData(grabExcessHorizontalSpace, 1, indent);
    }

    private GridData createGridData(boolean grabExcessHorizontalSpace, int horizontalSpan, int indent) {
        GridData gridData = new GridData(4, 0x1000000, grabExcessHorizontalSpace, false);
        gridData.horizontalSpan = horizontalSpan;
        gridData.horizontalIndent = indent;
        return gridData;
    }

    public boolean performFinish() {
        RecordingProvider recDesc = this.wizardModel.getRecordingDescriptor();
        if (this.m_lastPartScale.isEnabled()) {
            long timeToDump = this.m_lastPartIntervals[this.m_lastPartScale.getSelection()];
            if (this.m_lastPartDefaultCheckbox.getSelection()) {
                FlightRecorderUI.getDefault().setLastPartToDump(timeToDump);
            }
            new DumpRecordingJob(recDesc, this.wizardModel.getPath(), timeToDump).schedule();
        } else if (this.m_startTimeChooser.isEnabled()) {
            Date startTime = this.m_startTimeChooser.getTime();
            Date endTime = this.m_endTimeChooser.getTime();
            new DumpRecordingJob(recDesc, this.wizardModel.getPath(), startTime, endTime).schedule();
        } else {
            if (this.m_lastPartDefaultCheckbox.getSelection()) {
                FlightRecorderUI.getDefault().setDumpWhole();
            }
            new DumpRecordingJob(recDesc, this.wizardModel.getPath()).schedule();
        }
        return true;
    }

    public void dispose() {
        this.wizardModel.dispose();
        super.dispose();
    }
}

