/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.jobs;

import com.jrockit.mc.common.io.IOToolkit;
import com.jrockit.mc.core.MCFile;
import com.jrockit.mc.core.StatusFactory;
import com.jrockit.mc.flightrecorder.controlpanel.ui.RecordingProvider;
import com.jrockit.mc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.services.flr.IEventSettingsHolder;
import com.jrockit.mc.rjmx.services.flr.IFlightRecorderService;
import com.jrockit.mc.rjmx.services.flr.IRecordingDescriptor;
import java.io.Closeable;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

public class UpdateRecordingJob
extends Job {
    private final RecordingProvider recording;
    private final MCFile m_path;
    private final Map<String, ?> m_recordingOptions;
    private final IEventSettingsHolder m_recordingSettings;

    public UpdateRecordingJob(RecordingProvider recording, MCFile path, Map<String, ?> recordingOptions, IEventSettingsHolder recordingSettings) {
        super(NLS.bind((String)Messages.UPDATE_RECORDING_JOB_NAME, (Object)recording.getRecordingDescriptor().getName()));
        this.recording = recording;
        this.m_path = path;
        this.m_recordingOptions = recordingOptions;
        this.m_recordingSettings = recordingSettings;
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus iStatus;
        IRecordingDescriptor rd = this.recording.getRecordingDescriptor();
        IConnectionHandle connection = null;
        try {
            connection = this.recording.getServerHandle().connect(this.getName());
            IFlightRecorderService flightRecorderService = (IFlightRecorderService)connection.getServiceOrDummy(IFlightRecorderService.class);
            flightRecorderService.updateRecordingOptions(rd, this.m_recordingOptions);
            flightRecorderService.updateEventSettings(rd, this.m_recordingSettings);
            this.recording.setDumpToFile(this.m_path);
            iStatus = StatusFactory.createOk((String)Messages.UPDATE_RECORDING_JOB_SUCCESS_MSG);
        }
        catch (Exception e) {
            IStatus iStatus2;
            try {
                iStatus2 = StatusFactory.createErr((String)NLS.bind((String)Messages.UPDATE_RECORDING_JOB_SERVICE_ERROR_MSG, (Object)rd.getName()));
            }
            catch (Throwable throwable) {
                IOToolkit.closeSilently(connection);
                throw throwable;
            }
            IOToolkit.closeSilently((Closeable)connection);
            return iStatus2;
        }
        IOToolkit.closeSilently((Closeable)connection);
        return iStatus;
    }
}

