/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.handlers;

import com.jrockit.mc.common.io.IOToolkit;
import com.jrockit.mc.core.MCFile;
import com.jrockit.mc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.ui.AbstractFlightRecordingEditor;
import com.jrockit.mc.ui.idesupport.IDESupportUIToolkit;
import com.jrockit.mc.ui.misc.ErrorDialog;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.internal.handlers.SaveAsHandler;

public class SaveAsJFRHandler
extends SaveAsHandler {
    public Object execute(ExecutionEvent event) {
        ISaveablePart saveablePart = this.getSaveablePart(event);
        if (saveablePart != null && saveablePart instanceof AbstractFlightRecordingEditor) {
            Path srcPath;
            MCFile saveAsFile;
            File srcFile;
            AbstractFlightRecordingEditor editor = (AbstractFlightRecordingEditor)saveablePart;
            try {
                srcFile = editor.getActiveFile();
            }
            catch (IOException e) {
                ErrorDialog.showException((Shell)editor.getActiveEditor().getSite().getShell(), (String)Messages.SAVE_AS_ERROR_MSG, (String)Messages.SAVE_AS_NO_SRC_ERROR_MSG, (Throwable)e);
                return null;
            }
            if (srcFile != null && (saveAsFile = IDESupportUIToolkit.browseForSaveAsFile((String)Messages.SAVE_AS_TITLE, (String)(srcPath = new Path(srcFile.getAbsolutePath())).lastSegment(), (IPath)srcPath.removeLastSegments(1), (String)srcPath.getFileExtension(), (String)Messages.SAVE_AS_JFR_DESCRIPTION, (boolean)true)) != null) {
                try {
                    IOToolkit.copyFile((File)srcFile, (File)saveAsFile.toFile());
                    editor.setActiveFile(saveAsFile.toFile());
                }
                catch (IOException e) {
                    ErrorDialog.showException((Shell)editor.getActiveEditor().getSite().getShell(), (String)Messages.SAVE_AS_ERROR_MSG, (Throwable)e);
                    return null;
                }
            }
        }
        return null;
    }
}

