/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.actions;

import com.jrockit.mc.core.MCFile;
import com.jrockit.mc.flightrecorder.controlpanel.ui.ControlPanel;
import com.jrockit.mc.flightrecorder.controlpanel.ui.RecordingProvider;
import com.jrockit.mc.flightrecorder.controlpanel.ui.jobs.DumpRecordingJob;
import com.jrockit.mc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.RecordingWizardModel;
import com.jrockit.mc.flightrecorder.ui.FlightRecorderUI;
import com.jrockit.mc.ui.misc.AbstractWarningAction;

public class DumpLastPartRecordingAction
extends AbstractWarningAction {
    private final RecordingProvider recording;

    public DumpLastPartRecordingAction(RecordingProvider recording) {
        super(Messages.ACTION_DUMP_LAST_PART_RECORDING_LABEL, Messages.ACTION_DUMP_LAST_PART_RECORDING_TOOLTIP, ControlPanel.getDefault().getMCImageDescriptor("FLR_dump.gif"));
        this.recording = recording;
    }

    public void doExecute() throws Exception {
        long defaultTimeToDump = FlightRecorderUI.getDefault().getLastPartToDump();
        if (defaultTimeToDump > 0L) {
            String serverName = this.recording.getServerHandle().getServerDescriptor().getDisplayName();
            MCFile dumpFile = RecordingWizardModel.getDefaultRecordingFileName(serverName);
            new DumpRecordingJob(this.recording, dumpFile, defaultTimeToDump).schedule();
        }
    }
}

