/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.anchor;

import java.awt.Point;
import java.awt.Rectangle;
import org.netbeans.api.visual.anchor.AnchorShapeFactory;
import org.netbeans.api.visual.anchor.AnchorShapeLocationResolver;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.Widget;

public class DefaultAnchorShapeResolver
implements AnchorShapeLocationResolver {
    private ConnectionWidget connection = null;
    private AnchorShapeFactory.ConnectionEnd attachedEnd = AnchorShapeFactory.ConnectionEnd.SOURCE;
    private Widget attachedWidget = null;

    public DefaultAnchorShapeResolver(ConnectionWidget connectionWidget, AnchorShapeFactory.ConnectionEnd connectionEnd) {
        this(connectionWidget, connectionEnd, null);
    }

    public DefaultAnchorShapeResolver(ConnectionWidget connectionWidget, AnchorShapeFactory.ConnectionEnd connectionEnd, Widget widget) {
        this.connection = connectionWidget;
        this.attachedEnd = connectionEnd;
        this.attachedWidget = widget;
    }

    @Override
    public int getEndLocation() {
        int n = 0;
        if (this.attachedWidget != null) {
            Rectangle rectangle = this.attachedWidget.getBounds();
            n = this.getLocation(rectangle);
        } else {
            Rectangle rectangle = new Rectangle();
            if (this.attachedEnd == AnchorShapeFactory.ConnectionEnd.SOURCE) {
                Widget widget = this.getConnection().getSourceAnchor().getRelatedWidget();
                rectangle = widget.getBounds();
            } else {
                Widget widget = this.getConnection().getTargetAnchor().getRelatedWidget();
                rectangle = widget.getBounds();
            }
            n = this.getLocation(rectangle);
        }
        return n;
    }

    public Widget getAttachedWidget() {
        return this.attachedWidget;
    }

    public void setAttachedWidget(Widget widget) {
        this.attachedWidget = widget;
    }

    public ConnectionWidget getConnection() {
        return this.connection;
    }

    public AnchorShapeFactory.ConnectionEnd getAttachedEnd() {
        return this.attachedEnd;
    }

    protected int getLocation(Rectangle rectangle) {
        int n = 0;
        Point point = null;
        Rectangle rectangle2 = null;
        if (this.attachedEnd == AnchorShapeFactory.ConnectionEnd.SOURCE) {
            point = this.connection.getFirstControlPoint();
            rectangle2 = this.getSourceBounds();
        } else {
            point = this.connection.getLastControlPoint();
            rectangle2 = this.getTargetBounds();
        }
        if (rectangle2 != null) {
            if (point.x == rectangle2.x && point.y == rectangle2.y) {
                System.out.println("Top Left Corner");
                n = rectangle.width;
            } else if (point.x == rectangle2.x && point.y == rectangle2.y + rectangle2.height) {
                System.out.println("Bottom Left Corner");
                n = rectangle.width;
            }
            if (point.x == rectangle2.x + rectangle2.width && point.y == rectangle2.y) {
                System.out.println("Top Right Corner");
                n = rectangle.width;
            } else if (point.x == rectangle2.x + rectangle2.width && point.y == rectangle2.y + rectangle2.height) {
                System.out.println("Bottom Right Corner");
                n = rectangle.width;
            } else if (point.x <= rectangle2.x) {
                n = rectangle.width;
            } else if (point.x >= rectangle2.x + rectangle2.width) {
                n = rectangle.width;
            } else if (point.y <= rectangle2.y) {
                n = rectangle.height;
            } else if (point.y >= rectangle2.y + rectangle2.height) {
                n = rectangle.height;
            }
        }
        return n;
    }

    private Rectangle getSourceBounds() {
        Widget widget = this.connection.getSourceAnchor().getRelatedWidget();
        if (widget != null) {
            Point point = widget.getLocation();
            Rectangle rectangle = widget.getClientArea();
            return new Rectangle(point, rectangle.getSize());
        }
        return null;
    }

    private Rectangle getTargetBounds() {
        Widget widget = this.connection.getTargetAnchor().getRelatedWidget();
        if (widget != null) {
            Point point = widget.getLocation();
            Rectangle rectangle = widget.getClientArea();
            return new Rectangle(point, rectangle.getSize());
        }
        return null;
    }
}

