/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.actions.Bundle;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public final class LoadSnapshotAction
extends AbstractAction {
    private static File importDir;

    public LoadSnapshotAction() {
        this.putValue("ShortDescription", Bundle.LoadSnapshotAction_ActionDescr());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.loadSnapshot(false);
    }

    public void loadSnapshotOrHeapdump() {
        this.loadSnapshot(true);
    }

    private void loadSnapshot(final boolean bl) {
        JFileChooser jFileChooser = new JFileChooser();
        if (importDir != null) {
            jFileChooser.setCurrentDirectory(importDir);
        }
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(true);
        jFileChooser.setDialogType(0);
        jFileChooser.setDialogTitle(bl ? Bundle.LoadSnapshotAction_OpenSnapshotHeapdumpDialogCaption() : Bundle.LoadSnapshotAction_OpenSnapshotDialogCaption());
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = file.getName();
                if (string.endsWith(".nps")) {
                    return true;
                }
                if (string.endsWith(".npss")) {
                    return true;
                }
                return bl && string.endsWith(".hprof");
            }

            @Override
            public String getDescription() {
                return bl ? Bundle.LoadSnapshotAction_ProfilerSnapshotHeapdumpFileFilter("nps", "hprof") : Bundle.LoadSnapshotAction_ProfilerSnapshotFileFilter("nps");
            }
        });
        if (jFileChooser.showOpenDialog(WindowManager.getDefault().getMainWindow()) == 0) {
            File[] fileArray = jFileChooser.getSelectedFiles();
            final ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
            final ArrayList<File> arrayList2 = new ArrayList<File>();
            for (int i = 0; i < fileArray.length; ++i) {
                File file = fileArray[i];
                String string = file.getName();
                if (string.endsWith(".nps") || string.endsWith(".npss")) {
                    arrayList.add(FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file)));
                    continue;
                }
                if (!string.endsWith(".hprof")) continue;
                arrayList2.add(file);
            }
            if (!arrayList.isEmpty()) {
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        final LoadedSnapshot[] loadedSnapshotArray = ResultsManager.getDefault().loadSnapshots(arrayList.toArray(new FileObject[arrayList.size()]));
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ResultsManager.getDefault().openSnapshots(loadedSnapshotArray);
                            }
                        });
                    }
                });
            } else if (!bl) {
                ProfilerDialogs.displayError((String)Bundle.LoadSnapshotAction_No_Snapshot_Selected());
            }
            if (!arrayList2.isEmpty()) {
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        for (File file : arrayList2) {
                            ResultsManager.getDefault().openSnapshot(file);
                        }
                    }
                });
            }
            importDir = jFileChooser.getCurrentDirectory();
        }
    }
}

