/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.subscription.internal;

import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.internal.AbstractSyntheticAttribute;
import com.jrockit.mc.rjmx.subscription.internal.AttributeValueToolkit;
import com.jrockit.mc.rjmx.subscription.internal.SyntheticAttributeToolkit;
import java.util.Set;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;

public class HotSpotLiveSetAttribute
extends AbstractSyntheticAttribute {
    private static final String COM_SUN_MANAGEMENT_GC_NOTIFICATION = "com.sun.management.gc.notification";
    private MBeanServerConnection m_connection = null;
    private MRI[] m_notificationDescriptors = null;
    private final NotificationListener m_listener = this.createListener();
    private Double m_liveSet = null;

    @Override
    public Object getValue(MBeanServerConnection connection) throws MBeanException, ReflectionException {
        return this.m_liveSet;
    }

    @Override
    public void setValue(MBeanServerConnection connection, Object value) throws InvalidAttributeValueException, MBeanException, ReflectionException {
    }

    @Override
    public void init(MBeanServerConnection connection) {
        super.init(connection);
        this.m_connection = connection;
        Set<ObjectName> garbageCollectorMxBeans = SyntheticAttributeToolkit.lookupMxBeans(this.m_connection, "java.lang", "GarbageCollector");
        this.setInitialValue(garbageCollectorMxBeans);
        this.m_notificationDescriptors = SyntheticAttributeToolkit.createNotificationDescriptors(this.m_connection, garbageCollectorMxBeans, COM_SUN_MANAGEMENT_GC_NOTIFICATION);
        SyntheticAttributeToolkit.subscribeToNotifications(this.m_connection, this.m_listener, this.m_notificationDescriptors);
    }

    @Override
    public void stop() {
        SyntheticAttributeToolkit.unsubscribeFromNotifications(this.m_connection, this.m_listener, this.m_notificationDescriptors);
    }

    private NotificationListener createListener() {
        return new NotificationListener(){

            @Override
            public void handleNotification(Notification notification, Object handback) {
                CompositeData userData = (CompositeData)notification.getUserData();
                if (HotSpotLiveSetAttribute.this.isOldCollection(userData)) {
                    CompositeData gcInfo = (CompositeData)userData.get("gcInfo");
                    HotSpotLiveSetAttribute.this.m_liveSet = HotSpotLiveSetAttribute.this.calculateLiveSet(gcInfo);
                }
            }
        };
    }

    private void setInitialValue(Set<ObjectName> garbageCollectorMxBeans) {
        ObjectName majorGcObjectName = this.findMajorGcMbean(garbageCollectorMxBeans);
        if (majorGcObjectName != null) {
            try {
                CompositeData gcInfo = (CompositeData)AttributeValueToolkit.getAttribute(this.m_connection, majorGcObjectName, "LastGcInfo");
                if (gcInfo != null) {
                    this.m_liveSet = this.calculateLiveSet(gcInfo);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private ObjectName findMajorGcMbean(Set<ObjectName> garbageCollectorMxBeans) {
        int maxGcPools = 0;
        ObjectName majorGcObjectName = null;
        for (ObjectName objectName : garbageCollectorMxBeans) {
            try {
                int gcPools;
                Object poolNames = AttributeValueToolkit.getAttribute(this.m_connection, objectName, "MemoryPoolNames");
                if (!(poolNames instanceof String[]) || (gcPools = ((String[])poolNames).length) <= maxGcPools) continue;
                majorGcObjectName = objectName;
                maxGcPools = gcPools;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return majorGcObjectName;
    }

    private Double calculateLiveSet(CompositeData gcInfo) {
        long usedHeap = this.lookupUsedHeap(gcInfo);
        long committedHeap = this.getCommittedHeap();
        if (committedHeap > 0L) {
            return (double)usedHeap / (double)committedHeap;
        }
        return null;
    }

    private boolean isOldCollection(CompositeData data) {
        return ((String)data.get("gcAction")).indexOf("major") >= 0;
    }

    private long lookupUsedHeap(CompositeData gcInfo) {
        long usedHeap = 0L;
        TabularData memoryUsageAfterGc = (TabularData)gcInfo.get("memoryUsageAfterGc");
        for (Object memoryPool : memoryUsageAfterGc.values()) {
            usedHeap += this.getMemoryPoolUsed((CompositeData)memoryPool);
        }
        return usedHeap;
    }

    private long getMemoryPoolUsed(CompositeData memoryPool) {
        if (this.includeMemoryPool(memoryPool.get("key").toString())) {
            Long memoryPoolUsed = (Long)((CompositeData)memoryPool.get("value")).get("used");
            return memoryPoolUsed;
        }
        return 0L;
    }

    private boolean includeMemoryPool(String memoryPoolName) {
        if (memoryPoolName.equals("Code Cache")) {
            return false;
        }
        if (memoryPoolName.contains("Perm Gen")) {
            return false;
        }
        return !memoryPoolName.contains("Metaspace");
    }

    private long getCommittedHeap() {
        try {
            return ((Number)AttributeValueToolkit.getAttribute(this.m_connection, new MRI(MRI.Type.ATTRIBUTE, "java.lang:type=Memory", "HeapMemoryUsage/committed"))).longValue();
        }
        catch (Exception e) {
            return -1L;
        }
    }
}

