/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.subscription.internal;

import com.jrockit.mc.common.io.IOToolkit;
import com.jrockit.mc.common.xml.XmlEnabled;
import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.rjmx.RJMXPlugin;
import com.jrockit.mc.rjmx.subscription.IMRIMetaData;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataProviderService;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataService;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.MRIMetaDataToolkit;
import com.jrockit.mc.rjmx.subscription.internal.CompositeFileMRIMetaData;
import com.jrockit.mc.rjmx.subscription.internal.FileMRIMetaData;
import com.jrockit.mc.rjmx.subscription.internal.MRIMetaDataWrapper;
import java.io.Closeable;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class FileMRIMetaDataDB
extends Observable
implements XmlEnabled,
IMRIMetaDataService {
    private static final Logger LOGGER = Logger.getLogger("com.jrockit.mc.rjmx");
    private static final String ELEMENT_CHANGED_META_DATA = "changedMetaData";
    private static final String XML_COMPONENT_TAG = "metadatacollection";
    private final Map<MRI, Map<String, Object>> defaultMetaDataMap = new HashMap<MRI, Map<String, Object>>();
    private Map<MRI, Map<String, Object>> changedMetaDataStore = new HashMap<MRI, Map<String, Object>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMetaData(MRI mri, String key, Object value) {
        Map<MRI, Map<String, Object>> map = this.changedMetaDataStore;
        synchronized (map) {
            Map<String, Object> metaDataKeyValueMap = this.changedMetaDataStore.get(mri);
            if (metaDataKeyValueMap == null) {
                metaDataKeyValueMap = new HashMap<String, Object>();
                this.changedMetaDataStore.put(mri, metaDataKeyValueMap);
            }
            metaDataKeyValueMap.put(key, value);
            this.setChanged();
            this.notifyObservers(mri);
        }
    }

    @Override
    public Object getMetaData(MRI mri, String dataKey) {
        Map<String, Object> mriMetaDataMap = this.changedMetaDataStore.get(mri);
        if (mriMetaDataMap != null && mriMetaDataMap.containsKey(dataKey)) {
            return mriMetaDataMap.get(dataKey);
        }
        return this.getDefaultMetaData(mri, dataKey);
    }

    private Object getDefaultMetaData(MRI mri, String dataKey) {
        Object metaData = this.getNonNullMap(this.defaultMetaDataMap, mri).get(dataKey);
        if (metaData == null) {
            metaData = this.getMetaDataFromProviderService(mri, dataKey);
        }
        return metaData;
    }

    private Object getMetaDataFromProviderService(MRI mri, String dataKey) {
        Object metaData = this.getMetaDataProviderService().getMetaData(this, mri, dataKey);
        if (metaData != null) {
            this.setDefaultMetaDataValue(mri, dataKey, metaData);
        }
        return metaData;
    }

    private IMRIMetaDataProviderService getMetaDataProviderService() {
        return RJMXPlugin.getDefault().getService(IMRIMetaDataProviderService.class);
    }

    @Override
    public IMRIMetaData getMetaData(MRI mri) {
        return new MRIMetaDataWrapper(mri, this);
    }

    private void addAttributeMetaData(IMRIMetaData metaDataInfo) {
        if (metaDataInfo instanceof CompositeFileMRIMetaData) {
            IMRIMetaData[] iMRIMetaDataArray = ((CompositeFileMRIMetaData)metaDataInfo).getCompositeChildren();
            int n = iMRIMetaDataArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMRIMetaData element = iMRIMetaDataArray[n2];
                this.addAttributeMetaData(element);
                ++n2;
            }
        }
        this.setDefaultMetaDataValue(metaDataInfo.getMRI(), "UpdateTime", metaDataInfo.getUpdateTime());
        this.setDefaultMetaDataValue(metaDataInfo.getMRI(), "UnitString", metaDataInfo.getUnitString());
        this.setDefaultMetaDataValue(metaDataInfo.getMRI(), "DisplayName", metaDataInfo.getDisplayName());
        this.setDefaultMetaDataValue(metaDataInfo.getMRI(), "composite", metaDataInfo instanceof CompositeFileMRIMetaData);
        this.setDefaultMetaDataValue(metaDataInfo.getMRI(), "AttributeType", metaDataInfo.getValueType());
        this.setDefaultMetaDataValue(metaDataInfo.getMRI(), "Description", metaDataInfo.getDescription());
        if (MRIMetaDataToolkit.isNumerical(metaDataInfo) && metaDataInfo.getUnitString() == null) {
            LOGGER.warning("Unit is missing for " + metaDataInfo.getMRI());
        }
    }

    private void setDefaultMetaDataValue(MRI mri, String key, Object value) {
        Map<String, Object> metaData = this.defaultMetaDataMap.get(mri);
        if (metaData == null) {
            metaData = new HashMap<String, Object>();
            this.defaultMetaDataMap.put(mri, metaData);
        }
        metaData.put(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportToXml(Element parentNode) {
        Map<MRI, Map<String, Object>> map = this.changedMetaDataStore;
        synchronized (map) {
            XmlToolkit.setNameTypeValue((Element)parentNode, (String)ELEMENT_CHANGED_META_DATA, this.changedMetaDataStore);
        }
    }

    private void initAttributeFromXMLElement(Element e) {
        FileMRIMetaData info = null;
        info = this.hasCompositeTag(e) ? new CompositeFileMRIMetaData() : new FileMRIMetaData();
        info.initializeFromXml(e);
        this.addDefaultMetaDataValues(info);
        this.addAttributeMetaData(info);
    }

    private boolean hasCompositeTag(Element e) {
        return XmlToolkit.getChildElementOrNull((Element)e, (String)"composite") != null;
    }

    private void addDefaultMetaDataValues(FileMRIMetaData info) {
        for (Object key : info.getDefaultValues().keySet()) {
            this.setDefaultMetaDataValue(info.getMRI(), (String)key, info.getDefaultValues().get(key));
        }
        if (info instanceof CompositeFileMRIMetaData) {
            IMRIMetaData[] children;
            CompositeFileMRIMetaData compositeInfo = (CompositeFileMRIMetaData)info;
            IMRIMetaData[] iMRIMetaDataArray = children = compositeInfo.getCompositeChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IMRIMetaData element = iMRIMetaDataArray[n2];
                if (element instanceof FileMRIMetaData) {
                    this.addDefaultMetaDataValues((FileMRIMetaData)element);
                }
                ++n2;
            }
        }
    }

    private void initFromXml(Element node) {
        List nodeList = XmlToolkit.getChildElementsByTag((Node)node, (String)"metadata");
        for (Element e : nodeList) {
            this.initAttributeFromXMLElement(e);
        }
    }

    void initializeFromDefault() {
        block6: {
            InputStream is = null;
            try {
                try {
                    is = this.getClass().getResourceAsStream("mrimetadata.xml");
                    Document doc = XmlToolkit.loadDocumentFromStream((InputStream)is);
                    List elems = XmlToolkit.getChildElementsByTag((Node)doc.getDocumentElement(), (String)XML_COMPONENT_TAG);
                    if (elems.size() != 1 || elems.get(0) == null) {
                        throw new Exception("Could not find the attributes element!");
                    }
                    this.initFromXml((Element)elems.get(0));
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Tried reading mrimetadata.xml, but an exception occured: " + e.getMessage() + "Extended information about attributes may not be available, " + "and the console will not operate optimally.", e);
                    IOToolkit.closeSilently((Closeable)is);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                IOToolkit.closeSilently(is);
                throw throwable;
            }
            IOToolkit.closeSilently((Closeable)is);
        }
    }

    public String getComponentTag() {
        return XML_COMPONENT_TAG;
    }

    public synchronized void initializeFromXml(Element node) {
        this.initializeFromDefault();
        if (node == null) {
            return;
        }
        try {
            Map changedDataMap = (Map)XmlToolkit.getNameTypeValue((Element)node, (String)ELEMENT_CHANGED_META_DATA);
            if (changedDataMap != null) {
                this.changedMetaDataStore = changedDataMap;
            }
        }
        catch (DOMException e) {
            LOGGER.log(Level.FINEST, "Found no changed attribute meta data node.", e);
        }
        this.setChanged();
        this.notifyObservers();
    }

    private <K, V, C> Map<V, C> getNonNullMap(Map<K, Map<V, C>> map, K key) {
        Map<V, C> keyMap = map.get(key);
        if (keyMap == null) {
            return Collections.emptyMap();
        }
        return keyMap;
    }
}

