/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.subscription.internal;

import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.subscription.IMRIMetaData;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataService;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.internal.IValueFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;

public final class AttributeToolkit {
    private static final Comparator<IMRIMetaData> ATTRIBUTE_INFO_COMPARATOR = new ConsoleAttributeInfoAttributeComparator();
    private static final String KEY = "key";
    private static final String VALUE = "value";
    public static final String UNIT_PERCENT = "%";
    public static final String UNIT_BYTES = "bytes";
    public static final String UNIT_TIMESPAN_MS = "ms";
    public static final String UNIT_TIMESTAMP_MS_SINCE_1970 = "date";
    public static final String UNIT_TICKS = "ticks";
    public static final char VALUE_COMPOSITE_DELIMITER = '/';
    public static final char DELIMITER = '/';
    public static final String DELIMITER_STRING = "/";

    private AttributeToolkit() {
    }

    public static void prettyPrintAttributes(Map<MRI, IMRIMetaData> attributeMap, boolean printAttributes, boolean printAttributeInfo) {
        HashMap<String, HashSet<String>> domainToName = new HashMap<String, HashSet<String>>();
        HashMap<String, HashSet<IMRIMetaData>> nameToMetaData = new HashMap<String, HashSet<IMRIMetaData>>();
        for (Map.Entry<MRI, IMRIMetaData> entry : attributeMap.entrySet()) {
            HashSet<String> beans = null;
            String domain = entry.getKey().getObjectName().getDomain();
            String canonicalName = entry.getKey().getObjectName().getCanonicalName();
            beans = (HashSet<String>)domainToName.get(domain);
            if (beans == null) {
                beans = new HashSet<String>();
                domainToName.put(domain, beans);
            }
            beans.add(canonicalName);
            HashSet<IMRIMetaData> attrInfoSet = (HashSet<IMRIMetaData>)nameToMetaData.get(canonicalName);
            if (attrInfoSet == null) {
                attrInfoSet = new HashSet<IMRIMetaData>();
                nameToMetaData.put(canonicalName, attrInfoSet);
            }
            attrInfoSet.add(entry.getValue());
        }
        ArrayList sortedDomains = new ArrayList();
        sortedDomains.addAll(domainToName.keySet());
        Collections.sort(sortedDomains);
        for (String domain : sortedDomains) {
            System.out.println(domain);
            ArrayList mbeans = new ArrayList();
            mbeans.addAll((Collection)domainToName.get(domain));
            Collections.sort(mbeans);
            for (String qualName : mbeans) {
                System.out.println("\t+-" + qualName);
                if (!printAttributes) continue;
                ArrayList metaDatas = new ArrayList();
                metaDatas.addAll((Collection)nameToMetaData.get(qualName));
                Collections.sort(metaDatas, AttributeToolkit.getAttributeInfoComparator());
                for (IMRIMetaData info : metaDatas) {
                    System.out.println("\t\t+-" + info.getMRI().getDataPath());
                    if (!printAttributeInfo) continue;
                    System.out.println("\t\t\t+-UpdateTime=" + info.getUpdateTime());
                    System.out.println("\t\t\t+-Type=" + info.getValueType());
                    if (info.getDisplayName() != null) {
                        System.out.println("\t\t\t+-DisplayName: " + info.getDisplayName());
                    }
                    if (info.getDescription() == null) continue;
                    System.out.println("\t\t\t+-Description: " + info.getDescription());
                }
            }
        }
    }

    public static String prettyPrintAffinityArray(int[] affinity, boolean printNumbers) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < affinity.length) {
            int j = 0;
            while (j < 32) {
                int go = affinity[i] & 1 << j;
                if (go != 0) {
                    if (printNumbers) {
                        buf.append(String.valueOf(i * 32 + j));
                        buf.append(" ,");
                    } else {
                        buf.append('1');
                    }
                } else if (!printNumbers) {
                    buf.append('0');
                }
                ++j;
            }
            ++i;
        }
        return buf.toString();
    }

    public static Comparator<IMRIMetaData> getAttributeInfoComparator() {
        return ATTRIBUTE_INFO_COMPARATOR;
    }

    public static Properties convertMXTabularDataToMap(TabularData td) {
        Properties result = new Properties();
        for (Object value : td.values()) {
            if (!(value instanceof CompositeData)) continue;
            CompositeData cdata = (CompositeData)value;
            Object rkey = cdata.get(KEY);
            Object rvalue = cdata.get(VALUE);
            result.put(rkey, rvalue);
        }
        return result;
    }

    public static String getNiceObjectName(ObjectName name) {
        String nameStr = name.getKeyProperty("type");
        if (nameStr == null) {
            nameStr = name.getKeyProperty("name");
        }
        if (nameStr != null) {
            return nameStr;
        }
        nameStr = name.getKeyProperty("Name");
        if (nameStr == null) {
            if (name.getKeyProperty("class") != null) {
                nameStr = AttributeToolkit.getBaseClassName(name.getKeyProperty("class"));
            } else if (name.getKeyPropertyList().size() > 0) {
                int i = 0;
                int size = name.getKeyPropertyList().size();
                while (i < size) {
                    nameStr = name.getKeyProperty(name.getKeyPropertyList().keys().nextElement());
                    if (nameStr != null && nameStr.length() > 0) break;
                    ++i;
                }
            }
        }
        return nameStr == null ? "" : nameStr;
    }

    public static String getBaseClassName(String className) {
        int lastDot = className.lastIndexOf(46);
        if (lastDot != -1) {
            String shortClassName = className.substring(lastDot + 1);
            return shortClassName;
        }
        return className;
    }

    public static Object getMetaData(IConnectionHandle handle, MRI descriptor, String property) {
        IMRIMetaDataService infoService = handle.getServiceOrNull(IMRIMetaDataService.class);
        if (infoService != null) {
            return infoService.getMetaData(descriptor, property);
        }
        return null;
    }

    public static String getUnitString(IConnectionHandle handle, MRI attributeDescriptor) {
        return (String)AttributeToolkit.getMetaData(handle, attributeDescriptor, "UnitString");
    }

    public static String getUnitString(IMRIMetaDataService mds, MRI attributeDescriptor) {
        return (String)mds.getMetaData(attributeDescriptor, "UnitString");
    }

    public static MRI[] getParentMris(MRI mri) {
        String[] dataParts = AttributeToolkit.getDataPathParts(mri);
        MRI[] parentMris = new MRI[dataParts.length - 1];
        StringBuilder dataPath = new StringBuilder();
        int i = 0;
        while (i < parentMris.length) {
            dataPath.append(dataParts[i]);
            parentMris[i] = new MRI(mri.getType(), mri.getObjectName(), dataPath.toString());
            dataPath.append('/');
            ++i;
        }
        return parentMris;
    }

    public static String[] getDataPathParts(MRI mri) {
        return mri.getDataPath().split(DELIMITER_STRING);
    }

    public static IValueFilter getValueFilter(IMRIMetaData metaData) {
        String mri = metaData.getMRI().getQualifiedName();
        if ("attribute://java.lang:type=OperatingSystem/ProcessCpuLoad".equals(mri) || "attribute://java.lang:type=OperatingSystem/SystemCpuLoad".equals(mri) || "attribute://java.lang:type=OperatingSystem/SystemLoadAverage".equals(mri)) {
            return new IValueFilter(){

                @Override
                public boolean filterObject(Object value) {
                    return !(value instanceof Number) || ((Number)value).doubleValue() < 0.0;
                }
            };
        }
        return null;
    }

    private static class ConsoleAttributeInfoAttributeComparator
    implements Comparator<IMRIMetaData> {
        private ConsoleAttributeInfoAttributeComparator() {
        }

        @Override
        public int compare(IMRIMetaData arg0, IMRIMetaData arg1) {
            return arg0.getMRI().getDataPath().compareTo(arg1.getMRI().getDataPath());
        }
    }
}

