/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.subscription;

import com.jrockit.mc.common.unit.IUnit;
import com.jrockit.mc.common.unit.UnitLookup;
import com.jrockit.mc.common.util.ColorToolkit;
import com.jrockit.mc.common.util.TypeHandling;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.subscription.IMRIMetaData;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataProvider;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataService;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.internal.AttributeToolkit;
import java.awt.Color;
import java.util.HashSet;
import java.util.Set;
import javax.management.Descriptor;
import javax.management.openmbean.CompositeData;

public final class MRIMetaDataToolkit {
    private MRIMetaDataToolkit() {
        throw new AssertionError((Object)"This is a toolkit! Do not instantiate!");
    }

    public static String getDisplayName(IConnectionHandle handle, MRI mri) {
        return MRIMetaDataToolkit.getDisplayName(handle.getServiceOrNull(IMRIMetaDataService.class), mri);
    }

    public static String getDisplayName(IMRIMetaDataService service, MRI mri) {
        String displayName;
        if (service != null && (displayName = (String)service.getMetaData(mri, "DisplayName")) != null && displayName.trim().length() > 0) {
            return displayName;
        }
        StringBuilder builder = new StringBuilder();
        String attributeDisplayName = mri.getDataPath();
        if (attributeDisplayName == null) {
            return "";
        }
        boolean lastCharLowerCase = false;
        int n = 0;
        while (n < attributeDisplayName.length()) {
            char c = attributeDisplayName.charAt(n);
            if (lastCharLowerCase && Character.isUpperCase(c)) {
                builder.append(' ');
                builder.append(Character.toUpperCase(c));
            } else {
                builder.append(c);
            }
            lastCharLowerCase = Character.isLowerCase(c);
            ++n;
        }
        return builder.toString();
    }

    public static boolean isChild(MRI childCandidate, MRI parent) {
        if (!parent.getObjectName().equals(childCandidate.getObjectName()) || childCandidate.getType() != parent.getType()) {
            return false;
        }
        String parentMriDataPath = parent.getDataPath();
        String childMRIDataPath = childCandidate.getDataPath();
        if (childMRIDataPath.startsWith(parentMriDataPath)) {
            String childDataPath = childMRIDataPath.substring(parentMriDataPath.length());
            return childDataPath.indexOf("/") == 0 && childDataPath.lastIndexOf("/") == 0;
        }
        return false;
    }

    public static String getDescription(IConnectionHandle handle, MRI mri) {
        String str = (String)AttributeToolkit.getMetaData(handle, mri, "Description");
        if (str != null) {
            return str;
        }
        return "";
    }

    public static IMRIMetaData getAttributeInfo(IConnectionHandle handle, MRI descriptor) {
        IMRIMetaDataService infoService = handle.getServiceOrNull(IMRIMetaDataService.class);
        if (infoService != null) {
            return infoService.getMetaData(descriptor);
        }
        return null;
    }

    public static boolean isNumerical(IMRIMetaData info) {
        return MRIMetaDataToolkit.isNumerical(info.getValueType());
    }

    public static boolean isNumerical(String attributeType) {
        if (attributeType == null) {
            return false;
        }
        if (attributeType.equals(Integer.TYPE.getName())) {
            return true;
        }
        if (attributeType.equals(Float.TYPE.getName())) {
            return true;
        }
        if (attributeType.equals(Double.TYPE.getName())) {
            return true;
        }
        if (attributeType.equals(Long.TYPE.getName())) {
            return true;
        }
        if (attributeType.equals(Short.TYPE.getName())) {
            return true;
        }
        if (attributeType.equals(Byte.TYPE.getName())) {
            return true;
        }
        try {
            return Number.class.isAssignableFrom(Class.forName(attributeType));
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static boolean isComposite(IMRIMetaDataProvider info) {
        return MRIMetaDataToolkit.getBooleanValue(info, "composite");
    }

    public static boolean isCompositeType(String className) {
        block4: {
            if (className == null || className.length() == 0) {
                return false;
            }
            try {
                if (!TypeHandling.isPrimitive((String)className)) break block4;
                return false;
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }
        return CompositeData.class.isAssignableFrom(Class.forName(className));
    }

    public static boolean isReadable(IMRIMetaDataProvider info) {
        return MRIMetaDataToolkit.getBooleanValue(info, "Readable");
    }

    public static boolean isWritable(IMRIMetaDataProvider info) {
        return MRIMetaDataToolkit.getBooleanValue(info, "Writable");
    }

    public static Descriptor getDescriptor(IMRIMetaDataProvider info) {
        return (Descriptor)info.getMetaData("Descriptor");
    }

    public static Color getColor(IMRIMetaDataProvider info) {
        Object colorStr = info.getMetaData("color");
        if (colorStr != null) {
            return ColorToolkit.decode((String)colorStr.toString());
        }
        return ColorToolkit.getDistinguishableColor((Object)info.getMRI());
    }

    public static Double getMultiplier(IMRIMetaDataProvider info) {
        Object o = info.getMetaData("multiplier");
        return o == null ? Double.valueOf(1.0) : new Double(o.toString());
    }

    public static IUnit<?> getUnit(IMRIMetaDataProvider info) {
        String unitString = (String)info.getMetaData("UnitString");
        if (unitString != null) {
            return UnitLookup.getUnitOrDefault((String)unitString);
        }
        return null;
    }

    public static boolean getBooleanValue(IMRIMetaDataProvider info, String key) {
        Boolean b = (Boolean)info.getMetaData(key);
        if (b != null) {
            return b;
        }
        return false;
    }

    public static Set<MRI> filterAttributes(Set<MRI> mris) {
        return MRIMetaDataToolkit.filterMRIs(mris, MRI.Type.ATTRIBUTE);
    }

    public static Set<MRI> filterNotifications(Set<MRI> mris) {
        return MRIMetaDataToolkit.filterMRIs(mris, MRI.Type.NOTIFICATION);
    }

    private static Set<MRI> filterMRIs(Set<MRI> availableMRIs, MRI.Type type) {
        HashSet<MRI> filteredMRIs = new HashSet<MRI>();
        for (MRI mri : availableMRIs) {
            if (mri.getType() != type) continue;
            filteredMRIs.add(mri);
        }
        return filteredMRIs;
    }
}

