/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.services.internal;

import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.services.CouldNotCreateServiceException;
import com.jrockit.mc.rjmx.services.IServiceFactory;
import com.jrockit.mc.rjmx.services.internal.IMBeanManagerService;
import com.jrockit.mc.rjmx.services.internal.MBeanManagerService;
import com.jrockit.mc.rjmx.subscription.IMBeanHelperService;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public final class MBeanManagerServiceFactory
implements IServiceFactory<IMBeanManagerService> {
    private static final String REGISTER_MBEANS_OPERATION = "registerMBeans";
    private static final String CLASS_NAME = "com.sun.management.MissionControl";
    private static final String MBEAN_NAME = "com.sun.management:type=MissionControl";
    private static final ObjectName OBJECT_NAME = MBeanManagerServiceFactory.createObjectName();

    private static ObjectName createObjectName() {
        try {
            return new ObjectName(MBEAN_NAME);
        }
        catch (MalformedObjectNameException e) {
            throw new Error("Should not be possible: Could not make a new ObjectName com.sun.management:type=MissionControl");
        }
    }

    @Override
    public IMBeanManagerService getServiceInstance(Class<IMBeanManagerService> serviceClass, IConnectionHandle handle) throws CouldNotCreateServiceException {
        IMBeanHelperService m = handle.getServiceOrNull(IMBeanHelperService.class);
        if (m != null) {
            this.createManagerMBean(m);
            this.registerMBeans(m);
            return new MBeanManagerService();
        }
        throw new CouldNotCreateServiceException("Could not locate MBeanHelperService when creating MBeanManagerService");
    }

    private void registerMBeans(IMBeanHelperService m) throws CouldNotCreateServiceException {
        try {
            m.invokeMethod(OBJECT_NAME, REGISTER_MBEANS_OPERATION, new Object[0], new String[0]);
        }
        catch (Exception e) {
            throw new CouldNotCreateServiceException("Could not invoke registerMBeans operation on " + OBJECT_NAME + " mbean", e);
        }
    }

    private void createManagerMBean(IMBeanHelperService m) throws CouldNotCreateServiceException {
        try {
            m.createMBean(CLASS_NAME, OBJECT_NAME);
        }
        catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
        }
        catch (MBeanException mbe) {
            if (!(mbe.getTargetException() instanceof InstanceAlreadyExistsException)) {
                throw new CouldNotCreateServiceException("Could not create com.sun.management:type=MissionControl mbean", mbe);
            }
        }
        catch (Exception e) {
            throw new CouldNotCreateServiceException("Could not create com.sun.management:type=MissionControl mbean", e);
        }
    }

    @Override
    public Class<IMBeanManagerService> getServiceType() {
        return IMBeanManagerService.class;
    }
}

