/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.internal;

import com.jrockit.mc.common.jvm.JVMDescriptor;
import com.jrockit.mc.rjmx.ConnectionException;
import com.jrockit.mc.rjmx.ConnectionToolkit;
import com.jrockit.mc.rjmx.IConnectionDescriptor;
import com.jrockit.mc.rjmx.IServerDescriptor;
import com.jrockit.mc.rjmx.RJMXPlugin;
import com.jrockit.mc.rjmx.WrappedConnectionException;
import com.jrockit.mc.rjmx.internal.JMXRMISystemPropertiesProvider;
import com.jrockit.mc.rjmx.internal.MCMBeanServerConnection;
import com.jrockit.mc.rjmx.internal.TimestampHolder;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.internal.AttributeValueToolkit;
import com.jrockit.mc.rjmx.subscription.internal.InvoluntaryDisconnectException;
import java.io.Closeable;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.rmi.UnmarshalException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.JMRuntimeException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.rmi.ssl.SslRMIClientSocketFactory;

public class RJMXConnection
implements Closeable {
    private static final Logger LOGGER = Logger.getLogger("com.jrockit.mc.rjmx");
    private static final ObjectName REGISTRATION_MBEAN = RJMXConnection.createRegistrationMBeanObjectName();
    public static final String KEY_PROTOCOL_PROVIDER_PACKAGES = "jmx.remote.protocol.provider.pkgs";
    public static final String KEY_SOCKET_FACTORY = "com.sun.jndi.rmi.factory.socket";
    public static final int VALUE_DEFAULT_REMOTE_PORT_RMP = 7090;
    public static final int VALUE_DEFAULT_REMOTE_PORT_JMX = 7091;
    public static final long VALUE_RECALIBRATION_INTERVAL = 120000L;
    static final long REMOTE_START_TIME_UNDEFINED = -1L;
    private final IConnectionDescriptor m_connectionDescriptor;
    private final IServerDescriptor m_serverDescriptor;
    private volatile MCMBeanServerConnection m_server;
    private JMXConnector m_jmxc;
    private long m_serverOffset;
    private long m_lastRecalibration;
    private long m_recalibrationInterval = 120000L;
    private long m_remoteStartTime = -1L;
    private boolean m_hasInitializedAllMBeans = false;
    private final HashMap<ObjectName, MBeanInfo> m_cachedInfos = new HashMap();
    private volatile Set<ObjectName> m_cachedMBeanNames = new HashSet<ObjectName>();
    private volatile Runnable m_onFailCallback;
    private final NotificationListener m_registrationListener = new NotificationListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleNotification(Notification notification, Object handback) {
            if (notification instanceof MBeanServerNotification) {
                ObjectName name = ((MBeanServerNotification)notification).getMBeanName();
                if (notification.getType().equals("JMX.mbean.registered")) {
                    try {
                        HashMap hashMap = RJMXConnection.this.m_cachedInfos;
                        synchronized (hashMap) {
                            RJMXConnection.this.getMBeanInfo(name);
                            if (RJMXConnection.this.m_cachedMBeanNames.size() > 0) {
                                RJMXConnection.this.m_cachedMBeanNames.add(name);
                            }
                        }
                    }
                    catch (Exception e) {
                        RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Could not retrieve MBean information for " + name + '!', e);
                    }
                } else if (notification.getType().equals("JMX.mbean.unregistered")) {
                    HashMap hashMap = RJMXConnection.this.m_cachedInfos;
                    synchronized (hashMap) {
                        RJMXConnection.this.m_cachedInfos.remove(name);
                        RJMXConnection.this.m_cachedMBeanNames.remove(name);
                    }
                }
            }
        }
    };
    private final NotificationListener m_disconnectListener = new NotificationListener(){

        @Override
        public void handleNotification(Notification notification, Object handback) {
            if (notification != null && ("jmx.remote.connection.closed".equals(notification.getType()) || "jmx.remote.connection.failed".equals(notification.getType()))) {
                RJMXConnection.this.close();
                if (RJMXConnection.this.m_onFailCallback != null) {
                    RJMXConnection.this.m_onFailCallback.run();
                }
            }
        }
    };
    private final Object connectionStateLock = new Object();

    private static ObjectName createRegistrationMBeanObjectName() {
        ObjectName notificationMBean = null;
        try {
            notificationMBean = new ObjectName("JMImplementation:type=MBeanServerDelegate");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return notificationMBean;
    }

    public RJMXConnection(IConnectionDescriptor connectionDescriptor, IServerDescriptor serverDescriptor, Runnable onFailCallback) {
        if (connectionDescriptor == null) {
            throw new IllegalArgumentException("Connection descriptor must not be null!");
        }
        this.m_onFailCallback = onFailCallback;
        this.m_connectionDescriptor = connectionDescriptor;
        this.m_serverDescriptor = serverDescriptor;
    }

    public IServerDescriptor getServerDescriptor() {
        return this.m_serverDescriptor;
    }

    public IConnectionDescriptor getConnectionDescriptor() {
        return this.m_connectionDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.connectionStateLock;
        synchronized (object) {
            if (this.isConnected()) {
                this.m_server.dispose();
                this.tryRemovingListener();
                this.clearCollections();
                this.m_server = null;
                if (this.m_jmxc != null) {
                    try {
                        this.m_jmxc.close();
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.INFO, "Problem when closing connection.", e);
                    }
                    this.m_jmxc = null;
                }
            }
        }
    }

    private void clearCollections() {
        this.clearCache();
    }

    private void tryRemovingListener() {
        try {
            this.ensureConnected().removeNotificationListener(REGISTRATION_MBEAN, this.m_registrationListener);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to remove unregistration listener! Lost connection?", e);
        }
    }

    public boolean isConnected() {
        return this.m_server != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ObjectName> getMBeanNames() throws IOException {
        HashMap<ObjectName, MBeanInfo> hashMap = this.m_cachedInfos;
        synchronized (hashMap) {
            if (this.m_cachedMBeanNames.size() == 0) {
                MBeanServerConnection server = this.ensureConnected();
                this.m_cachedMBeanNames = server.queryNames(null, null);
            }
            return new HashSet<ObjectName>(this.m_cachedMBeanNames);
        }
    }

    private HashMap<ObjectName, MBeanInfo> getMBeanInfos(String domain, QueryExp query) throws MalformedObjectNameException, IOException {
        MBeanServerConnection server = this.ensureConnected();
        ObjectName objectName = null;
        int crapCounter = 0;
        if (domain != null) {
            objectName = new ObjectName(String.valueOf(domain) + ":*");
        }
        Set<ObjectName> names = server.queryNames(objectName, query);
        HashMap<ObjectName, MBeanInfo> infos = new HashMap<ObjectName, MBeanInfo>(names.size());
        for (ObjectName name : names) {
            try {
                infos.put(name, this.getMBeanInfo(name));
            }
            catch (NullPointerException e) {
                LOGGER.log(Level.WARNING, "Skipping " + name.toString() + ". Could not retrieve the MBean info for the MBean. Set log level to fine for stacktrace!");
                LOGGER.log(Level.FINE, e.getMessage(), e);
                ++crapCounter;
            }
            catch (UnmarshalException e) {
                LOGGER.log(Level.WARNING, "Skipping " + name.toString() + ". Could not retrieve the MBean info due to marshalling problems. Set log level to fine for stacktrace!");
                LOGGER.log(Level.FINE, e.getMessage(), e);
                ++crapCounter;
            }
            catch (InstanceNotFoundException e) {
                LOGGER.log(Level.WARNING, "Skipping " + name.toString() + ". It could not be found and may have been unregistered very recently. Set log level to fine to fine for stacktrace!");
                LOGGER.log(Level.FINE, e.getMessage(), e);
            }
            catch (IntrospectionException e) {
                IOException exception = new IOException("Error accessing the bean.");
                exception.initCause(e);
                throw exception;
            }
            catch (ReflectionException e) {
                IOException exception = new IOException("Error accessing the bean.");
                exception.initCause(e);
                throw exception;
            }
        }
        if (crapCounter > 0) {
            LOGGER.log(Level.WARNING, "Skipped " + crapCounter + " MBeans because of marshalling related issues.");
        }
        return infos;
    }

    private void tryToAddMBeanNotificationListener() {
        try {
            this.ensureConnected().addNotificationListener(REGISTRATION_MBEAN, this.m_registrationListener, null, null);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeMBeanInfos() throws IOException {
        HashMap<ObjectName, MBeanInfo> hashMap = this.m_cachedInfos;
        synchronized (hashMap) {
            block6: {
                if (!this.m_hasInitializedAllMBeans) {
                    try {
                        this.getMBeanInfos(null, null);
                        this.m_hasInitializedAllMBeans = true;
                    }
                    catch (MalformedObjectNameException e) {
                        if ($assertionsDisabled) break block6;
                        throw new AssertionError();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<ObjectName, MBeanInfo> getMBeanInfos() throws IOException {
        HashMap<ObjectName, MBeanInfo> hashMap = this.m_cachedInfos;
        synchronized (hashMap) {
            this.initializeMBeanInfos();
            return new HashMap<ObjectName, MBeanInfo>(this.m_cachedInfos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MBeanInfo getMBeanInfo(ObjectName mbean) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        HashMap<ObjectName, MBeanInfo> hashMap = this.m_cachedInfos;
        synchronized (hashMap) {
            MBeanServerConnection server;
            MBeanInfo mbeanInfo = this.m_cachedInfos.get(mbean);
            if (mbeanInfo == null && (mbeanInfo = (server = this.ensureConnected()).getMBeanInfo(mbean)) != null) {
                this.m_cachedInfos.put(mbean, mbeanInfo);
            }
            return mbeanInfo;
        }
    }

    public Map<MRI, Object> getAttributes(Iterable<MRI> attributes, TimestampHolder outTime) throws IOException, InstanceNotFoundException, ReflectionException {
        MBeanServerConnection server = this.ensureConnected();
        long before = 0L;
        before = System.currentTimeMillis();
        if (before - this.m_lastRecalibration > this.m_recalibrationInterval) {
            this.recalibrateTimestampOffset();
            before = System.currentTimeMillis();
        }
        Map<MRI, Object> values = AttributeValueToolkit.getAttributes(server, attributes);
        if (outTime != null) {
            outTime.timestamp = (System.currentTimeMillis() + before) / 2L + this.m_serverOffset;
        }
        return values;
    }

    public void setAttribute(MRI attribute, Object value) throws AttributeNotFoundException, InstanceNotFoundException, InvalidAttributeValueException, MBeanException, IOException, ReflectionException {
        try {
            MBeanServerConnection server = this.ensureConnected();
            AttributeValueToolkit.setAttribute(server, attribute, value);
        }
        catch (RuntimeMBeanException e) {
            throw new MBeanException(e.getTargetException(), e.getTargetException().getMessage());
        }
        catch (JMRuntimeException e) {
            throw new MBeanException(e, e.getMessage());
        }
    }

    public ObjectInstance createMBean(String className, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException, ReflectionException, MBeanException, IOException {
        MBeanServerConnection server = this.ensureConnected();
        return server.createMBean(className, name);
    }

    public Object getAttribute(MRI attribute) throws AttributeNotFoundException, MBeanException, IOException, InstanceNotFoundException, ReflectionException {
        try {
            MBeanServerConnection server = this.ensureConnected();
            return AttributeValueToolkit.getAttribute(server, attribute);
        }
        catch (JMRuntimeException e) {
            throw new MBeanException(e, e.getMessage());
        }
    }

    public String[] getDomains() throws IOException {
        MBeanServerConnection server = this.ensureConnected();
        return server.getDomains();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean connect() throws ConnectionException {
        JVMDescriptor jvmInfo = this.getServerDescriptor().getJvmInfo();
        if (jvmInfo != null && jvmInfo.getJavaVersion() != null && !ConnectionToolkit.isJDKVersionAboveOrEqual(jvmInfo.getJavaVersion(), 1.5f)) {
            throw new ConnectionException("Too low JDK Version. JDK 1.5 or higher is supported.");
        }
        Object object = this.connectionStateLock;
        synchronized (object) {
            JMXServiceURL url;
            if (this.isConnected()) {
                return false;
            }
            try {
                url = this.m_connectionDescriptor.createJMXServiceURL();
            }
            catch (IOException e1) {
                throw new WrappedConnectionException(this.toString(), null, e1);
            }
            try {
                String hostName = ConnectionToolkit.getHostName(url);
                if (hostName != null && hostName.equals("localhost") && ConnectionToolkit.getPort(url) == 0) {
                    this.m_server = new MCMBeanServerConnection(ManagementFactory.getPlatformMBeanServer());
                } else {
                    this.establishConnection(url, this.m_connectionDescriptor.getEnvironment());
                }
                this.tryToAddMBeanNotificationListener();
                this.setRemoteStartTime(this.fetchServerStartTime());
                this.recalibrateTimestampOffset();
                return true;
            }
            catch (Exception e) {
                this.m_server = null;
                throw new WrappedConnectionException(this.toString(), url, e);
            }
        }
    }

    private long fetchServerStartTime() throws AttributeNotFoundException, MBeanException, IOException, ReflectionException, MalformedObjectNameException {
        try {
            return ((Number)this.getAttribute(new MRI(MRI.Type.ATTRIBUTE, new ObjectName("java.lang:type=Runtime"), "StartTime"))).longValue();
        }
        catch (InstanceNotFoundException e) {
            LOGGER.log(Level.WARNING, "Could not find the Runtime MBean. You are probably connecting to a custom MBean server. Functionality will be limited.", e);
            return -1L;
        }
    }

    private void establishConnection(JMXServiceURL serviceURL, Map<String, Object> env) throws IOException {
        try {
            this.connectJmxConnector(serviceURL, env);
        }
        catch (IOException exception) {
            try {
                if (env.get(KEY_SOCKET_FACTORY) instanceof SslRMIClientSocketFactory) {
                    env.remove(KEY_SOCKET_FACTORY);
                } else {
                    env.put(KEY_SOCKET_FACTORY, new SslRMIClientSocketFactory());
                }
                this.connectJmxConnector(serviceURL, env);
            }
            catch (IOException ioe) {
                throw exception;
            }
        }
        this.m_server = new MCMBeanServerConnection(this.m_jmxc.getMBeanServerConnection());
    }

    private void connectJmxConnector(JMXServiceURL serviceURL, Map<String, Object> env) throws IOException {
        this.m_jmxc = JMXConnectorFactory.newJMXConnector(serviceURL, env);
        this.m_jmxc.addConnectionNotificationListener(this.m_disconnectListener, null, null);
        JMXRMISystemPropertiesProvider.setup();
        this.m_jmxc.connect(env);
    }

    public long getRemoteStartTime() {
        return this.m_remoteStartTime;
    }

    private void setRemoteStartTime(long remoteStartTime) {
        this.m_remoteStartTime = remoteStartTime;
    }

    private void recalibrateTimestampOffset() {
        long uptime;
        if (this.getRemoteStartTime() == -1L) {
            return;
        }
        long startTime = System.currentTimeMillis();
        try {
            uptime = ((Number)this.getAttribute(new MRI(MRI.Type.ATTRIBUTE, new ObjectName("java.lang:type=Runtime"), "Uptime"))).longValue();
        }
        catch (Exception e) {
            uptime = 0L;
        }
        long returnTime = System.currentTimeMillis();
        long estimate = (startTime + returnTime) / 2L;
        this.m_serverOffset = this.getRemoteStartTime() + uptime - estimate;
        this.m_lastRecalibration = returnTime;
    }

    public long getRecalibrationInterval() {
        return this.m_recalibrationInterval;
    }

    public void setRecalibrationInterval(long recalibrationInterval) {
        this.m_recalibrationInterval = recalibrationInterval;
    }

    public long getApproximateServerTime(long localTime) {
        return localTime + this.m_serverOffset;
    }

    public MBeanServerConnection getMBeanServer() {
        return this.m_server;
    }

    public IConnectionDescriptor getDescriptor() {
        return this.m_connectionDescriptor;
    }

    private MBeanServerConnection ensureConnected() throws IOException {
        MCMBeanServerConnection server = this.m_server;
        if (server == null) {
            throw new InvoluntaryDisconnectException("Server is disconnected!");
        }
        return server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        HashMap<ObjectName, MBeanInfo> hashMap = this.m_cachedInfos;
        synchronized (hashMap) {
            this.m_cachedInfos.clear();
            this.m_cachedMBeanNames.clear();
            this.m_hasInitializedAllMBeans = false;
        }
    }

    public String toString() {
        return this.m_serverDescriptor == null ? super.toString() : this.m_serverDescriptor.getDisplayName();
    }
}

