/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx;

import com.jrockit.mc.common.jvm.JVMDescriptor;
import com.jrockit.mc.common.jvm.JVMType;
import com.jrockit.mc.rjmx.ConnectionToolkit;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.IServerHandle;
import com.jrockit.mc.rjmx.Messages;
import com.jrockit.mc.rjmx.ServerToolkit;

public final class JVMSupportToolkit {
    private JVMSupportToolkit() {
        throw new IllegalArgumentException("Don't instantiate this toolkit");
    }

    public static String[] checkSupport(IConnectionHandle connection) {
        String title = null;
        String message = null;
        if (ConnectionToolkit.isJRockit(connection)) {
            title = Messages.JVMSupport_TITLE_JROCKIT_NOT_SUPPORTED;
            message = Messages.JVMSupport_MESSAGE_JROCKIT_NOT_SUPPORTED;
        } else if (!ConnectionToolkit.isHotSpot(connection)) {
            title = Messages.JVMSupport_TITLE_NOT_A_KNOWN_JVM;
            message = Messages.JVMSupport_MESSAGE_NOT_A_KNOWN_JVM;
        } else if (!ConnectionToolkit.isHotspotVersionAboveOrEqual(connection, 23.0f)) {
            title = Messages.JVMSupport_TITLE_TOO_OLD_JVM;
            message = Messages.JVMSupport_MESSAGE_TOO_OLD_JVM;
        }
        if (title != null) {
            String[] returnInfo = new String[]{title, message};
            return returnInfo;
        }
        return new String[0];
    }

    public static String checkFlightRecorderSupport(IConnectionHandle handle, boolean shortMessage) {
        if (ConnectionToolkit.isJRockit(handle)) {
            return JVMSupportToolkit.getJFRJRockitNotSupported(shortMessage);
        }
        if (!ConnectionToolkit.isHotSpot(handle)) {
            return JVMSupportToolkit.getJFRNonHotSpotNotSupported(shortMessage);
        }
        if (!ConnectionToolkit.isHotspotVersionAboveOrEqual(handle, 23.0f)) {
            return JVMSupportToolkit.getJFROldHotSpotNotSupported(shortMessage);
        }
        return null;
    }

    public static String checkFlightRecorderSupport(IServerHandle server, boolean shortMessage) {
        if (ServerToolkit.getJvmInfo(server) != null) {
            JVMDescriptor jvmInfo = ServerToolkit.getJvmInfo(server);
            if (jvmInfo.getJvmType() == null) {
                return null;
            }
            if (jvmInfo.getJvmType() == JVMType.JROCKIT) {
                return JVMSupportToolkit.getJFRJRockitNotSupported(shortMessage);
            }
            if (jvmInfo.getJvmType() == JVMType.UNKNOWN) {
                return null;
            }
            if (jvmInfo.getJvmType() != JVMType.HOTSPOT) {
                return JVMSupportToolkit.getJFRNonHotSpotNotSupported(shortMessage);
            }
            if (jvmInfo.getJavaVersion() == null) {
                return null;
            }
            if (!ConnectionToolkit.isJDKVersionAboveOrEqual(jvmInfo.getJavaVersion(), 1.7f)) {
                return JVMSupportToolkit.getJFROldHotSpotNotSupported(shortMessage);
            }
        }
        return null;
    }

    private static String getJFROldHotSpotNotSupported(boolean shortMessage) {
        return shortMessage ? Messages.JVMSupport_FLIGHT_RECORDER_NOT_SUPPORTED_OLD_HOTSPOT_SHORT : Messages.JVMSupport_FLIGHT_RECORDER_NOT_SUPPORTED_OLD_HOTSPOT;
    }

    private static String getJFRNonHotSpotNotSupported(boolean shortMessage) {
        return shortMessage ? Messages.JVMSupport_FLIGHT_RECORDER_NOT_SUPPORTED_NOT_HOTSPOT_SHORT : Messages.JVMSupport_FLIGHT_RECORDER_NOT_SUPPORTED_NOT_HOTSPOT;
    }

    private static String getJFRJRockitNotSupported(boolean shortMessage) {
        return shortMessage ? Messages.JVMSupport_JROCKIT_NOT_LONGER_SUPPORTED_SHORT : Messages.JVMSupport_JROCKIT_NOT_LONGER_SUPPORTED;
    }
}

