/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.notification.action;

import com.jrockit.mc.alert.AlertObject;
import com.jrockit.mc.alert.AlertPlugin;
import com.jrockit.mc.alert.NotificationUIToolkit;
import com.jrockit.mc.console.ui.ConsolePlugin;
import com.jrockit.mc.console.ui.notification.NotificationPlugin;
import com.jrockit.mc.console.ui.notification.action.Messages;
import com.jrockit.mc.console.ui.notification.action.TriggerActionJFRToolkit;
import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.MCFile;
import com.jrockit.mc.core.StatusFactory;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.services.flr.FlightRecorderException;
import com.jrockit.mc.rjmx.services.flr.IFlightRecorderService;
import com.jrockit.mc.rjmx.services.flr.IRecordingDescriptor;
import com.jrockit.mc.rjmx.services.flr.RecordingOptionsBuilder;
import com.jrockit.mc.rjmx.triggers.TriggerAction;
import com.jrockit.mc.rjmx.triggers.TriggerEvent;
import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.idesupport.OpenHandler;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;

public class TriggerActionStartTimeBoundJFR
extends TriggerAction {
    public static final int MAX_CONTINUOUS_ERROR_COUNT = 10;
    private int recordingNumber = 0;

    public void handleNotificationEvent(TriggerEvent event) throws FlightRecorderException {
        IFlightRecorderService service = (IFlightRecorderService)event.getSource().getServiceOrNull(IFlightRecorderService.class);
        if (service == null) {
            ConsolePlugin.getDefault().getLogger().severe("There is no flight recorder available on the " + event.getSource().getServerDescriptor().getDisplayName() + " JVM");
            return;
        }
        this.startTimeBoundJFR(service, event);
    }

    private void startTimeBoundJFR(IFlightRecorderService service, TriggerEvent event) throws FlightRecorderException {
        long millis = this.getSetting("timerange").getLong();
        RecordingOptionsBuilder b = new RecordingOptionsBuilder();
        b.duration(millis);
        String name = this.getSetting("name").getString();
        if (++this.recordingNumber > 1) {
            name = String.valueOf(name) + " " + this.recordingNumber;
        }
        b.name(name);
        MCFile path = this.getUniqueFile(this.getSetting("file").getFileName());
        IRecordingDescriptor descriptor = service.start(b.build(), TriggerActionJFRToolkit.getTemplate("Profiling", service));
        boolean open = this.getSetting("open").getBoolean();
        if (!descriptor.isContinuous()) {
            new WaitAndOpenJob(service, descriptor, event, path, open).schedule(millis);
        }
    }

    private MCFile getUniqueFile(String name) {
        File f = new File(name);
        if (!f.exists()) {
            return CorePlugin.getDefault().getIDESupport().fromPath((IPath)new Path(name));
        }
        String file = f.getName();
        String suffix = "";
        int suffixStart = file.lastIndexOf(46);
        if (suffixStart != -1) {
            suffix = file.substring(suffixStart + 1);
            file = file.substring(0, suffixStart);
        }
        return CorePlugin.getDefault().getIDESupport().getValidDefaultFile(file, suffix);
    }

    private IPath dumpFile(IProgressMonitor monitor, IFlightRecorderService service, IRecordingDescriptor descriptor, MCFile path) throws IOException, FlightRecorderException {
        return path.writeStreamToUnique((InputStream)new GZIPInputStream(service.openStream(descriptor, false)), monitor);
    }

    private void openFile(final IPath path) {
        final OpenHandler handler = UIPlugin.getDefault().getFiletypeManager().getFileOpener(path.getFileExtension());
        if (handler != null) {
            DisplayToolkit.safeAsyncExec((Display)NotificationPlugin.getDefault().getWorkbench().getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    IWorkbenchWindow window = NotificationPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
                    handler.open(window, (Object)path.toFile());
                }
            });
        }
    }

    private void showAlert(IPath path, TriggerEvent event) {
        AlertObject ao = new AlertObject(event.getCreationTime(), event.getSource(), event.getRule(), NotificationUIToolkit.prettyPrint((TriggerEvent)event, (String)NLS.bind((String)Messages.TriggerActionStartTimeBoundJFR_MESSAGE_RECORDING_SUCCESSFUL_PATH, (Object)path.toOSString())), null);
        AlertPlugin.getDefault().addAlertObject(ao);
    }

    public boolean supportsAction(IConnectionHandle handle) {
        return handle.getServiceOrNull(IFlightRecorderService.class) != null;
    }

    private class WaitAndOpenJob
    extends Job {
        private final IFlightRecorderService m_service;
        private IRecordingDescriptor m_descriptor;
        private final MCFile m_path;
        private int m_updateErrorCount;
        private boolean m_open;
        private TriggerEvent m_event;

        public WaitAndOpenJob(IFlightRecorderService service, IRecordingDescriptor descriptor, TriggerEvent event, MCFile path, boolean open) {
            super(descriptor.getName());
            this.m_updateErrorCount = 0;
            this.m_service = service;
            this.m_descriptor = descriptor;
            this.m_event = event;
            this.m_path = path;
            this.m_open = open;
        }

        protected IStatus run(IProgressMonitor monitor) {
            block8: {
                try {
                    this.m_descriptor = this.m_service.getUpdatedRecordingDescription(this.m_descriptor);
                    this.m_updateErrorCount = 0;
                }
                catch (FlightRecorderException e) {
                    ConsolePlugin.getDefault().getLogger().severe("Problem updating a flight recording on the " + this.m_descriptor.getName() + " JVM");
                    if (++this.m_updateErrorCount <= 10) break block8;
                    return StatusFactory.createErr((String)NLS.bind((String)Messages.TriggerActionStartTimeBoundJFR_UPDATE_STATUS_ERROR_MSG, (Object)this.m_descriptor.getName()), (Throwable)e, (boolean)false);
                }
            }
            if (this.m_descriptor.getState() != IRecordingDescriptor.RecordingState.STOPPED) {
                this.schedule(1000L);
                return Status.OK_STATUS;
            }
            try {
                IPath writtenFile = TriggerActionStartTimeBoundJFR.this.dumpFile(monitor, this.m_service, this.m_descriptor, this.m_path);
                if (this.m_open) {
                    TriggerActionStartTimeBoundJFR.this.openFile(writtenFile);
                } else {
                    TriggerActionStartTimeBoundJFR.this.showAlert(writtenFile, this.m_event);
                }
                return StatusFactory.createOk((String)NLS.bind((String)Messages.WriteAndOpenRecordingJob_MESSAGE_SUCCESSFUL_DUMP, (Object)this.m_descriptor.getName()));
            }
            catch (FlightRecorderException e) {
                return StatusFactory.createErr((String)NLS.bind((String)Messages.TriggerActionStartTimeBoundJFR_SERVICE_ERROR_MSG, (Object)this.m_descriptor.getName()), (Throwable)e, (boolean)false);
            }
            catch (IOException e) {
                return StatusFactory.createErr((String)NLS.bind((String)Messages.TriggerActionStartTimeBoundJFR_IO_ERROR_MSG, (Object)this.m_descriptor.getName()), (Throwable)e, (boolean)false);
            }
        }
    }
}

