/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr;

import java.io.IOException;
import java.net.InetAddress;
import jdk.jfr.events.SocketWriteEvent;
import oracle.jrockit.jfr.JIInstrumentationMethod;
import oracle.jrockit.jfr.JIInstrumentationTarget;
import oracle.jrockit.jfr.JITracer;
import oracle.jrockit.jfr.JITypeMapping;

@JIInstrumentationTarget(value="java.net.SocketOutputStream")
@JITypeMapping(from="oracle.jrockit.jfr.SocketOutputStreamInstrumentor$AbstractPlainSocketImpl", to="java.net.AbstractPlainSocketImpl")
final class SocketOutputStreamInstrumentor {
    private AbstractPlainSocketImpl impl = null;

    private SocketOutputStreamInstrumentor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JIInstrumentationMethod
    private void socketWrite(byte[] byArray, int n, int n2) throws IOException {
        if (!JITracer.socketWriteToken.isEnabled()) {
            this.socketWrite(byArray, n, n2);
            return;
        }
        SocketWriteEvent socketWriteEvent = new SocketWriteEvent(JITracer.socketWriteToken);
        int n3 = -1;
        try {
            socketWriteEvent.begin();
            this.socketWrite(byArray, n, n2);
            n3 = n2;
        }
        finally {
            String string = this.impl.address.toString();
            int n4 = string.lastIndexOf(47);
            socketWriteEvent.host = string.substring(0, n4);
            socketWriteEvent.address = string.substring(n4 + 1);
            socketWriteEvent.port = this.impl.port;
            socketWriteEvent.bytesWritten = n3;
            socketWriteEvent.commit();
        }
    }

    static class AbstractPlainSocketImpl {
        InetAddress address;
        int port;

        AbstractPlainSocketImpl() {
        }
    }
}

