/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr;

import java.io.IOException;
import java.nio.ByteBuffer;
import jdk.jfr.events.FileReadEvent;
import jdk.jfr.events.FileWriteEvent;
import oracle.jrockit.jfr.JIInstrumentationMethod;
import oracle.jrockit.jfr.JIInstrumentationTarget;
import oracle.jrockit.jfr.JITracer;

@JIInstrumentationTarget(value="sun.nio.ch.FileChannelImpl")
final class FileChannelImplInstrumentor {
    private String path;

    private FileChannelImplInstrumentor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JIInstrumentationMethod
    public int read(ByteBuffer byteBuffer) throws IOException {
        if (!JITracer.fileReadToken.isEnabled()) {
            return this.read(byteBuffer);
        }
        FileReadEvent fileReadEvent = new FileReadEvent(JITracer.fileReadToken);
        int n = -1;
        try {
            fileReadEvent.begin();
            n = this.read(byteBuffer);
        }
        finally {
            fileReadEvent.bytesRead = n;
            fileReadEvent.path = this.path;
            fileReadEvent.commit();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JIInstrumentationMethod
    public int read(ByteBuffer byteBuffer, long l) throws IOException {
        if (!JITracer.fileReadToken.isEnabled()) {
            return this.read(byteBuffer, l);
        }
        FileReadEvent fileReadEvent = new FileReadEvent(JITracer.fileReadToken);
        int n = -1;
        try {
            fileReadEvent.begin();
            n = this.read(byteBuffer, l);
        }
        finally {
            fileReadEvent.bytesRead = n;
            fileReadEvent.path = this.path;
            fileReadEvent.commit();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JIInstrumentationMethod
    public long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        if (!JITracer.fileReadToken.isEnabled()) {
            return this.read(byteBufferArray, n, n2);
        }
        FileReadEvent fileReadEvent = new FileReadEvent(JITracer.fileReadToken);
        long l = -1L;
        try {
            fileReadEvent.begin();
            l = this.read(byteBufferArray, n, n2);
        }
        finally {
            fileReadEvent.bytesRead = l;
            fileReadEvent.path = this.path;
            fileReadEvent.commit();
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JIInstrumentationMethod
    public int write(ByteBuffer byteBuffer) throws IOException {
        if (!JITracer.fileWriteToken.isEnabled()) {
            return this.write(byteBuffer);
        }
        FileWriteEvent fileWriteEvent = new FileWriteEvent(JITracer.fileWriteToken);
        int n = -1;
        try {
            fileWriteEvent.begin();
            n = this.write(byteBuffer);
        }
        finally {
            fileWriteEvent.bytesWritten = n;
            fileWriteEvent.path = this.path;
            fileWriteEvent.commit();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JIInstrumentationMethod
    public int write(ByteBuffer byteBuffer, long l) throws IOException {
        if (!JITracer.fileWriteToken.isEnabled()) {
            return this.write(byteBuffer, l);
        }
        FileWriteEvent fileWriteEvent = new FileWriteEvent(JITracer.fileWriteToken);
        int n = -1;
        try {
            fileWriteEvent.begin();
            n = this.write(byteBuffer, l);
        }
        finally {
            fileWriteEvent.bytesWritten = n;
            fileWriteEvent.path = this.path;
            fileWriteEvent.commit();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JIInstrumentationMethod
    public long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        if (!JITracer.fileWriteToken.isEnabled()) {
            return this.write(byteBufferArray, n, n2);
        }
        FileWriteEvent fileWriteEvent = new FileWriteEvent(JITracer.fileWriteToken);
        long l = -1L;
        try {
            fileWriteEvent.begin();
            l = this.write(byteBufferArray, n, n2);
        }
        finally {
            fileWriteEvent.bytesWritten = l;
            fileWriteEvent.path = this.path;
            fileWriteEvent.commit();
        }
        return l;
    }
}

