/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.io.CharConversionException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Caret;
import org.netbeans.api.search.SearchHistory;
import org.netbeans.api.search.SearchPattern;
import org.netbeans.modules.search.Bundle;
import org.netbeans.modules.search.MatchingObject;
import org.netbeans.modules.search.Selectable;
import org.netbeans.modules.search.ui.ReplaceCheckableNode;
import org.netbeans.modules.search.ui.ResultsOutlineSupport;
import org.netbeans.modules.search.ui.UiUtils;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.text.Line;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.xml.XMLUtil;

public final class TextDetail
implements Selectable {
    private static final Logger LOG = Logger.getLogger(TextDetail.class.getName());
    private static final RequestProcessor RP = new RequestProcessor(TextDetail.class);
    public static final int DH_SHOW = 1;
    public static final int DH_GOTO = 2;
    public static final int DH_HIDE = 3;
    private DataObject dobj;
    private int line;
    private String lineText;
    private int column;
    private int markLength;
    private Line lineObj;
    private List<SurroundingLine> surroundingLines = null;
    private SearchPattern searchPattern;
    private int startOffset;
    private int endOffset;
    private String matchedText;
    private boolean selected = true;
    private String lineNumberIndent = "";
    private boolean showAfterDataObjectUpdated = false;
    private ChangeSupport changeSupport = new ChangeSupport((Object)this);

    public TextDetail(DataObject dataObject, SearchPattern searchPattern) {
        this.dobj = dataObject;
        this.searchPattern = searchPattern;
    }

    public void showDetail(final int n) {
        this.prepareLine();
        if (this.lineObj == null) {
            Toolkit.getDefaultToolkit().beep();
            EditCookie editCookie = (EditCookie)this.dobj.getLookup().lookup(EditCookie.class);
            if (editCookie != null) {
                editCookie.edit();
                this.showAfterDataObjectUpdated = true;
            }
            return;
        }
        if (n == 3) {
            return;
        }
        final EditorCookie editorCookie = (EditorCookie)this.dobj.getLookup().lookup(EditorCookie.class);
        if (editorCookie != null) {
            Task task = editorCookie.prepareDocument();
            task.addTaskListener(new TaskListener(){

                public void taskFinished(Task task) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            editorCookie.open();
                            TextDetail.this.showLine(n);
                            TextDetail.this.highlightDetail(editorCookie);
                        }
                    });
                }
            });
        } else {
            this.showLine(n);
        }
        SearchHistory.getDefault().add(SearchPattern.create(this.searchPattern.getSearchExpression(), this.searchPattern.isWholeWords(), this.searchPattern.isMatchCase(), this.searchPattern.isRegExp()));
    }

    private void showLine(int n) {
        if (n == 1) {
            this.lineObj.show(Line.ShowOpenType.NONE, Line.ShowVisibilityType.NONE, this.column - 1);
        } else if (n == 2) {
            this.lineObj.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS, this.column - 1);
        }
    }

    private void highlightDetail(EditorCookie editorCookie) {
        JEditorPane[] jEditorPaneArray;
        if (this.markLength > 0 && (jEditorPaneArray = editorCookie.getOpenedPanes()) != null && jEditorPaneArray.length > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        Caret caret = jEditorPaneArray[0].getCaret();
                        caret.moveDot(caret.getDot() + TextDetail.this.markLength);
                    }
                    catch (Exception exception) {
                        StatusDisplayer.getDefault().setStatusText(Bundle.MSG_CannotShowTextDetai());
                        LOG.log(Level.FINE, Bundle.MSG_CannotShowTextDetai(), exception);
                    }
                }
            });
        }
    }

    public String getLineText() {
        return this.lineText;
    }

    public void setLineText(String string) {
        this.lineText = string;
    }

    String getLineTextPart(int n, int n2) {
        if (n >= 0 && n <= n2) {
            return this.lineText.substring(n, n2);
        }
        LOG.log(Level.WARNING, "Invalid range: beginIndex = {0}, endIndex = {1}.", new Object[]{n, n2});
        return this.lineText.substring(Math.max(0, n), Math.max(0, Math.max(n, n2)));
    }

    String getLineTextPart(int n) {
        return this.lineText.substring(n);
    }

    public int getLineTextLength() {
        return this.lineText == null ? 0 : this.lineText.length();
    }

    public DataObject getDataObject() {
        return this.dobj;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int n) {
        this.line = n;
    }

    public int getColumn() {
        return this.column;
    }

    public void setColumn(int n) {
        this.column = n;
    }

    int getColumn0() {
        return this.column - 1;
    }

    public void setMarkLength(int n) {
        this.markLength = n;
    }

    public int getMarkLength() {
        return this.markLength;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public void setEndOffset(int n) {
        this.endOffset = n;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public void setStartOffset(int n) {
        this.startOffset = n;
    }

    public String getMatchedText() {
        return this.matchedText;
    }

    public void setMatchedText(String string) {
        this.matchedText = string;
    }

    public void associate(int n, int n2, String string) {
        this.setLine(n);
        this.setColumn(n2);
        this.setLineText(string);
    }

    private void prepareLine() {
        LineCookie lineCookie;
        if (this.dobj == null || !this.dobj.isValid()) {
            this.lineObj = null;
        } else if (this.lineObj == null && (lineCookie = (LineCookie)this.dobj.getLookup().lookup(LineCookie.class)) != null) {
            Line.Set set = lineCookie.getLineSet();
            try {
                this.lineObj = set.getOriginal(this.line - 1);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.lineObj = set.getOriginal(TextDetail.findMaxLine(set));
                this.markLength = 0;
                this.column = 0;
            }
        }
    }

    public void addSurroundingLine(int n, String string) {
        if (this.surroundingLines == null) {
            this.surroundingLines = new ArrayList<SurroundingLine>(5);
        }
        this.surroundingLines.add(new SurroundingLine(n, string));
    }

    private static int findMaxLine(Line.Set set) {
        int n = 0;
        int n2 = 32000;
        try {
            while (true) {
                set.getOriginal(n2);
                n = n2;
                n2 *= 2;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            while (n < n2) {
                int n3 = (n + n2 + 1) / 2;
                try {
                    set.getOriginal(n3);
                    n = n3;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException2) {
                    n2 = n3 - 1;
                }
            }
            return n;
        }
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setSelected(boolean bl) {
        if (this.selected != bl) {
            this.selected = bl;
            this.fireChange();
        }
    }

    @Override
    public void setSelectedRecursively(boolean bl) {
        this.setSelected(bl);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    public void fireChange() {
        this.changeSupport.fireChange();
    }

    public void updateDataObject(DataObject dataObject) {
        if (this.dobj.getPrimaryFile().equals(dataObject.getPrimaryFile())) {
            this.dobj = dataObject;
            this.lineObj = null;
            if (this.showAfterDataObjectUpdated) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TextDetail.this.showDetail(2);
                    }
                });
                this.showAfterDataObjectUpdated = false;
            }
        } else {
            throw new IllegalArgumentException("Expected data object for the same file");
        }
    }

    void setLineNumberIndent(String string) {
        this.lineNumberIndent = string;
    }

    private class SurroundingLine {
        private final int number;
        private final String text;

        public SurroundingLine(int n, String string) {
            this.number = n;
            this.text = string;
        }

        public int getNumber() {
            return this.number;
        }

        public String getText() {
            return this.text;
        }
    }

    private static class GotoDetailAction
    extends AbstractAction {
        private DetailNode detailNode;

        public GotoDetailAction(DetailNode detailNode) {
            super(UiUtils.getText("LBL_GotoDetailAction"));
            this.detailNode = detailNode;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.detailNode.gotoDetail();
        }
    }

    static final class DetailNode
    extends AbstractNode
    implements OutputListener {
        private static final String ICON = "org/netbeans/modules/search/res/textDetail.png";
        static final int DETAIL_DISPLAY_LENGTH = 240;
        private static final String ELLIPSIS = "...";
        private TextDetail txtDetail;
        private String name;
        private String htmlDisplayName;
        private final MatchingObject mo;

        public DetailNode(TextDetail textDetail, boolean bl, MatchingObject matchingObject) {
            super(Children.LEAF, Lookups.fixed((Object[])new Object[]{textDetail, new ReplaceCheckableNode(textDetail, bl)}));
            this.txtDetail = textDetail;
            this.mo = matchingObject;
            this.setValue("output line", DetailNode.getFullDesc(textDetail));
            RP.post(new Runnable(){

                @Override
                public void run() {
                    DetailNode.this.txtDetail.prepareLine();
                }
            });
            textDetail.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    DetailNode.this.fireIconChange();
                    ResultsOutlineSupport.toggleParentSelected(DetailNode.this.getParentNode());
                }
            });
            this.setIconBaseWithExtension(ICON);
        }

        public Action[] getActions(boolean bl) {
            if (!bl) {
                return new Action[]{this.getPreferredAction()};
            }
            return new Action[0];
        }

        public String getShortDescription() {
            if (this.txtDetail.surroundingLines == null || this.txtDetail.surroundingLines.isEmpty()) {
                return super.getShortDescription();
            }
            StringBuilder stringBuilder = new StringBuilder("<html>");
            try {
                boolean bl = false;
                for (SurroundingLine surroundingLine : this.txtDetail.surroundingLines) {
                    if (this.txtDetail.getLine() == surroundingLine.getNumber() - 1) {
                        this.appendMarkedText(stringBuilder);
                        stringBuilder.append("<br/>");
                        bl = true;
                    }
                    stringBuilder.append(DetailNode.escape(surroundingLine.getText()));
                    stringBuilder.append("<br/>");
                }
                if (!bl) {
                    this.appendMarkedText(stringBuilder);
                }
            }
            catch (CharConversionException charConversionException) {
                return null;
            }
            stringBuilder.append("</html>");
            return stringBuilder.toString();
        }

        public Action getPreferredAction() {
            return new GotoDetailAction(this);
        }

        public boolean equals(Object object) {
            return object != null && object.getClass() == DetailNode.class && ((DetailNode)((Object)object)).txtDetail.equals(this.txtDetail);
        }

        public int hashCode() {
            return this.txtDetail.hashCode() + 1;
        }

        public String getName() {
            if (this.name == null) {
                this.name = this.cutLongLine(this.txtDetail.getLineText()) + "      [" + DetailNode.getName(this.txtDetail) + "]";
            }
            return this.name;
        }

        public String getHtmlDisplayName() {
            if (this.htmlDisplayName != null) {
                return this.htmlDisplayName;
            }
            try {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("<html><font color='!controlShadow'>");
                stringBuilder.append(this.txtDetail.lineNumberIndent);
                stringBuilder.append(this.txtDetail.getLine());
                stringBuilder.append(": ");
                stringBuilder.append("</font>");
                if (this.canBeMarked()) {
                    this.appendMarkedText(stringBuilder);
                } else {
                    stringBuilder.append(DetailNode.escape(this.cutLongLine(this.txtDetail.getLineText())));
                }
                stringBuilder.append("      ");
                stringBuilder.append("<font color='!controlShadow'>[");
                stringBuilder.append(DetailNode.escape(DetailNode.getLinePos(this.txtDetail)));
                stringBuilder.append("]</font></html>");
                this.htmlDisplayName = stringBuilder.toString();
                return this.htmlDisplayName;
            }
            catch (CharConversionException charConversionException) {
                return null;
            }
        }

        private String cutLongLine(String string) {
            if (string == null) {
                return "";
            }
            if (string.length() < 240) {
                return string;
            }
            return string.substring(0, 240 - ELLIPSIS.length()) + ELLIPSIS;
        }

        private boolean canBeMarked() {
            int n = this.txtDetail.getColumn0();
            return this.txtDetail.getMarkLength() > 0 && n > -1 && n < this.txtDetail.getLineTextLength();
        }

        private void appendMarkedText(StringBuilder stringBuilder) throws CharConversionException {
            int n;
            int n2;
            int n3 = this.txtDetail.getLineTextLength();
            int n4 = this.txtDetail.getColumn0();
            int n5 = n4 + Math.min(this.txtDetail.getMarkLength(), n3 - n4);
            int n6 = n5 - n4;
            if (n6 > 240) {
                n2 = n4;
                n = n5;
            } else if (n3 > 240) {
                int n7 = 240 - n6;
                int n8 = n7 / 4;
                int n9 = Math.min(n8, n4);
                int n10 = Math.min(3 * n8, n3 - n5);
                int n11 = n8 - n9;
                int n12 = 3 * n8 - n10;
                n2 = Math.max(0, n4 - n9 - n12);
                n = Math.min(n3, n5 + n10 + n11);
            } else {
                n2 = 0;
                n = n3;
            }
            this.appendMarkedTextPrefix(stringBuilder, n2, n4);
            this.appendMarkedTextMatch(stringBuilder, n4, n5, n3, n6);
            this.appendMarkedTextSuffix(stringBuilder, n5, n, n3);
        }

        private void appendMarkedTextPrefix(StringBuilder stringBuilder, int n, int n2) throws CharConversionException {
            if (n > 0) {
                stringBuilder.append(ELLIPSIS);
            }
            stringBuilder.append(DetailNode.escape(this.txtDetail.getLineTextPart(n, n2)));
        }

        private void appendMarkedTextMatch(StringBuilder stringBuilder, int n, int n2, int n3, int n4) throws CharConversionException {
            int n5;
            stringBuilder.append("<b>");
            if (n4 > 240) {
                n5 = (240 - ELLIPSIS.length()) / 2;
                stringBuilder.append(DetailNode.escape(this.txtDetail.getLineTextPart(n, n + n5)));
                stringBuilder.append("</b>");
                stringBuilder.append(ELLIPSIS);
                stringBuilder.append("<b>");
                stringBuilder.append(DetailNode.escape(this.txtDetail.getLineTextPart(n2 - n5, n2)));
            } else {
                stringBuilder.append(DetailNode.escape(this.txtDetail.getLineTextPart(n, n2)));
            }
            n5 = n + this.txtDetail.getMarkLength();
            stringBuilder.append("</b>");
            if (n5 > n3) {
                stringBuilder.append(ELLIPSIS);
            }
        }

        private void appendMarkedTextSuffix(StringBuilder stringBuilder, int n, int n2, int n3) throws CharConversionException {
            if (n3 > n) {
                stringBuilder.append(DetailNode.escape(this.txtDetail.getLineTextPart(n, n2)));
                if (n2 < n3) {
                    stringBuilder.append(ELLIPSIS);
                }
            }
        }

        private static String escape(String string) throws CharConversionException {
            return XMLUtil.toElementContent((String)string).replace(" ", "&nbsp;");
        }

        void gotoDetail() {
            this.txtDetail.showDetail(2);
        }

        private void showDetail() {
            this.txtDetail.showDetail(1);
        }

        public void outputLineSelected(OutputEvent outputEvent) {
            this.txtDetail.showDetail(1);
        }

        public void outputLineAction(OutputEvent outputEvent) {
            this.txtDetail.showDetail(2);
        }

        public void outputLineCleared(OutputEvent outputEvent) {
            this.txtDetail.showDetail(3);
        }

        private static String getName(TextDetail textDetail) {
            int n = textDetail.getLine();
            int n2 = textDetail.getColumn();
            if (n2 > 0) {
                return NbBundle.getMessage(DetailNode.class, (String)"TEXT_DETAIL_FMT_NAME1", (Object)Integer.toString(n), (Object)Integer.toString(n2));
            }
            return NbBundle.getMessage(DetailNode.class, (String)"TEXT_DETAIL_FMT_NAME2", (Object)Integer.toString(n));
        }

        private static String getLinePos(TextDetail textDetail) {
            int n = textDetail.getColumn();
            if (n > 0) {
                return NbBundle.getMessage(DetailNode.class, (String)"TEXT_DETAIL_FMT_NAME3", (Object)n);
            }
            return "";
        }

        private static String getShortDesc(TextDetail textDetail) {
            int n = textDetail.getLine();
            int n2 = textDetail.getColumn();
            if (n2 > 0) {
                return NbBundle.getMessage(DetailNode.class, (String)"TEXT_DETAIL_FMT_SHORT1", (Object[])new Object[]{Integer.toString(n), Integer.toString(n2)});
            }
            return NbBundle.getMessage(DetailNode.class, (String)"TEXT_DETAIL_FMT_SHORT2", (Object)Integer.toString(n));
        }

        private static String getFullDesc(TextDetail textDetail) {
            String string = textDetail.getDataObject().getPrimaryFile().getNameExt();
            String string2 = textDetail.getLineText();
            if (string2 != null && string2.length() > 16384) {
                string2 = string2.substring(0, 16384) + ELLIPSIS;
            }
            int n = textDetail.getLine();
            int n2 = textDetail.getColumn();
            if (n2 > 0) {
                return NbBundle.getMessage(DetailNode.class, (String)"TEXT_DETAIL_FMT_FULL1", (Object[])new Object[]{string2, string, Integer.toString(n), Integer.toString(n2)});
            }
            return NbBundle.getMessage(DetailNode.class, (String)"TEXT_DETAIL_FMT_FULL2", (Object[])new Object[]{string2, string, Integer.toString(n)});
        }

        protected void createPasteTypes(Transferable transferable, List<PasteType> list) {
        }

        public boolean canDestroy() {
            return true;
        }

        public void destroy() throws IOException {
            this.mo.removeDetail(this.txtDetail);
        }
    }
}

