/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import org.netbeans.modules.search.ResultModel;
import org.netbeans.modules.search.Selectable;
import org.netbeans.modules.search.TextDetail;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public final class MatchingObject
implements Comparable<MatchingObject>,
Selectable {
    public static final String PROP_INVALIDITY_STATUS = "invalidityStatus";
    public static final String PROP_SELECTED = "selected";
    public static final String PROP_REMOVED = "removed";
    public static final String PROP_CHILD_REMOVED = "child_removed";
    private static final Logger LOG = Logger.getLogger(MatchingObject.class.getName());
    private static final int FILE_READ_BUFFER_SIZE = 4096;
    private final ResultModel resultModel;
    private final FileObject fileObject;
    private DataObject dataObject;
    private final long timestamp;
    private int matchesCount = 0;
    private Node nodeDelegate = null;
    List<TextDetail> textDetails;
    private final Charset charset;
    private boolean selected = true;
    private boolean expanded = false;
    private boolean[] matchesSelection;
    private int selectedMatchesCount;
    private boolean childrenSelectionDirty;
    private boolean valid = true;
    private InvalidityStatus invalidityStatus = null;
    private StringBuilder text;
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private FileListener fileListener;
    private static final boolean REALLY_WRITE = true;

    MatchingObject(ResultModel resultModel, FileObject fileObject, Charset charset, List<TextDetail> list) {
        if (resultModel == null) {
            throw new IllegalArgumentException("resultModel = null");
        }
        if (fileObject == null) {
            throw new IllegalArgumentException("object = null");
        }
        this.textDetails = list;
        this.resultModel = resultModel;
        this.charset = charset;
        this.fileObject = fileObject;
        this.dataObject = this.dataObject();
        this.timestamp = fileObject.lastModified().getTime();
        boolean bl = this.valid = this.timestamp != 0L;
        if (this.dataObject != null) {
            this.matchesCount = this.computeMatchesCount();
            this.nodeDelegate = this.dataObject.getNodeDelegate();
        }
        this.setUpDataObjValidityChecking();
        if (list != null && !list.isEmpty()) {
            this.adjustTextDetails();
        }
    }

    private void adjustTextDetails() {
        TextDetail textDetail = this.textDetails.get(this.textDetails.size() - 1);
        int n = textDetail.getLine();
        int n2 = this.countDigits(n);
        for (TextDetail textDetail2 : this.textDetails) {
            int n3 = this.countDigits(textDetail2.getLine());
            if (n3 >= n2) continue;
            textDetail2.setLineNumberIndent(this.indent(n2 - n3));
        }
    }

    private int countDigits(int n) {
        int n2 = 0;
        while (n > 0) {
            n /= 10;
            ++n2;
        }
        return n2;
    }

    private String indent(int n) {
        switch (n) {
            case 1: {
                return "&nbsp;&nbsp;";
            }
            case 2: {
                return "&nbsp;&nbsp;&nbsp;&nbsp;";
            }
            case 3: {
                return "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("&nbsp;&nbsp;");
        }
        return stringBuilder.toString();
    }

    private void setUpDataObjValidityChecking() {
        if (this.fileObject != null && this.fileObject.isValid()) {
            this.fileListener = new FileListener();
            this.fileObject.addFileChangeListener((FileChangeListener)this.fileListener);
        }
    }

    void cleanup() {
        if (this.fileObject != null && this.fileListener != null) {
            this.fileObject.removeFileChangeListener((FileChangeListener)this.fileListener);
            this.fileListener = null;
        }
        this.dataObject = null;
        this.nodeDelegate = null;
        this.changeSupport.firePropertyChange(PROP_REMOVED, null, null);
    }

    private void setInvalid(InvalidityStatus invalidityStatus) {
        if (this.invalidityStatus == invalidityStatus) {
            return;
        }
        InvalidityStatus invalidityStatus2 = this.invalidityStatus;
        this.valid = false;
        this.invalidityStatus = invalidityStatus;
        this.resultModel.objectBecameInvalid(this);
        if (this.fileObject != null && this.fileListener != null && invalidityStatus == InvalidityStatus.DELETED) {
            this.fileObject.removeFileChangeListener((FileChangeListener)this.fileListener);
        }
        this.changeSupport.firePropertyChange(PROP_INVALIDITY_STATUS, (Object)invalidityStatus2, (Object)invalidityStatus);
    }

    public boolean isObjectValid() {
        return this.valid && this.dataObject != null ? this.dataObject.isValid() : false;
    }

    public FileObject getFileObject() {
        return this.fileObject;
    }

    @Override
    public void setSelected(boolean bl) {
        if (bl == this.selected) {
            return;
        }
        this.selected = bl;
        this.matchesSelection = null;
        this.changeSupport.firePropertyChange(PROP_SELECTED, !bl, bl);
    }

    @Override
    public void setSelectedRecursively(boolean bl) {
        if (this.selected == bl) {
            return;
        }
        if (this.textDetails != null) {
            for (TextDetail textDetail : this.getTextDetails()) {
                textDetail.setSelectedRecursively(bl);
            }
        }
        this.setSelected(bl);
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    boolean isUniformSelection() {
        return this.matchesSelection == null;
    }

    Boolean checkSubnodesSelection() {
        if (this.matchesSelection == null) {
            return this.selected;
        }
        boolean bl = this.matchesSelection[0];
        for (int i = 1; i < this.matchesSelection.length; ++i) {
            if (this.matchesSelection[i] == bl) continue;
            return null;
        }
        return bl;
    }

    boolean toggleSubnodeSelection(ResultModel resultModel, int n) {
        if (this.matchesSelection == null) {
            int n2 = resultModel.getDetailsCount(this);
            if (n2 == 1) {
                this.selected = !this.selected;
                return true;
            }
            this.matchesSelection = new boolean[n2];
            Arrays.fill(this.matchesSelection, this.selected);
            this.matchesSelection[n] = !this.selected;
            boolean bl = this.selected;
            this.selectedMatchesCount = bl ? n2 - 1 : 1;
            this.selected = true;
            return this.selected != bl;
        }
        assert (this.selected);
        assert (this.selectedMatchesCount > 0 && this.selectedMatchesCount < this.matchesSelection.length);
        boolean bl = this.matchesSelection[n];
        if (bl) {
            if (--this.selectedMatchesCount == 0) {
                this.matchesSelection = null;
                this.selected = false;
                return true;
            }
        } else if (++this.selectedMatchesCount == this.matchesSelection.length) {
            this.matchesSelection = null;
            return false;
        }
        this.matchesSelection[n] = !bl;
        return false;
    }

    boolean isSubnodeSelected(int n) {
        if (this.matchesSelection == null) {
            return this.selected;
        }
        if (n >= 0 && n < this.matchesSelection.length) {
            return this.matchesSelection[n];
        }
        LOG.log(Level.FINE, "Illegal index={0} in the case matchesSelection.length={1}", new Object[]{n, this.matchesSelection.length});
        return false;
    }

    void markChildrenSelectionDirty() {
        this.childrenSelectionDirty = true;
    }

    void markChildrenSelectionClean() {
        this.childrenSelectionDirty = false;
    }

    boolean isChildrenSelectionDirty() {
        return this.childrenSelectionDirty;
    }

    void markExpanded(boolean bl) {
        this.expanded = bl;
    }

    boolean isExpanded() {
        return this.expanded;
    }

    String getName() {
        return this.getFileObject().getNameExt();
    }

    String getHtmlDisplayName() {
        return this.getFileObject().getNameExt();
    }

    long getTimestamp() {
        return this.timestamp;
    }

    String getDescription() {
        return this.getFileObject().getParent().getPath();
    }

    String getText() throws IOException {
        StringBuilder stringBuilder = this.text(false);
        return stringBuilder != null ? stringBuilder.toString() : null;
    }

    public List<TextDetail> getTextDetails() {
        return this.textDetails;
    }

    public int getDetailsCount() {
        if (this.textDetails == null) {
            return 0;
        }
        return this.textDetails.size();
    }

    public Node[] getDetails() {
        if (this.textDetails == null) {
            return null;
        }
        ArrayList<TextDetail.DetailNode> arrayList = new ArrayList<TextDetail.DetailNode>(this.textDetails.size());
        for (TextDetail textDetail : this.textDetails) {
            arrayList.add(new TextDetail.DetailNode(textDetail, false, this));
        }
        return arrayList.toArray(new Node[arrayList.size()]);
    }

    public Children getDetailsChildren(boolean bl) {
        return new DetailsChildren(bl, this.resultModel);
    }

    FileLock lock() throws IOException {
        return this.getFileObject().lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StringBuilder text(boolean bl) throws IOException {
        assert (!EventQueue.isDispatchThread());
        if (bl || this.text == null) {
            if (this.charset == null) {
                this.text = new StringBuilder(this.getFileObject().asText());
            } else {
                this.text = new StringBuilder();
                InputStream inputStream = this.getFileObject().getInputStream();
                try {
                    CharsetDecoder charsetDecoder = this.charset.newDecoder();
                    InputStreamReader inputStreamReader = new InputStreamReader(inputStream, charsetDecoder);
                    try {
                        BufferedReader bufferedReader = new BufferedReader(inputStreamReader, 4096);
                        try {
                            int n;
                            char[] cArray = new char[4096];
                            while ((n = bufferedReader.read(cArray)) != -1) {
                                this.text.append(cArray, 0, n);
                            }
                        }
                        finally {
                            bufferedReader.close();
                        }
                    }
                    finally {
                        inputStreamReader.close();
                    }
                }
                finally {
                    inputStream.close();
                }
            }
        }
        return this.text;
    }

    @Override
    public int compareTo(MatchingObject matchingObject) {
        if (matchingObject == null) {
            return Integer.MAX_VALUE;
        }
        return this.getName().compareToIgnoreCase(matchingObject.getName());
    }

    private DataObject dataObject() {
        try {
            return DataObject.find((FileObject)this.fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            this.valid = false;
            return null;
        }
    }

    public DataObject getDataObject() {
        return this.dataObject;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    InvalidityStatus checkValidity() {
        InvalidityStatus invalidityStatus = this.getFreshInvalidityStatus();
        if (invalidityStatus != null) {
            this.valid = false;
            this.invalidityStatus = invalidityStatus;
        }
        return invalidityStatus;
    }

    public InvalidityStatus getInvalidityStatus() {
        return this.invalidityStatus;
    }

    String getInvalidityDescription() {
        InvalidityStatus invalidityStatus = this.getFreshInvalidityStatus();
        String string = invalidityStatus != null ? invalidityStatus.getDescription(this.getFileObject().getPath()) : null;
        return string;
    }

    private InvalidityStatus getFreshInvalidityStatus() {
        this.log(Level.FINER, "getInvalidityStatus()");
        FileObject fileObject = this.getFileObject();
        if (!fileObject.isValid()) {
            this.log(Level.FINEST, " - DELETED");
            return InvalidityStatus.DELETED;
        }
        if (fileObject.isFolder()) {
            this.log(Level.FINEST, " - BECAME_DIR");
            return InvalidityStatus.BECAME_DIR;
        }
        long l = fileObject.lastModified().getTime();
        if (l > this.resultModel.getStartTime()) {
            this.log(Level.SEVERE, "file's timestamp changed since start of the search");
            if (LOG.isLoggable(Level.FINEST)) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(l);
                this.log(Level.FINEST, " - file stamp:           " + l + " (" + calendar.getTime() + ')');
                calendar.setTimeInMillis(this.resultModel.getStartTime());
                this.log(Level.FINEST, " - result model created: " + this.resultModel.getStartTime() + " (" + calendar.getTime() + ')');
            }
            return InvalidityStatus.CHANGED;
        }
        if (fileObject.getSize() > Integer.MAX_VALUE) {
            return InvalidityStatus.TOO_BIG;
        }
        if (!fileObject.canRead()) {
            return InvalidityStatus.CANT_READ;
        }
        return null;
    }

    boolean isValid() {
        return this.valid;
    }

    public void updateDataObject(DataObject dataObject) {
        FileObject fileObject = dataObject.getPrimaryFile();
        if (this.dataObject == null || this.dataObject.getPrimaryFile().equals(fileObject)) {
            if (fileObject.isValid()) {
                this.invalidityStatus = null;
                if (this.fileListener == null) {
                    this.fileListener = new FileListener();
                    fileObject.addFileChangeListener((FileChangeListener)this.fileListener);
                } else if (fileObject != this.dataObject.getPrimaryFile()) {
                    this.dataObject.getPrimaryFile().removeFileChangeListener((FileChangeListener)this.fileListener);
                    fileObject.addFileChangeListener((FileChangeListener)this.fileListener);
                }
                this.dataObject = dataObject;
                this.nodeDelegate = dataObject.getNodeDelegate();
                this.valid = true;
                for (TextDetail textDetail : this.textDetails) {
                    textDetail.updateDataObject(dataObject);
                }
            }
        } else {
            throw new IllegalArgumentException("Expected data object for the same file");
        }
    }

    public InvalidityStatus replace() throws IOException {
        boolean bl;
        assert (!EventQueue.isDispatchThread());
        assert (this.isSelected());
        Boolean bl2 = this.checkSubnodesSelection();
        boolean bl3 = bl = bl2 == Boolean.FALSE;
        if (bl) {
            return null;
        }
        StringBuilder stringBuilder = this.text(true);
        List<TextDetail> list = this.getTextDetails();
        int n = 0;
        for (int i = 0; i < list.size(); ++i) {
            TextDetail textDetail = list.get(i);
            if (!textDetail.isSelected()) continue;
            String string = stringBuilder.substring(textDetail.getStartOffset() + n, textDetail.getEndOffset() + n);
            if (!string.equals(textDetail.getMatchedText())) {
                this.log(Level.SEVERE, "file match part differs from the expected match");
                if (LOG.isLoggable(Level.FINEST)) {
                    this.log(Level.SEVERE, " - expected line: \"" + textDetail.getMatchedText() + '\"');
                    this.log(Level.SEVERE, " - file line:     \"" + string + '\"');
                }
                return InvalidityStatus.CHANGED;
            }
            String string2 = this.resultModel.basicCriteria.getReplaceExpr();
            if (this.resultModel.basicCriteria.getSearchPattern().isRegExp()) {
                Matcher matcher = this.resultModel.basicCriteria.getTextPattern().matcher(string);
                string2 = matcher.replaceFirst(this.resultModel.basicCriteria.getReplaceString());
            } else if (this.resultModel.basicCriteria.isPreserveCase()) {
                string2 = MatchingObject.adaptCase(string2, string);
            }
            stringBuilder.replace(textDetail.getStartOffset() + n, textDetail.getEndOffset() + n, string2);
            n += string2.length() - string.length();
        }
        return null;
    }

    public static String adaptCase(String string, String string2) {
        if (string2.equals(string2.toUpperCase())) {
            return string.toUpperCase();
        }
        if (string2.equals(string2.toLowerCase())) {
            return string.toLowerCase();
        }
        if (Character.isUpperCase(string2.charAt(0))) {
            return Character.toUpperCase(string.charAt(0)) + string.substring(1);
        }
        if (Character.isLowerCase(string2.charAt(0))) {
            if (string2.substring(1).equals(string2.substring(1).toUpperCase())) {
                return Character.toLowerCase(string.charAt(0)) + string.substring(1).toUpperCase();
            }
            return Character.toLowerCase(string.charAt(0)) + string.substring(1);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(FileLock fileLock) throws IOException {
        if (this.text == null) {
            throw new IllegalStateException("Buffer is gone");
        }
        Writer writer = null;
        try {
            writer = new OutputStreamWriter(this.fileObject.getOutputStream(fileLock), this.charset);
            writer.write(this.makeStringToWrite());
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    private String makeStringToWrite() {
        return MatchingObject.makeStringToWrite(this.text);
    }

    static String makeStringToWrite(StringBuilder stringBuilder) {
        return stringBuilder.toString();
    }

    private void log(Level level, String string) {
        String string2;
        String string3 = string2 = this.dataObject != null ? this.dataObject.getName() : this.fileObject.toString();
        if (LOG.isLoggable(level)) {
            LOG.log(level, "{0}: {1}", new Object[]{string2, string});
        }
    }

    public String toString() {
        return super.toString() + "[" + this.getName() + "]";
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MatchingObject matchingObject = (MatchingObject)object;
        if (this.resultModel == matchingObject.resultModel || this.resultModel != null && this.resultModel.equals(matchingObject.resultModel)) {
            return this.fileObject == matchingObject.fileObject || this.fileObject != null && this.fileObject.equals(matchingObject.fileObject);
        }
        return false;
    }

    public int hashCode() {
        int n = 3;
        n = 73 * n + (this.fileObject != null ? this.fileObject.hashCode() : 0);
        n = 73 * n + (this.resultModel != null ? this.resultModel.hashCode() : 0);
        return n;
    }

    private int computeMatchesCount() {
        return this.resultModel.getDetailsCount(this);
    }

    String getFileDisplayName() {
        return FileUtil.getFileDisplayName((FileObject)this.fileObject);
    }

    int getMatchesCount() {
        return this.matchesCount;
    }

    Node getNodeDelegate() {
        return this.nodeDelegate;
    }

    public void removeDetail(TextDetail textDetail) {
        boolean bl = this.textDetails.remove(textDetail);
        if (bl) {
            this.matchesCount = this.getDetailsCount();
            this.resultModel.removeDetailMatch(this, textDetail);
            this.changeSupport.firePropertyChange(PROP_CHILD_REMOVED, null, null);
        }
    }

    public void remove() {
        this.resultModel.remove(this);
    }

    private class FileListener
    extends FileChangeAdapter {
        private FileListener() {
        }

        public void fileDeleted(FileEvent fileEvent) {
            MatchingObject.this.setInvalid(InvalidityStatus.DELETED);
        }

        public void fileChanged(FileEvent fileEvent) {
            if (((MatchingObject)MatchingObject.this).resultModel.basicCriteria.isSearchAndReplace()) {
                MatchingObject.this.setInvalid(InvalidityStatus.CHANGED);
            }
        }
    }

    private class DetailsChildren
    extends Children.Keys<TextDetail> {
        private boolean replacing;

        public DetailsChildren(boolean bl, ResultModel resultModel) {
            this.replacing = bl;
            this.setKeys(MatchingObject.this.getTextDetails());
            MatchingObject.this.addPropertyChangeListener(MatchingObject.PROP_CHILD_REMOVED, new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    DetailsChildren.this.update();
                }
            });
        }

        protected Node[] createNodes(TextDetail textDetail) {
            return new Node[]{new TextDetail.DetailNode(textDetail, this.replacing, MatchingObject.this)};
        }

        public void update() {
            this.setKeys(MatchingObject.this.getTextDetails());
        }
    }

    public static class Def {
        private FileObject fileObject;
        private Charset charset;
        private List<TextDetail> textDetails;

        public Def(FileObject fileObject, Charset charset, List<TextDetail> list) {
            this.fileObject = fileObject;
            this.charset = charset;
            this.textDetails = list;
        }

        public Charset getCharset() {
            return this.charset;
        }

        public void setCharset(Charset charset) {
            this.charset = charset;
        }

        public FileObject getFileObject() {
            return this.fileObject;
        }

        public void setFileObject(FileObject fileObject) {
            this.fileObject = fileObject;
        }

        public List<TextDetail> getTextDetails() {
            return this.textDetails;
        }

        public void setTextDetails(List<TextDetail> list) {
            this.textDetails = list;
        }
    }

    public static enum InvalidityStatus {
        DELETED(true, "Inv_status_Err_deleted"),
        BECAME_DIR(true, "Inv_status_Err_became_dir"),
        CHANGED(false, "Inv_status_Err_changed"),
        TOO_BIG(false, "Inv_status_Err_too_big"),
        CANT_READ(false, "Inv_status_Err_cannot_read");

        private final boolean fatal;
        private final String descrBundleKey;

        private InvalidityStatus(boolean bl, String string2) {
            this.fatal = bl;
            this.descrBundleKey = string2;
        }

        boolean isFatal() {
            return this.fatal;
        }

        String getDescription(String string) {
            return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)this.descrBundleKey, (Object)string);
        }
    }
}

