/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.views.types;

import com.jrockit.mc.components.ui.components.UIScope;
import com.jrockit.mc.flightrecorder.ui.FlightRecorderUI;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.ui.views.types.ITypeVisibilityChange;
import com.jrockit.mc.flightrecorder.ui.views.types.MatchingFilter;
import com.jrockit.mc.flightrecorder.ui.views.types.TypeCheckedStateProvider;
import com.jrockit.mc.flightrecorder.ui.views.types.TypeContentProvider;
import com.jrockit.mc.flightrecorder.ui.views.types.TypeDescriptor;
import com.jrockit.mc.flightrecorder.ui.views.types.TypeFolder;
import com.jrockit.mc.flightrecorder.ui.views.types.TypeLabelProvider;
import com.jrockit.mc.flightrecorder.ui.views.types.TypeRespository;
import com.jrockit.mc.flightrecorder.ui.views.types.TypeViewerComparator;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.Page;

public class TypeTreePage
extends Page
implements ICheckStateListener {
    private Composite container;
    private CheckboxTreeViewer m_viewer;
    private Text m_filterText;
    private final MatchingFilter m_matchFilter;
    private final TypeRespository typeRepo;
    private final UIScope flrEditorScope;

    public TypeTreePage(TypeRespository repo, UIScope flrEditorScope) {
        this.typeRepo = repo;
        this.flrEditorScope = flrEditorScope;
        this.m_matchFilter = new MatchingFilter(this.typeRepo.getRootFolder().getFolders());
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        this.container.setLayout((Layout)layout);
        Composite filterContainer = this.createFilterContainer(this.container);
        filterContainer.setLayoutData((Object)new GridData(4, 4, true, false));
        this.m_viewer = new CheckboxTreeViewer(this.container);
        this.m_viewer.setLabelProvider((IBaseLabelProvider)new TypeLabelProvider(this.m_matchFilter));
        this.m_viewer.setComparator((ViewerComparator)new TypeViewerComparator());
        this.m_viewer.setContentProvider((IContentProvider)new TypeContentProvider());
        this.m_viewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_viewer.setInput((Object)this.typeRepo);
        block0: for (TypeFolder folder : this.typeRepo.getRootFolder().getFolders()) {
            for (TypeDescriptor type : folder.getTypeDescriptors()) {
                if (!type.isChecked()) continue;
                this.m_viewer.setExpandedState((Object)folder, true);
                continue block0;
            }
        }
        this.m_viewer.addCheckStateListener((ICheckStateListener)this);
        this.m_viewer.setCheckStateProvider((ICheckStateProvider)new TypeCheckedStateProvider());
    }

    public Control getControl() {
        return this.container;
    }

    public void setFocus() {
        this.container.setFocus();
    }

    private Composite createFilterContainer(Composite parent) {
        Composite client = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginRight = 14;
        layout.verticalSpacing = 0;
        client.setLayout((Layout)layout);
        this.m_filterText = this.createFilterText(client);
        this.m_filterText.setLayoutData((Object)new GridData(4, 4, true, true));
        return client;
    }

    private Text createFilterText(Composite container) {
        final Text text = new Text(container, 2048);
        text.setToolTipText(Messages.EVENT_TYPES_VIEW_FILTER_DESCRIPTION_TEXT);
        final ControlDecoration cd = this.createClearDecoration(text);
        cd.hide();
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TypeTreePage.this.updateFilter();
                if (text.getText().length() > 0) {
                    cd.show();
                } else {
                    cd.hide();
                }
            }
        });
        return text;
    }

    private ControlDecoration createClearDecoration(final Text text) {
        ControlDecoration cd = new ControlDecoration((Control)text, 131072);
        cd.setImage(FlightRecorderUI.getDefault().getImage("clear_co.gif"));
        cd.setDescriptionText(Messages.EVENT_TYPES_VIEW_FILTER_CLEAR_TEXT);
        cd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                text.setText("");
            }
        });
        return cd;
    }

    private void updateFilter() {
        if (this.m_filterText.getText().length() != 0) {
            this.m_matchFilter.setFilterText(this.m_filterText.getText());
            this.m_viewer.setFilters(new ViewerFilter[]{this.m_matchFilter});
            if (this.m_matchFilter.getMatchesParents().size() < 10) {
                this.m_viewer.setExpandedElements(this.m_matchFilter.getMatchesParents().toArray());
            }
        } else {
            this.m_matchFilter.setFilterText(null);
            this.m_viewer.resetFilters();
            this.m_viewer.collapseAll();
        }
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        TypeCheckedStateProvider.setCheckedState(event.getElement(), event.getChecked());
        this.m_viewer.refresh();
        for (ITypeVisibilityChange tp : this.flrEditorScope.getAllComponents(ITypeVisibilityChange.class)) {
            if (!tp.isTypeChangeEnabled()) continue;
            tp.onTypeVisibilityChange();
        }
    }
}

