/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.tableProviders.objectstatistics;

import com.jrockit.mc.common.util.Filter;
import com.jrockit.mc.common.util.FilteredIterator;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IField;
import com.jrockit.mc.flightrecorder.ui.components.custom.IEventRow;
import java.util.Iterator;

public final class ClassStatistics
implements IEventRow {
    private final Object m_clazz;
    private final Iterable<IEvent> m_iterable;
    private long m_initial = 0L;
    private long m_last;
    private long m_initialSize;
    private long m_lastSize;
    private long m_lastSnapShotId;
    private final IField m_classField;

    ClassStatistics(Object clazz, Iterable<IEvent> iterable, IField classField) {
        this.m_clazz = clazz;
        this.m_iterable = iterable;
        this.m_classField = classField;
    }

    @Override
    public Object[] getColumnValues() {
        return new Object[]{this.m_clazz, this.getDeltaCount(), this.getDeltaSize()};
    }

    @Override
    public Iterator<IEvent> iterator() {
        return new FilteredIterator(this.m_iterable.iterator(), (Filter)new Filter<IEvent>(){

            public boolean accept(IEvent event) {
                return ClassStatistics.this.m_clazz.equals(ClassStatistics.this.m_classField.getValue(event));
            }
        });
    }

    public Object getClazz() {
        return this.m_clazz;
    }

    public void setInitialCount(long initial) {
        this.m_initial = initial;
    }

    public void setLastCount(long last) {
        this.m_last = last;
    }

    long getDeltaCount() {
        return this.m_last - this.m_initial;
    }

    void setLastSnapshotId(long snapShot) {
        this.m_lastSnapShotId = snapShot;
    }

    long getLastSnapshotId() {
        return this.m_lastSnapShotId;
    }

    public void setInitialSize(long size) {
        this.m_initialSize = size;
    }

    public long getDeltaSize() {
        return this.m_lastSize - this.m_initialSize;
    }

    public void setLastSize(long size) {
        this.m_lastSize = size;
    }
}

